#include <bnb/glsl.vert>
#include <bnb/transform_uv.glsl>
#include <bnb/transform_camera_uv.glsl>

layout(location = 0) in vec2 attrib_pos;

BNB_OUT(0)
vec2 var_uv;

BNB_OUT(1)
vec3 bg_uv;

void main()
{
    vec2 v = attrib_pos;
    gl_Position = vec4(v, 0., 1.);

    var_uv = bnb_transform_camera_uv(v);

    /* fill background info */
    bg_uv.xy = vec2(vec3(v, 1.) * mat3(background_nn_transform));
    bg_uv.z = mat3(background_nn_transform) != mat3(1.f, 0.f, 0.f, 0.f, 1.f, 0.f, 0.f, 0.f, 1.f) ? 1.f : 0.f;
}
