//
//	VidyoLocalMicrophone_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoDevice_Objc.h"
#import "VidyoLocalSpeaker_Objc.h"
#import "VidyoRemoteSpeaker_Objc.h"
/*!
 * @enum State of the voice processing selection mode inside the capturer.
 * @constant VCVoiceProcessingModeDefault Audio capturer will rely on default voice processing algorithms.
 * @constant VCVoiceProcessingModeVidyo Audio capturer will rely on Vidyo's voice processing algorithms.
 * @constant VCVoiceProcessingModePlatform Audio capturer will rely on the voice processing algorithms supported by the OS (if applicable).
 */
typedef NS_ENUM(NSInteger, VCVoiceProcessingMode) {
	VCVoiceProcessingModeDefault,
	VCVoiceProcessingModeVidyo,
	VCVoiceProcessingModePlatform
};
/*!
 * This object represents a microphone on the local endpoint.
 */
@interface VCLocalMicrophone : NSObject
{
	void* objPtr;
}
	/*!
	 * Unique ID.
	 */
	@property NSMutableString* id;
	/*!
	 * Name.
	 */
	@property NSMutableString* name;
	-(void) dealloc;
	/*!
	 * @param m The VidyoLocalMicrophone object.
	 */
	-(BOOL) addToLocalSpeaker:(VCLocalSpeaker*)speaker;
	/*!
	 * @param m The VidyoLocalMicrophone object.
	 */
	-(BOOL) addToRemoteSpeaker:(VCRemoteSpeaker*)remoteSpeaker;
	/*!
	 * @param m The VidyoLocalMicrophone object.
	 */
	-(BOOL) disableDebugRecording;
	/*!
	 * @param m The VidyoLocalMicrophone object.
	 */
	-(BOOL) enableDebugRecording:(NSString*)dir;
	/*!
	 * @param m The VidyoLocalMicrophone object.
	 */
	-(BOOL) getAutoGain;
	/*!
	 * Get the microphone boost for the local microphone.
	 * @param m The local microphone object.
	 */
	-(float) getBoost;
	/*!
	 * Get echo cancellation status for particular microphone.
	 * @param m The VidyoLocalMicrophone object.
	 */
	-(BOOL) getEchoCancellation;
	/*!
	 * Gets the unique ID of the microphone.
	 * @param m The VidyoLocalMicrophone object.
	 */
	-(NSString*) getId;
	/*!
	 * Gets the name of the microphone.
	 * @param m The VidyoLocalMicrophone object.
	 */
	-(NSString*) getName;
	/*!
	 * Gets signal type of the microphone, which affects how the audio is processed.
	 * @param m The VidyoLocalMicrophone object.
	 */
	-(VCDeviceAudioSignalType) getSignalType;
	/*!
	 * Gets the type of the microphone.
	 * @param m The VidyoLocalMicrophone object.
	 */
	-(NSString*) getType;
	/*!
	 * @param m The VidyoLocalMicrophone object.
	 */
	-(BOOL) getVoiceProcessing;
	/*!
	 * @param m The VidyoLocalMicrophone object.
	 */
	-(unsigned int) getVolume;
	/*!
	 * Hides an audio debug dialog for the local microphone.
	 * @param microphone The local microphone object to extract stats.
	 */
	-(void) hideDebugDialog;
	/*!
	 * @param m The VidyoLocalMicrophone object.
	 */
	-(BOOL) isDebugRecordingEnabled;
	/*!
	 * @param m The VidyoLocalMicrophone object.
	 */
	-(BOOL) isPaused;
	/*!
	 * @param m The VidyoLocalMicrophone object.
	 */
	-(void) pause;
	/*!
	 * @param m The VidyoLocalMicrophone object.
	 */
	-(void) playTone:(char)dtmfTone;
	/*!
	 * @param m The VidyoLocalMicrophone object.
	 */
	-(BOOL) removeFromLocalSpeaker:(VCLocalSpeaker*)speaker;
	/*!
	 * @param m The VidyoLocalMicrophone object.
	 */
	-(BOOL) removeFromRemoteSpeaker:(VCRemoteSpeaker*)remoteSpeaker;
	/*!
	 * Restart the local microphone.
	 * @param microphone The local microphone object to restart.
	 */
	-(BOOL) restart;
	/*!
	 * @param m The VidyoLocalMicrophone object.
	 */
	-(void) resume;
	/*!
	 * Enable or disable AGC for a microphone. If this API will be called for selected microphone this will cause a force reconfiguration of the device and will restart the audio capturer.
	 * @param m The VidyoLocalMicrophone object.
	 * @param autoGain LMI_TRUE to enable AGC, LMI_FALSE to disable AGC.
	 */
	-(BOOL) setAutoGain:(BOOL)autoGain;
	/*!
	 * Set the microphone boost for the local microphone.
	 * @param m The local microphone object.
	 * @param value The microphone boost in dB.
	 */
	-(BOOL) setBoost:(float)value;
	/*!
	 * @param m The VidyoLocalMicrophone object.
	 */
	-(BOOL) setEchoCancellation:(VCLocalSpeaker*)speaker IsEnable:(BOOL)isEnable;
	/*!
	 * Sets the signal type of the microhone which changes how the auido is processed. If this API will be called for selected microphone this will cause a force reconfiguration of the device and will restart the audio capturer.
	 * @param m The VidyoLocalMicrophone object.
	 * @param signalType The signal type of the microphone.
	 */
	-(BOOL) setSignalType:(VCDeviceAudioSignalType)signalType;
	/*!
	 * Enable or disable voice processing and set voice processing mode. If this API will be called for selected microphone this will cause a force reconfiguration of the device and will restart the audio capturer.
	 * @param m The VidyoLocalMicrophone object.
	 * @param voiceProcessing LMI_TRUE to enable the voice processing, LMI_FALSE to disable the voice processing.
	 * @param mode The voice processing mode.
	 */
	-(BOOL) setVoiceProcessing:(BOOL)voiceProcessing Mode:(VCVoiceProcessingMode)mode;
	/*!
	 * @param m The VidyoLocalMicrophone object.
	 */
	-(void) setVolume:(unsigned int)volumePercent;
	/*!
	 * Shows an audio debug dialog for the local microphone.
	 * @param microphone The local microphone object to extract stats.
	 */
	-(void) showDebugDialog;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
