//
//	VidyoNetworkInterface_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

/*!
 * @enum The family of a network interface.
 * @constant VCNetworkInterfaceFamilyUnspecified The interface state is unknown.
 * @constant VCNetworkInterfaceFamilyIPV4 The interface IPV4.
 * @constant VCNetworkInterfaceFamilyIPV6 The interface is IPV6.
 */
typedef NS_ENUM(NSInteger, VCNetworkInterfaceFamily) {
	VCNetworkInterfaceFamilyUnspecified,
	VCNetworkInterfaceFamilyIPV4,
	VCNetworkInterfaceFamilyIPV6
};
/*!
 * @enum The state of a network interface.
 * @constant VCNetworkInterfaceStateUnknown The interface state is unknown.
 * @constant VCNetworkInterfaceStateUp The interface is up.
 * @constant VCNetworkInterfaceStateDown The interface is down.
 */
typedef NS_ENUM(NSInteger, VCNetworkInterfaceState) {
	VCNetworkInterfaceStateUnknown,
	VCNetworkInterfaceStateUp,
	VCNetworkInterfaceStateDown
};
/*!
 * @enum The trasport type used over the network interface.
 * @constant VCNetworkInterfaceTransportTypeSignaling The interface is used for signaling.
 * @constant VCNetworkInterfaceTransportTypeMedia The interface is used fro Media.
 * @constant VCNetworkInterfaceTransportTypeData The interface is used fro Data.
 */
typedef NS_ENUM(NSInteger, VCNetworkInterfaceTransportType) {
	VCNetworkInterfaceTransportTypeSignaling,
	VCNetworkInterfaceTransportTypeMedia,
	VCNetworkInterfaceTransportTypeData
};
/*!
 * @enum The connection type of a network interface.
 * @constant VCNetworkInterfaceTypeOther Some other type of interface.
 * @constant VCNetworkInterfaceTypeWired A wired interface.
 * @constant VCNetworkInterfaceTypeWiFi A Wi-Fi (802.11) interface.
 * @constant VCNetworkInterfaceTypeWwan A WWAN (cellular data) interface.
 * @constant VCNetworkInterfaceTypeLoopback A loopback interface.
 * @constant VCNetworkInterfaceTypeTunneled A tunneled interface.
 * @constant VCNetworkInterfaceTypeNotApplicable Network interface type is not applicable in this context.
 */
typedef NS_ENUM(NSInteger, VCNetworkInterfaceType) {
	VCNetworkInterfaceTypeOther,
	VCNetworkInterfaceTypeWired,
	VCNetworkInterfaceTypeWiFi,
	VCNetworkInterfaceTypeWwan,
	VCNetworkInterfaceTypeLoopback,
	VCNetworkInterfaceTypeTunneled,
	VCNetworkInterfaceTypeNotApplicable
};
/*!
 * Stores network interface information.
 */
@interface VCNetworkInterface : NSObject
{
	void* objPtr;
}
	/*!
	 * The address of the interface.
	 */
	@property NSMutableString* address;
	/*!
	 * The family of the interface.
	 */
	@property VCNetworkInterfaceFamily family;
	/*!
	 * The name of the interface.
	 */
	@property NSMutableString* name;
	/*!
	 * The state of the interface.
	 */
	@property VCNetworkInterfaceState state;
	/*!
	 * The type of the interface.
	 */
	@property VCNetworkInterfaceType type;
	-(void) dealloc;
	/*!
	 * Gets the address of the network interface.
	 * @param n The VidyoNetworkInterface object.
	 */
	-(NSString*) getAddress;
	/*!
	 * Gets the family of the network interface.
	 * @param n The VidyoNetworkInterface object.
	 */
	-(VCNetworkInterfaceFamily) getFamily;
	/*!
	 * Gets the name of the network interface.
	 * @param n The VidyoNetworkInterface object.
	 */
	-(NSString*) getName;
	/*!
	 * Gets the state of the network interface.
	 * @param n The VidyoNetworkInterface object.
	 */
	-(VCNetworkInterfaceState) getState;
	/*!
	 * Gets the type of the network interface.
	 * @param n The VidyoNetworkInterface object.
	 */
	-(VCNetworkInterfaceType) getType;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
