//
//	VidyoRemoteCamera_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoCameraControlCapabilities_Objc.h"
#import "VidyoDevice_Objc.h"
#import "VidyoLocalRenderer_Objc.h"
#import "VidyoParticipant_Objc.h"
#import "VidyoVideoFrame_Objc.h"
/*!
 * @enum 
 * @constant VCRemoteCameraModeDynamic 
 * @constant VCRemoteCameraModeStatic 
 */
typedef NS_ENUM(NSInteger, VCRemoteCameraMode) {
	VCRemoteCameraModeDynamic,
	VCRemoteCameraModeStatic
};
/*!
 * @enum Position of the camera.
 * @constant VCRemoteCameraPositionUnknown Position is unknown.
 * @constant VCRemoteCameraPositionFront Facing towards the screen.
 * @constant VCRemoteCameraPositionBack Facing away from the screen.
 */
typedef NS_ENUM(NSInteger, VCRemoteCameraPosition) {
	VCRemoteCameraPositionUnknown,
	VCRemoteCameraPositionFront,
	VCRemoteCameraPositionBack
};
@protocol VCRemoteCameraIRegisterFrameEventListener
	/*!
	 * Callback that is triggered each time a remote camera produces a video frame.
	 */
	-(void) onRemoteCameraFrame:(VCParticipant*)participant VideoFrame:(VCVideoFrame*)videoFrame;
@end
@protocol VCRemoteCameraIRegisterFrameSizeListener
	/*!
	 * Callback that is triggered when video frame from a remote camera changes it's size.
	 */
	-(void) onFrameSizeUpdate:(size_t)width Height:(size_t)height;
@end
@protocol VCRemoteCameraIRegisterPresetEventListener
	/*!
	 * Callback that is triggered each time a remote camera updates preset information.
	 */
	-(void) onPresetUpdated:(NSMutableArray*)presets;
@end
/*!
 * This object represents a camera which belongs to the remote participant.
 */
@interface VCRemoteCamera : NSObject
{
	void* objPtr;
	@public
	/*!
	 * Registers to get notified about a new remote camera frame.
	 */
	id<VCRemoteCameraIRegisterFrameEventListener> remoteCameraIRegisterFrameEventListener;
	/*!
	 * Registers to get notified about camera frame size changes.
	 */
	id<VCRemoteCameraIRegisterFrameSizeListener> remoteCameraIRegisterFrameSizeListener;
	/*!
	 * Registers a callback to receive notifications about camera preset information.
	 */
	id<VCRemoteCameraIRegisterPresetEventListener> remoteCameraIRegisterPresetEventListener;
}
	/*!
	 * Unique ID.
	 */
	@property NSMutableString* id;
	/*!
	 * Name.
	 */
	@property NSMutableString* name;
	-(void) dealloc;
	/*!
	 * Send the preset index to the remote camera.
	 * @param c The VidyoRemoteCamera object.
	 * @param index Represents the preset index.
	 */
	-(BOOL) activatePreset:(unsigned int)index;
	/*!
	 * @param c The VidyoRemoteCamera object.
	 */
	-(long) addToLocalRenderer:(VCLocalRenderer*)localRenderer Mode:(VCRemoteCameraMode)mode;
	/*!
	 * Send the PTZ Nudge commands to the remote camera.
	 * @param c The VidyoRemoteCamera object.
	 * @param pan Number of nudges to pan the camera.
	 * @param tilt Number of nudges to tilt the camera.
	 * @param zoom Number of nudges to zoom the camera.
	 */
	-(BOOL) controlPTZNudge:(int)pan Tilt:(int)tilt Zoom:(int)zoom;
	/*!
	 * Send the PTZ Start commands to the remote camera.
	 * @param c The VidyoRemoteCamera object.
	 * @param direction The VidyoCameraControlDirection enum that indicates direction of move.
	 * @param timeout Amount of time in nanoseconds at which camera will be moving in the specified directions.
	 */
	-(BOOL) controlPTZStart:(VCCameraControlDirection)direction Timeout:(long)timeout;
	/*!
	 * Send the PTZ Stop commands to the remote camera.
	 * @param c The VidyoRemoteCamera object.
	 */
	-(BOOL) controlPTZStop;
	/*!
	 * Gets camera control capabilities.
	 * @param c The VidyoRemoteCamera object.
	 */
	-(VCCameraControlCapabilities*) getControlCapabilities;
	/*!
	 * Gets the unique ID of the camera.
	 * @param c The VidyoRemoteCamera object.
	 */
	-(NSString*) getId;
	/*!
	 * @param c The VidyoRemoteCamera object.
	 */
	-(long) getLocalRenderingStreamId:(int)index;
	/*!
	 * Gets the name of the camera.
	 * @param c The VidyoRemoteCamera object.
	 */
	-(NSString*) getName;
	/*!
	 * Gets the position of the camera.
	 * @param c The VidyoRemoteCamera object.
	 */
	-(VCRemoteCameraPosition) getPosition;
	/*!
	 * Checks if the remote camera is controllable.
	 * @param c The VidyoRemoteCamera object.
	 */
	-(BOOL) isControllable;
	/*!
	 * Registers to get notified about a new remote camera frame.
	 * @param c The VidyoRemoteCamera object.
	 * @param onFrame Callback that is triggered each time a remote camera produces a video frame.
	 */
	-(BOOL) registerFrameEventListener:(id<VCRemoteCameraIRegisterFrameEventListener>)remoteCameraIRegisterFrameEventListener;
	/*!
	 * Registers to get notified about camera frame size changes.
	 * @param c The VidyoRemoteCamera object.
	 * @param onFrameSizeUpdate Callback that is triggered whenever frame size changes.
	 */
	-(BOOL) registerFrameSizeListener:(id<VCRemoteCameraIRegisterFrameSizeListener>)remoteCameraIRegisterFrameSizeListener;
	/*!
	 * Registers a callback to receive notifications about camera preset information.
	 * @param c The VidyoRemoteCamera object.
	 * @param onPresetUpdated Callback that is triggered whenever camera preset information changes.
	 */
	-(BOOL) registerPresetEventListener:(id<VCRemoteCameraIRegisterPresetEventListener>)remoteCameraIRegisterPresetEventListener;
	/*!
	 * @param c The VidyoRemoteCamera object.
	 */
	-(BOOL) removeFromLocalRenderer:(VCLocalRenderer*)localRenderer;
	/*!
	 * @param c The VidyoRemoteCamera object.
	 */
	-(BOOL) setPositionInLocalRenderer:(VCLocalRenderer*)localRenderer X:(int)x Y:(int)y Width:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval;
	/*!
	 * Shows camera control when rendering remote camera.
	 * @param c The VidyoRemoteCamera object.
	 * @param show Show or hide camera controls.
	 */
	-(BOOL) showCameraControl:(BOOL)show;
	/*!
	 * Unregisters remote camera frame notifications.
	 * @param c The VidyoRemoteCamera object.
	 */
	-(BOOL) unregisterFrameEventListener;
	/*!
	 * Unregisters frame size event notifications.
	 * @param c The VidyoRemoteCamera object.
	 */
	-(BOOL) unregisterFrameSizeListener;
	/*!
	 * Unregisters callback to get notified about camera preset information.
	 * @param c The VidyoRemoteCamera object.
	 */
	-(BOOL) unregisterPresetEventListener;
	/*!
	 * Sends the visca message to the remote camera.
	 * @param c The VidyoRemoteCamera object.
	 * @param viscaCmd Represents the visca command, with maximum length as 128 characters. This should be any valid visca command.For example: "81 01 04 3f 02 02 ff"
	 * @param viscaCmdId Represents the visca command identifier, with maximum length as 128 characters. Application can set NULL OR any valid string identifier, which can be used at remote end for debugging.
	 */
	-(BOOL) viscaControl:(NSString*)viscaCmd ViscaCmdId:(NSString*)viscaCmdId;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
