//
//	VidyoVirtualRenderer_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoCameraControlCapabilities_Objc.h"
#import "VidyoDevice_Objc.h"
#import "VidyoVideoFrame_Objc.h"
@class VCVirtualRendererParticipant;
@class VCVirtualRendererStream;
/*!
 * @enum The video stream type.
 * @constant VCVirtualRendererStreamTypeVideo The source is a participant's video.
 * @constant VCVirtualRendererStreamTypeContentShare The source is a content share video.
 * @constant VCVirtualRendererStreamTypeUnknown The source type is unknown.
 */
typedef NS_ENUM(NSInteger, VCVirtualRendererStreamType) {
	VCVirtualRendererStreamTypeVideo,
	VCVirtualRendererStreamTypeContentShare,
	VCVirtualRendererStreamTypeUnknown
};
@protocol VCVirtualRendererIRegisterParticipantsEventListener
	/*!
	 * This callback is invoked to report the participant that joined conference and provides its information.
	 */
	-(void) onParticipantAdded:(VCVirtualRendererParticipant*)participant UserData:(long)userData;
	/*!
	 * This callback is invoked to report the participant id that left the conference.
	 */
	-(void) onParticipantRemoved:(VCVirtualRendererParticipant*)participant UserData:(long)userData;
	/*!
	 * This callback is invoked to report that an audio-only participant has gain or lost loudest speaker status.
	 */
	-(void) onLoudestParticipantChanged:(VCVirtualRendererParticipant*)participant AudioOnly:(BOOL)audioOnly UserData:(long)userData;
	/*!
	 * This callback is invoked to report that the list of dynamically selected participants in a conference has changed.
	 */
	-(void) onDynamicParticipantChanged:(NSMutableArray*)selectedParticipants UserData:(long)userData;
	/*!
	 * This callback is invoked to report the audio level for specific participant.
	 */
	-(void) onAudioLevelChanged:(VCVirtualRendererParticipant*)participant Energy:(int)energy IsSpeech:(BOOL)isSpeech UserData:(long)userData;
@end
@protocol VCVirtualRendererIRegisterStreamsEventListener
	/*!
	 * This callback is invoked to report the video stream information of video source that was added to the conference.
	 */
	-(void) onStreamAdded:(VCVirtualRendererStream*)stream UserData:(long)userData;
	/*!
	 * This callback is invoked to report the video stream was removed from the conference.
	 */
	-(void) onStreamRemoved:(VCVirtualRendererStream*)stream UserData:(long)userData;
	/*!
	 * This callback is invoked to send the frame of a video stream to the application.
	 */
	-(void) onStreamFrameReceived:(VCVirtualRendererStream*)stream VideoFrame:(VCVideoFrame*)videoFrame UserData:(long)userData;
	/*!
	 * This Callback is triggered when there is change in camera control capabilities.
	 */
	-(void) onFECCCapabilitiesChanged:(VCVirtualRendererStream*)stream Caps:(VCCameraControlCapabilities*)caps UserData:(long)userData;
@end
/*!
 * This object represents a virtual renderer on the local endpoint.
 */
@interface VCVirtualRenderer : NSObject
{
	void* objPtr;
	@public
	/*!
	 * Registers virtual renderer callbacks to receive notifications about participants.
	 */
	id<VCVirtualRendererIRegisterParticipantsEventListener> virtualRendererIRegisterParticipantsEventListener;
	/*!
	 * Registers virtual renderer callbacks to receive notifications about streams.
	 */
	id<VCVirtualRendererIRegisterStreamsEventListener> virtualRendererIRegisterStreamsEventListener;
}
	/*!
	 * Unique ID.
	 */
	@property NSMutableString* id;
	/*!
	 * Name of the virtual renderer.
	 */
	@property NSMutableString* name;
	/*!
	 * This object represents a virtual renderer on the local endpoint.
	 * @param r The VidyoVirtualRenderer object.
	 * @param id Unique ID.
	 * @param name Name of the virtual renderer.
	 * @param alloc The LmiAllocator object.
	 */
	-(id) init:(NSString*)id Name:(NSString*)name;
	-(void) dealloc;
	/*!
	 * Gets the id of the virtual renderer.
	 * @param r The VidyoVirtualRenderer object.
	 */
	-(NSString*) getId;
	/*!
	 * Gets the name of the virtual renderer.
	 * @param r The VidyoVirtualRenderer object.
	 */
	-(NSString*) getName;
	/*!
	 * Registers virtual renderer callbacks to receive notifications about participants.
	 * @param r The VidyoVirtualRenderer object.
	 * @param userData The user data, returned in callback.
	 * @param onParticipantAdded Notifies the application that the participant added and sends its information.
	 * @param onParticipantRemoved Notifies the application that the participant removed.
	 * @param onLoudestParticipantChanged Notifies the application that the loudest speaker was changed.
	 * @param onDynamicParticipantChanged Reports the list of new dynamic participants.
	 * @param onAudioLevelChanged Notifies the application the audio level of participant was changed.
	 */
	-(unsigned long long) registerParticipantsEventListener:(long)userData VirtualRendererIRegisterParticipantsEventListener:(id<VCVirtualRendererIRegisterParticipantsEventListener>)virtualRendererIRegisterParticipantsEventListener;
	/*!
	 * Registers virtual renderer callbacks to receive notifications about streams.
	 * @param r The VidyoVirtualRenderer object.
	 * @param userData The user data, returned in callback.
	 * @param onStreamAdded Notifies the application that the stream added and sends its information.
	 * @param onStreamRemoved Notifies the application that the stream removed.
	 * @param onStreamsFrame Notifies the application that the video frame received for stream.
	 * @param onFECCCapabilitiesChanged Notifies the application about the camera control capabilities.
	 */
	-(unsigned long long) registerStreamsEventListener:(long)userData VirtualRendererIRegisterStreamsEventListener:(id<VCVirtualRendererIRegisterStreamsEventListener>)virtualRendererIRegisterStreamsEventListener;
	/*!
	 * Sends the camera control commands.
	 * @param r The VidyoVirtualRenderer object.
	 * @param streamId The unique ID of stream.
	 * @param cmds Camera control commands.
	 */
	-(BOOL) sendFECCCommands:(unsigned long long)streamId Cmds:(NSMutableArray*)cmds;
	/*!
	 * Requests frames for the specific stream with specified parameters or updates stream parameters if frames have already been requested. Parameters are used to request the most suitable video stream for this source. It is set based on tile size..
	 * @param r The VidyoVirtualRenderer object.
	 * @param streamId The unique ID of stream.
	 * @param width Desired stream width.
	 * @param height Desired stream height.
	 * @param frameInterval Desired stream frame interval.
	 * @param pin LMI_TRUE to pin stream to always receive the video frames. LMI_FALSE to make the stream behavior default.
	 */
	-(BOOL) streamStart:(unsigned long long)streamId Width:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval Pin:(BOOL)pin;
	/*!
	 * Stops receiving frames for a specific stream.
	 * @param r The VidyoVirtualRenderer object.
	 * @param streamId The unique ID of stream.
	 */
	-(void) streamStop:(unsigned long long)streamId;
	/*!
	 * Unregisters virtual renderer callbacks to receive notifications about participants and streams.
	 * @param r The VidyoVirtualRenderer object.
	 * @param token Token for callbacks that should be unregister.
	 */
	-(long) unregisterEventListener:(unsigned long long)token;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
/*!
 * The participant information needed for renderer.
 */
@interface VCVirtualRendererParticipant : NSObject
{
	void* objPtr;
}
	/*!
	 * The participant unique id.
	 */
	@property unsigned long long id;
	-(void) dealloc;
	/*!
	 * Gets participant id.
	 * @param p The VidyoVirtualRendererParticipant object.
	 */
	-(unsigned long long) getId;
	/*!
	 * Gets participant initials.
	 * @param p The VidyoVirtualRendererParticipant object.
	 */
	-(NSString*) getInitial;
	/*!
	 * Gets participant name.
	 * @param p The VidyoVirtualRendererParticipant object.
	 */
	-(NSString*) getName;
	/*!
	 * Gets participant unique id in the conference.
	 * @param p The VidyoVirtualRendererParticipant object.
	 */
	-(NSString*) getParticipantId;
	/*!
	 * Checks whether participant is remote.
	 * @param p The VidyoVirtualRendererParticipant object.
	 */
	-(BOOL) isRemote;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
/*!
 * The stream information needed for renderer.
 */
@interface VCVirtualRendererStream : NSObject
{
	void* objPtr;
}
	/*!
	 * The stream unique id.
	 */
	@property unsigned long long id;
	/*!
	 * The participant unique id.
	 */
	@property unsigned long long participantId;
	-(void) dealloc;
	/*!
	 * Gets stream id.
	 * @param s The VidyoVirtualRendererStream object.
	 */
	-(unsigned long long) getId;
	/*!
	 * Gets stream label.
	 * @param s The VidyoVirtualRendererStream object.
	 */
	-(NSString*) getLabel;
	/*!
	 * Gets streams participant unique id.
	 * @param s The VidyoVirtualRendererStream object.
	 */
	-(unsigned long long) getParticipantId;
	/*!
	 * Gets stream type.
	 * @param s The VidyoVirtualRendererStream object.
	 */
	-(VCVirtualRendererStreamType) getType;
	/*!
	 * Checks whether stream is local.
	 * @param s The VidyoVirtualRendererStream object.
	 */
	-(BOOL) isLocal;
	/*!
	 * Checks whether stream is mirrored.
	 * @param s The VidyoVirtualRendererStream object.
	 */
	-(BOOL) isMirrored;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
