//
//	VidyoApplication_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoEndpoint_Objc.h"
/*!
 * @enum The reason of failed update check
 * @constant APPLICATION_DOWNLOADFAILEDREASON_WebProxyAuthenticationRequired Check for update failed because of webproxy authentication failure
 * @constant APPLICATION_DOWNLOADFAILEDREASON_MiscError Check for update failed because of misc error
 */
typedef NS_ENUM(NSInteger, VCApplicationDownloadFailedReason) {
	APPLICATION_DOWNLOADFAILEDREASON_WebProxyAuthenticationRequired,
	APPLICATION_DOWNLOADFAILEDREASON_MiscError
};
@protocol VCApplicationIRegisterUpdaterEventListener
	-(void) downloadCompletedCallback:(NSMutableString*)version DownloadedFile:(NSMutableString*)downloadedFile;
	/*!
	 * .
	 */
	-(void) downloadFailedCallback:(VCApplicationDownloadFailedReason)reason;
@end
@interface VCApplication : NSObject
{
	void* objPtr;
	@public
	/*!
	 * Registers to get notified about software updater events.
	 */
	id<VCApplicationIRegisterUpdaterEventListener> applicationIRegisterUpdaterEventListener;
}
	/*!
	 */
	-(id) init:(VCEndpoint*)endpoint;
	-(void) dealloc;
	/*!
	 * Registers to get notified about software updater events.
	 * @param app The VidyoApplication object.
	 */
	-(BOOL) registerUpdaterEventListener:(id<VCApplicationIRegisterUpdaterEventListener>)applicationIRegisterUpdaterEventListener;
	/*!
	 * @param app The application object.
	 */
	-(void) setWebProxyCredentials:(const char*)webProxyUserName WebProxyPassword:(const char*)webProxyPassword;
	/*!
	 * Start checking for client software updates on the server.
	 * @param app The endpoint object.
	 * @param currentVersion Current version of this application.
	 * @param workingDirectory The working directory used to store the installer.
	 * @param server The server to be polled.
	 * @param webProxyUsername User name for connecting to web proxy.
	 * @param webProxyPassword Password for connecting to web proxy.
	 */
	-(BOOL) startUpdateService:(const char*)currentVersion WorkingDirectory:(const char*)workingDirectory Server:(const char*)server CaFilePath:(const char*)caFilePath WebProxyUsername:(const char*)webProxyUsername WebProxyPassword:(const char*)webProxyPassword;
	/*!
	 * Stop checking for client software updates on the server.
	 * @param app The application object.
	 */
	-(void) stopUpdateService;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
