//
//	VidyoCameraControlCapabilities_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

/*!
 * @enum Represents the enumeration of camera control action.
 * @constant VCCameraControlActionStart Start control action for continuous move.
 * @constant VCCameraControlActionStop Stop contraol action for stopping the move.
 * @constant VCCameraControlActionNudge Nudge control action for move the camera to a direction.
 * @constant VCCameraControlActionVisca Visca contraol action for sending visca command.
 * @constant VCCameraControlActionPreset Preset control action for sending the preset index.
 */
typedef NS_ENUM(NSInteger, VCCameraControlAction) {
	VCCameraControlActionStart,
	VCCameraControlActionStop,
	VCCameraControlActionNudge,
	VCCameraControlActionVisca,
	VCCameraControlActionPreset
};
/*!
 * @enum The camera control direction.
 * @constant VCCameraControlDirectionPanLeft 
 * @constant VCCameraControlDirectionPanRight 
 * @constant VCCameraControlDirectionTiltUp 
 * @constant VCCameraControlDirectionTiltDown 
 * @constant VCCameraControlDirectionZoomIn 
 * @constant VCCameraControlDirectionZoomOut 
 * @constant VCCameraControlDirectionNone 
 */
typedef NS_ENUM(NSInteger, VCCameraControlDirection) {
	VCCameraControlDirectionPanLeft,
	VCCameraControlDirectionPanRight,
	VCCameraControlDirectionTiltUp,
	VCCameraControlDirectionTiltDown,
	VCCameraControlDirectionZoomIn,
	VCCameraControlDirectionZoomOut,
	VCCameraControlDirectionNone
};
/*!
 * Represents the capability of a camera control.
 */
@interface VCCameraControlCapabilities : NSObject
{
}
	@property BOOL hasPhotoCapture;
	/*!
	 * Camera supports Presets.
	 */
	@property BOOL hasPresetSupport;
	/*!
	 * Camera supports VISCA Protocol.
	 */
	@property BOOL hasViscaSupport;
	@property BOOL panTiltHasContinuousMove;
	@property BOOL panTiltHasNudge;
	@property BOOL panTiltHasRubberBand;
	@property BOOL zoomHasNudge;
	@property BOOL zoomHasRubberBand;
	@property BOOL zooomHasContinuousMove;
@end
