//
//	VidyoEndpoint_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoAudioFrame_Objc.h"
#import "VidyoChatMessage_Objc.h"
#import "VidyoContactInfo_Objc.h"
#import "VidyoContact_Objc.h"
#import "VidyoDevice_Objc.h"
#import "VidyoEventSchedule_Objc.h"
#import "VidyoLocalCamera_Objc.h"
#import "VidyoLocalMicrophone_Objc.h"
#import "VidyoLocalMonitor_Objc.h"
#import "VidyoLocalRenderer_Objc.h"
#import "VidyoLocalSpeaker_Objc.h"
#import "VidyoLocalWindowShare_Objc.h"
#import "VidyoLogRecord_Objc.h"
#import "VidyoNetworkInterface_Objc.h"
#import "VidyoParticipant_Objc.h"
#import "VidyoProperty_Objc.h"
#import "VidyoRemoteCamera_Objc.h"
#import "VidyoRemoteMicrophone_Objc.h"
#import "VidyoRemoteRenderer_Objc.h"
#import "VidyoRemoteSpeaker_Objc.h"
#import "VidyoRemoteWindowShare_Objc.h"
#import "VidyoRoomProperties_Objc.h"
#import "VidyoStatistics_Objc.h"
#import "VidyoVideoFrame_Objc.h"
#import "VidyoVirtualRenderer_Objc.h"
@class VCCall;
@class VCEndpoint;
@class VCEndpointCameraEffectInfo;
@class VCEndpointGoogleAnalyticsEventTable;
@class VCEndpointGoogleAnalyticsOptions;
@class VCEndpointShareOptions;
@class VCLoggerCategory;
@class VCRoleAuthorization;
@class VCRoom;
@class VCRoomBotInfo;
@class VCRoomConnectionProperties;
@class VCRoomInCallEvent;
@class VCRoomInfo;
@class VCRoomParticipantProfile;
@class VCTenantCapabilities;
@class VCUser;
@class VCUserAuthenticationInfo;
@class VCUserLoginInfo;
@class VCUserTokenInfo;
@class VCVirtualAudioSource;
@class VCVirtualVideoSource;
/*!
 * @enum Reasons why a VidyoCall is ending.
 * @constant VCCallEndReasonEnded Call was terminated locally.
 * @constant VCCallEndReasonConnectionFailed Local entity could not establish a signaling connection to its peer.
 * @constant VCCallEndReasonConnectionLost Signaling connection was lost between the local entity and its peer.
 * @constant VCCallEndReasonParticipantBusy Remote peer is busy and cannot accept the call.
 * @constant VCCallEndReasonParticipantRejected Remote peer rejected the call.
 * @constant VCCallEndReasonParticipantEnded Local entity had a call and the remote peer ended it.
 * @constant VCCallEndReasonMiscError Miscellaneous error occurred.
 */
typedef NS_ENUM(NSInteger, VCCallEndReason) {
	VCCallEndReasonEnded,
	VCCallEndReasonConnectionFailed,
	VCCallEndReasonConnectionLost,
	VCCallEndReasonParticipantBusy,
	VCCallEndReasonParticipantRejected,
	VCCallEndReasonParticipantEnded,
	VCCallEndReasonMiscError
};
/*!
 * @enum Result of an attempt to enter a VidyoCall.
 * @constant VCCallInitiatedResultOK Call entered successfully.
 * @constant VCCallInitiatedResultCancelled Enter request was cancelled.
 * @constant VCCallInitiatedResultNoResponse Server did not respond in a reasonable amount of time to the request to enter the room.
 * @constant VCCallInitiatedResultUnknownParticipant Call specified by the user does not exist.
 * @constant VCCallInitiatedResultMiscLocalError Server is rejecting the request to enter due to some miscellaneous problem with the request.
 * @constant VCCallInitiatedResultMiscRemoteError Server is rejecting the request to enter due to some miscellaneous problem of its own.
 */
typedef NS_ENUM(NSInteger, VCCallInitiatedResult) {
	VCCallInitiatedResultOK,
	VCCallInitiatedResultCancelled,
	VCCallInitiatedResultNoResponse,
	VCCallInitiatedResultUnknownParticipant,
	VCCallInitiatedResultMiscLocalError,
	VCCallInitiatedResultMiscRemoteError
};
/*!
 * @enum 
 * @constant VCClientAppLogLevelInfo 
 * @constant VCClientAppLogLevelDebug 
 * @constant VCClientAppLogLevelWarning 
 * @constant VCClientAppLogLevelError 
 */
typedef NS_ENUM(NSInteger, VCClientAppLogLevel) {
	VCClientAppLogLevelInfo,
	VCClientAppLogLevelDebug,
	VCClientAppLogLevelWarning,
	VCClientAppLogLevelError
};
/*!
 * @enum Indicates the audio mode.
 * @constant VCEndpointAudioModeSharedModeBoth Both audio devices (Speaker and Microphone) used in shared mode.
 * @constant VCEndpointAudioModeExclusiveModeBoth Both audio devices (Speaker and Microphone) used in exclusive mode.
 * @constant VCEndpointAudioModeExclusiveModeMicrophone Microphone is used in exclusive mode and speaker in shared mode..
 * @constant VCEndpointAudioModeUnknown Unknown audio mode.
 */
typedef NS_ENUM(NSInteger, VCEndpointAudioMode) {
	VCEndpointAudioModeSharedModeBoth,
	VCEndpointAudioModeExclusiveModeBoth,
	VCEndpointAudioModeExclusiveModeMicrophone,
	VCEndpointAudioModeUnknown
};
/*!
 * @enum Base transport type.
 * @constant VCEndpointBaseTransportTypeTLS Use TLS as base transport.
 * @constant VCEndpointBaseTransportTypeTCP Use TCP as base transport.
 * @constant VCEndpointBaseTransportTypeUDP Use UDP as base transport.
 */
typedef NS_ENUM(NSInteger, VCEndpointBaseTransportType) {
	VCEndpointBaseTransportTypeTLS,
	VCEndpointBaseTransportTypeTCP,
	VCEndpointBaseTransportTypeUDP
};
/*!
 * @enum Provides the error codes for camera background effect.
 * @constant VCEndpointCameraEffectErrorNone No errors.
 * @constant VCEndpointCameraEffectErrorInvalidToken The token is empty or expired.
 * @constant VCEndpointCameraEffectErrorInvalidResources The path to resources is empty or does not contain some files.
 * @constant VCEndpointCameraEffectErrorInvalidEffect The path to effect is empty or does not contain some files.
 * @constant VCEndpointCameraEffectErrorInvalidBlurIntensity The blur intensity is out of allowed range.
 * @constant VCEndpointCameraEffectErrorInvalidBackgroundPicture The path to background picture is empty or file doesn't exist or has unsupported format.
 * @constant VCEndpointCameraEffectErrorLoadEffectFailed Failed to load effect.
 * @constant VCEndpointCameraEffectErrorUnsupportedOpenGLVersion Effect was not started due to unsupported OpenGL version.
 * @constant VCEndpointCameraEffectErrorUnsupportedLibraryVersion Effect was not started due to unsupported Banuba library version.
 * @constant VCEndpointCameraEffectErrorNotAllowedForCurrectEffect Opperation is not allowed with the current effect.
 * @constant VCEndpointCameraEffectErrorMiscError Miscellaneous error.
 */
typedef NS_ENUM(NSInteger, VCEndpointCameraEffectError) {
	VCEndpointCameraEffectErrorNone,
	VCEndpointCameraEffectErrorInvalidToken,
	VCEndpointCameraEffectErrorInvalidResources,
	VCEndpointCameraEffectErrorInvalidEffect,
	VCEndpointCameraEffectErrorInvalidBlurIntensity,
	VCEndpointCameraEffectErrorInvalidBackgroundPicture,
	VCEndpointCameraEffectErrorLoadEffectFailed,
	VCEndpointCameraEffectErrorUnsupportedOpenGLVersion,
	VCEndpointCameraEffectErrorUnsupportedLibraryVersion,
	VCEndpointCameraEffectErrorNotAllowedForCurrectEffect,
	VCEndpointCameraEffectErrorMiscError
};
/*!
 * @enum Provides the supported camera background effects and used to enable or disable effect.
 * @constant VCEndpointCameraEffectTypeNone Disables active effects.
 * @constant VCEndpointCameraEffectTypeBlur Enables background blur effect.
 * @constant VCEndpointCameraEffectTypeVirtualBackground Enables virtual background effect.
 */
typedef NS_ENUM(NSInteger, VCEndpointCameraEffectType) {
	VCEndpointCameraEffectTypeNone,
	VCEndpointCameraEffectTypeBlur,
	VCEndpointCameraEffectTypeVirtualBackground
};
/*!
 * @enum Provide the advanced error code to the application.
 * @constant VCEndpointErrorCodeNotAllowed Not allowed.
 * @constant VCEndpointErrorCodeWrongState Called in wrong state.
 * @constant VCEndpointErrorCodeInvalidInput Invalid input.
 * @constant VCEndpointErrorCodeMisc Miscellaneous remote error.
 */
typedef NS_ENUM(NSInteger, VCEndpointErrorCode) {
	VCEndpointErrorCodeNotAllowed,
	VCEndpointErrorCodeWrongState,
	VCEndpointErrorCodeInvalidInput,
	VCEndpointErrorCodeMisc
};
/*!
 * @enum Result of getting the logger category list.
 * @constant VCEndpointGetLoggerCategoryListResultSUCCESS Logger category list was got successfully.
 * @constant VCEndpointGetLoggerCategoryListResultMiscError The getting of logger category list failed some miscellaneous reason.
 */
typedef NS_ENUM(NSInteger, VCEndpointGetLoggerCategoryListResult) {
	VCEndpointGetLoggerCategoryListResultSUCCESS,
	VCEndpointGetLoggerCategoryListResultMiscError
};
/*!
 * @enum Represents the event action of google analytics service.
 * @constant VCEndpointGoogleAnalyticsEventActionLoginSuccess Action for success login.
 * @constant VCEndpointGoogleAnalyticsEventActionLoginAttempt Action for login attempt.
 * @constant VCEndpointGoogleAnalyticsEventActionLoginFailedAuthentication Action for login failed: authentication failed.
 * @constant VCEndpointGoogleAnalyticsEventActionLoginFailedConnect Action for login failed: failed to connect.
 * @constant VCEndpointGoogleAnalyticsEventActionLoginFailedResponseTimeout Action for login failed: response timeout.
 * @constant VCEndpointGoogleAnalyticsEventActionLoginFailedMiscError Action for login failed: misc error.
 * @constant VCEndpointGoogleAnalyticsEventActionLoginFailedWebProxyAuthRequired Action for login failed: webproxy authentication required.
 * @constant VCEndpointGoogleAnalyticsEventActionLoginFailedUnsupportedTenantVersion Action for login failed: unsupported tenant version.
 * @constant VCEndpointGoogleAnalyticsEventActionUserTypeGuest Action to indicate if user type is guest.
 * @constant VCEndpointGoogleAnalyticsEventActionUserTypeRegularToken Action to indicate if user type is regular: token.
 * @constant VCEndpointGoogleAnalyticsEventActionUserTypeRegularPassword Action to indicate if user type is regular: password.
 * @constant VCEndpointGoogleAnalyticsEventActionUserTypeRegularSaml Action to indicate if user type is regular: saml.
 * @constant VCEndpointGoogleAnalyticsEventActionUserTypeRegularExtdata Action to indicate if user type is regular: extdata.
 * @constant VCEndpointGoogleAnalyticsEventActionJoinConferenceSuccess Action to indicate join conference success.
 * @constant VCEndpointGoogleAnalyticsEventActionJoinConferenceAttempt Action to indicate join conference attempt.
 * @constant VCEndpointGoogleAnalyticsEventActionJoinConferenceReconnectRequests Action to indicate join conference reconnect requests.
 * @constant VCEndpointGoogleAnalyticsEventActionJoinConferenceFailedConnectionError Action to indicate join conference failed due to connection error.
 * @constant VCEndpointGoogleAnalyticsEventActionJoinConferenceFailedWrongPin Action to indicate join conference failed due to wrong Pin.
 * @constant VCEndpointGoogleAnalyticsEventActionJoinConferenceFailedRoomFull Action to indicate join conference failed because room is full.
 * @constant VCEndpointGoogleAnalyticsEventActionJoinConferenceFailedRoomDisabled Action to indicate join conference failed because room disabled.
 * @constant VCEndpointGoogleAnalyticsEventActionJoinConferenceFailedConferenceLocked Action to indicate join conference failed because conference is locked.
 * @constant VCEndpointGoogleAnalyticsEventActionJoinConferenceFailedUnknownError Action to indicate join conference failed due to unknown error.
 * @constant VCEndpointGoogleAnalyticsEventActionConferenceEndLeft Action to indicate conference left.
 * @constant VCEndpointGoogleAnalyticsEventActionConferenceEndBooted Action to indicate conference end booted.
 * @constant VCEndpointGoogleAnalyticsEventActionConferenceEndSignalingConnectionLost Action to indicate conference end signaling connection lost.
 * @constant VCEndpointGoogleAnalyticsEventActionConferenceEndMediaConnectionLost Action to indicate conference end failed media connection lost.
 * @constant VCEndpointGoogleAnalyticsEventActionConferenceEndUnknownError Action to indicate conference end unknown error.
 * @constant VCEndpointGoogleAnalyticsEventActionInCallCodecVideoH264 Action to indicate H264 video codec is used in a conference call.
 * @constant VCEndpointGoogleAnalyticsEventActionInCallCodecVideoH264SVC Action to indicate H264-SVC video codec is used in a conference call.
 * @constant VCEndpointGoogleAnalyticsEventActionInCallCodecAudioSPEEXRED Action to indicate SPEEX RED audio codec is used in a conference call.
 * @constant VCEndpointGoogleAnalyticsEventActionAll All actions in category should be sent.
 * @constant VCEndpointGoogleAnalyticsEventActionUnknown Unknown event action.
 */
typedef NS_ENUM(NSInteger, VCEndpointGoogleAnalyticsEventAction) {
	VCEndpointGoogleAnalyticsEventActionLoginSuccess,
	VCEndpointGoogleAnalyticsEventActionLoginAttempt,
	VCEndpointGoogleAnalyticsEventActionLoginFailedAuthentication,
	VCEndpointGoogleAnalyticsEventActionLoginFailedConnect,
	VCEndpointGoogleAnalyticsEventActionLoginFailedResponseTimeout,
	VCEndpointGoogleAnalyticsEventActionLoginFailedMiscError,
	VCEndpointGoogleAnalyticsEventActionLoginFailedWebProxyAuthRequired,
	VCEndpointGoogleAnalyticsEventActionLoginFailedUnsupportedTenantVersion,
	VCEndpointGoogleAnalyticsEventActionUserTypeGuest,
	VCEndpointGoogleAnalyticsEventActionUserTypeRegularToken,
	VCEndpointGoogleAnalyticsEventActionUserTypeRegularPassword,
	VCEndpointGoogleAnalyticsEventActionUserTypeRegularSaml,
	VCEndpointGoogleAnalyticsEventActionUserTypeRegularExtdata,
	VCEndpointGoogleAnalyticsEventActionJoinConferenceSuccess,
	VCEndpointGoogleAnalyticsEventActionJoinConferenceAttempt,
	VCEndpointGoogleAnalyticsEventActionJoinConferenceReconnectRequests,
	VCEndpointGoogleAnalyticsEventActionJoinConferenceFailedConnectionError,
	VCEndpointGoogleAnalyticsEventActionJoinConferenceFailedWrongPin,
	VCEndpointGoogleAnalyticsEventActionJoinConferenceFailedRoomFull,
	VCEndpointGoogleAnalyticsEventActionJoinConferenceFailedRoomDisabled,
	VCEndpointGoogleAnalyticsEventActionJoinConferenceFailedConferenceLocked,
	VCEndpointGoogleAnalyticsEventActionJoinConferenceFailedUnknownError,
	VCEndpointGoogleAnalyticsEventActionConferenceEndLeft,
	VCEndpointGoogleAnalyticsEventActionConferenceEndBooted,
	VCEndpointGoogleAnalyticsEventActionConferenceEndSignalingConnectionLost,
	VCEndpointGoogleAnalyticsEventActionConferenceEndMediaConnectionLost,
	VCEndpointGoogleAnalyticsEventActionConferenceEndUnknownError,
	VCEndpointGoogleAnalyticsEventActionInCallCodecVideoH264,
	VCEndpointGoogleAnalyticsEventActionInCallCodecVideoH264SVC,
	VCEndpointGoogleAnalyticsEventActionInCallCodecAudioSPEEXRED,
	VCEndpointGoogleAnalyticsEventActionAll,
	VCEndpointGoogleAnalyticsEventActionUnknown
};
/*!
 * @enum Represents the event category of google analytics service.
 * @constant VCEndpointGoogleAnalyticsEventCategoryLogin The login event category.
 * @constant VCEndpointGoogleAnalyticsEventCategoryUserType The user type event category.
 * @constant VCEndpointGoogleAnalyticsEventCategoryJoinConference The join Conference event category.
 * @constant VCEndpointGoogleAnalyticsEventCategoryConferenceEnd The conference end event category.
 * @constant VCEndpointGoogleAnalyticsEventCategoryInCallCodec The in-call codec event category.
 * @constant VCEndpointGoogleAnalyticsEventCategoryNone Unknown event category.
 */
typedef NS_ENUM(NSInteger, VCEndpointGoogleAnalyticsEventCategory) {
	VCEndpointGoogleAnalyticsEventCategoryLogin,
	VCEndpointGoogleAnalyticsEventCategoryUserType,
	VCEndpointGoogleAnalyticsEventCategoryJoinConference,
	VCEndpointGoogleAnalyticsEventCategoryConferenceEnd,
	VCEndpointGoogleAnalyticsEventCategoryInCallCodec,
	VCEndpointGoogleAnalyticsEventCategoryNone
};
/*!
 * @enum Result of file log compression.
 * @constant VCEndpointLogCompressionResultSuccess File Compressed successfully.
 * @constant VCEndpointLogCompressionResultMiscError The compression failed some miscellaneous reason.
 */
typedef NS_ENUM(NSInteger, VCEndpointLogCompressionResult) {
	VCEndpointLogCompressionResultSuccess,
	VCEndpointLogCompressionResultMiscError
};
/*!
 * @enum Type of the logger.
 * @constant VCEndpointLoggerTypeCONSOLE Logger type is console logger.
 * @constant VCEndpointLoggerTypeFILE Logger type is file logger.
 * @constant VCEndpointLoggerTypeFEEDBACK Logger type is feedback logger.
 * @constant VCEndpointLoggerTypeHTTP Logger type is HTTP logger.
 */
typedef NS_ENUM(NSInteger, VCEndpointLoggerType) {
	VCEndpointLoggerTypeCONSOLE,
	VCEndpointLoggerTypeFILE,
	VCEndpointLoggerTypeFEEDBACK,
	VCEndpointLoggerTypeHTTP
};
/*!
 * @enum 
 * @constant VCEndpointMediaStateIdle 
 * @constant VCEndpointMediaStateGreenRoom 
 * @constant VCEndpointMediaStateLive 
 */
typedef NS_ENUM(NSInteger, VCEndpointMediaState) {
	VCEndpointMediaStateIdle,
	VCEndpointMediaStateGreenRoom,
	VCEndpointMediaStateLive
};
/*!
 * @enum Operating modes of the VidyoEndpoint.
 * @constant VCEndpointModeDefault The default operating mode.
 * @constant VCEndpointModeForeground Runs in the foreground.
 * @constant VCEndpointModeBackground Runs in the background.
 */
typedef NS_ENUM(NSInteger, VCEndpointMode) {
	VCEndpointModeDefault,
	VCEndpointModeForeground,
	VCEndpointModeBackground
};
/*!
 * @enum Lists available actions for next generation renderer library.
 * @constant VCEndpointNGRActionTypeSetLayout Sets the layout.
 * @constant VCEndpointNGRActionTypeSetViewSize Sets the view size.
 * @constant VCEndpointNGRActionTypeSetDebugInfoVisible Sets the visibility of debug information.
 * @constant VCEndpointNGRActionTypeSetLabelVisible Sets the visibility of labels on renderer.
 * @constant VCEndpointNGRActionTypeSetAudioMeterVisible Sets the visibility of audio meter on tiles.
 * @constant VCEndpointNGRActionTypeSetBackgroundColor Sets the background color.
 * @constant VCEndpointNGRActionTypeSetDensity Sets the density.
 * @constant VCEndpointNGRActionTypeSetMaxRemoteParticipants Sets the max remote participants.
 * @constant VCEndpointNGRActionTypePinParticipant Pin the participants.
 * @constant VCEndpointNGRActionTypeShowAudioTiles Sets whether to show audio only tiles.
 * @constant VCEndpointNGRActionTypeInvalid Invalid action.
 */
typedef NS_ENUM(NSInteger, VCEndpointNGRActionType) {
	VCEndpointNGRActionTypeSetLayout,
	VCEndpointNGRActionTypeSetViewSize,
	VCEndpointNGRActionTypeSetDebugInfoVisible,
	VCEndpointNGRActionTypeSetLabelVisible,
	VCEndpointNGRActionTypeSetAudioMeterVisible,
	VCEndpointNGRActionTypeSetBackgroundColor,
	VCEndpointNGRActionTypeSetDensity,
	VCEndpointNGRActionTypeSetMaxRemoteParticipants,
	VCEndpointNGRActionTypePinParticipant,
	VCEndpointNGRActionTypeShowAudioTiles,
	VCEndpointNGRActionTypeInvalid
};
/*!
 * @enum Preferred audio codec to be set.
 * @constant VCEndpointPreferredAudioCodecOpusRed Preferred audio codec is OPUS RED.
 * @constant VCEndpointPreferredAudioCodecOpus Preferred audio codec is OPUS.
 * @constant VCEndpointPreferredAudioCodecSpeexRed Preferred audio codec is SPEEX RED.
 * @constant VCEndpointPreferredAudioCodecUnknown Preferred audio codec is Unknown.
 */
typedef NS_ENUM(NSInteger, VCEndpointPreferredAudioCodec) {
	VCEndpointPreferredAudioCodecOpusRed,
	VCEndpointPreferredAudioCodecOpus,
	VCEndpointPreferredAudioCodecSpeexRed,
	VCEndpointPreferredAudioCodecUnknown
};
/*!
 * @enum This type indicates the reason why an attempt to reconnect failed.
 * @constant VCEndpointReconnectFailReasonCancelled Media support was disabled (by calling VidyoRoomDisableMedia) before an attempt to enable it completed.
 * @constant VCEndpointReconnectFailReasonNoConference There was an error determining which conference to join.
 * @constant VCEndpointReconnectFailReasonSignalingConnectionLost Signaling Connection lost on current transport.
 * @constant VCEndpointReconnectFailReasonMediaConnectionLost Media Connection lost on current transport.
 * @constant VCEndpointReconnectFailReasonNoResponse Signaling messages were sent to enable media, but no response was received within the allotted amount of time.
 * @constant VCEndpointReconnectFailReasonInvalidPassword Media support was disabled because the room password has changed.
 * @constant VCEndpointReconnectFailReasonInvalidRoomPin Media support was disabled because the room pin has changed.
 * @constant VCEndpointReconnectFailReasonRoomIsFull Media support was disabled because the room is full.
 * @constant VCEndpointReconnectFailReasonInvalidRoomKey Media support was disabled because the room is invalid.
 * @constant VCEndpointReconnectFailReasonRoomDisabled Media support was disabled because the room is disabled.
 * @constant VCEndpointReconnectFailReasonAllLinesInUse Media support was disabled because all lines are in use.
 * @constant VCEndpointReconnectFailReasonConnectionError Media support was disabled because the of a connection error.
 * @constant VCEndpointReconnectFailReasonInvalidRoom 
 * @constant VCEndpointReconnectFailReasonConferenceLocked Media support was disabled because the room is locked.
 * @constant VCEndpointReconnectFailReasonSeatLicenseExpired Media support was disabled because the seat license has expired.
 * @constant VCEndpointReconnectFailReasonNotLicensed Media support was disabled because the endpoint is not licensed.
 * @constant VCEndpointReconnectFailReasonRejected Attempt to enable media was rejected by the server
 * @constant VCEndpointReconnectFailReasonUnknownError Media support was disabled as there an unknown fault from the portal.
 * @constant VCEndpointReconnectFailReasonMiscLocalError Some miscellaneous problem occurred with this application.
 * @constant VCEndpointReconnectFailReasonMiscRemoteError Some miscellaneous problem occurred with the conferencing service.
 */
typedef NS_ENUM(NSInteger, VCEndpointReconnectFailReason) {
	VCEndpointReconnectFailReasonCancelled,
	VCEndpointReconnectFailReasonNoConference,
	VCEndpointReconnectFailReasonSignalingConnectionLost,
	VCEndpointReconnectFailReasonMediaConnectionLost,
	VCEndpointReconnectFailReasonNoResponse,
	VCEndpointReconnectFailReasonInvalidPassword,
	VCEndpointReconnectFailReasonInvalidRoomPin,
	VCEndpointReconnectFailReasonRoomIsFull,
	VCEndpointReconnectFailReasonInvalidRoomKey,
	VCEndpointReconnectFailReasonRoomDisabled,
	VCEndpointReconnectFailReasonAllLinesInUse,
	VCEndpointReconnectFailReasonConnectionError,
	VCEndpointReconnectFailReasonInvalidRoom,
	VCEndpointReconnectFailReasonConferenceLocked,
	VCEndpointReconnectFailReasonSeatLicenseExpired,
	VCEndpointReconnectFailReasonNotLicensed,
	VCEndpointReconnectFailReasonRejected,
	VCEndpointReconnectFailReasonUnknownError,
	VCEndpointReconnectFailReasonMiscLocalError,
	VCEndpointReconnectFailReasonMiscRemoteError
};
/*!
 * @enum 
 * @constant VCEndpointToneJoin 
 * @constant VCEndpointToneLeave 
 * @constant VCEndpointToneMsgRecv 
 * @constant VCEndpointToneMsgSend 
 * @constant VCEndpointToneRing 
 * @constant VCEndpointToneMax 
 */
typedef NS_ENUM(NSInteger, VCEndpointTone) {
	VCEndpointToneJoin,
	VCEndpointToneLeave,
	VCEndpointToneMsgRecv,
	VCEndpointToneMsgSend,
	VCEndpointToneRing,
	VCEndpointToneMax
};
/*!
 * @enum 
 * @constant VCEndpointTradeOffProfileHigh 
 * @constant VCEndpointTradeOffProfileMedium 
 * @constant VCEndpointTradeOffProfileLow 
 * @constant VCEndpointTradeOffProfileLowAlt an alternative low configuration driving CPU tradeoff lower than VIDYO_ENDPOINTTRADEOFFPROFILE_Low
 */
typedef NS_ENUM(NSInteger, VCEndpointTradeOffProfile) {
	VCEndpointTradeOffProfileHigh,
	VCEndpointTradeOffProfileMedium,
	VCEndpointTradeOffProfileLow,
	VCEndpointTradeOffProfileLowAlt
};
/*!
 * @enum Type of the virtual video source.
 * @constant VCVirtualVideoSourceTypeSHARE The type of virtual video source is a share.
 * @constant VCVirtualVideoSourceTypeCAMERA The type of virtual video source is a camera.
 */
typedef NS_ENUM(NSInteger, VCVirtualVideoSourceType) {
	VCVirtualVideoSourceTypeSHARE,
	VCVirtualVideoSourceTypeCAMERA
};
/*!
 * @enum 
 * @constant VCRoleModerator 
 * @constant VCRoleNone 
 */
typedef NS_ENUM(NSInteger, VCRole) {
	VCRoleModerator,
	VCRoleNone
};
/*!
 * @enum Tell us the joining status of the host or owner of the room hosting the conference.
 * @constant VCRoomConferenceHostStateJOINED Tells us if the host has joined
 * @constant VCRoomConferenceHostStateLEFT Tells us if the host has left the conference
 */
typedef NS_ENUM(NSInteger, VCRoomConferenceHostState) {
	VCRoomConferenceHostStateJOINED,
	VCRoomConferenceHostStateLEFT
};
/*!
 * @enum Sets the type of conference mode.
 * @constant VCRoomConferenceModeLOBBY Tells us if the user has entered into a waiting room,i.e. presenter has not joined yet
 * @constant VCRoomConferenceModeLECTURE Tells us if conference mode is lecture mode
 * @constant VCRoomConferenceModeGROUP Tells us if the user is in group mode
 */
typedef NS_ENUM(NSInteger, VCRoomConferenceMode) {
	VCRoomConferenceModeLOBBY,
	VCRoomConferenceModeLECTURE,
	VCRoomConferenceModeGROUP
};
/*!
 * @enum This type indicates the result of delete room.
 * @constant VCRoomDeleteResultOK The delete room operation was successful.
 * @constant VCRoomDeleteResultNoResponse The server did not respond in a reasonable amount of time to the request to delete room.
 * @constant VCRoomDeleteResultUnauthorized The user did not have permission to delete room.
 * @constant VCRoomDeleteResultOutOfResources The server cannot delete rooms at the current time because it is out of some resource.
 * @constant VCRoomDeleteResultMiscError Some other error occurred.
 */
typedef NS_ENUM(NSInteger, VCRoomDeleteResult) {
	VCRoomDeleteResultOK,
	VCRoomDeleteResultNoResponse,
	VCRoomDeleteResultUnauthorized,
	VCRoomDeleteResultOutOfResources,
	VCRoomDeleteResultMiscError
};
/*!
 * @enum Result of an attempt to enter a VidyoRoom.
 * @constant VCRoomEnterResultOK Room entered successfully.
 * @constant VCRoomEnterResultCancelled Enter request was cancelled.
 * @constant VCRoomEnterResultNoResponse Server did not respond in a reasonable amount of time to the request to enter the room.
 * @constant VCRoomEnterResultInvalidPassword User did not provide a password when one was required, or provided an invalid password.
 * @constant VCRoomEnterResultUnknownRoom Room specified by the user does not exist.
 * @constant VCRoomEnterResultRoomFull Room is at full capacity and cannot accept additional members.
 * @constant VCRoomEnterResultRoomLocked Room is locked.
 * @constant VCRoomEnterResultNotMember Room allows only certain users to enter, and the user is not one of them.
 * @constant VCRoomEnterResultBanned User has been banned from entering the room.
 * @constant VCRoomEnterResultMiscLocalError Server is rejecting the request to enter due to some miscellaneous problem with the request.
 * @constant VCRoomEnterResultMiscRemoteError Server is rejecting the request to enter due to some miscellaneous problem of its own.
 */
typedef NS_ENUM(NSInteger, VCRoomEnterResult) {
	VCRoomEnterResultOK,
	VCRoomEnterResultCancelled,
	VCRoomEnterResultNoResponse,
	VCRoomEnterResultInvalidPassword,
	VCRoomEnterResultUnknownRoom,
	VCRoomEnterResultRoomFull,
	VCRoomEnterResultRoomLocked,
	VCRoomEnterResultNotMember,
	VCRoomEnterResultBanned,
	VCRoomEnterResultMiscLocalError,
	VCRoomEnterResultMiscRemoteError
};
/*!
 * @enum Reason why a user is no longer a participant of a VidyoRoom.
 * @constant VCRoomExitReasonLeft Leave was invoked, and this action completed successfully.
 * @constant VCRoomExitReasonConnectionLost Connectivity was lost and signaling messages can no longer be sent or received.
 * @constant VCRoomExitReasonSessionConnectionLost Session connectivity was lost.
 * @constant VCRoomExitReasonMembershipConnectionLost Membership connectivity was lost.
 * @constant VCRoomExitReasonNoResponse A signaling request was sent, but no response was received within the allotted amount of time.
 * @constant VCRoomExitReasonProtocolViolation A signaling message was received that could not be understood or otherwise violated the rules of the protocol in use.
 * @constant VCRoomExitReasonBooted User was kicked out of the room. This could be the result of an administrator's action.
 * @constant VCRoomExitReasonShuttingDown Room or the entire conferencing service is going offline. All users are being removed from the room.
 * @constant VCRoomExitReasonMiscLocalError Some miscellaneous problem occurred with this application.
 * @constant VCRoomExitReasonMiscRemoteError Some miscellaneous problem occurred with the conferencing service.
 */
typedef NS_ENUM(NSInteger, VCRoomExitReason) {
	VCRoomExitReasonLeft,
	VCRoomExitReasonConnectionLost,
	VCRoomExitReasonSessionConnectionLost,
	VCRoomExitReasonMembershipConnectionLost,
	VCRoomExitReasonNoResponse,
	VCRoomExitReasonProtocolViolation,
	VCRoomExitReasonBooted,
	VCRoomExitReasonShuttingDown,
	VCRoomExitReasonMiscLocalError,
	VCRoomExitReasonMiscRemoteError
};
/*!
 * @enum This type indicates the result of get room properties.
 * @constant VCRoomGetPropertiesResultOK The get properties operation was successful.
 * @constant VCRoomGetPropertiesResultNoResponse The server did not respond in a reasonable amount of time to the request to get room properties.
 * @constant VCRoomGetPropertiesResultUnauthorized The user did not have permission to get room properties.
 * @constant VCRoomGetPropertiesResultMiscLocalError The server is rejecting the request to get room properties due to some miscellaneous problem with the request.
 * @constant VCRoomGetPropertiesResultMiscRemoteError The server is rejecting the request to get room properties due to some miscellaneous problem of its own.
 */
typedef NS_ENUM(NSInteger, VCRoomGetPropertiesResult) {
	VCRoomGetPropertiesResultOK,
	VCRoomGetPropertiesResultNoResponse,
	VCRoomGetPropertiesResultUnauthorized,
	VCRoomGetPropertiesResultMiscLocalError,
	VCRoomGetPropertiesResultMiscRemoteError
};
/*!
 * @enum It identifies the class of in call event.
 * @constant VCRoomInCallEventClassMediaTransport It indicate event belongs to media transportation.
 * @constant VCRoomInCallEventClassInCallCodec It indicate event belongs to InCallCodec.
 * @constant VCRoomInCallEventClassDtls It indicate event belongs to Dtls.
 * @constant VCRoomInCallEventClassUnKnown It indicate Unknown event.
 */
typedef NS_ENUM(NSInteger, VCRoomInCallEventClass) {
	VCRoomInCallEventClassMediaTransport,
	VCRoomInCallEventClassInCallCodec,
	VCRoomInCallEventClassDtls,
	VCRoomInCallEventClassUnKnown
};
/*!
 * @enum It represents error code in call event.
 * @constant VCRoomInCallEventCodeRTCPSendError RTCP send fail.
 * @constant VCRoomInCallEventCodeRTCPReceiveError RTCP receive fail.
 * @constant VCRoomInCallEventCodeRTPSendError RTP media packet send fail.
 * @constant VCRoomInCallEventCodeRTPReceiveError RTP media packet receive fail.
 * @constant VCRoomInCallEventCodeEncoderPausedOnLowBW Notification when encoder pauses when low bandwidth condition occur.
 * @constant VCRoomInCallEventCodeEncoderResumed Notification when encoder resumes after pause.
 * @constant VCRoomInCallEventCodeInCallCodecVideoH264 Notification when H264 video codec is used in a conference call.
 * @constant VCRoomInCallEventCodeInCallCodecVideoH264SVC Notification when H264-SVC video codec is used in a conference call.
 * @constant VCRoomInCallEventCodeInCallCodecAudioSPEEXRED Notification when SPEEX RED audio codec is used in a conference call.
 * @constant VCRoomInCallEventCodeDtlsError Notification when Dtls encryption fails.
 * @constant VCRoomInCallEventCodeUnKnown Unknown event code.
 */
typedef NS_ENUM(NSInteger, VCRoomInCallEventCode) {
	VCRoomInCallEventCodeRTCPSendError,
	VCRoomInCallEventCodeRTCPReceiveError,
	VCRoomInCallEventCodeRTPSendError,
	VCRoomInCallEventCodeRTPReceiveError,
	VCRoomInCallEventCodeEncoderPausedOnLowBW,
	VCRoomInCallEventCodeEncoderResumed,
	VCRoomInCallEventCodeInCallCodecVideoH264,
	VCRoomInCallEventCodeInCallCodecVideoH264SVC,
	VCRoomInCallEventCodeInCallCodecAudioSPEEXRED,
	VCRoomInCallEventCodeDtlsError,
	VCRoomInCallEventCodeUnKnown
};
/*!
 * @enum This type indicates the result of an attempt to invite an user to a room.
 * @constant VCRoomInviteResultOK The invite operation was successful.
 * @constant VCRoomInviteResultNoResponse The server did not respond in a reasonable amount of time to the request to invite user to the room.
 * @constant VCRoomInviteResultUnauthorized The user does not have sufficient privileges to invite user to the room it requested.
 * @constant VCRoomInviteResultOutOfResources The server cannot delete rooms at the current time because it is out of some resource.
 * @constant VCRoomInviteResultMiscError Some other error occurred.
 * @constant VCRoomInviteResultUserIsOffline User we are attempting to invite to a room is offline.
 * @constant VCRoomInviteResultServerError Server returned an error while attemptig to invite user to the room.
 * @constant VCRoomInviteResultRoomFull Room is currently full.
 */
typedef NS_ENUM(NSInteger, VCRoomInviteResult) {
	VCRoomInviteResultOK,
	VCRoomInviteResultNoResponse,
	VCRoomInviteResultUnauthorized,
	VCRoomInviteResultOutOfResources,
	VCRoomInviteResultMiscError,
	VCRoomInviteResultUserIsOffline,
	VCRoomInviteResultServerError,
	VCRoomInviteResultRoomFull
};
/*!
 * @enum This type indicates the reason why media support is now disabled on a room.
 * @constant VCRoomMediaDisableReasonDisabled Media support was disabled gracefully (after calling VidyoRoomEnableMedia).
 * @constant VCRoomMediaDisableReasonSignalingConnectionLost Signaling connectivity to the conference server was lost.
 * @constant VCRoomMediaDisableReasonMediaConnectionLost Media connectivity to the conference server was lost.
 * @constant VCRoomMediaDisableReasonBooted The server is ousting this member from the conference. This could be the result of an administrator's action.
 * @constant VCRoomMediaDisableReasonSessionTerminated The session that was carrying the conferencing protocol has been terminated.
 * @constant VCRoomMediaDisableReasonServerShuttingDown The conference server is shutting down. All members of all conferences are being booted.
 * @constant VCRoomMediaDisableReasonConferenceDestroyed The conference is being destroyed. All members of the conference are being booted.
 * @constant VCRoomMediaDisableReasonMiscLocalError Some miscellaneous problem occurred with this application.
 * @constant VCRoomMediaDisableReasonMiscRemoteError Some miscellaneous problem occurred with the conferencing service.
 */
typedef NS_ENUM(NSInteger, VCRoomMediaDisableReason) {
	VCRoomMediaDisableReasonDisabled,
	VCRoomMediaDisableReasonSignalingConnectionLost,
	VCRoomMediaDisableReasonMediaConnectionLost,
	VCRoomMediaDisableReasonBooted,
	VCRoomMediaDisableReasonSessionTerminated,
	VCRoomMediaDisableReasonServerShuttingDown,
	VCRoomMediaDisableReasonConferenceDestroyed,
	VCRoomMediaDisableReasonMiscLocalError,
	VCRoomMediaDisableReasonMiscRemoteError
};
/*!
 * @enum This type indicates the reason why an attempt to enable media on a room failed.
 * @constant VCRoomMediaFailReasonCancelled Media support was disabled (by calling VidyoRoomDisableMedia) before an attempt to enable it completed.
 * @constant VCRoomMediaFailReasonNoConference There was an error determining which conference to join.
 * @constant VCRoomMediaFailReasonSignalingConnectionLost Signaling Connection lost on current transport.
 * @constant VCRoomMediaFailReasonMediaConnectionLost Media Connection lost on current transport.
 * @constant VCRoomMediaFailReasonNoResponse Signaling messages were sent to enable media, but no response was received within the allotted amount of time.
 * @constant VCRoomMediaFailReasonInvalidPassword Media support was disabled because the room password has changed.
 * @constant VCRoomMediaFailReasonInvalidRoomPin Media support was disabled because the room pin has changed.
 * @constant VCRoomMediaFailReasonRoomIsFull Media support was disabled because the room is full.
 * @constant VCRoomMediaFailReasonInvalidRoomKey Media support was disabled because the room is invalid.
 * @constant VCRoomMediaFailReasonRoomDisabled Media support was disabled because the room is disabled.
 * @constant VCRoomMediaFailReasonAllLinesInUse Media support was disabled because all lines are in use.
 * @constant VCRoomMediaFailReasonConnectionError Media support was disabled because the of a connection error.
 * @constant VCRoomMediaFailReasonInvalidRoom 
 * @constant VCRoomMediaFailReasonConferenceLocked Media support was disabled because the room is locked.
 * @constant VCRoomMediaFailReasonSeatLicenseExpired Media support was disabled because the seat license has expired.
 * @constant VCRoomMediaFailReasonNotLicensed Media support was disabled because the endpoint is not licensed.
 * @constant VCRoomMediaFailReasonRejected Attempt to enable media was rejected by the server
 * @constant VCRoomMediaFailReasonUnknownError Media support was disabled as there an unknown fault from the portal.
 * @constant VCRoomMediaFailReasonMiscLocalError Some miscellaneous problem occurred with this application.
 * @constant VCRoomMediaFailReasonMiscRemoteError Some miscellaneous problem occurred with the conferencing service.
 */
typedef NS_ENUM(NSInteger, VCRoomMediaFailReason) {
	VCRoomMediaFailReasonCancelled,
	VCRoomMediaFailReasonNoConference,
	VCRoomMediaFailReasonSignalingConnectionLost,
	VCRoomMediaFailReasonMediaConnectionLost,
	VCRoomMediaFailReasonNoResponse,
	VCRoomMediaFailReasonInvalidPassword,
	VCRoomMediaFailReasonInvalidRoomPin,
	VCRoomMediaFailReasonRoomIsFull,
	VCRoomMediaFailReasonInvalidRoomKey,
	VCRoomMediaFailReasonRoomDisabled,
	VCRoomMediaFailReasonAllLinesInUse,
	VCRoomMediaFailReasonConnectionError,
	VCRoomMediaFailReasonInvalidRoom,
	VCRoomMediaFailReasonConferenceLocked,
	VCRoomMediaFailReasonSeatLicenseExpired,
	VCRoomMediaFailReasonNotLicensed,
	VCRoomMediaFailReasonRejected,
	VCRoomMediaFailReasonUnknownError,
	VCRoomMediaFailReasonMiscLocalError,
	VCRoomMediaFailReasonMiscRemoteError
};
/*!
 * @enum This type indicates the action of moderation request.
 * @constant VCRoomModerationActionTypeMute Mute video or audio action.
 * @constant VCRoomModerationActionTypeUnmute Unmute video or audio action.
 * @constant VCRoomModerationActionTypeStartLectureMode Start lecture mode action.
 * @constant VCRoomModerationActionTypeStopLectureMode Stop lecture mode action.
 * @constant VCRoomModerationActionTypeSetPresenter Set presenter action.
 * @constant VCRoomModerationActionTypeRemovePresenter Remove presenter action.
 * @constant VCRoomModerationActionTypeRaiseHand Raise hand action.
 * @constant VCRoomModerationActionTypeUnraiseHand Unraise hand action.
 * @constant VCRoomModerationActionTypeDismissRaisedHand Dismiss raised hand action.
 * @constant VCRoomModerationActionTypeDismissAllRaisedHands Dismiss all raised hands action.
 * @constant VCRoomModerationActionTypeSetModeratorPin Set moderator pin.
 * @constant VCRoomModerationActionTypeRemoveModeratorPin Remove moderator pin.
 * @constant VCRoomModerationActionTypeDisconnectAll Disconnect all participants.
 * @constant VCRoomModerationActionTypeDisconnectOne Disconnect one participant.
 * @constant VCRoomModerationActionTypeInvalid Wrong action.
 */
typedef NS_ENUM(NSInteger, VCRoomModerationActionType) {
	VCRoomModerationActionTypeMute,
	VCRoomModerationActionTypeUnmute,
	VCRoomModerationActionTypeStartLectureMode,
	VCRoomModerationActionTypeStopLectureMode,
	VCRoomModerationActionTypeSetPresenter,
	VCRoomModerationActionTypeRemovePresenter,
	VCRoomModerationActionTypeRaiseHand,
	VCRoomModerationActionTypeUnraiseHand,
	VCRoomModerationActionTypeDismissRaisedHand,
	VCRoomModerationActionTypeDismissAllRaisedHands,
	VCRoomModerationActionTypeSetModeratorPin,
	VCRoomModerationActionTypeRemoveModeratorPin,
	VCRoomModerationActionTypeDisconnectAll,
	VCRoomModerationActionTypeDisconnectOne,
	VCRoomModerationActionTypeInvalid
};
/*!
 * @enum This type indicates the result of room moderation
 * @constant VCRoomModerationResultOK The moderation operation was successful.
 * @constant VCRoomModerationResultNoResponse The server did not respond in a reasonable amount of time to the moderation request.
 * @constant VCRoomModerationResultUnauthorized The user did not have permission to moderate.
 * @constant VCRoomModerationResultInvalidInput The input of role change authorization is invalid.
 * @constant VCRoomModerationResultMiscLocalError Moderation request failed due to some miscellaneous problem with the request.
 * @constant VCRoomModerationResultMiscRemoteError The server is rejecting the moderation request due to some miscellaneous problem of its own.
 */
typedef NS_ENUM(NSInteger, VCRoomModerationResult) {
	VCRoomModerationResultOK,
	VCRoomModerationResultNoResponse,
	VCRoomModerationResultUnauthorized,
	VCRoomModerationResultInvalidInput,
	VCRoomModerationResultMiscLocalError,
	VCRoomModerationResultMiscRemoteError
};
/*!
 * @enum Sets the type of moderation command received from the server.
 * @constant VCRoomModerationTypeSoftMute Moderation command which tells that device was muted by the server and he is allowed to unmute.
 * @constant VCRoomModerationTypeHardMute Moderation command which tells that device was muted by the server and he is NOT allowed to unmute.
 * @constant VCRoomModerationTypeNone Moderation command which tells that device was not muted by the server and he is allowed to unmute.
 */
typedef NS_ENUM(NSInteger, VCRoomModerationType) {
	VCRoomModerationTypeSoftMute,
	VCRoomModerationTypeHardMute,
	VCRoomModerationTypeNone
};
/*!
 * @enum Describes the profile control mode.
 * @constant VCRoomProfileControlModeAlwaysOn Profile is always ON.
 * @constant VCRoomProfileControlModeAlwaysOff Profile is always OFF.
 * @constant VCRoomProfileControlModeDefault Profile will take the default behavior.
 */
typedef NS_ENUM(NSInteger, VCRoomProfileControlMode) {
	VCRoomProfileControlModeAlwaysOn,
	VCRoomProfileControlModeAlwaysOff,
	VCRoomProfileControlModeDefault
};
/*!
 * @enum Provide the status of recording.
 * @constant VCRoomRecordingStateNotRecording Recording is in stop state.
 * @constant VCRoomRecordingStateRecordingPaused Recording is in pause state.
 * @constant VCRoomRecordingStateRecording Recording is in start/resume state.
 */
typedef NS_ENUM(NSInteger, VCRoomRecordingState) {
	VCRoomRecordingStateNotRecording,
	VCRoomRecordingStateRecordingPaused,
	VCRoomRecordingStateRecording
};
/*!
 * @enum This type indicates the result of request role change.
 * @constant VCRoomRequestRoleChangeResultOK Request role change was successful.
 * @constant VCRoomRequestRoleChangeResultNoResponse The server did not respond in a reasonable amount of time to the role change request.
 * @constant VCRoomRequestRoleChangeResultUnauthorized The user did not have permission to request role change.
 * @constant VCRoomRequestRoleChangeResultMiscLocalError Request role change failed due to some miscellaneous problem with the request.
 * @constant VCRoomRequestRoleChangeResultMiscRemoteError The server is rejecting the role change request due to some miscellaneous problem of its own.
 */
typedef NS_ENUM(NSInteger, VCRoomRequestRoleChangeResult) {
	VCRoomRequestRoleChangeResultOK,
	VCRoomRequestRoleChangeResultNoResponse,
	VCRoomRequestRoleChangeResultUnauthorized,
	VCRoomRequestRoleChangeResultMiscLocalError,
	VCRoomRequestRoleChangeResultMiscRemoteError
};
/*!
 * @enum Result of get room history.
 * @constant VCRoomSearchResultOK Get room history operation was successful.
 * @constant VCRoomSearchResultNoRecords Server did not return any records.
 * @constant VCRoomSearchResultNoResponse Server did not respond in a reasonable amount of time to the get room history request.
 * @constant VCRoomSearchResultUnauthorized User did not have the permission to get room history.
 * @constant VCRoomSearchResultMiscLocalError Server is rejecting the request to get room history due to some miscellaneous problem with the request.
 * @constant VCRoomSearchResultMiscRemoteError Server is rejecting the request to get room history due to some miscellaneous problem of its own.
 */
typedef NS_ENUM(NSInteger, VCRoomSearchResult) {
	VCRoomSearchResultOK,
	VCRoomSearchResultNoRecords,
	VCRoomSearchResultNoResponse,
	VCRoomSearchResultUnauthorized,
	VCRoomSearchResultMiscLocalError,
	VCRoomSearchResultMiscRemoteError
};
/*!
 * @enum This type indicates the result of set favorite room.
 * @constant VCRoomSetFavoriteResultOK The set operation was successful.
 * @constant VCRoomSetFavoriteResultNoResponse The server did not respond in a reasonable amount of time to the request to set.
 * @constant VCRoomSetFavoriteResultConflict There was a conflict in set.
 * @constant VCRoomSetFavoriteResultUnauthorized The user did not have permission to set.
 * @constant VCRoomSetFavoriteResultNotAcceptable The properties set on the room are not acceptable.
 * @constant VCRoomSetFavoriteResultNotAllowed The operation being performed on the room using set properties is not allowed.
 * @constant VCRoomSetFavoriteResultMiscLocalError The server is rejecting the request to set due to some miscellaneous problem with the request.
 * @constant VCRoomSetFavoriteResultMiscRemoteError The server isrejecting the request to set room properties due to some miscellaneous problem of its own.
 */
typedef NS_ENUM(NSInteger, VCRoomSetFavoriteResult) {
	VCRoomSetFavoriteResultOK,
	VCRoomSetFavoriteResultNoResponse,
	VCRoomSetFavoriteResultConflict,
	VCRoomSetFavoriteResultUnauthorized,
	VCRoomSetFavoriteResultNotAcceptable,
	VCRoomSetFavoriteResultNotAllowed,
	VCRoomSetFavoriteResultMiscLocalError,
	VCRoomSetFavoriteResultMiscRemoteError
};
/*!
 * @enum This type indicates the result of set room properties.
 * @constant VCRoomSetPropertiesResultOK The set properties operation was successful.
 * @constant VCRoomSetPropertiesResultNoResponse The server did not respond in a reasonable amount of time to the request to set room properties.
 * @constant VCRoomSetPropertiesResultConflict There was a conflict in setting room properties.
 * @constant VCRoomSetPropertiesResultUnauthorized The user did not have permission to get room properties.
 * @constant VCRoomSetPropertiesResultNotOwnerOfRoom The user is not owner of the room.
 * @constant VCRoomSetPropertiesResultNotAcceptable The properties set on the room are not acceptable.
 * @constant VCRoomSetPropertiesResultNotAllowed The operation being performed on the room using set properties is not allowed.
 * @constant VCRoomSetPropertiesResultMiscLocalError The server is rejecting the request to set room properties due to some miscellaneous problem with the request.
 * @constant VCRoomSetPropertiesResultMiscRemoteError The server is rejecting the request to set room properties due to some miscellaneous problem of its own.
 */
typedef NS_ENUM(NSInteger, VCRoomSetPropertiesResult) {
	VCRoomSetPropertiesResultOK,
	VCRoomSetPropertiesResultNoResponse,
	VCRoomSetPropertiesResultConflict,
	VCRoomSetPropertiesResultUnauthorized,
	VCRoomSetPropertiesResultNotOwnerOfRoom,
	VCRoomSetPropertiesResultNotAcceptable,
	VCRoomSetPropertiesResultNotAllowed,
	VCRoomSetPropertiesResultMiscLocalError,
	VCRoomSetPropertiesResultMiscRemoteError
};
/*!
 * @enum Type of throttling to apply to show requests.
 * @constant VCRoomShowThrottleNONE Disable show throttling.
 * @constant VCRoomShowThrottleTIMED Throttle show requests with timer.
 * @constant VCRoomShowThrottleWINDOWSIZE Throttle show requests by window size change threshold.
 */
typedef NS_ENUM(NSInteger, VCRoomShowThrottle) {
	VCRoomShowThrottleNONE,
	VCRoomShowThrottleTIMED,
	VCRoomShowThrottleWINDOWSIZE
};
/*!
 * @enum 
 * @constant VCRoomStateCreating 
 * @constant VCRoomStateCreated 
 * @constant VCRoomStateEntering 
 * @constant VCRoomStateEntered 
 * @constant VCRoomStateMediaRouteAcquiring 
 * @constant VCRoomStateMediaRouteAcquired 
 * @constant VCRoomStateMediaEnabling 
 * @constant VCRoomStateMediaEnabled 
 * @constant VCRoomStateMediaDisabling 
 * @constant VCRoomStateMediaDisabled 
 * @constant VCRoomStateExiting 
 * @constant VCRoomStateExited 
 */
typedef NS_ENUM(NSInteger, VCRoomState) {
	VCRoomStateCreating,
	VCRoomStateCreated,
	VCRoomStateEntering,
	VCRoomStateEntered,
	VCRoomStateMediaRouteAcquiring,
	VCRoomStateMediaRouteAcquired,
	VCRoomStateMediaEnabling,
	VCRoomStateMediaEnabled,
	VCRoomStateMediaDisabling,
	VCRoomStateMediaDisabled,
	VCRoomStateExiting,
	VCRoomStateExited
};
/*!
 * @enum This indicates the type of the room.
 * @constant VCRoomTypeUnknown This indicates that room type is unknown.
 * @constant VCRoomTypeConversation This room is for private chat between users speicfied in the VidyoUserGetConversationRoom method. It is auto-created and the access is permanently limited to the list of users specified so that no other participants can be invited outside of the original user list. If the list of users needs to be modified, another CONVERSATION room must be created with the new list.
 * @constant VCRoomTypeTopic This room is created using the VidyoUserCreateTopicRoom method for topic discussions. The user creating the room will usually become the owner and can moderate/invite other users. The access and properties of this room can be modified by privileged users and others can join/leave this room based on those properties such as guest access or member only.
 * @constant VCRoomTypeScheduled This indicates that room is of type scheduled.
 * @constant VCRoomTypePersonal This indicates that room is of type personal.
 * @constant VCRoomTypeTestCall This indicates that room is for test call.
 * @constant VCRoomTypeLegacy This indicates that room is a legacy endpoint.
 */
typedef NS_ENUM(NSInteger, VCRoomType) {
	VCRoomTypeUnknown,
	VCRoomTypeConversation,
	VCRoomTypeTopic,
	VCRoomTypeScheduled,
	VCRoomTypePersonal,
	VCRoomTypeTestCall,
	VCRoomTypeLegacy
};
/*!
 * @enum Provide the status of webcasting/broadcasting.
 * @constant VCRoomWebcastingStateNotWebcasting Room is not broadcast or webcasting is not going on.
 * @constant VCRoomWebcastingStateWebcasting Room is being broadcast or webcasting is going on.
 */
typedef NS_ENUM(NSInteger, VCRoomWebcastingState) {
	VCRoomWebcastingStateNotWebcasting,
	VCRoomWebcastingStateWebcasting
};
/*!
 * @enum This type specify the room property to search.
 * @constant VCRoomSearchFieldOwner owner of the rom.
 * @constant VCRoomSearchFieldAdmin administrator of the room.
 * @constant VCRoomSearchFieldModerator moderator of the room.
 * @constant VCRoomSearchFieldMember member of the room.
 * @constant VCRoomSearchFieldUser user of the room.
 * @constant VCRoomSearchFieldName name of the room.
 * @constant VCRoomSearchFieldSubject subject of the room.
 * @constant VCRoomSearchFieldType type of the room.
 * @constant VCRoomSearchFieldPublic visibility of the room; value of "true" indicates public room.
 * @constant VCRoomSearchFieldNonMembers number of members in the room includes owners, admins, moderators and members.
 */
typedef NS_ENUM(NSInteger, VCRoomSearchField) {
	VCRoomSearchFieldOwner,
	VCRoomSearchFieldAdmin,
	VCRoomSearchFieldModerator,
	VCRoomSearchFieldMember,
	VCRoomSearchFieldUser,
	VCRoomSearchFieldName,
	VCRoomSearchFieldSubject,
	VCRoomSearchFieldType,
	VCRoomSearchFieldPublic,
	VCRoomSearchFieldNonMembers
};
/*!
 * @enum This type specify the relation between room property fields that apply in the search, AND operator gets evaluated before OR.
 * @constant VCRoomSearchFieldRelationAND apply logical AND between the fields.
 * @constant VCRoomSearchFieldRelationOR apply logical OR between the fields.
 */
typedef NS_ENUM(NSInteger, VCRoomSearchFieldRelation) {
	VCRoomSearchFieldRelationAND,
	VCRoomSearchFieldRelationOR
};
/*!
 * @enum This type indicates the authentication type that needs to be used by the user to login.
 * @constant VCUserAuthTypeGuest Guest authnetication can be used to login.
 * @constant VCUserAuthTypePassword Password can be used to login.
 * @constant VCUserAuthTypeAccessToken AccessToken can be used to login.
 * @constant VCUserAuthTypeRefreshToken RefreshToken can be used to login.
 * @constant VCUserAuthTypeProvisionToken ProvisionToken can be used to login.
 * @constant VCUserAuthTypeFacebook Facebook authnetication can be used to login.
 * @constant VCUserAuthTypeGuestWithRoomKey The associated key is a room key.
 * @constant VCUserAuthTypeSaml SAML authnetication can be used to login.
 * @constant VCUserAuthTypeCac CAC authnetication can be used to login.
 */
typedef NS_ENUM(NSInteger, VCUserAuthType) {
	VCUserAuthTypeGuest,
	VCUserAuthTypePassword,
	VCUserAuthTypeAccessToken,
	VCUserAuthTypeRefreshToken,
	VCUserAuthTypeProvisionToken,
	VCUserAuthTypeFacebook,
	VCUserAuthTypeGuestWithRoomKey,
	VCUserAuthTypeSaml,
	VCUserAuthTypeCac
};
/*!
 * @enum This type indicates the result of an attempt to create call.
 * @constant VCUserCallCreateResultOK The call created successfully.
 * @constant VCUserCallCreateResultNoResponse The server did not respond in a reasonable amount of time to the request to create the call.
 * @constant VCUserCallCreateResultNotAllowed The user is not allowed to create call.
 * @constant VCUserCallCreateResultMiscLocalError The server is rejecting the request to create the call due to some miscellaneous problem with the request.
 * @constant VCUserCallCreateResultMiscRemoteError The server is rejecting the request to create the call due to some miscellaneous problem of its own.
 */
typedef NS_ENUM(NSInteger, VCUserCallCreateResult) {
	VCUserCallCreateResultOK,
	VCUserCallCreateResultNoResponse,
	VCUserCallCreateResultNotAllowed,
	VCUserCallCreateResultMiscLocalError,
	VCUserCallCreateResultMiscRemoteError
};
/*!
 * @enum This type indicates the reason for a change in connection status .
 * @constant VCUserConnectionStatusChangedReasonOK Connected to the server
 * @constant VCUserConnectionStatusChangedReasonLostContactWithServer Lost contact with the server
 * @constant VCUserConnectionStatusChangedReasonNoCommunicationWithServer No communication with the server
 * @constant VCUserConnectionStatusChangedReasonNoValidNetworkInterfaces The user has no valid network interfaces available.
 * @constant VCUserConnectionStatusChangedReasonNetworkInterfaceChanged The user's network interfaces have changed.
 * @constant VCUserConnectionStatusChangedReasonMiscNetworkError Misc network error
 * @constant VCUserConnectionStatusChangedReasonConnectionError Error on connecting to backend.
 */
typedef NS_ENUM(NSInteger, VCUserConnectionStatusChangedReason) {
	VCUserConnectionStatusChangedReasonOK,
	VCUserConnectionStatusChangedReasonLostContactWithServer,
	VCUserConnectionStatusChangedReasonNoCommunicationWithServer,
	VCUserConnectionStatusChangedReasonNoValidNetworkInterfaces,
	VCUserConnectionStatusChangedReasonNetworkInterfaceChanged,
	VCUserConnectionStatusChangedReasonMiscNetworkError,
	VCUserConnectionStatusChangedReasonConnectionError
};
/*!
 * @enum This type indicates the result of a search for user or room.
 * @constant VCUserGetAuthTypesResultOK The search operation was successful.
 * @constant VCUserGetAuthTypesResultConnectionFailed NThe Get Authentication Types result failed as connection failed.
 * @constant VCUserGetAuthTypesResultConnectionLost The Get Authentication Types result failed as connection was lost.
 * @constant VCUserGetAuthTypesResultConnectionTimeout The Get Authentication Types result failed due to request timeout.
 * @constant VCUserGetAuthTypesResultNoResponse The Get Authentication Types result failed as there was no response from the server.
 * @constant VCUserGetAuthTypesResultWebProxyAuthenticationFailed The Get Authentication Types result failed as the web proxy address required authentication.
 * @constant VCUserGetAuthTypesResultTlsFailed The Get Authentication Types result failed as the tls handshake failed.
 * @constant VCUserGetAuthTypesResultServiceUnavailable The Get Authentication Types result failed as the service was unavailable.
 * @constant VCUserGetAuthTypesResultMiscLocalError The Get Authentication Types result failed due to some miscellaneous local problem.
 * @constant VCUserGetAuthTypesResultMiscRemoteError The Get Authentication Types failed due to some miscellaneous remote problem.
 * @constant VCUserGetAuthTypesResultUnSupportedTenantVersion The Get Authentication Types failed as the version of tenant/backend not supported.
 * @constant VCUserGetAuthTypesResultNoValidNetworkInterface The Get Authentication Types failed as there is no valid network interface available.
 */
typedef NS_ENUM(NSInteger, VCUserGetAuthTypesResult) {
	VCUserGetAuthTypesResultOK,
	VCUserGetAuthTypesResultConnectionFailed,
	VCUserGetAuthTypesResultConnectionLost,
	VCUserGetAuthTypesResultConnectionTimeout,
	VCUserGetAuthTypesResultNoResponse,
	VCUserGetAuthTypesResultWebProxyAuthenticationFailed,
	VCUserGetAuthTypesResultTlsFailed,
	VCUserGetAuthTypesResultServiceUnavailable,
	VCUserGetAuthTypesResultMiscLocalError,
	VCUserGetAuthTypesResultMiscRemoteError,
	VCUserGetAuthTypesResultUnSupportedTenantVersion,
	VCUserGetAuthTypesResultNoValidNetworkInterface
};
/*!
 * @enum This type indicates the result of getting a contact vCard.
 * @constant VCUserGetContactResultOK The request was successful.
 * @constant VCUserGetContactResultNoResponse The server did not respond in a reasonable amount of time.
 * @constant VCUserGetContactResultUnauthorized The user is not allowed to get contacts.
 * @constant VCUserGetContactResultMiscLocalError The server is rejecting the request due to some miscellaneous problem with the request.
 * @constant VCUserGetContactResultMiscRemoteError The server is rejecting the request due to some miscellaneous problem of its own.
 */
typedef NS_ENUM(NSInteger, VCUserGetContactResult) {
	VCUserGetContactResultOK,
	VCUserGetContactResultNoResponse,
	VCUserGetContactResultUnauthorized,
	VCUserGetContactResultMiscLocalError,
	VCUserGetContactResultMiscRemoteError
};
/*!
 * @enum This type indicates the result of an attempt to log in to some service.
 * @constant VCUserLoginResultOK The user logged in successfully.
 * @constant VCUserLoginResultConnectionFailed The destination could not be reached.
 * @constant VCUserLoginResultConnectionLost The transport connection was lost prior to completing the login procedure.
 * @constant VCUserLoginResultConnectionTimeout The signaling connection timed out prior to completing the login procedure.
 * @constant VCUserLoginResultNoResponse The service was successfully contacted, but the service ignored the user's request to log in, or did not answer in a reasonable amount of time.
 * @constant VCUserLoginResultTerminated The service was successfully contacted, but the service closed the connection or refused to continue processing the login request.
 * @constant VCUserLoginResultInvalidUser The user ID that was provided is unknown to the service or unauthorized to log in.
 * @constant VCUserLoginResultInvalidPassword The password that was provided is incorrect.
 * @constant VCUserLoginResultMiscAuthError The login failed for some other authentication error.
 * @constant VCUserLoginResultCancelled The user cancelled the login request before it completed.
 * @constant VCUserLoginResultMiscError The login failed for some other miscellaneous error.
 * @constant VCUserLoginResultWebProxyAuthenticationRequired The login failed as the web proxy address required authentication.
 * @constant VCUserLoginResultServiceUnavailable The login failed as the service is not available.
 * @constant VCUserLoginResultRoomIsFull The login with room key failed as the room is full.
 * @constant VCUserLoginResultRoomIsDisabled The login with room key failed as the room is disabled.
 * @constant VCUserLoginResultTlsFailed The login failed as TLS negotiation failed.
 * @constant VCUserLoginResultCertificateVerificationFailed The login failed as the client certificate verification has failed.
 * @constant VCUserLoginResultUnsupportedTenantVersion The login failed as the tenant/backend is of an unsupported version.
 * @constant VCUserLoginResultNoValidNetworkInterface The login failed as there is no valid network interface available.
 */
typedef NS_ENUM(NSInteger, VCUserLoginResult) {
	VCUserLoginResultOK,
	VCUserLoginResultConnectionFailed,
	VCUserLoginResultConnectionLost,
	VCUserLoginResultConnectionTimeout,
	VCUserLoginResultNoResponse,
	VCUserLoginResultTerminated,
	VCUserLoginResultInvalidUser,
	VCUserLoginResultInvalidPassword,
	VCUserLoginResultMiscAuthError,
	VCUserLoginResultCancelled,
	VCUserLoginResultMiscError,
	VCUserLoginResultWebProxyAuthenticationRequired,
	VCUserLoginResultServiceUnavailable,
	VCUserLoginResultRoomIsFull,
	VCUserLoginResultRoomIsDisabled,
	VCUserLoginResultTlsFailed,
	VCUserLoginResultCertificateVerificationFailed,
	VCUserLoginResultUnsupportedTenantVersion,
	VCUserLoginResultNoValidNetworkInterface
};
/*!
 * @enum This type indicates the reason that a user that was once logged in is no longer logged in.
 * @constant VCUserLogoutReasonLoggedOut The user logged out gracefully.
 * @constant VCUserLogoutReasonConnectionLost The transport connection was lost.
 * @constant VCUserLogoutReasonConnectionTimeout The signaling connection timed out.
 * @constant VCUserLogoutReasonNoResponse The service did not respond in a reasonable amount of time to a request by the user.
 * @constant VCUserLogoutReasonTerminated The service closed the connection or otherwise terminated the login session.
 * @constant VCUserLogoutReasonMiscError The login session was closed for some other miscellaneous reason.
 * @constant VCUserLogoutReasonLoggedInElsewhere The same user has logged in from somewhere else.
 * @constant VCUserLogoutReasonNetworkInterfaceChanged The network interface changed.
 * @constant VCUserLogoutReasonOutOfLicenses The Portal is out of licenses.
 * @constant VCUserLogoutReasonEpClientBadConnection Logged out due to bad connection with VidyoManager.
 * @constant VCUserLogoutReasonEpClientBadVersion Logged out as VidyoManager rejected the connection as EMCP version is bad.
 * @constant VCUserLogoutReasonEpClientBadSessionId Logged out as the Endpoint's session ID did not match that of the VidyoManager.
 * @constant VCUserLogoutReasonEpClientBadComms Logged out due to Bad communication with VidyoManager.EpClient can no longer insure proper operation.
 * @constant VCUserLogoutReasonEpClientRebootRequested Logged out as the VidyoManager has requested that the Endpoint reset.
 * @constant VCUserLogoutReasonEpClientShutdownRequested Logged out as the VidyoManager has requested that the Endpoint reset.
 * @constant VCUserLogoutReasonEpClientRestartRequested Logged out as the VidyoManager has requested that the Endpoint reset.
 * @constant VCUserLogoutReasonEpClientInternalError Logged out because an internal error occurred at the epclient.
 * @constant VCUserLogoutReasonEndpointNotBound Logged out as the endpoint is not bound to the backend and will not be able join calls.
 * @constant VCUserLogoutReasonInvalidAuth Logged out as the authentication is no longer valid.
 * @constant VCUserLogoutReasonEpClientStartFailure Logged out as we failed to start EpClient
 */
typedef NS_ENUM(NSInteger, VCUserLogoutReason) {
	VCUserLogoutReasonLoggedOut,
	VCUserLogoutReasonConnectionLost,
	VCUserLogoutReasonConnectionTimeout,
	VCUserLogoutReasonNoResponse,
	VCUserLogoutReasonTerminated,
	VCUserLogoutReasonMiscError,
	VCUserLogoutReasonLoggedInElsewhere,
	VCUserLogoutReasonNetworkInterfaceChanged,
	VCUserLogoutReasonOutOfLicenses,
	VCUserLogoutReasonEpClientBadConnection,
	VCUserLogoutReasonEpClientBadVersion,
	VCUserLogoutReasonEpClientBadSessionId,
	VCUserLogoutReasonEpClientBadComms,
	VCUserLogoutReasonEpClientRebootRequested,
	VCUserLogoutReasonEpClientShutdownRequested,
	VCUserLogoutReasonEpClientRestartRequested,
	VCUserLogoutReasonEpClientInternalError,
	VCUserLogoutReasonEndpointNotBound,
	VCUserLogoutReasonInvalidAuth,
	VCUserLogoutReasonEpClientStartFailure
};
/*!
 * @enum This category signifies the outcome of the user's action.
 * @constant VCUserOperationResultOK The operation was carried out successfully.
 * @constant VCUserOperationResultCONNECTIONFAILED The operation was unsuccessful because of a connection failure.
 * @constant VCUserOperationResultCONNECTIONLOST The operation was unsuccessful because of a connection lost.
 * @constant VCUserOperationResultCONNECTIONTIMEDOUT The operation was unsuccessful because of a connection timeout.
 * @constant VCUserOperationResultMISCLOCALERROR The operation was unsuccessful because of a miscellaneous error occured inside the client library.
 * @constant VCUserOperationResultMISCREMOTEERROR The operation was unsuccessful because of a miscellaneous error occured with the conferencing service.
 * @constant VCUserOperationResultMISCRROR The operation was unsuccessful because of a miscellaneous error from server side.
 */
typedef NS_ENUM(NSInteger, VCUserOperationResult) {
	VCUserOperationResultOK,
	VCUserOperationResultCONNECTIONFAILED,
	VCUserOperationResultCONNECTIONLOST,
	VCUserOperationResultCONNECTIONTIMEDOUT,
	VCUserOperationResultMISCLOCALERROR,
	VCUserOperationResultMISCREMOTEERROR,
	VCUserOperationResultMISCRROR
};
/*!
 * @enum Results of Recording service requests.
 * @constant VCUserRecordingServiceResultSuccess The request has succeeded.
 * @constant VCUserRecordingServiceResultInvalidArgument One or more input arguments are invalid.
 * @constant VCUserRecordingServiceResultGeneralFailure Media support was disabled or there is an unknown fault on the portal.
 * @constant VCUserRecordingServiceResultSeatLicenseExpired The seat license has expired.
 * @constant VCUserRecordingServiceResultNotLicensed The endpoint is not licensed.
 * @constant VCUserRecordingServiceResultResourceNotAvailable There are no available resources of the portal or recording servers.
 * @constant VCUserRecordingServiceResultControlMeetingFailure Miscellaneous portal error occurred.
 */
typedef NS_ENUM(NSInteger, VCUserRecordingServiceResult) {
	VCUserRecordingServiceResultSuccess,
	VCUserRecordingServiceResultInvalidArgument,
	VCUserRecordingServiceResultGeneralFailure,
	VCUserRecordingServiceResultSeatLicenseExpired,
	VCUserRecordingServiceResultNotLicensed,
	VCUserRecordingServiceResultResourceNotAvailable,
	VCUserRecordingServiceResultControlMeetingFailure
};
/*!
 * @enum This type indicates the result of an attempt to create room.
 * @constant VCUserRoomCreateResultOK The room entered successfully.
 * @constant VCUserRoomCreateResultNoResponse The server did not respond in a reasonable amount of time to the request to enter the room.
 * @constant VCUserRoomCreateResultNotFound The server did not find the room.
 * @constant VCUserRoomCreateResultUnauthorized The user is not allowed to create rooms.
 * @constant VCUserRoomCreateResultMiscLocalError The server is rejecting the request to enter due to some miscellaneous problem with the request.
 * @constant VCUserRoomCreateResultMiscRemoteError The server is rejecting the request to enter due to some miscellaneous problem of its own.
 * @constant VCUserRoomCreateResultDuplicateName The room with this name already exists.
 * @constant VCUserRoomCreateResultLimitReached THe user has already created max number of rooms allowd by the server.
 * @constant VCUserRoomCreateResultNotSupported The server does not support room creation.
 */
typedef NS_ENUM(NSInteger, VCUserRoomCreateResult) {
	VCUserRoomCreateResultOK,
	VCUserRoomCreateResultNoResponse,
	VCUserRoomCreateResultNotFound,
	VCUserRoomCreateResultUnauthorized,
	VCUserRoomCreateResultMiscLocalError,
	VCUserRoomCreateResultMiscRemoteError,
	VCUserRoomCreateResultDuplicateName,
	VCUserRoomCreateResultLimitReached,
	VCUserRoomCreateResultNotSupported
};
/*!
 * @enum This type specify the user details to search.
 * @constant VCUserSearchFieldUID id of the user.
 * @constant VCUserSearchFieldEMAIL mail of the user.
 * @constant VCUserSearchFieldNAME display name of the user.
 * @constant VCUserSearchFieldTELNO telephone number of user.
 */
typedef NS_ENUM(NSInteger, VCUserSearchField) {
	VCUserSearchFieldUID,
	VCUserSearchFieldEMAIL,
	VCUserSearchFieldNAME,
	VCUserSearchFieldTELNO
};
/*!
 * @enum This type indicates the result of a search for user or room.
 * @constant VCUserSearchResultOK The search operation was successful.
 * @constant VCUserSearchResultNoRecords No records found for the search.
 * @constant VCUserSearchResultNoResponse The search result failed due to request timeout.
 * @constant VCUserSearchResultMiscLocalError The search result failed due to some miscellaneous local problem.
 * @constant VCUserSearchResultMiscRemoteError The search result failed due to some miscellaneous remote problem.
 */
typedef NS_ENUM(NSInteger, VCUserSearchResult) {
	VCUserSearchResultOK,
	VCUserSearchResultNoRecords,
	VCUserSearchResultNoResponse,
	VCUserSearchResultMiscLocalError,
	VCUserSearchResultMiscRemoteError
};
/*!
 * @enum 
 * @constant VCUserStateIdle 
 * @constant VCUserStateLoggingIn 
 * @constant VCUserStateLoggedIn 
 * @constant VCUserStateReconnecting 
 * @constant VCUserStateRequestingAuthenticationTypes 
 */
typedef NS_ENUM(NSInteger, VCUserState) {
	VCUserStateIdle,
	VCUserStateLoggingIn,
	VCUserStateLoggedIn,
	VCUserStateReconnecting,
	VCUserStateRequestingAuthenticationTypes
};
/*!
 * @enum An enumeration of authentication key types.
 * @constant VCUserTokenTypeRefreshToken The associated key is a refresh token.
 * @constant VCUserTokenTypeAccessToken The associated key is an access token.
 * @constant VCUserTokenTypeJwtToken The associated key is a jwt token.
 * @constant VCUserTokenTypeNone The associated key is a none.
 */
typedef NS_ENUM(NSInteger, VCUserTokenType) {
	VCUserTokenTypeRefreshToken,
	VCUserTokenTypeAccessToken,
	VCUserTokenTypeJwtToken,
	VCUserTokenTypeNone
};
/*!
 * The VidyoClient package encapsulates all APIs required to build a vidyo conferencing application.
 */
@interface VCEndpointPkg : NSObject
{}
	+(NSString*) getBuildTag;
	+(NSString*) getVersion;
	+(NSString*) getVersionWithoutBuildNumber;
	+(BOOL) vcInitialize;
	+(BOOL) setExperimentalOptions:(const char*)options;
	+(void) uninitialize;
@end
@protocol VCCallIAccept
	/*!
	 * Callback that is triggered when initiating a VidyoCall.
	 */
	-(void) onInitiated:(VCCallInitiatedResult)result P:(VCParticipant*)p;
	/*!
	 * Callback that is triggered when VidyoCall has ended.
	 */
	-(void) onEnded:(VCParticipant*)p Reason:(VCCallEndReason)reason;
@end
@protocol VCCallIRegisterMessageEventListener
	/*!
	 * Callback that is triggered when a new text message arrives.
	 */
	-(void) onMessageReceived:(VCParticipant*)participant ChatMessage:(VCChatMessage*)chatMessage;
	/*!
	 * Callback that is triggered when a VidyoChatMessage is delivered to the VidyoCall on the server.
	 */
	-(void) onMessageAcknowledged:(VCChatMessage*)chatMessage;
	/*!
	 * Callback that is triggered when a message that was acknowledged by the server was read by the other VidyoParticipant in the room.
	 */
	-(void) onMessageRead:(VCParticipant*)participant MessageId:(long long)messageId;
	/*!
	 * Callback that is triggered when typing state of a remote VidyoParticipant changes.
	 */
	-(void) onMessageTypingIndication:(VCParticipant*)participant TypingIndication:(VCChatMessageTypingIndication)typingIndication;
@end
@protocol VCCallIRegisterSubjectEventListener
	/*!
	 * Callback that is triggered when the subject of the VidyoCall has changed.
	 */
	-(void) onSetSubject:(const char*)subject;
@end
/*!
 * Establishes and manages a point-to-point call.
 */
@interface VCCall : NSObject
{
	void* objPtr;
	@public
	/*!
	 * Accepts an incoming VidyoCall that was notified by the VidyoUserOnCallCreatedByInvite callback.
	 */
	id<VCCallIAccept> callIAccept;
	/*!
	 * Registers to get notified about message events.
	 */
	id<VCCallIRegisterMessageEventListener> callIRegisterMessageEventListener;
	/*!
	 * Registers to get notified about subject events.
	 */
	id<VCCallIRegisterSubjectEventListener> callIRegisterSubjectEventListener;
}
	/*!
	 * Unique ID of the VidyoCall.
	 */
	@property NSMutableString* id;
	-(void) dealloc;
	/*!
	 * Accepts an incoming VidyoCall that was notified by the VidyoUserOnCallCreatedByInvite callback.
	 * @param c Pointer to the VidyoCall object.
	 * @param onInitiated Callback that is triggered when the enter operation completes. This could be a successful enter or a failure due to permissions, etc.
	 * @param onEnded Callback that is triggered when the room has been exited.
	 */
	-(BOOL) accept:(id<VCCallIAccept>)callIAccept;
	/*!
	 * Gets the unique ID of the VidyoCall
	 * @param c Pointer to the VidyoCall object.
	 */
	-(NSString*) getId;
	/*!
	 * Gets the current subject of the VidyoCall.
	 * @param c Pointer to the VidyoCall object.
	 */
	-(const char*) getSubject;
	/*!
	 */
	-(VCUser*) getUser;
	/*!
	 * Hangs up an in-progress VidyoCall.
	 * @param c Pointer to the VidyoCall object.
	 */
	-(void) hangUp;
	/*!
	 * Initiates a VidyoCall.
	 * @param c Pointer to the VidyoCall object.
	 * @param onInitiated Callback that is triggered when the enter operation completes. This could be a successful enter or a failure due to permissions, etc.
	 * @param onEnded Callback that is triggered when the room has been exited.
	 */
	-(BOOL) initiate:(id<VCCallIAccept>)callIAccept;
	/*!
	 * Registers to get notified about message events.
	 * @param c The VidyoCall object.
	 * @param onMessageReceived Callback that is triggered when a new message has been received.
	 * @param onMessageAcknowledged Callback that is triggered when a sent message has been acknowledged.
	 * @param onMessageRead Callback that is triggered when a sent message has been read.
	 * @param onMessageTypingIndication Callback that is triggered when a remote participant is typing.
	 */
	-(BOOL) registerMessageEventListener:(id<VCCallIRegisterMessageEventListener>)callIRegisterMessageEventListener;
	/*!
	 * Registers to get notified about subject events.
	 * @param c The VidyoCall object.
	 * @param onSetSubject Callback that is triggered when the subject has been changed.
	 */
	-(BOOL) registerSubjectEventListener:(id<VCCallIRegisterSubjectEventListener>)callIRegisterSubjectEventListener;
	/*!
	 * Rejects an incoming VidyoCall that was notified by the VidyoUserFeedbackCallCreatedByInvite callback.
	 * @param c Pointer to the VidyoCall object.
	 */
	-(void) reject;
	/*!
	 * Sends a message to the remote user in the VidyoCall.
	 * @param c Pointer to the VidyoCall object.
	 * @param message Message to be sent.
	 */
	-(BOOL) sendMessage:(const char*)message;
	/*!
	 * Sets a new subject on the VidyoCall.
	 * @param c Pointer to the VidyoCall object.
	 * @param subject New subject of the VidyoCall.
	 */
	-(BOOL) setSubject:(const char*)subject;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
@protocol VCEndpointICompressLogs
	/*!
	 * Callback that is triggered when the file log compression completes.
	 */
	-(void) onLogCompressionComplete:(NSMutableString*)compressedFileName Result:(VCEndpointLogCompressionResult)result;
@end
@protocol VCEndpointIGetActiveNetworkInterface
	/*!
	 * Callback that is triggered each time when result of VidyoEndpointGetActiveNetworkInterface is received.
	 */
	-(void) onGetActiveNetworkInterface:(VCNetworkInterface*)signalingInterface MediaInterface:(VCNetworkInterface*)mediaInterface;
@end
@protocol VCEndpointIGetAutoReconnectSetting
	/*!
	 * Callback that is triggered each time when result of VidyoEndpointGetAutoReconnectSetting is received.
	 */
	-(void) onGetAutoReconnectSetting:(BOOL)enableAutoReconnect ReconnectBackoff:(unsigned int)reconnectBackoff MaxReconnectAttempts:(unsigned int)maxReconnectAttempts;
@end
@protocol VCEndpointIGetCameraBackgroundEffect
	/*!
	 * Callback that reports the current configuration of camera background effect to the application.
	 */
	-(void) onGetCameraBackgroundEffectInfo:(VCEndpointCameraEffectInfo*)effectInfo;
@end
@protocol VCEndpointIGetFileLoggerCategoryListAsync
	/*!
	 * Callback that is triggered when getting the logger category list completes.
	 */
	-(void) onGetLoggerCategoryListComplete:(VCEndpointLoggerType)loggerType Categories:(NSMutableArray*)categories Result:(VCEndpointGetLoggerCategoryListResult)result;
@end
@protocol VCEndpointIGetGoogleAnalyticsEventTable
	/*!
	 * Callback that is triggered each time when result of VidyoEndpointGetGoogleAnalyticsEventTable is received.
	 */
	-(void) onGetAnalyticsEventTable:(NSMutableArray*)eventTables;
@end
@protocol VCEndpointIGetGoogleAnalyticsOptions
	/*!
	 * Callback that is triggered each time when result of VidyoEndpointGetGoogleAnalyticsOptions is received.
	 */
	-(void) onGetGoogleAnalyticsOptions:(VCEndpointGoogleAnalyticsOptions*)options;
@end
@protocol VCEndpointIGetProductInfoAsync
	/*!
	 * Callback that is triggered when getting the product information completes.
	 */
	-(void) onGetProductInfoComplete:(NSMutableArray*)productInfo SupportedFeature:(NSMutableArray*)supportedFeature;
@end
@protocol VCEndpointIGetWhitelistedAudioDevices
	/*!
	 * Callback that reports the names of the audio devices that are whitelisted.
	 */
	-(void) onGetWhitelistedAudioDevices:(NSMutableArray*)audioDevices;
@end
@protocol VCEndpointIRegisterCameraEffectErrorListener
	/*!
	 * Callback that reports camera effect errors.
	 */
	-(void) onCameraEffectError:(VCEndpointCameraEffectError)error;
@end
@protocol VCEndpointIRegisterDisableVideoOnLowBwEventListener
	/*!
	 * Callback that will be triggered when disable video on low bandwidth is started.
	 */
	-(void) onDisableVideoOnLowBwStarted;
	/*!
	 * Callback that will be triggered when disable video on low bandwidth is ended.
	 */
	-(void) onDisableVideoOnLowBwEnded;
@end
@protocol VCEndpointIRegisterErrorEventListener
	/*!
	 * Callback that is triggered to provide advanced error codes to the application.
	 */
	-(void) onError:(VCEndpointErrorCode)error ApiName:(NSString*)apiName;
@end
@protocol VCEndpointIRegisterLocalCameraEventListener
	/*!
	 * Callback that is triggered each time a local camera becomes available to a VidyoEndpoint.
	 */
	-(void) onLocalCameraAdded:(VCLocalCamera*)localCamera;
	/*!
	 * Callback that is triggered each time a local camera is no longer available to a VidyoEndpoint.
	 */
	-(void) onLocalCameraRemoved:(VCLocalCamera*)localCamera;
	/*!
	 * Callback that is triggered each time there is a change in which local camera is selected for use.
	 */
	-(void) onLocalCameraSelected:(VCLocalCamera*)localCamera;
	/*!
	 * Callback that is triggered each time there is a change in the state of the camera such as being suspended or disabled.
	 */
	-(void) onLocalCameraStateUpdated:(VCLocalCamera*)localCamera State:(VCDeviceState)state;
@end
@protocol VCEndpointIRegisterLocalCameraFrameListener
	/*!
	 * Callback that is triggered each time a local camera produces a video frame.
	 */
	-(void) onLocalCameraFrame:(VCLocalCamera*)localCamera VideoFrame:(VCVideoFrame*)videoFrame;
@end
@protocol VCEndpointIRegisterLocalMicrophoneEnergyListener
	/*!
	 * Callback that is triggered each time a local microphone produces an audio frame with energy present.
	 */
	-(void) onLocalMicrophoneEnergy:(VCLocalMicrophone*)localMicrophone AudioEnergy:(int)audioEnergy;
@end
@protocol VCEndpointIRegisterLocalMicrophoneEventListener
	/*!
	 * Callback that is triggered each time a local microphone becomes available to a VidyoEndpoint.
	 */
	-(void) onLocalMicrophoneAdded:(VCLocalMicrophone*)localMicrophone;
	/*!
	 * Callback that is triggered each time a local microphone is no longer available to a VidyoEndpoint.
	 */
	-(void) onLocalMicrophoneRemoved:(VCLocalMicrophone*)localMicrophone;
	/*!
	 * Callback that is triggered each time there is a change in which local microphone is selected for use.
	 */
	-(void) onLocalMicrophoneSelected:(VCLocalMicrophone*)localMicrophone;
	/*!
	 * Callback that is triggered each time there is a change in the state of the microphone such as being suspended or disabled.
	 */
	-(void) onLocalMicrophoneStateUpdated:(VCLocalMicrophone*)localMicrophone State:(VCDeviceState)state;
@end
@protocol VCEndpointIRegisterLocalMicrophoneFrameListener
	/*!
	 * Callback that is triggered each time a local microphone produces an audio frame.
	 */
	-(void) onLocalMicrophoneFrame:(VCLocalMicrophone*)localMicrophone AudioFrame:(VCAudioFrame*)audioFrame;
@end
@protocol VCEndpointIRegisterLocalMonitorEventListener
	/*!
	 * Callback that is triggered each time a local monitor becomes available to a VidyoEndpoint.
	 */
	-(void) onLocalMonitorAdded:(VCLocalMonitor*)localMonitor;
	/*!
	 * Callback that is triggered each time a local monitor is no longer available to a VidyoEndpoint.
	 */
	-(void) onLocalMonitorRemoved:(VCLocalMonitor*)localMonitor;
	/*!
	 * Callback that is triggered each time there is a change in which local monitor is selected for sharing.
	 */
	-(void) onLocalMonitorSelected:(VCLocalMonitor*)localMonitor;
	/*!
	 * Callback that is triggered each time there is a change in the state of the monitor such as being suspended or disabled.
	 */
	-(void) onLocalMonitorStateUpdated:(VCLocalMonitor*)localMonitor State:(VCDeviceState)state;
@end
@protocol VCEndpointIRegisterLocalMonitorFrameListener
	/*!
	 * Callback that is triggered each time a local camera produces a video frame.
	 */
	-(void) onLocalMonitorFrame:(VCLocalMonitor*)localMonitor VideoFrame:(VCVideoFrame*)videoFrame;
@end
@protocol VCEndpointIRegisterLocalRendererEventListener
	-(void) onLocalRendererAdded:(VCLocalRenderer*)localRenderer;
	-(void) onLocalRendererRemoved:(VCLocalRenderer*)localRenderer;
	-(void) onLocalRendererSelected:(VCLocalRenderer*)localRenderer;
	-(void) onLocalRendererStateUpdated:(VCLocalRenderer*)localRenderer State:(VCDeviceState)state;
@end
@protocol VCEndpointIRegisterLocalSpeakerEventListener
	/*!
	 * Callback that is triggered each time a local speaker becomes available to a VidyoEndpoint.
	 */
	-(void) onLocalSpeakerAdded:(VCLocalSpeaker*)localSpeaker;
	/*!
	 * Callback that is triggered each time a local speaker is no longer available to a VidyoEndpoint.
	 */
	-(void) onLocalSpeakerRemoved:(VCLocalSpeaker*)localSpeaker;
	/*!
	 * Callback that is triggered each time there is a change in which local speaker is selected for use.
	 */
	-(void) onLocalSpeakerSelected:(VCLocalSpeaker*)localSpeaker;
	/*!
	 * Callback that is triggered each time there is a change in the state of the speaker such as being suspended or disabled.
	 */
	-(void) onLocalSpeakerStateUpdated:(VCLocalSpeaker*)localSpeaker State:(VCDeviceState)state;
@end
@protocol VCEndpointIRegisterLocalWindowShareEventListener
	/*!
	 * Callback that is triggered each time a local window becomes available for a VidyoEndpoint to share in a conference.
	 */
	-(void) onLocalWindowShareAdded:(VCLocalWindowShare*)localWindowShare;
	/*!
	 * Callback that is triggered each time a local window is no longer available for a VidyoEndpoint to share in a conference.
	 */
	-(void) onLocalWindowShareRemoved:(VCLocalWindowShare*)localWindowShare;
	/*!
	 * Callback that is triggered each time there is a change in which local window is selected for sharing.
	 */
	-(void) onLocalWindowShareSelected:(VCLocalWindowShare*)localWindowShare;
	/*!
	 * Callback that is triggered each time there is a change in the state of the window such as being suspended or disabled.
	 */
	-(void) onLocalWindowShareStateUpdated:(VCLocalWindowShare*)localWindowShare State:(VCDeviceState)state;
@end
@protocol VCEndpointIRegisterLocalWindowShareFrameListener
	/*!
	 * Callback that is triggered each time a local camera produces a video frame.
	 */
	-(void) onLocalWindowShareFrame:(VCLocalWindowShare*)localWindowShare VideoFrame:(VCVideoFrame*)videoFrame;
@end
@protocol VCEndpointIRegisterLogEventListener
	/*!
	 * Callback that is triggered for every log record.
	 */
	-(void) onLog:(VCLogRecord*)logRecord;
@end
@protocol VCEndpointIRegisterNGRResultEventListener
	/*!
	 * Callback providing final response for actions requested to next generation renderer.
	 */
	-(void) onNGRResult:(VCEndpointNGRActionType)type Success:(BOOL)success Error:(NSString*)error;
@end
@protocol VCEndpointIRegisterNetworkInterfaceEventListener
	/*!
	 * Callback that is triggered each time a network interface is available to a VidyoEndpoint.
	 */
	-(void) onNetworkInterfaceAdded:(VCNetworkInterface*)networkInterface;
	/*!
	 * Callback that is triggered each time a network interface is no longer available to a VidyoEndpoint.
	 */
	-(void) onNetworkInterfaceRemoved:(VCNetworkInterface*)networkInterface;
	/*!
	 * Callback that is triggered each time there is a change in which network interface is selected for use.
	 */
	-(void) onNetworkInterfaceSelected:(VCNetworkInterface*)networkInterface TransportType:(VCNetworkInterfaceTransportType)transportType;
	/*!
	 * Callback that is triggered each time there is a change in the state of the network interface such as being up or down.
	 */
	-(void) onNetworkInterfaceStateUpdated:(VCNetworkInterface*)networkInterface State:(VCNetworkInterfaceState)state;
@end
@protocol VCEndpointIRegisterReconnectEventListener
	/*!
	 * Callback that is triggered when the reconnecting attempt has failed and new attempt will be started.
	 */
	-(void) onReconnecting:(unsigned int)attempt AttemptTimeout:(unsigned int)attemptTimeout Reason:(VCEndpointReconnectFailReason)reason;
	/*!
	 * This callback will be triggered when media was enabled and the user rejoined to the call/conference.
	 */
	-(void) onReconnected;
	/*!
	 * Callback that is triggered when reconnecting failed and there no more attempt to reconnect.
	 */
	-(void) onConferenceLost:(VCEndpointReconnectFailReason)reason;
@end
@protocol VCEndpointIRegisterRemoteCameraEventListener
	-(void) onRemoteCameraAdded:(VCRemoteCamera*)remoteCamera User:(VCUser*)user Call:(VCCall*)call Room:(VCRoom*)room Participant:(VCParticipant*)participant;
	-(void) onRemoteCameraRemoved:(VCRemoteCamera*)remoteCamera User:(VCUser*)user Call:(VCCall*)call Room:(VCRoom*)room Participant:(VCParticipant*)participant;
	-(void) onRemoteCameraStateUpdated:(VCRemoteCamera*)remoteCamera User:(VCUser*)user Call:(VCCall*)call Room:(VCRoom*)room Participant:(VCParticipant*)participant State:(VCDeviceState)state;
@end
@protocol VCEndpointIRegisterRemoteCameraFrameListener
	/*!
	 * Callback that is triggered each time a remote camera produces a video frame.
	 */
	-(void) onRemoteCameraFrame:(VCRemoteCamera*)remoteCamera Participant:(VCParticipant*)participant VideoFrame:(VCVideoFrame*)videoFrame;
@end
@protocol VCEndpointIRegisterRemoteMicrophoneEnergyListener
	/*!
	 * Callback that is triggered each time a remote camera produces a video frame.
	 */
	-(void) onRemoteMicrophoneEnergy:(VCRemoteMicrophone*)remoteMicrophone Participant:(VCParticipant*)participant AudioEnergy:(int)audioEnergy;
@end
@protocol VCEndpointIRegisterRemoteMicrophoneEventListener
	-(void) onRemoteMicrophoneAdded:(VCRemoteMicrophone*)remoteMicrophone User:(VCUser*)user Call:(VCCall*)call Room:(VCRoom*)room Participant:(VCParticipant*)participant;
	-(void) onRemoteMicrophoneRemoved:(VCRemoteMicrophone*)remoteMicrophone User:(VCUser*)user Call:(VCCall*)call Room:(VCRoom*)room Participant:(VCParticipant*)participant;
	-(void) onRemoteMicrophoneStateUpdated:(VCRemoteMicrophone*)remoteMicrophone User:(VCUser*)user Call:(VCCall*)call Room:(VCRoom*)room Participant:(VCParticipant*)participant State:(VCDeviceState)state;
@end
@protocol VCEndpointIRegisterRemoteMicrophoneFrameListener
	/*!
	 * Callback that is triggered each time a remote camera produces a video frame.
	 */
	-(void) onRemoteMicrophoneFrame:(VCRemoteMicrophone*)remoteMicrophone Participant:(VCParticipant*)participant AudioFrame:(VCAudioFrame*)audioFrame;
@end
@protocol VCEndpointIRegisterRemoteRendererEventListener
	-(void) onRemoteRendererAdded:(VCRemoteRenderer*)remoteRenderer User:(VCUser*)user Call:(VCCall*)call Room:(VCRoom*)room;
	-(void) onRemoteRendererRemoved:(VCRemoteRenderer*)remoteRenderer User:(VCUser*)user Call:(VCCall*)call Room:(VCRoom*)room;
	-(void) onRemoteRendererStateUpdated:(VCRemoteRenderer*)remoteRenderer User:(VCUser*)user Call:(VCCall*)call Room:(VCRoom*)room State:(VCDeviceState)state;
@end
@protocol VCEndpointIRegisterRemoteSpeakerEventListener
	-(void) onRemoteSpeakerAdded:(VCRemoteSpeaker*)remoteSpeaker User:(VCUser*)user Call:(VCCall*)call Room:(VCRoom*)room;
	-(void) onRemoteSpeakerRemoved:(VCRemoteSpeaker*)remoteSpeaker User:(VCUser*)user Call:(VCCall*)call Room:(VCRoom*)room;
	-(void) onRemoteSpeakerStateUpdated:(VCRemoteSpeaker*)remoteSpeaker User:(VCUser*)user Call:(VCCall*)call Room:(VCRoom*)room State:(VCDeviceState)state;
@end
@protocol VCEndpointIRegisterRemoteWindowShareEventListener
	-(void) onRemoteWindowShareAdded:(VCRemoteWindowShare*)remoteWindowShare User:(VCUser*)user Call:(VCCall*)call Room:(VCRoom*)room Participant:(VCParticipant*)participant;
	-(void) onRemoteWindowShareRemoved:(VCRemoteWindowShare*)remoteWindowShare User:(VCUser*)user Call:(VCCall*)call Room:(VCRoom*)room Participant:(VCParticipant*)participant;
	-(void) onRemoteWindowShareStateUpdated:(VCRemoteWindowShare*)remoteWindowShare User:(VCUser*)user Call:(VCCall*)call Room:(VCRoom*)room Participant:(VCParticipant*)participant State:(VCDeviceState)state;
@end
@protocol VCEndpointIRegisterRemoteWindowShareFrameListener
	/*!
	 * Callback that is triggered each time a remote camera produces a video frame.
	 */
	-(void) onRemoteWindowShareFrame:(VCRemoteWindowShare*)remoteWindowShare Participant:(VCParticipant*)participant VideoFrame:(VCVideoFrame*)videoFrame;
@end
@protocol VCEndpointIRegisterVirtualAudioSourceEventListener
	/*!
	 * Callback that is triggered each time a virtual audio source becomes available for a VidyoEndpoint to add into a conference.
	 */
	-(void) onVirtualAudioSourceAdded:(VCVirtualAudioSource*)virtualAudioSource;
	/*!
	 * Callback that is triggered each time a virtual audio source is no longer available for a VidyoEndpoint to add into a conference.
	 */
	-(void) onVirtualAudioSourceRemoved:(VCVirtualAudioSource*)virtualAudioSource;
	/*!
	 * Callback that is triggered each time there is a change in the state of the window such as being suspended or disabled.
	 */
	-(void) onVirtualAudioSourceStateUpdated:(VCVirtualAudioSource*)virtualAudioSource State:(VCDeviceState)state;
	/*!
	 * Callback that is triggered when specific virtual audio source selected.
	 */
	-(void) onVirtualAudioSourceSelected:(VCVirtualAudioSource*)virtualAudioSource;
	/*!
	 * Callback that is triggered to notify application that VidyoClient is done with the buffer that holds raw audio frame. This buffer is the same one that was passed to VidyoClient via function VidyoVirtualAudioSourceSendFrameWithExternalData.
	 */
	-(void) onVirtualAudioSourceExternalMediaBufferReleased:(VCVirtualAudioSource*)virtualAudioSource Buffer:(unsigned char*)buffer Size:(size_t)size;
@end
@protocol VCEndpointIRegisterVirtualVideoSourceEventListener
	/*!
	 * Callback that is triggered each time a virtual video source becomes available for a VidyoEndpoint to add to a conference.
	 */
	-(void) onVirtualVideoSourceAdded:(VCVirtualVideoSource*)virtualVideoSource;
	/*!
	 * Callback that is triggered each time a virtual video source is no longer available for a VidyoEndpoint to add to a conference.
	 */
	-(void) onVirtualVideoSourceRemoved:(VCVirtualVideoSource*)virtualVideoSource;
	/*!
	 * Callback that is triggered each time there is a change in the state of the virtual video source such as being started, stopped or configuration changed.
	 */
	-(void) onVirtualVideoSourceStateUpdated:(VCVirtualVideoSource*)virtualVideoSource State:(VCDeviceState)state;
	/*!
	 * Callback that is triggered to notify application that VidyoClient is done with the buffer that holds raw video frame. This buffer is the same one that was passed to VidyoClient via function VidyoVirtualVideoSourceSendFrameWithExternalData.
	 */
	-(void) onVirtualVideoSourceExternalMediaBufferReleased:(VCVirtualVideoSource*)virtualVideoSource Buffer:(unsigned char*)buffer Size:(size_t)size;
@end
@protocol VCEndpointIRequestVideoForRemoteCamera
	/*!
	 * Callback that is triggered each time the first frame for remote camera received.
	 */
	-(void) onRemoteCameraFirstFrameReceived:(VCRemoteCamera*)remoteCamera;
@end
@protocol VCEndpointIRequestVideoForRemoteWindowShare
	/*!
	 * Callback that is triggered each time the first frame for remote window share received.
	 */
	-(void) onRemoteWindowShareFirstFrameReceived:(VCRemoteWindowShare*)remoteWindowShare;
@end
@interface VCEndpoint : NSObject
{
	void* objPtr;
	NSMutableDictionary<NSString*, VCRemoteCamera*> *remoteCamerasMap;
	NSMutableDictionary<NSString*, VCRemoteMicrophone*> *remoteMicrophonesMap;
	NSMutableDictionary<NSString*, VCRemoteWindowShare*> *remoteWindowSharesMap;
	NSMutableDictionary<NSString*, id<VCEndpointIRequestVideoForRemoteCamera>> *onRemoteCameraFirstFrameReceivedCallbacksMap;
	NSMutableDictionary<NSString*, id<VCEndpointIRequestVideoForRemoteWindowShare>> *onRemoteWindowShareFirstFrameReceivedCallbacksMap;
	@public
	id<VCEndpointICompressLogs> endpointICompressLogs;
	/*!
	 * This is an asynchronous interface. Get the NetworkInterface for media and signaling.
	 */
	id<VCEndpointIGetActiveNetworkInterface> endpointIGetActiveNetworkInterface;
	/*!
	 * This is an asynchronous interface. Gets the auto-reconnect setting.
	 */
	id<VCEndpointIGetAutoReconnectSetting> endpointIGetAutoReconnectSetting;
	/*!
	 * Gets the current configuration of camera background effect. This functionality is supported only for macOS 10.14 and above, iOS 10.0 and above and Windows VC++ 15 and above.
	 */
	id<VCEndpointIGetCameraBackgroundEffect> endpointIGetCameraBackgroundEffect;
	id<VCEndpointIGetFileLoggerCategoryListAsync> endpointIGetFileLoggerCategoryListAsync;
	/*!
	 * This is an asynchronous interface. Get the analytics event table.
	 */
	id<VCEndpointIGetGoogleAnalyticsEventTable> endpointIGetGoogleAnalyticsEventTable;
	/*!
	 * Returns the configuration of Google Analytics 4 service.
	 */
	id<VCEndpointIGetGoogleAnalyticsOptions> endpointIGetGoogleAnalyticsOptions;
	/*!
	 * Get the product information of the endpoint.
	 */
	id<VCEndpointIGetProductInfoAsync> endpointIGetProductInfoAsync;
	/*!
	 * Gets the names of the audio devices that are whitelisted.
	 */
	id<VCEndpointIGetWhitelistedAudioDevices> endpointIGetWhitelistedAudioDevices;
	/*!
	 * Registers callback to notify the user in case of any errors occur during enabling camera effect.
	 */
	id<VCEndpointIRegisterCameraEffectErrorListener> endpointIRegisterCameraEffectErrorListener;
	/*!
	 * Register callbacks for disable video on low bandwidth.
	 */
	id<VCEndpointIRegisterDisableVideoOnLowBwEventListener> endpointIRegisterDisableVideoOnLowBwEventListener;
	/*!
	 * Registers the advanced error event listeners.
	 */
	id<VCEndpointIRegisterErrorEventListener> endpointIRegisterErrorEventListener;
	/*!
	 * Registers to get notified about camera events. On, iOS, this API must be called from main(UI) thread.
	 */
	id<VCEndpointIRegisterLocalCameraEventListener> endpointIRegisterLocalCameraEventListener;
	/*!
	 * Registers to get notified about camera frames. On, iOS, this API must be called from main(UI) thread.
	 */
	id<VCEndpointIRegisterLocalCameraFrameListener> endpointIRegisterLocalCameraFrameListener;
	/*!
	 * Registers to get notified about microphone energies.
	 */
	id<VCEndpointIRegisterLocalMicrophoneEnergyListener> endpointIRegisterLocalMicrophoneEnergyListener;
	/*!
	 * Registers to get notified about microphone events. On, iOS, this API must be called from main(UI) thread.
	 */
	id<VCEndpointIRegisterLocalMicrophoneEventListener> endpointIRegisterLocalMicrophoneEventListener;
	/*!
	 * Registers to get notified about microphone frames. On, iOS, this API must be called from main(UI) thread.
	 */
	id<VCEndpointIRegisterLocalMicrophoneFrameListener> endpointIRegisterLocalMicrophoneFrameListener;
	/*!
	 * Registers to get notified about monitor events. On, iOS, this API must be called from main(UI) thread.
	 */
	id<VCEndpointIRegisterLocalMonitorEventListener> endpointIRegisterLocalMonitorEventListener;
	/*!
	 * Registers to get notified about monitor frames. On, iOS, this API must be called from main(UI) thread.
	 */
	id<VCEndpointIRegisterLocalMonitorFrameListener> endpointIRegisterLocalMonitorFrameListener;
	/*!
	 * Registers to get notified about renderer events. On, iOS, this API must be called from main(UI) thread.
	 */
	id<VCEndpointIRegisterLocalRendererEventListener> endpointIRegisterLocalRendererEventListener;
	/*!
	 * Registers to get notified about speaker events. On, iOS, this API must be called from main(UI) thread.
	 */
	id<VCEndpointIRegisterLocalSpeakerEventListener> endpointIRegisterLocalSpeakerEventListener;
	/*!
	 * Registers to get notified about window events. On, iOS, this API must be called from main(UI) thread.
	 */
	id<VCEndpointIRegisterLocalWindowShareEventListener> endpointIRegisterLocalWindowShareEventListener;
	/*!
	 * Registers to get notified about window frames. On, iOS, this API must be called from main(UI) thread.
	 */
	id<VCEndpointIRegisterLocalWindowShareFrameListener> endpointIRegisterLocalWindowShareFrameListener;
	/*!
	 * Registers to get notified about log events.
	 */
	id<VCEndpointIRegisterLogEventListener> endpointIRegisterLogEventListener;
	/*!
	 * This is a synchronous interface. Register a callback to receive the final response for the Next Generation Renderer action.
	 */
	id<VCEndpointIRegisterNGRResultEventListener> endpointIRegisterNGRResultEventListener;
	/*!
	 * Registers to get notified about network interface events.
	 */
	id<VCEndpointIRegisterNetworkInterfaceEventListener> endpointIRegisterNetworkInterfaceEventListener;
	/*!
	 * Registers to get notified about reconnecting events. Note: You should not perform long action in the callbacks.
	 */
	id<VCEndpointIRegisterReconnectEventListener> endpointIRegisterReconnectEventListener;
	/*!
	 * Registers to get notified about camera events from other participants.
	 */
	id<VCEndpointIRegisterRemoteCameraEventListener> endpointIRegisterRemoteCameraEventListener;
	/*!
	 * Registers to get notified about camera frames from other participants.
	 */
	id<VCEndpointIRegisterRemoteCameraFrameListener> endpointIRegisterRemoteCameraFrameListener;
	/*!
	 * Registers to get notified about microphone energies from other participants.
	 */
	id<VCEndpointIRegisterRemoteMicrophoneEnergyListener> endpointIRegisterRemoteMicrophoneEnergyListener;
	/*!
	 * Registers to get notified about microphone events from other participants.
	 */
	id<VCEndpointIRegisterRemoteMicrophoneEventListener> endpointIRegisterRemoteMicrophoneEventListener;
	/*!
	 * Registers to get notified about microphone frames from other participants.
	 */
	id<VCEndpointIRegisterRemoteMicrophoneFrameListener> endpointIRegisterRemoteMicrophoneFrameListener;
	/*!
	 * Registers to get notified about renderer events.
	 */
	id<VCEndpointIRegisterRemoteRendererEventListener> endpointIRegisterRemoteRendererEventListener;
	/*!
	 * Registers to get notified about speaker events.
	 */
	id<VCEndpointIRegisterRemoteSpeakerEventListener> endpointIRegisterRemoteSpeakerEventListener;
	/*!
	 * Registers to get notified about window-shares from other participants.
	 */
	id<VCEndpointIRegisterRemoteWindowShareEventListener> endpointIRegisterRemoteWindowShareEventListener;
	/*!
	 * Registers to get notified about window-share frames from other participants.
	 */
	id<VCEndpointIRegisterRemoteWindowShareFrameListener> endpointIRegisterRemoteWindowShareFrameListener;
	/*!
	 * Registers to get notified about virtual audio source events. This is a synchronous interface.
	 */
	id<VCEndpointIRegisterVirtualAudioSourceEventListener> endpointIRegisterVirtualAudioSourceEventListener;
	/*!
	 * Registers to get notified about virtual video source events. On, iOS, this API must be called from main(UI) thread.
	 */
	id<VCEndpointIRegisterVirtualVideoSourceEventListener> endpointIRegisterVirtualVideoSourceEventListener;
}
	/*!
	 * @param viewId A platform specific parent view ID where the VidyoEndpoint's rendering window will be added as a child window. It will be used to render preview and composite remote participants. When running custom layout on macOS, the core animation layer should be disabled on this view.
	 * @param viewStyle Type of the composite renderer which represents the visual style and behaviour.
	 * @param remoteParticipants Number of remote participants to composite into the window. Setting the value to 0 will render preview only.
	 */
	-(id) init:(void*)viewId ViewStyle:(VCLocalRendererViewStyle)viewStyle RemoteParticipants:(unsigned int)remoteParticipants ConsoleLogFilter:(const char*)consoleLogFilter LogFileFilter:(const char*)logFileFilter LogFileName:(const char*)logFileName;
	-(void) dealloc;
	/*!
	 * Adds audio device to whitelist.
	 * @param e The VidyoEndpoint object.
	 * @param deviceName The name of audio device that will be whitelisted.
	 */
	-(BOOL) addAudioDeviceToWhitelist:(NSString*)deviceName;
	/*!
	 * Add message class that application should receive.
	 * @param e The VidyoEndpoint object.
	 * @param messageClass Name of message class. MSGCLASS_HUNTER is added by default so application will receive only these message class.
	 */
	-(BOOL) addMessageClass:(const char*)messageClass;
	/*!
	 * Log an application log message into the VidyoClient logs under the log category 'Application'.
	 * @param logLevel Specify logging level using enum, allowed values defined in VidyoClientAppLogLevel
	 * @param logMsg Log message to write to logfile
	 */
	-(void) appLog:(VCClientAppLogLevel)logLevel LogMsg:(NSMutableString*)logMsg;
	/*!
	 * Composites the preview and remote participants in a view. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param viewId A platform specific view ID where the participant will be rendered.
	 * @param viewStyle Type of the composite renderer which represents the visual style and behaviour.
	 * @param remoteParticipants Number of remote participants to composite into the window. Setting the value to 0 will render preview only.
	 */
	-(BOOL) assignViewToCompositeRenderer:(void*)viewId ViewStyle:(VCLocalRendererViewStyle)viewStyle RemoteParticipants:(unsigned int)remoteParticipants;
	/*!
	 * Shows a preview of a local camera in a view. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param viewId A platform specific view ID where the participant will be rendered.
	 * @param localCamera The VidyoLocalCamera that will be shown.
	 * @param displayCropped Render the image as cropped. Otherwise letterbox.
	 * @param allowZoom Allow zooming of the image with mouse or touch.
	 */
	-(BOOL) assignViewToLocalCamera:(void*)viewId LocalCamera:(VCLocalCamera*)localCamera DisplayCropped:(BOOL)displayCropped AllowZoom:(BOOL)allowZoom;
	/*!
	 * Shows a VidyoLocalMonitor in a view. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param viewId A platform specific view ID where the VidyoLocalMonitor will be rendered.
	 * @param localMonitor The VidyoLocalMonitor that will be shown.
	 * @param displayCropped Render the image as cropped. Otherwise letterbox.
	 * @param allowZoom Allow zooming of the image with mouse or touch.
	 */
	-(BOOL) assignViewToLocalMonitor:(void*)viewId LocalMonitor:(VCLocalMonitor*)localMonitor DisplayCropped:(BOOL)displayCropped AllowZoom:(BOOL)allowZoom;
	/*!
	 * Shows a VidyoLocalWindowShare in a view. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param viewId A platform specific view ID where the VidyoLocalWindowShare will be rendered.
	 * @param localWindowShare The VidyoLocalWindowShare that will be shown.
	 * @param displayCropped Render the image as cropped. Otherwise letterbox.
	 * @param allowZoom Allow zooming of the image with mouse or touch.
	 */
	-(BOOL) assignViewToLocalWindowShare:(void*)viewId LocalWindowShare:(VCLocalWindowShare*)localWindowShare DisplayCropped:(BOOL)displayCropped AllowZoom:(BOOL)allowZoom;
	/*!
	 * Shows a participant in a view.
	 * @param e The VidyoEndpoint object.
	 * @param viewId A platform specific view ID where the participant will be rendered.
	 * @param remoteCamera The VidyoRemoteCamera that will be shown.
	 * @param displayCropped Render the image as cropped. Otherwise letterbox.
	 * @param allowZoom Allow zooming of the image with mouse or touch.
	 */
	-(BOOL) assignViewToRemoteCamera:(void*)viewId RemoteCamera:(VCRemoteCamera*)remoteCamera DisplayCropped:(BOOL)displayCropped AllowZoom:(BOOL)allowZoom;
	/*!
	 * Shows a participant in a view. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param viewId A platform specific view ID where the participant will be rendered.
	 * @param remoteWindowShare The VidyoRemoteWindowShare that will be shown.
	 * @param displayCropped Render the image as cropped. Otherwise letterbox.
	 * @param allowZoom Allow zooming of the image with mouse or touch.
	 */
	-(BOOL) assignViewToRemoteWindowShare:(void*)viewId RemoteWindowShare:(VCRemoteWindowShare*)remoteWindowShare DisplayCropped:(BOOL)displayCropped AllowZoom:(BOOL)allowZoom;
	/*!
	 * Shows a virtual video source in a view. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param viewId A platform specific view ID where the source will be rendered.
	 * @param virtualVideoSource The VidyoVirtualVideoSource that will be shown.
	 * @param displayCropped Render the image as cropped. Otherwise letterbox.
	 * @param allowZoom Allow zooming of the image with mouse or touch.
	 */
	-(BOOL) assignViewToVirtualVideoSource:(void*)viewId VirtualVideoSource:(VCVirtualVideoSource*)virtualVideoSource DisplayCropped:(BOOL)displayCropped AllowZoom:(BOOL)allowZoom;
	/*!
	 * @param compressedFileName Name if the compression output file.
	 * @param onComplete Callback that is triggered when the compression completes.
	 */
	-(BOOL) compressLogs:(NSMutableString*)compressedFileName EndpointICompressLogs:(id<VCEndpointICompressLogs>)endpointICompressLogs;
	/*!
	 */
	-(BOOL) createRenderer:(VCLocalMonitor*)monitor Width:(unsigned int)width Height:(unsigned int)height;
	/*!
	 * @param viewId A platform specific parent view ID where the rendering window will be added as a child window.
	 * @param x X coordinate of the child window within the parent view ID.
	 * @param y Y coordinate of the child window within the parent view ID.
	 * @param width Width of the child window within the parent view ID.
	 * @param height Height of the child window within the parent view ID.
	 */
	-(BOOL) createRendererFromViewId:(void*)viewId X:(int)x Y:(int)y Width:(unsigned int)width Height:(unsigned int)height;
	/*!
	 */
	-(BOOL) createRendererMultiScreen;
	/*!
	 * Create virtual audio source. This is an asynchronous interface. The VidyoEndpointOnVirtualAudioSourceAdded will trigger.
	 * @param e The VidyoEndpoint object.
	 * @param name The name for the virtual audio source.
	 * @param id The id for the virtual audio source.
	 * @param configuration The string in JSON format that contain audio configuration that will be used for virtual audio source. <p>format - Specifies the media format. Possible values are: fl32 or in16. The default is fl32.</p> <p>Example: {'format' : 'in16'}.</p> <p>sampleRate - Specifies the audio sample rate. Possible values are: 48000, 32000 and 16000. The default is 32000.</p> <p>Example: {'sampleRate' : 48000}.</p> <p>numberOfChannels - Specifies the number of channels. Possible values are: 1 or 2. The default is 1.</p> <p>Example: {'numberOfChannels' : 2}.</p> <p>frameInterval - Specifies the frame interval in ms. Possible values are: 20 or 40. The default is 20.</p> <p>Example: {'frameInterval' : 40}.</p>
	 */
	-(BOOL) createVirtualAudioSource:(NSString*)name Id:(NSString*)id Configuration:(NSString*)configuration;
	/*!
	 * Create a virtual video source. The user can create a maximum of 10 virtual video sources. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param type Type of the virtual video source.
	 * @param id Unique ID.
	 * @param name Name of the virtual video source.
	 */
	-(BOOL) createVirtualVideoSource:(VCVirtualVideoSourceType)type Id:(const char*)id Name:(const char*)name;
	/*!
	 * Cycles camera selection to the next available camera. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) cycleCamera;
	/*!
	 * Cycles microphone selection to the next available microphone. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) cycleMicrophone;
	/*!
	 * Cycles speaker selection to the next available speaker. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) cycleSpeaker;
	/*!
	 * Destroy virtual audio source. This is an asynchronous interface. The VidyoEndpointOnVirtualAudioSourceRemoved will trigger.
	 * @param e The VidyoEndpoint object.
	 * @param virtualAudioSource The virtual audio source that will be destroyed.
	 */
	-(BOOL) destroyVirtualAudioSource:(VCVirtualAudioSource*)virtualAudioSource;
	/*!
	 * Destroy virtual video source. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param virtualVideoSource The virtual video source that will be destroyed.
	 */
	-(BOOL) destroyVirtualVideoSource:(VCVirtualVideoSource*)virtualVideoSource;
	/*!
	 * Stop background tasks associated with an endpoint. On, iOS, this API must be called from main(UI) thread.
	 * @param e The endpoint object to disable.
	 */
	-(void) disable;
	/*!
	 * @param e The VidyoEndpoint object.
	 */
	-(void) disableDebug;
	/*!
	 * Enabled debug mode on the endpoint which will start debug logging and enable statistics.
	 * @param e The VidyoEndpoint object.
	 * @param port Debug port will output debug logging.
	 * @param logFilter Log filter to use on the debug port.
	 */
	-(BOOL) enableDebug:(unsigned int)port LogFilter:(const char*)logFilter;
	/*!
	 */
	-(BOOL) enableFileLogger:(const char*)logFileName LogFileFilter:(const char*)logFileFilter;
	/*!
	 * This is an asynchronous interface. Get the NetworkInterface for media and signaling.
	 * @param e The VidyoEndpoint object.
	 * @param onGetActiveNetworkInterfaceCallback Callback called upon completion.
	 */
	-(BOOL) getActiveNetworkInterface:(id<VCEndpointIGetActiveNetworkInterface>)endpointIGetActiveNetworkInterface;
	/*!
	 */
	-(NSString*) getApplicationTag;
	/*!
	 * Gets audio bitrate multiplier which is used when calculating the audio bitrate.
	 * @param e The endpoint object.
	 */
	-(unsigned int) getAudioBitrateMultiplier;
	/*!
	 * Gets the audio mode for both the audio devices (speaker and microphone).
	 * @param e The endpoint object.
	 */
	-(VCEndpointAudioMode) getAudioMode;
	/*!
	 * Gets time interval between two packet of audio in miliseconds.
	 * @param e The endpoint object.
	 */
	-(unsigned int) getAudioPacketInterval;
	/*!
	 * Gets audio loss percantage - value that is used to configure encoder.
	 * @param e The endpoint object.
	 */
	-(unsigned int) getAudioPacketLossPercentage;
	/*!
	 * Gets state of auto-reconnect. It's either enabled or disabled.
	 * @param e The endpoint object.
	 */
	-(BOOL) getAutoReconnect;
	/*!
	 * Gets back off for next reconnect attempt.
	 * @param e The endpoint object.
	 */
	-(unsigned int) getAutoReconnectAttemptBackOff;
	/*!
	 * Gets maximum attempts to be done for reconnecting.
	 * @param e The endpoint object.
	 */
	-(unsigned int) getAutoReconnectMaxAttempts;
	/*!
	 * This is an asynchronous interface. Gets the auto-reconnect setting.
	 * @param e The VidyoEndpoint object.
	 * @param onGetAutoReconnectSettingCallback Callback called upon completion.
	 */
	-(BOOL) getAutoReconnectSetting:(id<VCEndpointIGetAutoReconnectSetting>)endpointIGetAutoReconnectSetting;
	/*!
	 * Gets the current configuration of camera background effect. This functionality is supported only for macOS 10.14 and above, iOS 10.0 and above and Windows VC++ 15 and above.
	 * @param e The VidyoEndpoint object.
	 * @param onGetEffectInfo Callback that reports the current configuration of camera background effect to the application. In case some error occurs NULL will be reported.
	 */
	-(BOOL) getCameraBackgroundEffect:(id<VCEndpointIGetCameraBackgroundEffect>)endpointIGetCameraBackgroundEffect;
	/*!
	 * Gets conference number - a special identifier that is showed up in the Portal CDR record for the conference.
	 * @param e The endpoint object.
	 */
	-(NSString*) getConferenceNumber;
	/*!
	 * Get current CPU profile setting.
	 * @param e The endpoint object.
	 */
	-(VCEndpointTradeOffProfile) getCpuTradeOffProfile;
	/*!
	 * Gets state of video on low bandwidth. It's either enabled or disabled.
	 * @param e The endpoint object.
	 */
	-(BOOL) getDisableVideoOnLowBandwidth;
	/*!
	 * Gets number of audio streams requested while video is shut off.
	 * @param e The endpoint object.
	 */
	-(unsigned int) getDisableVideoOnLowBandwidthAudioStreams;
	/*!
	 * Gets time it takes to recover when video is shut off.
	 * @param e The endpoint object.
	 */
	-(unsigned int) getDisableVideoOnLowBandwidthRecoveryTime;
	/*!
	 * Gets time it takes to shut off video due to low bandwidth.
	 * @param e The endpoint object.
	 */
	-(unsigned int) getDisableVideoOnLowBandwidthResponseTime;
	/*!
	 * Gets how often checking for low bandwidth happens.
	 * @param e The endpoint object.
	 */
	-(unsigned int) getDisableVideoOnLowBandwidthSampleTime;
	/*!
	 * Gets low bandwidth threshold.
	 * @param e The endpoint object.
	 */
	-(unsigned int) getDisableVideoOnLowBandwidthThreshold;
	/*!
	 */
	-(BOOL) getFileLoggerCategoryList:(NSMutableArray*)categories;
	/*!
	 * @param e The endpoint object.
	 * @param onComplete The callback that is triggered when getting the logger category list completes.
	 */
	-(BOOL) getFileLoggerCategoryListAsync:(id<VCEndpointIGetFileLoggerCategoryListAsync>)endpointIGetFileLoggerCategoryListAsync;
	/*!
	 * This is an asynchronous interface. Get the analytics event table.
	 * @param e The VidyoEndpoint object.
	 * @param onGetAnalyticsEventTableCallback Callback called upon completion.
	 */
	-(BOOL) getGoogleAnalyticsEventTable:(id<VCEndpointIGetGoogleAnalyticsEventTable>)endpointIGetGoogleAnalyticsEventTable;
	/*!
	 * Returns the configuration of Google Analytics 4 service.
	 * @param e The VidyoEndpoint object.
	 * @param onGetGoogleAnalyticsOptions Callback called upon completion.
	 */
	-(BOOL) getGoogleAnalyticsOptions:(id<VCEndpointIGetGoogleAnalyticsOptions>)endpointIGetGoogleAnalyticsOptions;
	/*!
	 */
	-(NSString*) getId;
	/*!
	 * Returns Insights Url if service is running.
	 * @param e The VidyoEndpoint object.
	 */
	-(NSString*) getInsightsServiceUrl;
	/*!
	 * Return the max receive bit rate configured by application.
	 * @param e The VidyoEndpoint object.
	 */
	-(unsigned int) getMaxReceiveBitRate;
	/*!
	 * Return the max send bit rate configured by application.
	 * @param e The VidyoEndpoint object.
	 */
	-(unsigned int) getMaxSendBitRate;
	/*!
	 * Gets maximum microphone boost level that is applied only in the conference for the selected microphone in case the system is set to the higher value.
	 * @param e The endpoint object.
	 */
	-(double) getMicrophoneMaxBoostLevel;
	/*!
	 * Gets minimum microphone value that is applied only in the conference for the selected microphone in case the system is set to the lower value.
	 * @param e The endpoint object.
	 */
	-(unsigned int) getMinMicrophoneVolume;
	/*!
	 * @param e The endpoint object.
	 */
	-(NSString*) getOptions;
	/*!
	 * Gets preferred audio codec type.
	 * @param e The endpoint object.
	 */
	-(VCEndpointPreferredAudioCodec) getPreferredAudioCodec;
	/*!
	 * Get the product information of the endpoint.
	 * @param e The endpoint object.
	 * @param productInfo The product info of the endpoint
	 * @param supportedFeature The features this endpoint can support
	 */
	-(BOOL) getProductInfo:(NSMutableArray*)productInfo SupportedFeature:(NSMutableArray*)supportedFeature;
	/*!
	 * Get the product information of the endpoint.
	 * @param e The endpoint object.
	 * @param onComplete The callback that is triggered when getting the product information completes.
	 */
	-(BOOL) getProductInfoAsync:(id<VCEndpointIGetProductInfoAsync>)endpointIGetProductInfoAsync;
	/*!
	 * Gets the local renderer and conference tiles displaying options.
	 * @param e The VidyoEndpoint object.
	 * @param viewId A platform-specific view ID.
	 */
	-(NSMutableString*) getRendererOptionsForViewId:(void*)viewId;
	/*!
	 * Gets whether SVC is enabled.
	 * @param e The endpoint object.
	 */
	-(BOOL) getStaticShareSvcState;
	/*!
	 * Gets conference room statistics gather interval in seconds.
	 * @param e The endpoint object.
	 */
	-(long long) getStatisticRate;
	/*!
	 * Fill in data in VidyoEndpointStats from an endpoint.
	 * @param e The endpoint object to extract stats.
	 */
	-(VCEndpointStats*) getStats;
	/*!
	 * Fill in data in VidyoEndpointStats from an endpoint.
	 * @param e The endpoint object to extract stats.
	 */
	-(NSMutableString*) getStatsJson;
	/*!
	 * Gets the names of the audio devices that are whitelisted.
	 * @param e The VidyoEndpoint object.
	 * @param onGetCallback Callback that will report an array with the names of audio devices that are whitelisted.
	 */
	-(BOOL) getWhitelistedAudioDevices:(id<VCEndpointIGetWhitelistedAudioDevices>)endpointIGetWhitelistedAudioDevices;
	/*!
	 * Control type of event action and categories.
	 * @param e The VidyoEndpoint object.
	 * @param eventCategory Type of event category.
	 * @param eventAction Type of event action
	 * @param enable Event action state flag.
	 */
	-(BOOL) googleAnalyticsControlEventAction:(VCEndpointGoogleAnalyticsEventCategory)eventCategory EventAction:(VCEndpointGoogleAnalyticsEventAction)eventAction Enable:(BOOL)enable;
	/*!
	 * Hides a view which is used for custom layout of sources. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param viewId The view ID of the view to hide.
	 */
	-(BOOL) hideView:(void*)viewId;
	/*!
	 * Notify endpoint of an event. This data will be sent to Loki analytics. Event is automatically timestamped.
	 * @param e The VidyoEndpoint object.
	 * @param eventName Event name.
	 * @param parameters Event parameters as string vector. Can be NULL if no parameters are needed.
	 */
	-(BOOL) insightsNotifyApplicationEvent:(const char*)eventName Parameters:(NSMutableArray*)parameters;
	/*!
	 * Checks if debug mode is enabled on the endpoint.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) isDebugEnabled;
	/*!
	 * Checks whether Google Analytics service is running.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) isGoogleAnalyticsServiceEnabled;
	/*!
	 * Checks whether Insights service is running.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) isInsightsServiceEnabled;
	/*!
	 * On, iOS, this API must be called from main(UI) thread.
	 */
	-(void) localCameraSelectAdvanced:(VCLocalCamera*)localCamera;
	/*!
	 * On, iOS, this API must be called from main(UI) thread.
	 */
	-(void) localCameraUnselectAdvanced:(VCLocalCamera*)localCamera;
	/*!
	 * On, iOS, this API must be called from main(UI) thread.
	 */
	-(void) localMicrophoneSelectAdvanced:(VCLocalMicrophone*)localMicrophone PreviewedPreCall:(BOOL)previewedPreCall;
	/*!
	 * On, iOS, this API must be called from main(UI) thread.
	 */
	-(void) localMicrophoneUnselectAdvanced:(VCLocalMicrophone*)localMicrophone;
	/*!
	 * On, iOS, this API must be called from main(UI) thread.
	 */
	-(void) localMonitorSelectAdvanced:(VCLocalMonitor*)localMonitor;
	/*!
	 * On, iOS, this API must be called from main(UI) thread.
	 */
	-(void) localMonitorUnselectAdvanced:(VCLocalMonitor*)localMonitor;
	/*!
	 * On, iOS, this API must be called from main(UI) thread.
	 */
	-(void) localRendererSelectAdvanced:(VCLocalRenderer*)localRenderer;
	/*!
	 * On, iOS, this API must be called from main(UI) thread.
	 */
	-(void) localRendererUnselectAdvanced:(VCLocalRenderer*)localRenderer;
	/*!
	 * On, iOS, this API must be called from main(UI) thread.
	 */
	-(void) localSpeakerSelectAdvanced:(VCLocalSpeaker*)localSpeaker;
	/*!
	 * On, iOS, this API must be called from main(UI) thread.
	 */
	-(void) localSpeakerUnselectAdvanced:(VCLocalSpeaker*)localSpeaker;
	/*!
	 * On, iOS, this API must be called from main(UI) thread.
	 */
	-(void) localWindowShareSelectAdvanced:(VCLocalWindowShare*)localWindowShare;
	/*!
	 * On, iOS, this API must be called from main(UI) thread.
	 */
	-(void) localWindowShareUnselectAdvanced:(VCLocalWindowShare*)localWindowShare;
	/*!
	 * Registers callback to notify the user in case of any errors occur during enabling camera effect.
	 * @param e The VidyoEndpoint object.
	 * @param onError The callback that will reports camera effect errors.
	 */
	-(BOOL) registerCameraEffectErrorListener:(id<VCEndpointIRegisterCameraEffectErrorListener>)endpointIRegisterCameraEffectErrorListener;
	/*!
	 * Register callbacks for disable video on low bandwidth.
	 * @param e VidyoEndpoint object.
	 * @param onStarted Callback that will be triggered when disable video on low bandwidth is started.
	 * @param onEnded Callback that will be triggered when disable video on low bandwidth is ended.
	 */
	-(void) registerDisableVideoOnLowBwEventListener:(id<VCEndpointIRegisterDisableVideoOnLowBwEventListener>)endpointIRegisterDisableVideoOnLowBwEventListener;
	/*!
	 * Registers the advanced error event listeners.
	 * @param e The VidyoEndpoint object.
	 * @param onErrorCallback Callback that is triggered when an error occurs.
	 */
	-(BOOL) registerErrorEventListener:(id<VCEndpointIRegisterErrorEventListener>)endpointIRegisterErrorEventListener;
	/*!
	 * Registers to get notified about camera events. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param onAdded Callback that is triggered for every new or existing camera added.
	 * @param onRemoved Callback that is triggered when the camera is removed.
	 * @param onSelected Callback that is triggered when a camera is selected for use.
	 * @param onStateUpdated Callback that is triggered when a camera state is updated.
	 */
	-(BOOL) registerLocalCameraEventListener:(id<VCEndpointIRegisterLocalCameraEventListener>)endpointIRegisterLocalCameraEventListener;
	/*!
	 * Registers to get notified about camera frames. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param localCamera The VidyoLocalCamera for which to receive the frames.
	 * @param onFrame Callback that is triggered for every frame from a remote camera.
	 * @param width Approximate width of the requested frame.
	 * @param height Approximate height of the requested frame.
	 * @param frameInterval Approximate frame interval of the requested frame.
	 */
	-(BOOL) registerLocalCameraFrameListener:(VCLocalCamera*)localCamera EndpointIRegisterLocalCameraFrameListener:(id<VCEndpointIRegisterLocalCameraFrameListener>)endpointIRegisterLocalCameraFrameListener Width:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval;
	/*!
	 * Registers to get notified about microphone energies.
	 * @param e The VidyoEndpoint object.
	 * @param onEnergy Callback that is triggered for every frame with energy from a microphone.
	 */
	-(BOOL) registerLocalMicrophoneEnergyListener:(id<VCEndpointIRegisterLocalMicrophoneEnergyListener>)endpointIRegisterLocalMicrophoneEnergyListener;
	/*!
	 * Registers to get notified about microphone events. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param onAdded Callback that is triggered for every new or existing microphone added.
	 * @param onRemoved Callback that is triggered when the microphone is removed.
	 * @param onSelected Callback that is triggered when a microphone is selected for use.
	 * @param onStateUpdated Callback that is triggered when a microphone state is updated.
	 */
	-(BOOL) registerLocalMicrophoneEventListener:(id<VCEndpointIRegisterLocalMicrophoneEventListener>)endpointIRegisterLocalMicrophoneEventListener;
	/*!
	 * Registers to get notified about microphone frames. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param localMicrophone The VidyoLocalMicrophone for which to receive the frames.
	 * @param onFrame Callback that is triggered for every frame from a microphone.
	 */
	-(BOOL) registerLocalMicrophoneFrameListener:(VCLocalMicrophone*)localMicrophone EndpointIRegisterLocalMicrophoneFrameListener:(id<VCEndpointIRegisterLocalMicrophoneFrameListener>)endpointIRegisterLocalMicrophoneFrameListener;
	/*!
	 * Registers to get notified about monitor events. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param onAdded Callback that is triggered for every new or existing monitor added.
	 * @param onRemoved Callback that is triggered when the monitor is removed.
	 * @param onSelected Callback that is triggered when a monitor is selected for use.
	 * @param onStateUpdated Callback that is triggered when a monitor state is updated.
	 */
	-(BOOL) registerLocalMonitorEventListener:(id<VCEndpointIRegisterLocalMonitorEventListener>)endpointIRegisterLocalMonitorEventListener;
	/*!
	 * Registers to get notified about monitor frames. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param localMonitor The VidyoLocalMonitor for which to receive the frames.
	 * @param onFrame Callback that is triggered for every frame from a monitor.
	 * @param width Approximate width of the requested frame.
	 * @param height Approximate height of the requested frame.
	 * @param frameInterval Approximate frame interval of the requested frame.
	 */
	-(BOOL) registerLocalMonitorFrameListener:(VCLocalMonitor*)localMonitor EndpointIRegisterLocalMonitorFrameListener:(id<VCEndpointIRegisterLocalMonitorFrameListener>)endpointIRegisterLocalMonitorFrameListener Width:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval;
	/*!
	 * Registers to get notified about renderer events. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param onAdded Callback that is triggered for every new or existing window added.
	 * @param onRemoved Callback that is triggered when the window is removed.
	 * @param onSelected Callback that is triggered when a window is selected for use.
	 * @param onStateUpdated Callback that is triggered when a window state changes.
	 */
	-(BOOL) registerLocalRendererEventListener:(id<VCEndpointIRegisterLocalRendererEventListener>)endpointIRegisterLocalRendererEventListener;
	/*!
	 * Registers to get notified about speaker events. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param onAdded Callback that is triggered for every new or existing speaker added.
	 * @param onRemoved Callback that is triggered when the speaker is removed.
	 * @param onSelected Callback that is triggered when a speaker is selected for use.
	 * @param onStateUpdated Callback that is triggered when a speaker state is updated.
	 */
	-(BOOL) registerLocalSpeakerEventListener:(id<VCEndpointIRegisterLocalSpeakerEventListener>)endpointIRegisterLocalSpeakerEventListener;
	/*!
	 * Registers to get notified about window events. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param onAdded Callback that is triggered for every new or existing window added.
	 * @param onRemoved Callback that is triggered when the window is removed.
	 * @param onSelected Callback that is triggered when a window is selected for use.
	 * @param onStateUpdated Callback that is triggered when a window state changes.
	 */
	-(BOOL) registerLocalWindowShareEventListener:(id<VCEndpointIRegisterLocalWindowShareEventListener>)endpointIRegisterLocalWindowShareEventListener;
	/*!
	 * Registers to get notified about window frames. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param localWindowShare The VidyoLocalWindowShare for which to receive the frames.
	 * @param onFrame Callback that is triggered for every frame from a window.
	 * @param width Approximate width of the requested frame.
	 * @param height Approximate height of the requested frame.
	 * @param frameInterval Approximate frame interval of the requested frame.
	 */
	-(BOOL) registerLocalWindowShareFrameListener:(VCLocalWindowShare*)localWindowShare EndpointIRegisterLocalWindowShareFrameListener:(id<VCEndpointIRegisterLocalWindowShareFrameListener>)endpointIRegisterLocalWindowShareFrameListener Width:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval;
	/*!
	 * Registers to get notified about log events.
	 * @param e The VidyoEndpoint object.
	 * @param onLog Callback that is triggered for every new log record.
	 * @param filter <p>A space-separated (or comma-separated) sequence of names of log levels, each optionally followed by a category. Categories are separated from levels by the character '@'.</p> <p>Either a level or category may be specified as 'all' or '*' (interchangeably), meaning all levels or categories. A level specified without a category is equivalent to a level@*.</p> <p>The levels are: 'fatal', 'error', 'warning', 'info', 'debug', 'sent', 'received', 'enter', and 'leave'.</p> <p>The level may be prefixed by '-' or '!' (interchangeably), meaning to remove the given level (or levels, see below) from the given category. The string 'none' is equivalent to '-all'.</p> <p>The first level in the list may be prefixed by '+'. If the first level begins with a '+' or '-'/'!', the string is used to modify the listener's existing levels and 45categories. Otherwise, unless the <code>add</code> parameter is true, the levels and categories specified in the string replace all existing levels and categories for the listener. The leading character '+' may be present before other levels, but is ignored.</p> <p>Unless they are preceded by '=', level names imply other levels as well. In particular, each of the levels 'fatal', 'error', 'warning', 'info', and 'debug' implies the levels higher than it, when specified positively; 'sent' and 'received' always imply each other; and 'enter' and 'leave' always imply each other.</p> <p>See VidyoEndpointGetLogCategories for determining the names and descriptions of registered categories.</p> <p>Level names are case-insensitive; category names are case-sensitive.</p> <p>Example: "all" - all levels, all categories.</p> <p>Example: "all -enter" - all categories, all levels but enter and leave.</p> <p>Example: "*@VidyoClient" - all levels for the VidyoClient category.</p> <p>Example: "-*@VidyoClient" - remove all levels from the VidyoClient category.</p> <p>Example: "debug" - all categories, fatal, error, warning, info, and debug levels.</p> <p>Example: "=debug" - all categories, debug level only.</p> <p>Example: "all -=enter" - all categories, all levels but enter (leave is still included).</p> <p>Example: "error@VidyoClient" - fatal and error only for the VidyoClient category.</p> <p>Example: "warning debug@VidyoClient" - fatal, error, and warning for all categories; additionally, info and debug for the VidyoClient category.</p>
	 */
	-(BOOL) registerLogEventListener:(id<VCEndpointIRegisterLogEventListener>)endpointIRegisterLogEventListener Filter:(const char*)filter;
	/*!
	 * This is a synchronous interface. Register a callback to receive the final response for the Next Generation Renderer action.
	 * @param e VidyoEndpoint object.
	 * @param onNGRResult Callback to be triggered upon receive the final response from next generation renderer library.
	 */
	-(BOOL) registerNGRResultEventListener:(id<VCEndpointIRegisterNGRResultEventListener>)endpointIRegisterNGRResultEventListener;
	/*!
	 * Registers to get notified about network interface events.
	 * @param e The VidyoEndpoint object.
	 * @param onAdded Callback that is triggered for every new or existing network interface added.
	 * @param onRemoved Callback that is triggered when the network interface is removed.
	 * @param onSelected Callback that is triggered when a network interface is selected for use.
	 * @param onStateUpdated Callback that is triggered when a network interface state changes.
	 */
	-(BOOL) registerNetworkInterfaceEventListener:(id<VCEndpointIRegisterNetworkInterfaceEventListener>)endpointIRegisterNetworkInterfaceEventListener;
	/*!
	 * Registers plugin.
	 * @param e The VidyoEndpoint object.
	 * @param plugin Plugin to register.
	 */
	-(long) registerPlugin:(long)plugin;
	/*!
	 * Registers to get notified about reconnecting events. Note: You should not perform long action in the callbacks.
	 * @param e The VidyoEndpoint object.
	 * @param onReconnecting Callback that is triggered each time the new attempt to reconnect will be started.
	 * @param onReconnected Callback that is triggered when reconnecting was successful.
	 * @param onConferenceLost Callback that is triggered when reconnecting failed.
	 */
	-(BOOL) registerReconnectEventListener:(id<VCEndpointIRegisterReconnectEventListener>)endpointIRegisterReconnectEventListener;
	/*!
	 * Registers to get notified about camera events from other participants.
	 * @param e The VidyoEndpoint object.
	 * @param onAdded Callback that is triggered when another participant adds a camera into a conference.
	 * @param onRemoved Callback that is triggered when another participant removes a camera from a conference.
	 * @param onStateUpdated Callback that is triggered when another participant updates a camera state in a conference.
	 */
	-(BOOL) registerRemoteCameraEventListener:(id<VCEndpointIRegisterRemoteCameraEventListener>)endpointIRegisterRemoteCameraEventListener;
	/*!
	 * Registers to get notified about camera frames from other participants.
	 * @param e The VidyoEndpoint object.
	 * @param remoteCamera The VidyoRemoteCamera for which to receive the frames.
	 * @param onFrame Callback that is triggered for every frame from a remote camera.
	 * @param width Approximate width of the requested frame.
	 * @param height Approximate height of the requested frame.
	 * @param frameInterval Approximate frame interval of the requested frame.
	 */
	-(BOOL) registerRemoteCameraFrameListener:(VCRemoteCamera*)remoteCamera EndpointIRegisterRemoteCameraFrameListener:(id<VCEndpointIRegisterRemoteCameraFrameListener>)endpointIRegisterRemoteCameraFrameListener Width:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval;
	/*!
	 * Registers to get notified about microphone energies from other participants.
	 * @param e The VidyoEndpoint object.
	 * @param onEnergy Callback that is triggered for every frame with energy from a remote microphone.
	 */
	-(BOOL) registerRemoteMicrophoneEnergyListener:(id<VCEndpointIRegisterRemoteMicrophoneEnergyListener>)endpointIRegisterRemoteMicrophoneEnergyListener;
	/*!
	 * Registers to get notified about microphone events from other participants.
	 * @param e The VidyoEndpoint object.
	 * @param onAdded Callback that is triggered when another participant adds a microphone into a conference.
	 * @param onRemoved Callback that is triggered when another participant removes a microphone from a conference.
	 * @param onStateUpdated Callback that is triggered when another participant updates a microphone state in a conference.
	 */
	-(BOOL) registerRemoteMicrophoneEventListener:(id<VCEndpointIRegisterRemoteMicrophoneEventListener>)endpointIRegisterRemoteMicrophoneEventListener;
	/*!
	 * Registers to get notified about microphone frames from other participants.
	 * @param e The VidyoEndpoint object.
	 * @param remoteMicrophone The VidyoRemoteMicrophone for which to receive the frames.
	 * @param onFrame Callback that is triggered for every frame from a remote microphone.
	 */
	-(BOOL) registerRemoteMicrophoneFrameListener:(VCRemoteMicrophone*)remoteMicrophone EndpointIRegisterRemoteMicrophoneFrameListener:(id<VCEndpointIRegisterRemoteMicrophoneFrameListener>)endpointIRegisterRemoteMicrophoneFrameListener;
	/*!
	 * Registers to get notified about renderer events.
	 * @param e The VidyoEndpoint object.
	 * @param onAdded .
	 */
	-(BOOL) registerRemoteRendererEventListener:(id<VCEndpointIRegisterRemoteRendererEventListener>)endpointIRegisterRemoteRendererEventListener;
	/*!
	 * Registers to get notified about speaker events.
	 * @param e The VidyoEndpoint object.
	 * @param onAdded Callback that is triggered for every new or existing window added.
	 * @param onRemoved Callback that is triggered when the window is removed.
	 */
	-(BOOL) registerRemoteSpeakerEventListener:(id<VCEndpointIRegisterRemoteSpeakerEventListener>)endpointIRegisterRemoteSpeakerEventListener;
	/*!
	 * Registers to get notified about window-shares from other participants.
	 * @param e The VidyoEndpoint object.
	 * @param onAdded Callback that is triggered when another participant adds a window-share into a conference.
	 * @param onRemoved Callback that is triggered when another participant removes a window-share from a conference.
	 * @param onStateUpdated Callback that is triggered when another participant updates a window-share state in a conference.
	 */
	-(BOOL) registerRemoteWindowShareEventListener:(id<VCEndpointIRegisterRemoteWindowShareEventListener>)endpointIRegisterRemoteWindowShareEventListener;
	/*!
	 * Registers to get notified about window-share frames from other participants.
	 * @param e The VidyoEndpoint object.
	 * @param remoteWindowShare The VidyoRemoteWindowShare for which to receive the frames.
	 * @param onFrame Callback that is triggered for every frame from a remote window share.
	 * @param width Approximate width of the requested frame.
	 * @param height Approximate height of the requested frame.
	 * @param frameInterval Approximate frame interval of the requested frame.
	 */
	-(BOOL) registerRemoteWindowShareFrameListener:(VCRemoteWindowShare*)remoteWindowShare EndpointIRegisterRemoteWindowShareFrameListener:(id<VCEndpointIRegisterRemoteWindowShareFrameListener>)endpointIRegisterRemoteWindowShareFrameListener Width:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval;
	/*!
	 * Registers to get notified about virtual audio source events. This is a synchronous interface.
	 * @param e The VidyoEndpoint object.
	 * @param onAdded Callback that is triggered each time when virtual audio source is created.
	 * @param onRemoved Callback that is triggered each time when virtual audio source is removed.
	 * @param onStateUpdated Callback that is triggered each time when virtual audio source chagnes state.
	 * @param onSelected Callback that is triggered each time when virtual audio source is selected.
	 * @param onExternalMediaBufferReleased Callback that is triggered each time when VidyoClient is done with an application allocated buffer that holds raw audio frame data.
	 */
	-(BOOL) registerVirtualAudioSourceEventListener:(id<VCEndpointIRegisterVirtualAudioSourceEventListener>)endpointIRegisterVirtualAudioSourceEventListener;
	/*!
	 * Registers to get notified about virtual video source events. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param onAdded Callback that is triggered for every new virtual video source added.
	 * @param onRemoved Callback that is triggered when the virtual video source is removed.
	 * @param onStateUpdated Callback that is triggered when a virtual video source state changes.
	 * @param onExternalMediaBufferReleased Callback that is triggered each time when VidyoClient is done with an application allocated buffer that holds raw video frame.
	 */
	-(BOOL) registerVirtualVideoSourceEventListener:(id<VCEndpointIRegisterVirtualVideoSourceEventListener>)endpointIRegisterVirtualVideoSourceEventListener;
	/*!
	 * Removes audio device from whitelist.
	 * @param e The VidyoEndpoint object.
	 * @param deviceName The name of audio device that will be removed from whitelist.
	 */
	-(BOOL) removeAudioDeviceFromWhitelist:(NSString*)deviceName;
	/*!
	 */
	-(void) removeRenderer:(VCLocalRenderer*)localRenderer;
	/*!
	 * Request to resume sending video after sever paused video stream from selected local camera. Will resume both local and remote streams and show preview in case it is on. Allowed only in case of soft mute. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) requestToResumeVideo;
	/*!
	 * Request to speak after sever paused audio stream from selected local microphone. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) requestToSpeak;
	/*!
	 * Requests video for remote camera before assign.
	 * @param e The VidyoEndpoint object.
	 * @param remoteCamera The VidyoRemoteCamera for which to receive the video.
	 * @param width Approximate width of the requested video.
	 * @param height Approximate height of the requested video.
	 * @param frameInterval Approximate frame interval of the requested video.
	 * @param onFirstFrameReceived Callback that is triggered when first frame from a remote camera received.
	 */
	-(BOOL) requestVideoForRemoteCamera:(VCRemoteCamera*)remoteCamera Width:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval EndpointIRequestVideoForRemoteCamera:(id<VCEndpointIRequestVideoForRemoteCamera>)endpointIRequestVideoForRemoteCamera;
	/*!
	 * Requests video for remote window share before assign.
	 * @param e The VidyoEndpoint object.
	 * @param remoteWindowShare The VidyoRemoteWindowShare for which to receive the video.
	 * @param width Approximate width of the requested video.
	 * @param height Approximate height of the requested video.
	 * @param frameInterval Approximate frame interval of the requested video.
	 * @param onFirstFrameReceived Callback that is triggered when first frame from a remote window share received.
	 */
	-(BOOL) requestVideoForRemoteWindowShare:(VCRemoteWindowShare*)remoteWindowShare Width:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval EndpointIRequestVideoForRemoteWindowShare:(id<VCEndpointIRequestVideoForRemoteWindowShare>)endpointIRequestVideoForRemoteWindowShare;
	/*!
	 * Selects the microphone to be used for audio content share. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param localMicrophone Microphone to be selected for audio content share.
	 */
	-(BOOL) selectAudioContentShare:(VCLocalMicrophone*)localMicrophone;
	/*!
	 * Resets the camera selection to pick the Default camera. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) selectDefaultCamera;
	/*!
	 * Resets the microphone selection to pick the Default microphone. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) selectDefaultMicrophone;
	/*!
	 * Selects the default ANY network interface to be used for Media.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) selectDefaultNetworkInterfaceForMedia;
	/*!
	 * Selects the default ANY network interface to be used for Signaling.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) selectDefaultNetworkInterfaceForSignaling;
	/*!
	 * Resets the speaker selection to pick the Default speaker. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) selectDefaultSpeaker;
	/*!
	 * Selects the camera to be used. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param localCamera Camera to be selected.
	 */
	-(BOOL) selectLocalCamera:(VCLocalCamera*)localCamera;
	/*!
	 * Selects the microphone to be used. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param localMicrophone Microphone to be selected.
	 */
	-(BOOL) selectLocalMicrophone:(VCLocalMicrophone*)localMicrophone;
	/*!
	 * Selects the monitor to be used. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param localMonitor Monitor to be selected.
	 */
	-(BOOL) selectLocalMonitor:(VCLocalMonitor*)localMonitor;
	/*!
	 * Selects the local monitor to share in a conference. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param localMonitor Monitor to be selected.
	 * @param options A structure that represent the sharing options.
	 */
	-(BOOL) selectLocalMonitorAdvanced:(VCLocalMonitor*)localMonitor Options:(VCEndpointShareOptions*)options;
	/*!
	 * Selects the speaker to be used. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param localSpeaker Speaker to be selected.
	 */
	-(BOOL) selectLocalSpeaker:(VCLocalSpeaker*)localSpeaker;
	/*!
	 * Selects the window to be used. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param localWindowShare Window to be selected.
	 */
	-(BOOL) selectLocalWindowShare:(VCLocalWindowShare*)localWindowShare;
	/*!
	 * Selects the local window to share in a conference. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param localWindowShare Window to be selected.
	 * @param options A structure that represent the sharing options.
	 */
	-(BOOL) selectLocalWindowShareAdvanced:(VCLocalWindowShare*)localWindowShare Options:(VCEndpointShareOptions*)options;
	/*!
	 * Selects the network interface to be used for Media.
	 * @param e The VidyoEndpoint object.
	 * @param networkInterface Network interface to be selected.
	 */
	-(BOOL) selectNetworkInterfaceForMedia:(VCNetworkInterface*)networkInterface;
	/*!
	 * Selects the network interface to be used for Signaling.
	 * @param e The VidyoEndpoint object.
	 * @param networkInterface Network interface to be selected.
	 */
	-(BOOL) selectNetworkInterfaceForSignaling:(VCNetworkInterface*)networkInterface;
	/*!
	 * Selects the camera to be used for video content share. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param localCamera Camera to be selected for video content share.
	 */
	-(BOOL) selectVideoContentShare:(VCLocalCamera*)localCamera;
	/*!
	 * Selects the virtual audio source which will be used for content share. The selected microphone which currently using for content share will be unselected. This is a synchronous interface. The VidyoEndpointOnVirtualAudioSourceStateUpdated will trigger.
	 * @param e The VidyoEndpoint object.
	 * @param virtualAudioSource The virtual audio source that will be used for content share.
	 */
	-(BOOL) selectVirtualAudioContentShare:(VCVirtualAudioSource*)virtualAudioSource;
	/*!
	 * Selects the virtual video source that will be shown to remote participants. The real camera will be unselected if it's selected. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param virtualCamera The virtual video source that will be shown to remote participants.
	 */
	-(BOOL) selectVirtualCamera:(VCVirtualVideoSource*)virtualCamera;
	/*!
	 * Selects the virtual audio source which will be used as microphone. The real miicrophone will be unselected if it's selected. This is a synchronous interface. The VidyoEndpointOnVirtualAudioSourceStateUpdated will trigger.
	 * @param e The VidyoEndpoint object.
	 * @param virtualAudioSource The virtual audio source that will be used as microphone.
	 */
	-(BOOL) selectVirtualMicrophone:(VCVirtualAudioSource*)virtualAudioSource;
	/*!
	 * Selects the virtual renderer to receive all events required for rendering. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param renderer The virtual renderer object to select, NULL to unselect.
	 */
	-(BOOL) selectVirtualRenderer:(VCVirtualRenderer*)renderer;
	/*!
	 * Selects the virtual video source which is window share that will be shown to remote participants. The local window share will be unselected if it's selected. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param virtualWindowShare The virtual video source that will be shown to remote participants.
	 */
	-(BOOL) selectVirtualSourceWindowShare:(VCVirtualVideoSource*)virtualWindowShare;
	/*!
	 * Sends already constructed audio frame to selected virtual audio source and then send it to local and/or remote streams. This is a synchronous interface.
	 * @param e The VidyoEndpoint object.
	 * @param virtualAudioSource The virtual audio source.
	 * @param audioFrame The audio frame to be sent.
	 */
	-(BOOL) sendVirtualAudioSourceFrame:(VCVirtualAudioSource*)virtualAudioSource AudioFrame:(VCAudioFrame*)audioFrame;
	/*!
	 * Pass raw buffer to selected virtual audio source, based on which the audio frame will be constructed and then send it to local and/or remote streams. This is an asynchronous interface. The VidyoEndpointOnVirtualAudioSourceExternalMediaBufferReleased will trigger when buffer is not needed anymore.
	 * @param e The VidyoEndpoint object.
	 * @param virtualAudioSource The virtual audio source.
	 * @param buffer The buffer with audio data to be sent.
	 * @param nbSamples The number of sample frames that will be represented in the audio data.
	 * @param elapsedTime The elapsed time.
	 */
	-(BOOL) sendVirtualAudioSourceFrameWithExternalData:(VCVirtualAudioSource*)virtualAudioSource Buffer:(unsigned char*)buffer NbSamples:(size_t)nbSamples ElapsedTime:(long)elapsedTime;
	/*!
	 * @param e The endpoint object.
	 * @param options The experimental optons in JSON format.
	 */
	-(BOOL) setAdvancedOptions:(const char*)options;
	/*!
	 */
	-(BOOL) setApplicationTag:(const char*)applicationTag;
	/*!
	 * Sets multiplier value to be used when calculating the audio bitrate. Default is 2.
	 * @param e The endpoint object.
	 * @param bitrateMultiplier Bitrate multiplier for which possible values are 0, 1 and 2.
	 */
	-(BOOL) setAudioBitrateMultiplier:(unsigned int)bitrateMultiplier;
	/*!
	 * Enables or disables usage of audio devices (speaker and microphone) in different audio modes. By default SharedModeBoth is enabled.
	 * @param e The endpoint object.
	 * @param audioMode Indicates which audio mode is enabled/disabled for both audio devices. For possible values of the audio mode, refer VidyoEndpointAudioMode.
	 */
	-(BOOL) setAudioMode:(VCEndpointAudioMode)audioMode;
	/*!
	 * Sets time interval between two packet of audio in miliseconds. Default is 40 ms.
	 * @param e The endpoint object.
	 * @param packetInterval Packet interval for which possible values are 20, and 40 ms.
	 */
	-(BOOL) setAudioPacketInterval:(unsigned int)packetInterval;
	/*!
	 * Sets value that is used to configure encoder. If given higher value then encoder is configured to resistant to loss on the expense of quality. Default is 10%.
	 * @param e The endpoint object.
	 * @param lossPercentage Loss percantage for which possible values are [0, 10, 20, 30] in percentage.
	 */
	-(BOOL) setAudioPacketLossPercentage:(unsigned int)lossPercentage;
	/*!
	 * Enables or disables auto-reconnect.
	 * @param e The endpoint object.
	 * @param enable Indicates whether auto-reconnect is enabled or not.
	 */
	-(BOOL) setAutoReconnect:(BOOL)enable;
	/*!
	 * Sets back off for next reconnect attempt. By default, it is set to 5 seconds.
	 * @param e The endpoint object.
	 * @param backOff Time in seconds before next reconnect attempt. Min value is 2 and the max is 20 seconds.
	 */
	-(BOOL) setAutoReconnectAttemptBackOff:(unsigned int)backOff;
	/*!
	 * Sets maximum attempts to be done for reconnecting. By default, it is set to 3.
	 * @param e The endpoint object.
	 * @param maxAttempts Number of maximum attempts to be done for reconnecting. Min value is 1 and the max is 4.
	 */
	-(BOOL) setAutoReconnectMaxAttempts:(unsigned int)maxAttempts;
	/*!
	 * Sets the intensity of the background blur effect. It is allowed to change blur intensity while the effect is enabled. This functionality is supported only for macOS 10.14 and above, iOS 10.0 and above and Windows VC++ 15 and above.
	 * @param e The VidyoEndpoint object.
	 * @param intensity The intensity of the background blur effect. Valid valies is [3-8]. Default value is 5.
	 */
	-(BOOL) setBlurIntensity:(unsigned int)intensity;
	/*!
	 * Enables the specified by VidyoEndpointCameraEffectType camera background effect or disables active effect if VIDYO_ENDPOINTCAMERAEFFECTTYPE_None passed. The application must provide token to enable this feature as part of VidyoConnectorCameraEffectInfo structure. This functionality is supported only for macOS 10.14 and above, iOS 10.0 and above and Windows VC++ 15 and above.
	 * @param e The VidyoEndpoint object.
	 * @param effectInfo Represents the configuration of camera background effect.
	 */
	-(BOOL) setCameraBackgroundEffect:(VCEndpointCameraEffectInfo*)effectInfo;
	/*!
	 * Sets camera PTZ nudge configuration.
	 * @param e The endpoint object.
	 * @param cameraNudgeConfig Camera PTZ nudge configuration in JSON format.
	 */
	-(BOOL) setCameraNudgeConfiguration:(const char*)cameraNudgeConfig;
	/*!
	 * Sets the flag to show/hide the local camera for remote participants for composite/custom layout and local camera preview for composite layout only. Will also unmute a soft mute(Hunter only). On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param privacy Flag to show/hide the camera.
	 */
	-(BOOL) setCameraPrivacy:(BOOL)privacy;
	/*!
	 * Sets conference number - a special identifier that will show up in the Portal CDR record for the conference. Should be set before joining the conference.
	 * @param e The endpoint object.
	 * @param conferenceNumber Conference number to be set.
	 */
	-(void) setConferenceNumber:(NSString*)conferenceNumber;
	/*!
	 */
	-(BOOL) setConsoleLoggerFilter:(const char*)consoleLogFilter;
	/*!
	 */
	-(BOOL) setConsoleLoggerLevelAndCategory:(const char*)levelName CategoryName:(const char*)categoryName On:(BOOL)on;
	/*!
	 */
	-(BOOL) setConsoleLoggerUTC:(BOOL)utc;
	/*!
	 * Set CPU profile for the endpoint.
	 * @param e The endpoint object.
	 * @param profile The CPU tradeoff profile.
	 */
	-(BOOL) setCpuTradeOffProfile:(VCEndpointTradeOffProfile)profile;
	/*!
	 * @param e The VidyoEndpoint object.
	 * @param debugLogFilter Log filter to use on the debug port.
	 */
	-(BOOL) setDebugFilter:(const char*)debugLogFilter;
	/*!
	 * When enabled, all video feeds (video and content share) will be shut off to the client when the user experiences prolonged low network bandwidth.
	 * @param e The endpoint object.
	 * @param enable Indicates whether disable video on low bandwidth is enabled or not.
	 */
	-(BOOL) setDisableVideoOnLowBandwidth:(BOOL)enable;
	/*!
	 * Sets number of audio streams requested while video is shut off. By default, it is set to 3.
	 * @param e The endpoint object.
	 * @param audioStreams Number of audio streams requested while video is shut off. Min value is 1 and max is 3.
	 */
	-(BOOL) setDisableVideoOnLowBandwidthAudioStreams:(unsigned int)audioStreams;
	/*!
	 * Sets time it takes to recover when video is shut off. By default, it is set to 0 seconds which means never.
	 * @param e The endpoint object.
	 * @param recoveryTime Time it takes to recover when video is shut off. Recovery can only happen when there are no available video sources.
	 */
	-(BOOL) setDisableVideoOnLowBandwidthRecoveryTime:(unsigned int)recoveryTime;
	/*!
	 * Sets time it takes to shut off video due to low bandwidth. By default, it is set to 30 seconds.
	 * @param e The endpoint object.
	 * @param responseTime Time it takes to shut off video due to low bandwidth.
	 */
	-(BOOL) setDisableVideoOnLowBandwidthResponseTime:(unsigned int)responseTime;
	/*!
	 * Sets how often to check for low bandwidth. By default, it is set to 5 seconds.
	 * @param e The endpoint object.
	 * @param sampleTime How often to check for low bandwidth. Must divide evenly into responseTime.
	 */
	-(BOOL) setDisableVideoOnLowBandwidthSampleTime:(unsigned int)sampleTime;
	/*!
	 * Sets low bandwidth threshold. By default, it is set to 100kpbs.
	 * @param e The endpoint object.
	 * @param kbps Threshold for low bandwidth in kilobits/sec.
	 */
	-(BOOL) setDisableVideoOnLowBandwidthThreshold:(unsigned int)kbps;
	/*!
	 */
	-(BOOL) setFileLoggerFilter:(const char*)logFileFilter;
	/*!
	 */
	-(BOOL) setFileLoggerLevelAndCategory:(const char*)levelName CategoryName:(const char*)categoryName On:(BOOL)on;
	/*!
	 * Sets log file size limit, how often to initiate the wrap and number of log files.
	 * @param e The endpoint object.
	 * @param maxSize The number of bytes of logged messages to save.
	 * @param wrapPeriod How often to initiate the wrap in nanoseconds. If this value is LMI_TIME_INFINITE, the log file will not be wrapped based on time.
	 * @param wrapCount The maximum number of files to keep.
	 */
	-(BOOL) setFileLoggerRotationParameters:(size_t)maxSize WrapPeriod:(long)wrapPeriod WrapCount:(size_t)wrapCount;
	/*!
	 */
	-(BOOL) setFileLoggerUTC:(BOOL)utc;
	/*!
	 * Set font file name. On, iOS, this API must be called from main(UI) thread.
	 * @param fontFileName Pointer to char array that contains font file name.
	 */
	-(BOOL) setFontFileName:(const char*)fontFileName;
	/*!
	 * Set the license key of the endpoint.
	 * @param e The endpoint object.
	 * @param licenseKey The lincense key for the endpoint
	 */
	-(BOOL) setLicenseKey:(NSMutableString*)licenseKey;
	/*!
	 */
	-(BOOL) setLocation:(double)latitude Longitude:(double)longitude;
	/*!
	 * Sets new path to log file.
	 * @param e The endpoint object.
	 * @param filename The name of the file to log to. Note: Can be passed just filename or with full path so that location will be changed.
	 */
	-(BOOL) setLogFilePath:(const char*)filename;
	/*!
	 * Request server to limit bit rate sent to this client.
	 * @param e The endpoint object.
	 * @param bitRate The maximum receiving bit rate request sent to server, in bps.
	 */
	-(void) setMaxReceiveBitRate:(unsigned int)bitRate;
	/*!
	 * Sets the max send bit rate for all sources.
	 * @param e The endpoint object.
	 * @param bitRate The max send bit rate for all sources, in bps.
	 */
	-(void) setMaxSendBitRate:(unsigned int)bitRate;
	/*!
	 * Sets max boost level that will be applied only in the conference for the selected microphone in case the system is set to the higher value.
	 * @param e The endpoint object.
	 * @param boostLevel Boost level for which possible values are devices specific, e.g. 0 - 20 dB. Default is 12 dB.
	 */
	-(void) setMicrophoneMaxBoostLevel:(double)boostLevel;
	/*!
	 * Sets the flag to mute/unmute the microphone. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param privacy Flag to mute/unmute the microphone.
	 */
	-(BOOL) setMicrophonePrivacy:(BOOL)privacy;
	/*!
	 * Sets min volume that will be applied only in the conference for the selected microphone in case the system is set to the lower value.
	 * @param e The endpoint object.
	 * @param volumePercent Volume percent for which possible values are 0 - 100 percentage. Default is 50 percent.
	 */
	-(void) setMinMicrophoneVolume:(unsigned int)volumePercent;
	/*!
	 * Sets the operating mode of the VidyoEndpoint. This API have to be called before renderer is destructed: i.e. VidyoEndpointHideView will be called in case VIDYO_ENDPOINTMODE_Background and after renderer is constructed: i.e. VidyoEndpointAssignViewToCompositeRenderer, VidyoEndpointAssignViewToLocalCamera, VidyoEndpointAssignViewToRemoteCamera will be called in case VIDYO_ENDPOINTMODE_Foreground. This API is required only when user in the conference. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param mode Desired operating mode.
	 */
	-(BOOL) setMode:(VCEndpointMode)mode;
	/*!
	 * @param e The endpoint object.
	 * @param options The options in JSON format. <p>conferenceReferenceNumber - a special identifier that will show up in the Portal CDR record for the conference. Should be set before joining the conference.</p> <p>Example: {'conferenceReferenceNumber' : 'reference number'}.</p> <p>microphoneMaxBoostLevel - sets max boost level that will be applied only in the conference for the selected microphone in case the system is set to the higher value. Possible values are devices specific, e.g. 0 - 20 dB. Default is 12 dB.</p> <p>Example: {'microphoneMaxBoostLevel' : 10}.</p> <p>minMicrophoneVolume - sets min volume that will be applied only in the conference for the selected microphone in case the system is set to the lower value. Possible values are 0 - 100 percentage. Default is 50 per cent.</p> <p>Example: {'minMicrophoneVolume' : 70}.</p> <p>Possible values for audio device modes are audioSharedModeBoth - use both audio devices (Speaker and Microphone) in shared mode. audioExclusiveModeBoth - use both audio devices (Speaker and Microphone) in exclusive mode. audioExclusiveModeMic - use microphone in exclusive mode and speaker in shared mode. By default VidyoClient is working with audioSharedModeBoth. A new mode will be applied only for the next conference or in case another device is selected.</p> <p>Example: {'audioSharedModeBoth' : true}.</p> <p>Example: {'audioExclusiveModeBoth' : true}.</p> <p>Example: {'audioExclusiveModeMic' : true}.</p> <p>preferredAudioCodec - sets VidyoClient to use preferred audio codec. Possible value are OPUS RED, OPUS and SPEEX RED. Default is OPUS RED.</p> <p>Example: {'preferredAudioCodec' : 'SPEEX RED'}.</p> <p>AudioBitrateMultiplier - A multiplier to be used when calculating the audio bitrate. Possible values are 0,1, and 2. Default is 2.</p> <p>Example: {'AudioBitrateMultiplier':1}.</p> <p>AudioPacketInterval - It decies audio frame duration to encoder. It sets time interval between two packet of audio in miliseconds Possible values are 20, and 40 ms. Default is 40 ms.</p> <p>Example: {'AudioPacketInterval':40}.</p> <p>AudioPacketLossPercentage - it values is used to configure encoder. If given higher value then encoder is configured to resistant to loss on the expense of quality. Possible values are [0, 10, 20, 30] in percentage. Default is 10%.</p> <p>Example: {'AudioPacketLossPercentage':20}.</p> <p>statRate - sets VidyoRoom statistics gather interval in seconds. Possible values are 2, 5, 10, 20 and 30. Default is 10.</p> <p>Example: {'statRate':10}.</p> <p>enableStaticShareSvc - Specifies whether SVC will be enabled or disabled for static sharing. Possible values are true or false. The default is false. Note: SVC is enabled by default for interactive video and high frame rate sharing.</p> <p>Example: {'enableStaticShareSvc' : true}.</p>
	 */
	-(BOOL) setOptions:(const char*)options;
	/*!
	 */
	-(BOOL) setPool:(NSString*)name;
	/*!
	 * Set the product information of the endpoint.
	 * @param e The endpoint object.
	 * @param productInfo The product info of the endpoint
	 * @param supportedFeature The features this endpoint can support
	 */
	-(BOOL) setProductInfo:(NSMutableArray*)productInfo SupportedFeature:(NSMutableArray*)supportedFeature;
	/*!
	 * Tell the library to send the raw chat messages to the application.
	 * @param e The VidyoEndpoint object.
	 * @param receiveRawMessage Set it to LMI_TRUE to receive raw message with header, LMI_FALSE to reseive only the message body.
	 */
	-(BOOL) setReceiveRawMessage:(BOOL)receiveRawMessage;
	/*!
	 * Sets up the local renderer and conference tiles displaying options.
	 * @param e The VidyoEndpoint object.
	 * @param viewId A platform-specific view ID.
	 * @param options A char array that contains options in the JSON format. <p>EnableVerticalVideoCentering - Enable or disable the vertical centering of the video screen. Default is true.</p> <p>Example: {'EnableVerticalVideoCentering':true}.</p> <p>EnableFECCIconCustomLayout - Enable or disable the displaying of custom FECC icon in the right bottom corner. Default is false.</p> <p>Example: {'EnableFECCIconCustomLayout':false}.</p> <p>ViewingDistance - Sets viewing distance in feet. Default is 2.5f. Minimum and Maximum values are 1f & 15f respectively.</p> <p>Example: {'ViewingDistance':2.5}.</p> <p>ShowAudioTiles - Enable or disable the showing of audio tiles. Default is true.</p> <p>Example: {'ShowAudioTiles':false}.</p> <p>SetPipPosition - Sets the position of the preview when it is displayed using picture-in-picture mode. Possible values for x: "PipPositionLeft", "PipPositionCenter", "PipPositionRight". Possible values for y: "PipPositionBottom", "PipPositionCenter", "PipPositionTop". lockPip is a boolean indicating whether to lock the preview in this position (by default is false). When false, the user may drag the preview to another location using the mouse or a touch. setPipSize - Sets the size of the preview in picture-in-picture mode. The value is a positive integer representing the percentage of the screen size (1 to 50) default is 1. setPipToTileAfterNTiles - Sets the number of tiles after which the preview will be displayed as a tile instead of picture-in-picture (default value is 2). A value of 0 means the preview will always be visible in picture-in-picture mode whereas N means that the preview will be visible as tile if the number of tiles is greater than N (where N is a positive integer).</p> <p>Example: {'SetPipPosition':{'x':'PipPositionRight', 'y': 'PipPositionTop', 'lockPip':true, 'setPipSize':1, 'setPipToTileAfterNTiles':2}}.</p> <p>SetPixelDensity - Sets the rendering environment's pixel density.</p> <p>Example: {'SetPixelDensity':326.0f. However for latest rendering environment, being released for iOS only, this option is used to choose surface density with possible values as 0.5 (everything will be smaller) / 1.0 (default) / 2.0 (everything will be larger).}</p> <p>SetTouchAsInputDevice - Enable or disable touch as a input device. Default is false.</p> <p>Example: {'SetTouchAsInputDevice':false}.</p> <p>EnableExpandedCameraControl - Enable or disable expanded camera control. Default is true for mobile devices and false for non-mobile devices.</p> <p>Example: {'EnableExpandedCameraControl':false}.</p> <p>BorderStyle - Sets the border style of the preview. None: Do not put a border on any tiles. Same: Put the same colored border on each tile. Highlight: Put a border on each tile, but tiles associated with the highest ranked participant will have a different colored border than the others. Flash: Tiles associated with the highest ranked participant have a different colored border than the others. When the highest ranked participant changes, the border of the new highest ranked participant flashes momentarily. Possible values for BorderStyle: "None", "Same", "Highlight", "Flash"</p> <p>Example: {'BorderStyle':'Same'</p>} <p>enablePreviewMirroring - Specifies whether mirroring will be enabled or disabled for local cameras. Possible values are true or false. The default is true.</p> <p>Example: {'EnablePreviewMirroring' : true}.</p>
	 */
	-(BOOL) setRendererOptionsForViewId:(void*)viewId Options:(const char*)options;
	/*!
	 * Sets the flag to mute/unmute the speaker. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param privacy Flag to mute/unmute the speaker.
	 */
	-(BOOL) setSpeakerPrivacy:(BOOL)privacy;
	/*!
	 * Enables or disables SVC. The default is false. Note: SVC is enabled by default for interactive video and high frame rate sharing.
	 * @param e The endpoint object.
	 * @param enable Indicates whether enable SVC or not.
	 */
	-(BOOL) setStaticShareSvcState:(BOOL)enable;
	/*!
	 * Sets conference room statistics gather interval in seconds. Default is 10.
	 * @param e The endpoint object.
	 * @param statRate Statistics gather interval for which possible values are 2, 5, 10, 20 and 30.
	 */
	-(BOOL) setStatisticRate:(long long)statRate;
	/*!
	 * Set TURN server and credentials information.
	 * @param e The endpoint object.
	 * @param turnAddress TURN server FQDN or IP address.
	 * @param port TURN server port.
	 * @param username TURN server user name.
	 * @param password TURN server password.
	 * @param baseTransport Base transport type.
	 */
	-(BOOL) setTURNAddressCredentials:(const char*)turnAddress Port:(unsigned int)port Username:(const char*)username Password:(const char*)password BaseTransport:(VCEndpointBaseTransportType)baseTransport;
	/*!
	 * Set TURN server certificate requirement.
	 * @param e The endpoint object.
	 * @param required LMI_TRUE if TURN server certificate is required.
	 */
	-(BOOL) setTURNServerCertificateRequired:(BOOL)required;
	/*!
	 * Sets the speed of transition animaiton for windows moving around inside the view. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param viewId A platform specific view ID to be positioned.
	 * @param speedPercentage Percentage of animation speed with default of 50, 100 for slowest and 0 for instant.
	 */
	-(BOOL) setViewAnimationSpeed:(void*)viewId SpeedPercentage:(unsigned int)speedPercentage;
	/*!
	 * Shows or hides the label on the view which displays the participant name or preview. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param viewId A platform specific view ID to be positioned.
	 * @param red Red component of the color 0-255.
	 * @param green Green component of the color 0-255.
	 * @param blue Blue component of the color 0-255.
	 */
	-(BOOL) setViewBackgroundColor:(void*)viewId Red:(unsigned char)red Green:(unsigned char)green Blue:(unsigned char)blue;
	/*!
	 * Sets path and file name to the picture that will be used for the virtual background effect. It is allowed to change picture while the effect is enabled. This functionality is supported only for macOS 10.14 and above, iOS 10.0 and above and Windows VC++ 15 and above.
	 * @param e The VidyoEndpoint object.
	 * @param pathToPicture Path and file name to the picture. Currently, only PNG and JPG is supported..
	 */
	-(BOOL) setVirtualBackgroundPicture:(NSString*)pathToPicture;
	/*!
	 * Shows or hides the audio meters in the view. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param viewId A platform specific view ID to be positioned.
	 * @param showMeters Boolean to show or hide the audio meters.
	 */
	-(BOOL) showAudioMeters:(void*)viewId ShowMeters:(BOOL)showMeters;
	/*!
	 * Sets the flag to show/hide the camera preview for composite layout only. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param preview Flag to show/hide the camera preview.
	 */
	-(BOOL) showPreview:(BOOL)preview;
	/*!
	 * Sets the position of the view every time it's changed on the screen. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param viewId A platform specific view ID to be positioned.
	 * @param x X coordinate.
	 * @param y Y coordinate.
	 * @param width Width of the view.
	 * @param height Height of the view.
	 */
	-(BOOL) showViewAt:(void*)viewId X:(int)x Y:(int)y Width:(unsigned int)width Height:(unsigned int)height;
	/*!
	 * Sets the position of the view every time it's changed on the screen. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param viewId A platform specific view ID to be positioned.
	 * @param x X coordinate (in points).
	 * @param y Y coordinate (in points).
	 * @param width Width of the view (in points).
	 * @param height Height of the view (in points).
	 */
	-(BOOL) showViewAtPoints:(void*)viewId X:(int)x Y:(int)y Width:(unsigned int)width Height:(unsigned int)height;
	/*!
	 * Shows or hides the label on the view which displays the participant name or preview. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param viewId A platform specific view ID to be positioned.
	 * @param showLabel Boolean to show or hide the label.
	 */
	-(BOOL) showViewLabel:(void*)viewId ShowLabel:(BOOL)showLabel;
	/*!
	 * Sets the flag to show/hide the window share preview. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param preview Flag to show/hide the window share preview.
	 */
	-(BOOL) showWindowSharePreview:(BOOL)preview;
	/*!
	 * Start sending of analytics in VidyoEndpoint.
	 * @param e The VidyoEndpoint object.
	 * @param options A structure that represent the google analytics options, plz refer VidyoEndpointGoogleAnalyticsOptions. If the user set to NULL, Vidyo Client will use default option to use google analytics.
	 */
	-(BOOL) startGoogleAnalyticsService:(VCEndpointGoogleAnalyticsOptions*)options;
	/*!
	 * Start sending of Insights in VidyoEndpoint.
	 * @param e The VidyoEndpoint object.
	 * @param serverUrl Url of Insights server.
	 */
	-(BOOL) startInsightsService:(NSString*)serverUrl;
	/*!
	 * On, iOS, this API must be called from main(UI) thread.
	 */
	-(BOOL) startLocalCameraDetection;
	/*!
	 * On, iOS, this API must be called from main(UI) thread.
	 */
	-(BOOL) startLocalMicrophoneDetection;
	/*!
	 * On, iOS, this API must be called from main(UI) thread.
	 */
	-(BOOL) startLocalMonitorDetection;
	/*!
	 * On, iOS, this API must be called from main(UI) thread.
	 */
	-(BOOL) startLocalSpeakerDetection;
	/*!
	 * On, iOS, this API must be called from main(UI) thread.
	 */
	-(BOOL) startLocalWindowShareDetection;
	/*!
	 */
	-(BOOL) startLocationDetection;
	/*!
	 * Option to stop logging into current file and start logging to the next one.
	 * @param e The endpoint object.
	 */
	-(BOOL) startNextLogFile;
	/*!
	 * Stop sending of Google analytics in VidyoEndpoint.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) stopGoogleAnalyticsService;
	/*!
	 * Stop sending of Insights in VidyoEndpoint.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) stopInsightsService;
	/*!
	 * On, iOS, this API must be called from main(UI) thread.
	 */
	-(void) stopLocalCameraDetection;
	/*!
	 * On, iOS, this API must be called from main(UI) thread.
	 */
	-(void) stopLocalMicrophoneDetection;
	/*!
	 * On, iOS, this API must be called from main(UI) thread.
	 */
	-(void) stopLocalMonitorDetection;
	/*!
	 * On, iOS, this API must be called from main(UI) thread.
	 */
	-(void) stopLocalSpeakerDetection;
	/*!
	 * On, iOS, this API must be called from main(UI) thread.
	 */
	-(void) stopLocalWindowShareDetection;
	/*!
	 */
	-(void) stopLocationDetection;
	/*!
	 * Swap streams of the remote video sources between views.
	 * @param e The VidyoEndpoint object.
	 * @param firstView A platform specific view ID where the first remote video sources is displayed.
	 * @param secondView A platform specific view ID where the second remote video sources is displayed.
	 */
	-(BOOL) swapStreamsBetweenViews:(void*)firstView SecondView:(void*)secondView;
	/*!
	 * Unregisters callback to notify the user in case of any errors occur during enabling camera effect.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) unregisterCameraEffectErrorListener;
	/*!
	 * Unregister callbacks for disable video on low bandwidth.
	 * @param e VidyoEndpoint object.
	 */
	-(void) unregisterDisableVideoOnLowBwEventListener;
	/*!
	 * Unregisters advanced error event notifications.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) unregisterErrorEventListener;
	/*!
	 * Unregisters local camera event notifications. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) unregisterLocalCameraEventListener;
	/*!
	 * Unregisters local camera frame notifications. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param localCamera The VidyoLocalCamera for which to stop notifications.
	 */
	-(BOOL) unregisterLocalCameraFrameListener:(VCLocalCamera*)localCamera;
	/*!
	 * Unregisters local microphone energy notifications.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) unregisterLocalMicrophoneEnergyListener;
	/*!
	 * Unregisters local microphone event notifications. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) unregisterLocalMicrophoneEventListener;
	/*!
	 * Unregisters local microphone frame notifications. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param localMicrophone The VidyoLocalMicrophone for which to stop notifications.
	 */
	-(BOOL) unregisterLocalMicrophoneFrameListener:(VCLocalMicrophone*)localMicrophone;
	/*!
	 * Unregisters local monitor event notifications. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) unregisterLocalMonitorEventListener;
	/*!
	 * Unregisters local monitor frame notifications. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param localMonitor The VidyoLocalMonitor for which to stop notifications.
	 */
	-(BOOL) unregisterLocalMonitorFrameListener:(VCLocalMonitor*)localMonitor;
	/*!
	 * Unregisters local renderer event notifications. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) unregisterLocalRendererEventListener;
	/*!
	 * Unregisters local speaker event notifications. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) unregisterLocalSpeakerEventListener;
	/*!
	 * Unregisters local window share event notifications. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) unregisterLocalWindowShareEventListener;
	/*!
	 * Unregisters local window share frame notifications. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param localWindowShare The VidyoLocalWindowShare for which to stop notifications.
	 */
	-(BOOL) unregisterLocalWindowShareFrameListener:(VCLocalWindowShare*)localWindowShare;
	/*!
	 * Unregisters log event notifications.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) unregisterLogEventListener;
	/*!
	 * This is a synchronous interface. Unregister the callback to stop receiving the final response for the next generation renderer action.
	 * @param e VidyoEndpoint object.
	 */
	-(BOOL) unregisterNGRResultEventListener;
	/*!
	 * Unregisters network interface event notifications.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) unregisterNetworkInterfaceEventListener;
	/*!
	 * Unregisters plugin.
	 * @param e The VidyoEndpoint object.
	 * @param plugin Plugin to unregister.
	 */
	-(BOOL) unregisterPlugin:(long)plugin;
	/*!
	 * Unregisters reconnecting event notifications.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) unregisterReconnectEventListener;
	/*!
	 * Unregisters remote camera event notifications.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) unregisterRemoteCameraEventListener;
	/*!
	 * Unregisters remote camera frame notifications.
	 * @param e The VidyoEndpoint object.
	 * @param remoteCamera The VidyoRemoteCamera for which to stop notifications.
	 */
	-(BOOL) unregisterRemoteCameraFrameListener:(VCRemoteCamera*)remoteCamera;
	/*!
	 * Unregisters remote microphone energy notifications.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) unregisterRemoteMicrophoneEnergyListener;
	/*!
	 * Unregisters remote microphone event notifications.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) unregisterRemoteMicrophoneEventListener;
	/*!
	 * Unregisters remote microphone frame notifications.
	 * @param e The VidyoEndpoint object.
	 * @param remoteMicrophone The VidyoRemoteMicrophone for which to stop notifications.
	 */
	-(BOOL) unregisterRemoteMicrophoneFrameListener:(VCRemoteMicrophone*)remoteMicrophone;
	/*!
	 * Unregisters remote renderer event notifications.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) unregisterRemoteRendererEventListener;
	/*!
	 * Unregisters remote speaker event notifications.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) unregisterRemoteSpeakerEventListener;
	/*!
	 * Unregisters remote window share event notifications.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) unregisterRemoteWindowShareEventListener;
	/*!
	 * Unregisters remote window share frame notifications.
	 * @param e The VidyoEndpoint object.
	 * @param remoteWindowShare The VidyoRemoteWindowShare for which to stop notifications.
	 */
	-(BOOL) unregisterRemoteWindowShareFrameListener:(VCRemoteWindowShare*)remoteWindowShare;
	/*!
	 * Unregisters virtual audio source event notifications. This is a synchronous interface.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) unregisterVirtualAudioSourceEventListener;
	/*!
	 * Unregisters virtual video source event notifications. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 */
	-(BOOL) unregisterVirtualVideoSourceEventListener;
	/*!
	 */
	-(BOOL) validateLicenseKey:(NSString*)licenseKey UserName:(NSString*)userName;
	/*!
	 * Select a specific virtual video source which is a camera and add it to all remote renderers. The real camera will be unselected. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object
	 * @param virtualCamera The VidyoVirtualVideoSource object to select. NULL to unselect the selected virtual camera.
	 */
	-(void) virtualCameraSelectAdvanced:(VCVirtualVideoSource*)virtualCamera;
	/*!
	 * Select a specific virtual video source which is a window share and add it to all remote renderers. The local window share will be unselected. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param virtualWindowShare The VidyoVirtualVideoSource object to select. NULL to unselect the selected virtual window share.
	 */
	-(void) virtualSourceWindowShareSelectAdvanced:(VCVirtualVideoSource*)virtualWindowShare;
	/*!
	 * Unselect a specific virtual video source. On, iOS, this API must be called from main(UI) thread.
	 * @param e The VidyoEndpoint object.
	 * @param virtualVideoSource The VidyoVirtualVideoSource object to unselect.
	 */
	-(void) virtualVideoSourceUnselectAdvanced:(VCVirtualVideoSource*)virtualVideoSource;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
	-(NSMutableDictionary<NSString*, VCRemoteCamera*> *)getRemoteCamerasMap;
	-(NSMutableDictionary<NSString*, VCRemoteMicrophone*> *)getRemoteMicrophonesMap;
	-(NSMutableDictionary<NSString*, VCRemoteWindowShare*> *)getRemoteWindowSharesMap;
	-(NSMutableDictionary<NSString*, id<VCEndpointIRequestVideoForRemoteCamera>> *)getOnRemoteCameraFirstFrameReceivedCallbacksMap;
	-(NSMutableDictionary<NSString*, id<VCEndpointIRequestVideoForRemoteWindowShare>> *)getOnRemoteWindowShareFirstFrameReceivedCallbacksMap;
@end
/*!
 * The event action from event table.
 */
@interface VCEndpointGoogleAnalyticsEventTable : NSObject
{
}
	/*!
	 * An enable flag for action.
	 */
	@property BOOL enable;
	/*!
	 * The event action.
	 */
	@property VCEndpointGoogleAnalyticsEventAction eventAction;
	/*!
	 * The event category.
	 */
	@property VCEndpointGoogleAnalyticsEventCategory eventCategory;
@end
/*!
 * Represent the options for google analytics.
 */
@interface VCEndpointGoogleAnalyticsOptions : NSObject
{
}
	/*!
	 * Represents the measurement is for google analytics service.
	 */
	@property NSMutableString* id;
	/*!
	 * Represents the configured API secret key for google analytics service.
	 */
	@property NSMutableString* key;
@end
/*!
 * Represent the configuration of camera background effect.
 */
@interface VCEndpointCameraEffectInfo : NSObject
{
}
	/*!
	 * Blur intensity. Valid valies is [3-8]. Default value is 5. Used only if effectType VIDYO_CONNECTORCAMERAEFFECTTYPE_Blur
	 */
	@property unsigned int blurIntensity;
	/*!
	 * Type of the camera background effect. In case VIDYO_CONNECTORCAMERAEFFECTTYPE_None is set no need to set other fields.
	 */
	@property VCEndpointCameraEffectType effectType;
	/*!
	 * The path to effect. A directory with supported effect is packaged with VidyoClient library.
	 */
	@property NSMutableString* pathToEffect;
	/*!
	 * The path to resources like a model and its configuration. A directory with supported resources is packaged with VidyoClient library.
	 */
	@property NSMutableString* pathToResources;
	/*!
	 * The token for enabling the camera background effect. The blank string is NOT allowed. In case the token is not valid or expired enabling of camera background effect will fail.
	 */
	@property NSMutableString* token;
	/*!
	 * The path to the picture that will be used for the virtual background. Used only if effectType VIDYO_CONNECTORCAMERAEFFECTTYPE_VirtualBackground.
	 */
	@property NSMutableString* virtualBackgroundPicture;
@end
/*!
 * Represent the options for sharing.
 */
@interface VCEndpointShareOptions : NSObject
{
}
	/*!
	 * A variable that indicates whether the sharing will be with or without audio.
	 */
	@property BOOL enableAudio;
	/*!
	 * A variable that indicates whether the sharing will be with or without high framerate share.
	 */
	@property BOOL enableHighFramerate;
@end
@interface VCLoggerCategory : NSObject
{
}
	@property const char* categoryDescr;
	@property NSMutableArray* levels;
	@property const char* name;
@end
@protocol VCRoomIAcceptIncoming
	/*!
	 * Callback that is triggered when entering the VidyoRoom as a result of VidyoRoomAcceptIncoming() request.
	 */
	-(void) onIncomingEntered:(VCRoomEnterResult)result;
	/*!
	 * Callback that is triggered when the VidyoUser exited the VidyoRoom or as a result of VidyoRoomLeave() request.
	 */
	-(void) onIncomingExited:(VCRoomExitReason)reason;
@end
@protocol VCRoomIAcquireMediaRoute
	/*!
	 * Callback that is triggered when media route is discovered as a result of VidyoRoomAcquireMediaRoute() request.
	 */
	-(void) onMediaRouteAcquired;
	/*!
	 * Callback that is triggered when media enabling failed as a result of VidyoRoomAcquireMediaRoute() request.
	 */
	-(void) onMediaRouteAcquireFailed:(VCRoomMediaFailReason)reason;
@end
@protocol VCRoomIDelete
	/*!
	 * Callback that is triggered when server acknowleges a VidyoRoom has been deleted on the server.
	 */
	-(void) onDeleteResult:(VCRoomDeleteResult)result;
@end
@protocol VCRoomIEnableMedia
	/*!
	 * Callback that is triggered when media was enabled as a result of VidyoRoomEnableMedia() request.
	 */
	-(void) onMediaEnabled;
	/*!
	 * Callback that is triggered when media enabling failed as a result of VidyoRoomEnableMedia() request.
	 */
	-(void) onMediaFailed:(VCRoomMediaFailReason)reason;
	/*!
	 * Callback that is triggered when media has been disbled after a successfully enabling it with VidyoRoomEnableMedia().
	 */
	-(void) onMediaDisabled:(VCRoomMediaDisableReason)reason;
@end
@protocol VCRoomIEnter
	/*!
	 * Callback that is triggered when entering the VidyoRoom as a result of VidyoRoomEnter() request.
	 */
	-(void) onEntered:(VCRoomEnterResult)result;
	/*!
	 * Callback that is triggered when the VidyoUser exited the VidyoRoom or as a result of VidyoRoomLeave() request.
	 */
	-(void) onExited:(VCRoomExitReason)reason;
@end
@protocol VCRoomIGetHistory
	/*!
	 * Callback that is triggered as a result of VidyoRoomGetHistory() call.
	 */
	-(void) onGetHistoryResults:(NSMutableArray*)records HistorySize:(long long)historySize Result:(VCRoomSearchResult)result;
@end
@protocol VCRoomIGetRoomProperties
	/*!
	 * Callback that is triggered when VidyoRoomGetRoomProperties() request completes.
	 */
	-(void) onGetRoomPropertiesResult:(VCRoomGetPropertiesResult)result RoomProperties:(VCRoomProperties*)roomProperties;
@end
@protocol VCRoomIGetSelectedLocalCameras
	/*!
	 * Callback that is triggered when getting the selected local cameras completes.
	 */
	-(void) onGetSelectedLocalCamerasComplete:(NSMutableArray*)cameras;
@end
@protocol VCRoomIGetSelectedLocalMicrophones
	/*!
	 * Callback that is triggered when getting the selected local microphones completes.
	 */
	-(void) onGetSelectedLocalMicrophonesComplete:(NSMutableArray*)microphones;
@end
@protocol VCRoomIGetSelectedLocalMonitors
	/*!
	 * Callback that is triggered when getting the selected local monitors completes.
	 */
	-(void) onGetSelectedLocalMonitorsComplete:(NSMutableArray*)monitors;
@end
@protocol VCRoomIGetSelectedLocalRenderers
	/*!
	 * Callback that is triggered when getting the selected local renderers completes.
	 */
	-(void) onGetSelectedLocalRenderersComplete:(NSMutableArray*)renderers;
@end
@protocol VCRoomIGetSelectedLocalSpeakers
	/*!
	 * Callback that is triggered when getting the selected local speakers completes.
	 */
	-(void) onGetSelectedLocalSpeakersComplete:(NSMutableArray*)speakers;
@end
@protocol VCRoomIGetSelectedLocalWindowShares
	/*!
	 * Callback that is triggered when getting the selected local window shares completes.
	 */
	-(void) onGetSelectedLocalWindowSharesComplete:(NSMutableArray*)windowShares;
@end
@protocol VCRoomIInvite
	/*!
	 * Callback that is triggered when server acknowleges a VidyoRoom invite has been sent to the user.
	 */
	-(void) onInviteResult:(NSMutableString*)inviteeId Result:(VCRoomInviteResult)result;
@end
@protocol VCRoomILockRoom
	/*!
	 * Callback that is triggered each tome when the result of lock room request is received.
	 */
	-(void) onLockRoomResult:(VCRoomSetPropertiesResult)result;
@end
@protocol VCRoomIMessageSearch
	/*!
	 * Callback that is triggered as a result of VidyoRoomSearch() call.
	 */
	-(void) onMessageSearchResults:(const char*)searchText Records:(NSMutableArray*)records Result:(VCRoomSearchResult)result;
@end
@protocol VCRoomIPauseRecording
	/*!
	 * Callback that is triggered upon completion of a recording service pause request.
	 */
	-(void) onRecordingServicePauseResult:(VCRoomSetPropertiesResult)result;
@end
@protocol VCRoomIRaiseHand
	/*!
	 * Callback that is triggered each time when response of hand raise request
	 */
	-(void) onRaiseHandResponse:(VCParticipantHandState)handState;
@end
@protocol VCRoomIRegisterBotEventListener
	/*!
	 * Callback that is triggered when bot participant joins a conference.
	 */
	-(void) onBotJoined:(VCRoomBotInfo*)info;
	/*!
	 * Callback that is triggered when bot participant leaves a conference.
	 */
	-(void) onBotLeft:(VCRoomBotInfo*)info;
@end
@protocol VCRoomIRegisterConferenceModeEventListener
	/*!
	 * Callback that will be triggered when conference mode changes
	 */
	-(void) onConferenceModeChanged:(VCRoomConferenceMode)mode;
@end
@protocol VCRoomIRegisterConnectionPropertiesEventListener
	/*!
	 * Callback that is triggered each time when connection properties is changed.
	 */
	-(void) onConnectionPropertiesChanged:(VCRoomConnectionProperties*)connectionProperties;
@end
@protocol VCRoomIRegisterHostEventListener
	/*!
	 * Callback that will be triggered when conference host joins or leaves
	 */
	-(void) onConferenceHostStatusChanged:(VCParticipant*)host HostState:(VCRoomConferenceHostState)hostState;
@end
@protocol VCRoomIRegisterInCallEventListener
	/*!
	 * A callback to be invoked when any in call event to be sent to application.
	 */
	-(void) onInCallEvents:(VCRoomInCallEvent*)ev;
@end
@protocol VCRoomIRegisterLectureModeEventListener
	/*!
	 * Callback that is triggered when the presenter was changed.
	 */
	-(void) onPresenterChanged:(VCParticipant*)participant;
	/*!
	 * Callback that is triggered for the moderator every time someone raises their hand.
	 */
	-(void) onHandRaised:(NSMutableArray*)participant;
@end
@protocol VCRoomIRegisterMessageEventListener
	/*!
	 * Callback that is triggered for every VidyoChatMessage that was sent to the VidyoRoom by every other VidyoParticipant after the VidyoRoomOnEntered returned successfully.
	 */
	-(void) onMessageReceived:(VCParticipant*)participant ChatMessage:(VCChatMessage*)chatMessage;
	/*!
	 * Callback that is triggered when a VidyoChatMessage is delivered to the VidyoRoom on the server.
	 */
	-(void) onMessageAcknowledged:(VCChatMessage*)chatMessage;
	/*!
	 * Callback that is triggered when a message that was acknowledged by the server was read by the other VidyoParticipant in the room.
	 */
	-(void) onMessageRead:(VCParticipant*)participant MessageId:(long long)messageId;
	/*!
	 * Callback that is triggered when typing state of a remote VidyoParticipant changes.
	 */
	-(void) onMessageTypingIndication:(VCParticipant*)participant TypingIndication:(VCChatMessageTypingIndication)typingIndication;
@end
@protocol VCRoomIRegisterModerationCommandEventListener
	/*!
	 * Callback that will be tringgered when the moderation command will be recieved from the server.
	 */
	-(void) onModerationCommandReceived:(VCDeviceType)deviceType ModerationType:(VCRoomModerationType)moderationType State:(BOOL)state;
@end
@protocol VCRoomIRegisterModerationResultEventListener
	-(void) onModerationResult:(VCParticipant*)participant Result:(VCRoomModerationResult)result ActionType:(VCRoomModerationActionType)actionType RequestId:(NSString*)requestId;
@end
@protocol VCRoomIRegisterParticipantEventListener
	/*!
	 * Callback that is triggered when VidyoParticipant is entering or has been in the room when VidyoUser Entered.
	 */
	-(void) onParticipantJoined:(VCParticipant*)participant;
	/*!
	 * Callback that is triggered when VidyoParticipant is leaving or is being removed when this VidyoUser Exited.
	 */
	-(void) onParticipantLeft:(VCParticipant*)participant;
	/*!
	 * This callback is invoked to report that the list of dynamically selected participants in a conference has changed.
	 */
	-(void) onDynamicParticipantChanged:(NSMutableArray*)selectedParticipants;
	/*!
	 * This callback is invoked to report that an audio-only participant has gain or lost loudest speaker status.
	 */
	-(void) onLoudestParticipantChanged:(VCParticipant*)participant IsAudioOnly:(BOOL)isAudioOnly IsStatic:(BOOL)isStatic;
@end
@protocol VCRoomIRegisterPipEventListener
	/*!
	 * Callback that is triggerred when picture-in-picture view size is changed.
	 */
	-(void) onPipLocationChanged:(int)x Y:(int)y Width:(unsigned int)width Height:(unsigned int)height IsExpanded:(BOOL)isExpanded;
@end
@protocol VCRoomIRegisterRecorderInCallEventListener
	/*!
	 * Callback that is triggered when the call is recorded or when call recording stops.
	 */
	-(void) recorderInCall:(BOOL)hasRecorder IsPaused:(BOOL)isPaused;
@end
@protocol VCRoomIRegisterResourceManagerEventListener
	/*!
	 * Callback that is triggered when the available resources such as CPU and bandwidth change when media is enabled. If there is no enough bandwidth for sources bandwidthSend and bandwidthReceive will be 0. If has enough bandwidth for sources bandwidthSend and bandwidthReceive will be 1-70%. If has more bandwidth than required for sources bandwidthSend and bandwidthReceive will be 70-100%.
	 */
	-(void) onAvailableResourcesChanged:(unsigned int)cpuEncode CpuDecode:(unsigned int)cpuDecode BandwidthSend:(unsigned int)bandwidthSend BandwidthReceive:(unsigned int)bandwidthReceive;
	/*!
	 * Callback that is triggered when maximum decoding capability changes when media is enabled.
	 */
	-(void) onMaxRemoteSourcesChanged:(unsigned int)maxRemoteSources;
@end
@protocol VCRoomIRegisterRoomPropertiesEventListener
	/*!
	 * Callback that is triggered when VidyoRoomProperties is changed on the server side.
	 */
	-(void) onRoomPropertiesChanged:(VCRoomProperties*)roomProperties;
@end
@protocol VCRoomIRegisterSubjectEventListener
	/*!
	 * Callback that is triggered when the subject of the VidyoRoom has changed.
	 */
	-(void) onSetSubject:(const char*)subject;
@end
@protocol VCRoomIRegisterUnprocessedAudioEventListener
	/*!
	 * Callback that is triggered when support of unprocessed audio is changed
	 */
	-(void) onUnprocessedAudioSupportChanged:(BOOL)supported;
	/*!
	 * Callback that is triggered when support of unprocessed audio is changed
	 */
	-(void) onUnprocessedAudioStarted:(BOOL)started;
@end
@protocol VCRoomIRemoveRoomPIN
	/*!
	 * Callback that is triggered each time when result of remove room pin is received.
	 */
	-(void) onRemoveRoomPINResult:(VCRoomSetPropertiesResult)result;
@end
@protocol VCRoomIRequestRoleChange
	-(void) onRequestRoleChangeResult:(VCRoomRequestRoleChangeResult)result RequestId:(NSString*)requestId;
@end
@protocol VCRoomIResumeRecording
	/*!
	 * Callback that is triggered upon completion of a recording service resume request.
	 */
	-(void) onRecordingServiceResumeResult:(VCRoomSetPropertiesResult)result;
@end
@protocol VCRoomISetDefaultProfile
	/*!
	 * Callback that is triggered when a VidyoRoomSetProperty request completes.
	 */
	-(void) onSetRoomPropertyResult:(VCRoomSetPropertiesResult)result;
@end
@protocol VCRoomISetFavorite
	/*!
	 * Callback that is triggered when server acknowleges a VidyoRoom's favorite status for current logged-in user has changed.
	 */
	-(void) onSetFavoriteResult:(BOOL)isFavorite Result:(VCRoomSetFavoriteResult)result;
@end
@protocol VCRoomISetRoomPIN
	/*!
	 * Callback that is triggered each time when result of set room pin is received.
	 */
	-(void) onSetRoomPINResult:(VCRoomSetPropertiesResult)result;
@end
@protocol VCRoomISetRoomProperties
	/*!
	 * Callback that is triggered when VidyoRoomSetProperties request completes.
	 */
	-(void) onSetRoomPropertiesResult:(VCRoomSetPropertiesResult)result;
@end
@protocol VCRoomIStartRecording
	/*!
	 * Callback that is triggered upon completion of a recording service start request.
	 */
	-(void) onRecordingServiceStartResult:(VCRoomSetPropertiesResult)result;
@end
@protocol VCRoomIStopRecording
	/*!
	 * Callback that is triggered upon completion of a recording service stop request.
	 */
	-(void) onRecordingServiceStopResult:(VCRoomSetPropertiesResult)result;
@end
@protocol VCRoomIUnlockRoom
	/*!
	 * Callback that is triggered each tome when the result of unlock room request is received.
	 */
	-(void) onUnlockRoomResult:(VCRoomSetPropertiesResult)result;
@end
/*!
 * Establishes and manages a conference room. See VidyoRoomType for sescription of room types.
 */
@interface VCRoom : NSObject
{
	void* objPtr;
	NSMutableDictionary<NSString*, VCParticipant*> *participantsMap;
	@public
	id<VCRoomIAcceptIncoming> roomIAcceptIncoming;
	id<VCRoomIAcquireMediaRoute> roomIAcquireMediaRoute;
	/*!
	 * Delete a room.
	 */
	id<VCRoomIDelete> roomIDelete;
	id<VCRoomIEnableMedia> roomIEnableMedia;
	id<VCRoomIEnter> roomIEnter;
	/*!
	 * Gets the latest history of the room.
	 */
	id<VCRoomIGetHistory> roomIGetHistory;
	id<VCRoomIGetRoomProperties> roomIGetRoomProperties;
	id<VCRoomIGetSelectedLocalCameras> roomIGetSelectedLocalCameras;
	id<VCRoomIGetSelectedLocalMicrophones> roomIGetSelectedLocalMicrophones;
	id<VCRoomIGetSelectedLocalMonitors> roomIGetSelectedLocalMonitors;
	id<VCRoomIGetSelectedLocalRenderers> roomIGetSelectedLocalRenderers;
	id<VCRoomIGetSelectedLocalSpeakers> roomIGetSelectedLocalSpeakers;
	id<VCRoomIGetSelectedLocalWindowShares> roomIGetSelectedLocalWindowShares;
	id<VCRoomIInvite> roomIInvite;
	/*!
	 * This api provides the ability lock the current room.
	 */
	id<VCRoomILockRoom> roomILockRoom;
	/*!
	 * Searches the room for text messages.
	 */
	id<VCRoomIMessageSearch> roomIMessageSearch;
	/*!
	 * Asynchronously pauses recording a conference. Must be called on behalf of a moderator. Fails in case recording is not in progress or already paused. Calls a callback upon completion.
	 */
	id<VCRoomIPauseRecording> roomIPauseRecording;
	/*!
	 * Each participant can send a moderation request to raise their hand to request to be unmuted. The Moderator and Presenter will be notified.
	 */
	id<VCRoomIRaiseHand> roomIRaiseHand;
	/*!
	 * This is a synchronous interface. Application can register a callback to get notified about bot participants.
	 */
	id<VCRoomIRegisterBotEventListener> roomIRegisterBotEventListener;
	/*!
	 * Registers callbacks to get notified about conference mode events,i.e. lobby mode/lecture mode/waiting room.
	 */
	id<VCRoomIRegisterConferenceModeEventListener> roomIRegisterConferenceModeEventListener;
	/*!
	 * Registers to get notified when a connection properties is changed.
	 */
	id<VCRoomIRegisterConnectionPropertiesEventListener> roomIRegisterConnectionPropertiesEventListener;
	/*!
	 * Registers callbacks to get notified about room host joinin or leaving events
	 */
	id<VCRoomIRegisterHostEventListener> roomIRegisterHostEventListener;
	/*!
	 * Registers a callback to be will be triggered during a conference, these events may not stop the conferece but may degrade quality of call.
	 */
	id<VCRoomIRegisterInCallEventListener> roomIRegisterInCallEventListener;
	/*!
	 * Register a callback if application needs to know result of moderation request.
	 */
	id<VCRoomIRegisterLectureModeEventListener> roomIRegisterLectureModeEventListener;
	/*!
	 * Registers to get notified about message events.
	 */
	id<VCRoomIRegisterMessageEventListener> roomIRegisterMessageEventListener;
	/*!
	 * Register a callback to receive moderation commands sent from the server.
	 */
	id<VCRoomIRegisterModerationCommandEventListener> roomIRegisterModerationCommandEventListener;
	/*!
	 * Register a callback if application needs to know result of moderation request.
	 */
	id<VCRoomIRegisterModerationResultEventListener> roomIRegisterModerationResultEventListener;
	/*!
	 * Registers to get notified about participant events.
	 */
	id<VCRoomIRegisterParticipantEventListener> roomIRegisterParticipantEventListener;
	/*!
	 * Registers to get notified when a a call is being recorded.
	 */
	id<VCRoomIRegisterPipEventListener> roomIRegisterPipEventListener;
	/*!
	 * Registers to get notified when a a call is being recorded.
	 */
	id<VCRoomIRegisterRecorderInCallEventListener> roomIRegisterRecorderInCallEventListener;
	/*!
	 * Registers to get notified about resource-management events.
	 */
	id<VCRoomIRegisterResourceManagerEventListener> roomIRegisterResourceManagerEventListener;
	/*!
	 * Registers to get notified about participant events.
	 */
	id<VCRoomIRegisterRoomPropertiesEventListener> roomIRegisterRoomPropertiesEventListener;
	/*!
	 * Registers to get notified about subject events.
	 */
	id<VCRoomIRegisterSubjectEventListener> roomIRegisterSubjectEventListener;
	/*!
	 * .
	 */
	id<VCRoomIRegisterUnprocessedAudioEventListener> roomIRegisterUnprocessedAudioEventListener;
	/*!
	 * This api provides the ability to remove the room pin. Once room pin is remove, all other users are not required to enter room pin to join the conference room.
	 */
	id<VCRoomIRemoveRoomPIN> roomIRemoveRoomPIN;
	/*!
	 * This API provides the ability to request moderator functionality, providing the user who is not a room owner, the ability to control remote source transmitting, for other users in the conference. Remote sources currently include camera's and microphones.
	 */
	id<VCRoomIRequestRoleChange> roomIRequestRoleChange;
	/*!
	 * Asynchronously resumes recording a conference. Must be called on behalf of a moderator. Fails in case recording is not in progress or not paused. Calls a callback upon completion.
	 */
	id<VCRoomIResumeRecording> roomIResumeRecording;
	/*!
	 * Set the default profile for all participants. Only one SetRoomProperty request is allowed at a time.
	 */
	id<VCRoomISetDefaultProfile> roomISetDefaultProfile;
	id<VCRoomISetFavorite> roomISetFavorite;
	/*!
	 * This api provides the ability to set the room pin. Once room pin is set, all other users are required to enter this room pin to join this conference room.
	 */
	id<VCRoomISetRoomPIN> roomISetRoomPIN;
	id<VCRoomISetRoomProperties> roomISetRoomProperties;
	/*!
	 * Asynchronously starts recording a conference using the specified recording profile. Must be called on behalf of a moderator. Fails in case another recording is in progress. Calls a callback upon completion.
	 */
	id<VCRoomIStartRecording> roomIStartRecording;
	/*!
	 * Asynchronously stops recording a conference. Must be called on behalf of a moderator. Fails in case there is no recording in progress. Calls a callback upon completion.
	 */
	id<VCRoomIStopRecording> roomIStopRecording;
	/*!
	 * This api provides the ability unlock the current room.
	 */
	id<VCRoomIUnlockRoom> roomIUnlockRoom;
}
	/*!
	 * Unique ID that identifies a VidyoRoom at the server.
	 */
	@property NSMutableString* id;
	/*!
	 * Type of VidyoRoom such as topic or Conversation.
	 */
	@property VCRoomType type;
	-(void) dealloc;
	/*!
	 * @param onIncomingEntered Callback that is triggered when the enter operation completes. This could be a successful enter or a failure due to permissions, etc.
	 * @param onIncomingExited Callback that is triggered when the room has been exited.
	 */
	-(BOOL) acceptIncoming:(id<VCRoomIAcceptIncoming>)roomIAcceptIncoming;
	/*!
	 * @param onMediaRouteAcquired Callback that is triggered when the acquire media route operation is complete.
	 * @param onMediaRouteAcquireFailed Callback that is triggered when the could not be enabled.
	 */
	-(BOOL) acquireMediaRoute:(id<VCRoomIAcquireMediaRoute>)roomIAcquireMediaRoute;
	/*!
	 * @param r Vidyo room object.
	 */
	-(void) addLocalCamera:(VCLocalCamera*)localCamera RemoveOthers:(BOOL)removeOthers;
	/*!
	 * @param r Vidyo room object.
	 */
	-(void) addLocalMicrophone:(VCLocalMicrophone*)localMicrophone RemoveOthers:(BOOL)removeOthers IsAES:(BOOL)isAES;
	/*!
	 * @param r Vidyo room object.
	 */
	-(void) addLocalMonitor:(VCLocalMonitor*)localMonitor RemoveOthers:(BOOL)removeOthers;
	/*!
	 * @param r Vidyo room object.
	 */
	-(void) addLocalRenderer:(VCLocalRenderer*)localRenderer RemoveOthers:(BOOL)removeOthers;
	/*!
	 * @param r Vidyo room object.
	 */
	-(void) addLocalSpeaker:(VCLocalSpeaker*)localSpeaker RemoveOthers:(BOOL)removeOthers IsAES:(BOOL)isAES;
	/*!
	 * @param r Vidyo room object.
	 */
	-(void) addLocalWindowShare:(VCLocalWindowShare*)localWindowShare RemoveOthers:(BOOL)removeOthers;
	/*!
	 * Add the virtual audio source to the room.
	 * @param r Vidyo room object.
	 * @param virtualAudioSource The VidyoVirtualAudioSource object.
	 * @param removeOthers Indicates that previously added virtual audio sources will be removed.
	 */
	-(void) addVirtualAudioSource:(VCVirtualAudioSource*)virtualAudioSource RemoveOthers:(BOOL)removeOthers;
	/*!
	 * @param r Vidyo room object.
	 */
	-(void) addVirtualVideoSource:(VCVirtualVideoSource*)virtualVideoSource RemoveOthers:(BOOL)removeOthers;
	/*!
	 * The Moderator can send a moderation request to approve a raised hand, in which case the participant whose hand was raised will be notified.
	 * @param r The VidyoRoom object.
	 * @param participant Selected participant whose raised hand request is approved.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) approveRaisedHand:(VCParticipant*)participant RequestId:(NSString*)requestId;
	/*!
	 * Kick all participants out of a room.
	 * @param r Vidyo room object.
	 * @param reason A message explaining the reason for the booting. This can be NULL if no message is desired.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) bootAllParticipants:(NSString*)reason RequestId:(NSString*)requestId;
	/*!
	 * Kick one participant out of a room.
	 * @param r Vidyo room object.
	 * @param userId ID of users to be kicked out of a room.
	 * @param reason A message explaining the reason for the booting. This can be NULL if no message is desired.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) bootParticipant:(NSString*)userId Reason:(NSString*)reason RequestId:(NSString*)requestId;
	/*!
	 * Cancel invitation to a VidyoRoom.
	 * @param r The room object to extract stats.
	 * @param inviteeId Id of the invited user.
	 */
	-(BOOL) cancelInvite:(NSString*)inviteeId;
	/*!
	 * Creates a VidyoRoomParticipantProfile object.
	 * @param r The VidyoRoom object.
	 * @param p The VidyoRoomParticipantProfile object to construct.
	 * @param userId User ID if this is not a default profile.
	 * @param microphone The Microphone Profile.
	 * @param camera The Camera Profile.
	 * @param windowShare The WindowShare Profile.
	 * @param chat The Chat Profile.
	 */
	-(VCRoomParticipantProfile*) createParticipantProfile:(VCRoomParticipantProfile*)p UserId:(const char*)userId Microphone:(VCRoomProfileControlMode)microphone Camera:(VCRoomProfileControlMode)camera WindowShare:(VCRoomProfileControlMode)windowShare Chat:(VCRoomProfileControlMode)chat;
	/*!
	 * Delete a room.
	 * @param r Vidyo room object.
	 * @param onDeleteResult Callback that is triggered when delete operation completes.
	 */
	-(void) delete:(id<VCRoomIDelete>)roomIDelete;
	/*!
	 * Destroys a VidyoRoomParticipantProfile object.
	 * @param r The VidyoRoom object.
	 * @param p The VidyoRoomParticipantProfile object to construct.
	 */
	-(void) destroyParticipantProfile:(VCRoomParticipantProfile*)p;
	/*!
	 * @param r The room object.
	 */
	-(BOOL) disableMedia;
	/*!
	 * The Moderator can send a moderation request to reject all raised hand, in which case all participants whose hand was raised will be notified.
	 * @param r The VidyoRoom object.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) dismissAllRaisedHands:(NSString*)requestId;
	/*!
	 * The Moderator can send a moderation request to decline a raised hands, in which case the participant whose hand was raised will be notified.
	 * @param r The VidyoRoom object.
	 * @param participants List of selected participants whose raised hand request is going to dismiss.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) dismissRaisedHand:(NSMutableArray*)participants RequestId:(NSString*)requestId;
	/*!
	 * @param onMediaEnabled Callback that is triggered when the media has been successfully enabled.
	 * @param onMediaFailed Callback that is triggered when the could not be enabled.
	 * @param onMediaDisabled Callback that is triggered when the media has been disabled after being previously enabled successfully.
	 */
	-(BOOL) enableMedia:(id<VCRoomIEnableMedia>)roomIEnableMedia;
	/*!
	 * @param onEntered Callback that is triggered when the enter operation completes. This could be a successful enter or a failure due to permissions, etc.
	 * @param onExited Callback that is triggered when the room has been exited.
	 */
	-(BOOL) enter:(const char*)password RoomIEnter:(id<VCRoomIEnter>)roomIEnter;
	/*!
	 * Gets the latest history of the room.
	 * @param r The room object.
	 * @param numMessages The number of latest messages to request.
	 * @param onGetHistoryResults Callback that is triggered when history results are ready.
	 */
	-(BOOL) getHistory:(unsigned int)numMessages RoomIGetHistory:(id<VCRoomIGetHistory>)roomIGetHistory;
	/*!
	 * Gets the history of the room before and after the messageId.
	 * @param r The room object.
	 * @param messageId The ID of the message to use as an apex.
	 * @param numMessagesBefore The number of messages before the apex.
	 * @param numMessagesAfter The number of messages after the apex.
	 * @param onGetHistoryResults Callback that is triggered when history results are ready.
	 */
	-(BOOL) getHistoryById:(long long)messageId NumMessagesBefore:(unsigned int)numMessagesBefore NumMessagesAfter:(unsigned int)numMessagesAfter RoomIGetHistory:(id<VCRoomIGetHistory>)roomIGetHistory;
	/*!
	 * Gets the history of the room before and after the messageId.
	 * @param r The room object.
	 * @param time The time to use as an apex.
	 * @param numMessagesBefore The number of messages before the apex.
	 * @param numMessagesAfter The number of messages after the apex.
	 * @param onGetHistoryResults Callback that is triggered when history results are ready.
	 */
	-(BOOL) getHistoryByTime:(long)time NumMessagesBefore:(unsigned int)numMessagesBefore NumMessagesAfter:(unsigned int)numMessagesAfter RoomIGetHistory:(id<VCRoomIGetHistory>)roomIGetHistory;
	/*!
	 */
	-(NSString*) getId;
	/*!
	 * @param onGetRoomPropertiesResult Callback that is triggered when get properties operation completes.
	 */
	-(BOOL) getRoomProperties:(id<VCRoomIGetRoomProperties>)roomIGetRoomProperties;
	/*!
	 * @param r Vidyo room object.
	 */
	-(void) getSelectedLocalCameras:(id<VCRoomIGetSelectedLocalCameras>)roomIGetSelectedLocalCameras;
	/*!
	 * @param r Vidyo room object.
	 */
	-(void) getSelectedLocalMicrophones:(id<VCRoomIGetSelectedLocalMicrophones>)roomIGetSelectedLocalMicrophones;
	/*!
	 * @param r Vidyo room object.
	 */
	-(void) getSelectedLocalMonitors:(id<VCRoomIGetSelectedLocalMonitors>)roomIGetSelectedLocalMonitors;
	/*!
	 * @param r Vidyo room object.
	 */
	-(void) getSelectedLocalRenderers:(id<VCRoomIGetSelectedLocalRenderers>)roomIGetSelectedLocalRenderers;
	/*!
	 * @param r Vidyo room object.
	 */
	-(void) getSelectedLocalSpeakers:(id<VCRoomIGetSelectedLocalSpeakers>)roomIGetSelectedLocalSpeakers;
	/*!
	 * @param r Vidyo room object.
	 */
	-(void) getSelectedLocalWindowShares:(id<VCRoomIGetSelectedLocalWindowShares>)roomIGetSelectedLocalWindowShares;
	/*!
	 * Get show throttle type.
	 * @param room Vidyo room object.
	 */
	-(VCRoomShowThrottle) getShowThrottle;
	/*!
	 * Get show throttle timer interval.
	 * @param room Vidyo room object.
	 */
	-(unsigned int) getShowThrottleTimerInterval;
	/*!
	 * Get show throttle threshold for window size change.
	 * @param room Vidyo room object.
	 */
	-(unsigned int) getShowThrottleWindowSizeChangeThreshold;
	/*!
	 */
	-(VCRoomType) getType;
	/*!
	 */
	-(VCUser*) getUser;
	/*!
	 * Hides statistics for a room.
	 * @param r Vidyo room object.
	 */
	-(void) hideStatisticsDialog;
	/*!
	 * @param onInviteResult Callback that is triggered when another participant joins a conference.
	 */
	-(BOOL) invite:(NSString*)userId Message:(const char*)message RoomIInvite:(id<VCRoomIInvite>)roomIInvite;
	/*!
	 * @param onInviteResult Callback that is triggered when another participant joins a conference.
	 */
	-(BOOL) inviteAll:(const char*)message RoomIInvite:(id<VCRoomIInvite>)roomIInvite;
	/*!
	 * @param onInviteResult Callback that is triggered when another participant joins a conference.
	 */
	-(BOOL) inviteN:(NSMutableArray*)userIds Message:(const char*)message RoomIInvite:(id<VCRoomIInvite>)roomIInvite;
	/*!
	 * Leaves the room. This triggers VidyoRoomOnExited.
	 */
	-(BOOL) leave;
	/*!
	 * This api provides the ability lock the current room.
	 * @param r VidyoRoom object.
	 * @param onLockRoomResult Callback to be triggered for lock room result.
	 */
	-(BOOL) lockRoom:(id<VCRoomILockRoom>)roomILockRoom;
	/*!
	 * Searches the room for text messages.
	 * @param r Vidyo room object.
	 * @param searchText The text to search the messages in the room.
	 * @param index The start index from which the recent rooms are required. A value of '0' represents rooms starting from the beginning. A value of 'n' represents rooms starting from 'n'th record. This is used for paging the response.
	 * @param pageSize The maximum number of room records that can be sent in the response. This is used for paging the response.
	 * @param onMessageSearchResults Callback that is triggered when message search results are ready.
	 */
	-(BOOL) messageSearch:(const char*)searchText Index:(unsigned int)index PageSize:(unsigned int)pageSize RoomIMessageSearch:(id<VCRoomIMessageSearch>)roomIMessageSearch;
	/*!
	 * Asynchronously pauses recording a conference. Must be called on behalf of a moderator. Fails in case recording is not in progress or already paused. Calls a callback upon completion.
	 * @param r VidyoRoom object.
	 * @param onRecordingServicePauseResultCallback Callback called upon completion.
	 */
	-(BOOL) pauseRecording:(id<VCRoomIPauseRecording>)roomIPauseRecording;
	/*!
	 * Each participant can send a moderation request to raise their hand to request to be unmuted. The Moderator and Presenter will be notified.
	 * @param r The VidyoRoom object.
	 * @param raiseHandResponse Callback that is triggered each time when response of hand raise request.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) raiseHand:(id<VCRoomIRaiseHand>)roomIRaiseHand RequestId:(NSString*)requestId;
	/*!
	 * This is a synchronous interface. Application can register a callback to get notified about bot participants.
	 * @param r The VidyoRoom object.
	 * @param onJoined Callback that is triggered when bot participant joins a conference.
	 * @param onLeft Callback that is triggered when an existing bot participant leaves a conference.
	 */
	-(BOOL) registerBotEventListener:(id<VCRoomIRegisterBotEventListener>)roomIRegisterBotEventListener;
	/*!
	 * Registers callbacks to get notified about conference mode events,i.e. lobby mode/lecture mode/waiting room.
	 * @param r The VidyoRoom object.
	 * @param conferenceModeChanged The conference mode i.e. Lecture mode/lobby room/group mode
	 */
	-(BOOL) registerConferenceModeEventListener:(id<VCRoomIRegisterConferenceModeEventListener>)roomIRegisterConferenceModeEventListener;
	/*!
	 * Registers to get notified when a connection properties is changed.
	 * @param r The VidyoRoom object.
	 * @param onConnectionPropertiesChanged Callback that is triggered when a connection properties is changed.
	 */
	-(BOOL) registerConnectionPropertiesEventListener:(id<VCRoomIRegisterConnectionPropertiesEventListener>)roomIRegisterConnectionPropertiesEventListener;
	/*!
	 * Registers callbacks to get notified about room host joinin or leaving events
	 * @param r The VidyoRoom object.
	 * @param hostStatus The host status whether joining or leaving
	 */
	-(BOOL) registerHostEventListener:(id<VCRoomIRegisterHostEventListener>)roomIRegisterHostEventListener;
	/*!
	 * Registers a callback to be will be triggered during a conference, these events may not stop the conferece but may degrade quality of call.
	 * @param r The VidyoRoom object.
	 * @param cb Callback which will be triggered when error occur in conference.
	 */
	-(BOOL) registerInCallEventListener:(id<VCRoomIRegisterInCallEventListener>)roomIRegisterInCallEventListener;
	/*!
	 * Register a callback if application needs to know result of moderation request.
	 * @param room Vidyo room object.
	 * @param presenterChanged Callback that is triggered when presenter changed.
	 * @param handRaised Callback that is triggered for Moderator when some hand raised.
	 */
	-(BOOL) registerLectureModeEventListener:(id<VCRoomIRegisterLectureModeEventListener>)roomIRegisterLectureModeEventListener;
	/*!
	 * Registers to get notified about message events.
	 * @param r The VidyoRoom object.
	 * @param onMessageReceived Callback that is triggered when a new message has been received.
	 * @param onMessageAcknowledged Callback that is triggered when a sent message has been acknowledged.
	 * @param onMessageRead Callback that is triggered when a sent message has been read.
	 * @param onMessageTypingIndication Callback that is triggered when a remote participant is typing.
	 */
	-(BOOL) registerMessageEventListener:(id<VCRoomIRegisterMessageEventListener>)roomIRegisterMessageEventListener;
	/*!
	 * Register a callback to receive moderation commands sent from the server.
	 * @param room Vidyo room object.
	 * @param onModerationCommand Callback to be triggered upon receive moderation command from the server.
	 */
	-(BOOL) registerModerationCommandEventListener:(id<VCRoomIRegisterModerationCommandEventListener>)roomIRegisterModerationCommandEventListener;
	/*!
	 * Register a callback if application needs to know result of moderation request.
	 * @param room Vidyo room object.
	 * @param onModerationResult Callback to be triggered upon receive moderation request result.
	 */
	-(BOOL) registerModerationResultEventListener:(id<VCRoomIRegisterModerationResultEventListener>)roomIRegisterModerationResultEventListener;
	/*!
	 * Registers to get notified about participant events.
	 * @param r The VidyoRoom object.
	 * @param onParticipantJoined Callback that is triggered when another participant joins a conference.
	 * @param onParticipantLeft Callback that is triggered when an existing participant leaves a conference.
	 * @param onDynamicParticipantChanged Callback that is triggered when the order of participants has changed, based on their importance according to active speech detection.
	 * @param onLoudestParticipantChanged Callback that is triggered when a new participant becomes the loudest, based on active speech detection.
	 */
	-(BOOL) registerParticipantEventListener:(id<VCRoomIRegisterParticipantEventListener>)roomIRegisterParticipantEventListener;
	/*!
	 * Registers to get notified when a a call is being recorded.
	 * @param r The VidyoRoom object.
	 * @param onPipLocationChanged .
	 */
	-(BOOL) registerPipEventListener:(id<VCRoomIRegisterPipEventListener>)roomIRegisterPipEventListener;
	/*!
	 * Registers to get notified when a a call is being recorded.
	 * @param r The VidyoRoom object.
	 * @param onRecorderInCallChanged Callback that is triggered when a recorder joins or leaves the call.
	 */
	-(BOOL) registerRecorderInCallEventListener:(id<VCRoomIRegisterRecorderInCallEventListener>)roomIRegisterRecorderInCallEventListener;
	/*!
	 * Registers to get notified about resource-management events.
	 * @param r The VidyoRoom object.
	 * @param onAvailableResourcesChanged Callback that is triggered when local resource availability changes.
	 * @param onMaxRemoteSourcesChanged Callback that is triggered when the maximum number of decoded sources changes.
	 */
	-(BOOL) registerResourceManagerEventListener:(id<VCRoomIRegisterResourceManagerEventListener>)roomIRegisterResourceManagerEventListener;
	/*!
	 * Registers to get notified about participant events.
	 * @param r The VidyoRoom object.
	 * @param onRoomPropertiesChanged Callback that is triggered when room properties have changed.
	 */
	-(BOOL) registerRoomPropertiesEventListener:(id<VCRoomIRegisterRoomPropertiesEventListener>)roomIRegisterRoomPropertiesEventListener;
	/*!
	 * Registers to get notified about subject events.
	 * @param r The VidyoRoom object.
	 * @param onSetSubject Callback that is triggered when the subject has been changed.
	 */
	-(BOOL) registerSubjectEventListener:(id<VCRoomIRegisterSubjectEventListener>)roomIRegisterSubjectEventListener;
	/*!
	 * .
	 * @param r The VidyoRoom object.
	 * @param onUnprocessedAudioSupportChanged .
	 * @param onUnprocessedAudioStarted .
	 */
	-(BOOL) registerUnprocessedAudioEventListener:(id<VCRoomIRegisterUnprocessedAudioEventListener>)roomIRegisterUnprocessedAudioEventListener;
	/*!
	 */
	-(BOOL) rejectIncoming;
	/*!
	 * @param r Vidyo room object.
	 */
	-(void) removeLocalCamera:(VCLocalCamera*)localCamera;
	/*!
	 * @param r Vidyo room object.
	 */
	-(void) removeLocalMicrophone:(VCLocalMicrophone*)localMicrophone;
	/*!
	 * @param r Vidyo room object.
	 */
	-(void) removeLocalMonitor:(VCLocalMonitor*)localMonitor;
	/*!
	 * @param r Vidyo room object.
	 */
	-(void) removeLocalRenderer:(VCLocalRenderer*)localRenderer;
	/*!
	 * @param r Vidyo room object.
	 */
	-(void) removeLocalSpeaker:(VCLocalSpeaker*)localSpeaker;
	/*!
	 * @param r Vidyo room object.
	 */
	-(void) removeLocalWindowShare:(VCLocalWindowShare*)localWindowShare;
	/*!
	 * Remove presenter rights from a specific participant.
	 * @param room Vidyo room object.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) removePresenter:(NSString*)requestId;
	/*!
	 * This API provides the ability to allow a room owner to remove authentication scheme for moderator functionality
	 * @param room Vidyo room object.
	 * @param role VidyoRole that provided auth is assoicted with.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) removeRoleChangeAuthorization:(VCRole)role RequestId:(NSString*)requestId;
	/*!
	 * This api provides the ability to remove the room pin. Once room pin is remove, all other users are not required to enter room pin to join the conference room.
	 * @param r VidyoRoom object.
	 * @param onRemoveRoomPINResult Callback to be triggered for remove room pin result.
	 */
	-(BOOL) removeRoomPIN:(id<VCRoomIRemoveRoomPIN>)roomIRemoveRoomPIN;
	/*!
	 * Remove the virtual audio source from the room.
	 * @param r Vidyo room object.
	 * @param virtualAudioSource The VidyoVirtualAudioSource object.
	 */
	-(void) removeVirtualAudioSource:(VCVirtualAudioSource*)virtualAudioSource;
	/*!
	 * @param r Vidyo room object.
	 */
	-(void) removeVirtualVideoSource:(VCVirtualVideoSource*)virtualVideoSource;
	/*!
	 * By default, local participant joining/leaving conference are not reported to applicaiotn. Use this function to report those events.
	 * @param r The VidyoRoom object.
	 * @param reportLocalParticipant Set to LMI_TRUE if application is interested in local participant to be included in participant event callbacks. Otherwise set to LMI_FALSE. Default is LMI_FALSE
	 */
	-(BOOL) reportLocalParticipantOnJoined:(BOOL)reportLocalParticipant;
	/*!
	 * Reqeust all participants in the room to stop sending audio. And any participant is allowed to restart audio after it is stopped first.
	 * @param room Vidyo room object.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) requestAudioSilenceForAll:(NSString*)requestId;
	/*!
	 * Reqeust a single participant in the room to stop sending audio. This participant is allowed to restart audio after it is stopped first.
	 * @param room Vidyo room object.
	 * @param userId The ID of participant whose audio is requested to stop.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) requestAudioSilenceForParticipant:(NSString*)userId RequestId:(NSString*)requestId;
	/*!
	 * This API provides the ability to request moderator functionality, providing the user who is not a room owner, the ability to control remote source transmitting, for other users in the conference. Remote sources currently include camera's and microphones.
	 * @param room Vidyo room object.
	 * @param newRole .
	 * @param auth .
	 * @param onRequestRoleChangeResult .
	 * @param requestId .
	 */
	-(BOOL) requestRoleChange:(VCRole)newRole Auth:(VCRoleAuthorization*)auth RoomIRequestRoleChange:(id<VCRoomIRequestRoleChange>)roomIRequestRoleChange RequestId:(NSString*)requestId;
	/*!
	 * Reqeust all participants in the room to stop sending video. And any participant is allowed to restart video after it is stopped first.
	 * @param room Vidyo room object.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) requestVideoSilenceForAll:(NSString*)requestId;
	/*!
	 * Reqeust a single participant in the room to stop sending video. This participant is allowed to restart video after it is stopped first.
	 * @param room Vidyo room object.
	 * @param userId The ID of participant whose video is requested to stop.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) requestVideoSilenceForParticipant:(NSString*)userId RequestId:(NSString*)requestId;
	/*!
	 * Resizes statistics dialog for a room.
	 * @param r Vidyo room object.
	 * @param width Width of the dialog.
	 * @param height height of the dialog.
	 */
	-(void) resizeStatisticsDialog:(int)width Height:(int)height;
	/*!
	 * Asynchronously resumes recording a conference. Must be called on behalf of a moderator. Fails in case recording is not in progress or not paused. Calls a callback upon completion.
	 * @param r VidyoRoom object.
	 * @param onRecordingServiceResumeResultCallback Callback called upon completion.
	 */
	-(BOOL) resumeRecording:(id<VCRoomIResumeRecording>)roomIResumeRecording;
	/*!
	 * Set audio revoke state for all participants in the room.
	 * @param room Vidyo room object.
	 * @param revoke Set to LMI_TRUE to stop all participants' audio. Audio cannot be resumed until another call with revoke set to LMI_FALSE.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) revokeAudioForAll:(BOOL)revoke RequestId:(NSString*)requestId;
	/*!
	 * Set audio revoke state for a single participant in the room.
	 * @param room Vidyo room object.
	 * @param userId The ID of participant whose audio is revoked/resumed.
	 * @param revoke Set to LMI_TRUE to stop the participant's audio. Audio cannot be resumed until another call with revoke set to LMI_FALSE.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) revokeAudioForParticipant:(NSString*)userId Revoke:(BOOL)revoke RequestId:(NSString*)requestId;
	/*!
	 * Set video revoke state for all participants in the room.
	 * @param room Vidyo room object.
	 * @param revoke Set to LMI_TRUE to stop all participants' video. Video cannot be resumed until another call with revoke set to LMI_FALSE.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) revokeVideoForAll:(BOOL)revoke RequestId:(NSString*)requestId;
	/*!
	 * Set video revoke state for a single participant in the room.
	 * @param room Vidyo room object.
	 * @param userId The ID of participant whose audio is revoked/resumed.
	 * @param revoke Set to LMI_TRUE to stop the participant's video. Video cannot be resumed until another call with revoke set to LMI_FALSE.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) revokeVideoForParticipant:(NSString*)userId Revoke:(BOOL)revoke RequestId:(NSString*)requestId;
	/*!
	 */
	-(BOOL) sendMessage:(const char*)message;
	/*!
	 * Send the acknowledgement to message in a conference room.
	 * @param r The room object.
	 * @param messageId The message id of message being acknowledged.
	 */
	-(BOOL) sendMessageAcknowledged:(long long)messageId;
	/*!
	 * Send a typing indication state to all participants of a room.
	 * @param r The room object.
	 * @param typingIndication The typing indication state.
	 */
	-(BOOL) sendMessageTypingIndication:(VCChatMessageTypingIndication)typingIndication;
	/*!
	 * Send a private message. Only specific participant will receive this.
	 * @param r The VidyoRoom object.
	 * @param participant The participant which will receive message.
	 * @param message Message that need to be sent.
	 */
	-(BOOL) sendPrivateMessage:(VCParticipant*)participant Message:(const char*)message;
	/*!
	 * Set the default profile for all participants. Only one SetRoomProperty request is allowed at a time.
	 * @param r The VidyoRoom object.
	 * @param profile The default profile for all participants.
	 * @param onSetRoomPropertyResult Callback that is triggered when set property operation completes.
	 */
	-(BOOL) setDefaultProfile:(VCRoomParticipantProfile*)profile RoomISetDefaultProfile:(id<VCRoomISetDefaultProfile>)roomISetDefaultProfile;
	/*!
	 */
	-(BOOL) setDynamicGenerationPosition:(unsigned int)generation X:(int)x Y:(int)y Width:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval;
	/*!
	 */
	-(BOOL) setDynamicLocalRenderer:(VCLocalRenderer*)renderer;
	/*!
	 * @param r Vidyo room object.
	 * @param onSetFavoriteResult Callback that is triggered when set favorite operation completes.
	 */
	-(void) setFavorite:(BOOL)isFavorite RoomISetFavorite:(id<VCRoomISetFavorite>)roomISetFavorite;
	/*!
	 */
	-(BOOL) setMaxAudioSources:(unsigned int)count;
	/*!
	 * @param r The room object.
	 * @param bitRate The maximum receiving bit rate request sent to server, in bps.
	 */
	-(void) setMaxReceiveBitRate:(unsigned int)bitRate;
	/*!
	 * @param r The room object.
	 * @param bitRate The maximum send bit rate request sent to server, in bps.
	 */
	-(void) setMaxSendBitRate:(unsigned int)bitRate;
	/*!
	 */
	-(BOOL) setMaxVideoSources:(unsigned int)count;
	/*!
	 * Set the profiles for specific participants. Only one SetRoomProperty request is allowed at a time.
	 * @param r The VidyoRoom object.
	 * @param profiles Set the profiles for specific participants.
	 * @param onSetRoomPropertyResult Callback that is triggered when set property operation completes.
	 */
	-(BOOL) setParticipantProfiles:(NSMutableArray*)profiles RoomISetDefaultProfile:(id<VCRoomISetDefaultProfile>)roomISetDefaultProfile;
	/*!
	 * Set a specific participant as a presenter.
	 * @param room Vidyo room object.
	 * @param participant The VidyoParticipant object who will be a new presenter.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) setPresenter:(VCParticipant*)participant RequestId:(NSString*)requestId;
	/*!
	 * This API provides the ability to allow a room owner to set an authentication scheme for moderator functionality. The same authentication scheme must be used by other participants who calls VidyoRoomRequestRoleChange to control remote source transmitting
	 * @param room Vidyo room object.
	 * @param role VidyoRole that provided auth is assoicted with.
	 * @param auth Represent the authentication scheme (e.g use passCode to obtain moderator functionality).
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) setRoleChangeAuthorization:(VCRole)role Auth:(VCRoleAuthorization*)auth RequestId:(NSString*)requestId;
	/*!
	 * This api provides the ability to set the room pin. Once room pin is set, all other users are required to enter this room pin to join this conference room.
	 * @param r VidyoRoom object.
	 * @param roomPIN Pin to be set as room pin or set NULL to remove existing room pin.
	 * @param onSetRoomPINResult Callback to be triggered for set room pin result.
	 */
	-(BOOL) setRoomPIN:(NSString*)roomPIN RoomISetRoomPIN:(id<VCRoomISetRoomPIN>)roomISetRoomPIN;
	/*!
	 * @param onSetRoomPropertiesResult Callback that is triggered when set properties operation completes.
	 */
	-(BOOL) setRoomProperties:(VCRoomProperties*)roomProperties RoomISetRoomProperties:(id<VCRoomISetRoomProperties>)roomISetRoomProperties;
	/*!
	 * Set show throttle type.
	 * @param room Vidyo room object.
	 * @param t The throttle type.
	 */
	-(void) setShowThrottle:(VCRoomShowThrottle)t;
	/*!
	 * Set show throttle timer interval.
	 * @param room Vidyo room object.
	 * @param seconds The time interval in between shows.
	 */
	-(void) setShowThrottleTimerInterval:(unsigned int)seconds;
	/*!
	 * Set show throttle window size change threshold.
	 * @param room Vidyo room object.
	 * @param percentage The threshold as a percentage of window size change.
	 */
	-(void) setShowThrottleWindowSizeChangeThreshold:(unsigned int)percentage;
	/*!
	 */
	-(BOOL) setSubject:(const char*)subject;
	/*!
	 * Shows statistics for a room.
	 * @param r Vidyo room object.
	 */
	-(void) showStatisticsDialog;
	/*!
	 * Switch room mode to the Lecture mode.
	 * @param room Vidyo room object.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) startLectureMode:(NSString*)requestId;
	/*!
	 * Asynchronously starts recording a conference using the specified recording profile. Must be called on behalf of a moderator. Fails in case another recording is in progress. Calls a callback upon completion.
	 * @param r VidyoRoom object.
	 * @param recordingProfilePrefix Recording profile prefix to start the recording with.
	 * @param onRecordingServiceStartCallback Callback called upon completion.
	 */
	-(BOOL) startRecording:(NSString*)recordingProfilePrefix RoomIStartRecording:(id<VCRoomIStartRecording>)roomIStartRecording;
	/*!
	 * Switch room mode to the Group mode.
	 * @param room Vidyo room object.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) stopLectureMode:(NSString*)requestId;
	/*!
	 * Asynchronously stops recording a conference. Must be called on behalf of a moderator. Fails in case there is no recording in progress. Calls a callback upon completion.
	 * @param r VidyoRoom object.
	 * @param onRecordingServiceStopResultCallback Callback called upon completion.
	 */
	-(BOOL) stopRecording:(id<VCRoomIStopRecording>)roomIStopRecording;
	/*!
	 * This api provides the ability unlock the current room.
	 * @param r VidyoRoom object.
	 * @param onUnlockRoomResult Callback to be triggered for unlock room result.
	 */
	-(BOOL) unlockRoom:(id<VCRoomIUnlockRoom>)roomIUnlockRoom;
	/*!
	 * Each participant can send a moderation request to remove his raised hand to cancel the request to be unmuted.
	 * @param r The VidyoRoom object.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) unraiseHand:(NSString*)requestId;
	/*!
	 * This is a synchronous interface. Application can unregister callback to stop bot participant event notifications.
	 * @param r The VidyoRoom object.
	 */
	-(BOOL) unregisterBotEventListener;
	/*!
	 * UnRegisters callbacks to get notified about conference mode events.
	 * @param r The VidyoRoom object.
	 */
	-(BOOL) unregisterConferenceModeEventListener;
	/*!
	 * Unregisters event listener, application will not receive an event about connection properties changes.
	 * @param r The VidyoRoom object.
	 */
	-(BOOL) unregisterConnectionPropertiesEventListener;
	/*!
	 * UnRegisters callbacks to get notified about host joining or leaving events.
	 * @param r The VidyoRoom object.
	 */
	-(BOOL) unregisterHostEventListener;
	/*!
	 * Unregisters callback for in call events.
	 * @param r The VidyoRoom object.
	 */
	-(BOOL) unregisterInCallEventListener;
	/*!
	 * @param room Vidyo room object.
	 */
	-(BOOL) unregisterLectureModeEventListener;
	/*!
	 * Unregisters message event notifications.
	 * @param r The VidyoRoom object.
	 */
	-(BOOL) unregisterMessageEventListener;
	/*!
	 * Unregister a callback to do not receive moderation commands sent from the server.
	 * @param room Vidyo room object.
	 */
	-(BOOL) unregisterModerationCommandEventListener;
	/*!
	 * @param room Vidyo room object.
	 */
	-(BOOL) unregisterModerationResultEventListener;
	/*!
	 * Unregisters participant event notifications.
	 * @param r The VidyoRoom object.
	 */
	-(BOOL) unregisterParticipantEventListener;
	/*!
	 * Unregisters recorder in call event notifications.
	 * @param r The VidyoRoom object.
	 */
	-(BOOL) unregisterPipEventListener;
	/*!
	 * Unregisters recorder in call event notifications.
	 * @param r The VidyoRoom object.
	 */
	-(BOOL) unregisterRecorderInCallEventListener;
	/*!
	 * Unregisters resource manager event notifications.
	 * @param r The VidyoRoom object.
	 */
	-(BOOL) unregisterResourceManagerEventListener;
	/*!
	 * Unregisters room properties event notifications.
	 * @param r The VidyoRoom object.
	 */
	-(BOOL) unregisterRoomPropertiesEventListener;
	/*!
	 * Unregisters subject event notifications.
	 * @param r The VidyoRoom object.
	 */
	-(BOOL) unregisterSubjectEventListener;
	/*!
	 * .
	 * @param r The VidyoRoom object.
	 */
	-(BOOL) unregisterUnprocessedAudioEventListener;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
	-(NSMutableDictionary<NSString*, VCParticipant*> *)getParticipantsMap;
@end
/*!
 * Represents a remote participant whose selected ranking in a conference has changed. When the selected participant list changes, a set of these objects can be used to represent the differences between the old list and the new list. Each object can indicate a new participant in the list, a participant that is no longer in the list, or a participant that has changed rank within the list.
 */
@interface VCGenerationDiff : NSObject
{
}
	@property int newIndex;
	@property int oldIndex;
	@property VCParticipant* participant;
@end
@interface VCRoleAuthorization : NSObject
{
}
	/*!
	 * hasPassCode set to LMI_TRUE means 'passCode' field contains a valid input.
	 */
	@property BOOL hasPassCode;
	@property NSMutableString* passCode;
@end
/*!
 * Represents the bot info structure.
 */
@interface VCRoomBotInfo : NSObject
{
}
	/*!
	 * Represents the meta data associated with bot in json format string.
	 */
	@property NSMutableString* data;
	/*!
	 * Represents the id associated with bot.
	 */
	@property NSMutableString* id;
	/*!
	 * Represents the name associated with bot.
	 */
	@property NSMutableString* name;
@end
/*!
 * Represents the connection properties for the room, which are based on information from the portal.
 */
@interface VCRoomConnectionProperties : NSObject
{
}
	/*!
	 * Return LMI_TRUE if moderation pin is set otherwise LMI_FALSE.
	 */
	@property BOOL hasModeratorPin;
	/*!
	 * Return LMI_TRUE if room pin is set otherwise LMI_FALSE.
	 */
	@property BOOL hasRoomPin;
	/*!
	 * Return LMI_TRUE if room is lock otherwise LMI_FALSE.
	 */
	@property BOOL isRoomLocked;
	/*!
	 * Return LMI_TRUE if VP9 is enabled otherwise LMI_FALSE.
	 */
	@property BOOL isVp9Enabled;
	/*!
	 * Represents the maximum receive bandwidth.
	 */
	@property unsigned int maxReceiveBandWidth;
	/*!
	 * Represents the maximum send bandwidth.
	 */
	@property unsigned int maxSendBandWidth;
	/*!
	 * Return the maximum room pin length if maximumRoomPinLength is set by default.
	 */
	@property int maximumRoomPinLength;
	/*!
	 * Return the minimum room pin length if minimumRoomPinLength is set by default.
	 */
	@property int minimumRoomPinLength;
	/*!
	 * State of Recording. See enum VidyoRoomRecordingState.
	 */
	@property VCRoomRecordingState recordingState;
	/*!
	 * Name of the room.
	 */
	@property NSMutableString* roomName;
	/*!
	 * State of Webcasting. See enum VidyoRoomWebcastingState.
	 */
	@property VCRoomWebcastingState webcastingState;
@end
/*!
 * It is the event which will be sent to application which register for incall events.
 */
@interface VCRoomInCallEvent : NSObject
{
}
	/*!
	 * It is error code for the event.
	 */
	@property VCRoomInCallEventCode code;
	/*!
	 * It extra information for the event. It is optional and it may depend on type of event.
	 */
	@property NSMutableString* details;
	/*!
	 * This indicate the module to which event belongs to.
	 */
	@property VCRoomInCallEventClass type;
@end
/*!
 * Participant's profile describing the source restrictions and the chat restriction.
 */
@interface VCRoomParticipantProfile : NSObject
{
}
	@property VCRoomProfileControlMode camera;
	@property VCRoomProfileControlMode chat;
	@property VCRoomProfileControlMode microphone;
	@property NSMutableString* userId;
	@property VCRoomProfileControlMode windowShare;
@end
@protocol VCUserIAdvancedSearchRooms
	-(void) onRoomSearchResults:(const char*)searchText SearchResult:(VCUserSearchResult)searchResult RoomInfo:(NSMutableArray*)roomInfo NumRecords:(size_t)numRecords;
@end
@protocol VCUserIAdvancedSearchUsers
	-(void) onUserSearchResults:(const char*)searchText SearchResult:(VCUserSearchResult)searchResult Contacts:(NSMutableArray*)contacts NumRecords:(size_t)numRecords;
@end
@protocol VCUserICreateCall
	-(void) onCallCreated:(VCCall*)call Result:(VCUserCallCreateResult)result CreateToken:(NSString*)createToken;
@end
@protocol VCUserICreateRoomFromId
	-(void) onRoomCreated:(VCRoom*)room Result:(VCUserRoomCreateResult)result CreateToken:(NSString*)createToken;
@end
@protocol VCUserIGetAuthTypes
	-(void) onAuthTypes:(VCUserGetAuthTypesResult)result AuthTypes:(NSMutableArray*)authTypes;
	-(void) onAuthTypesWebProxyCredentialsRequest:(NSMutableString*)webProxyAddress;
@end
@protocol VCUserIGetContact
	-(void) onGetContactResult:(VCContact*)contact Result:(VCUserGetContactResult)result;
@end
@protocol VCUserIGetCurrentRoster
	/*!
	 * Callback that is triggered when getting the contact completes.
	 */
	-(void) onGetCurrentRosterComplete:(NSMutableArray*)roster;
@end
@protocol VCUserIGetFavoriteRooms
	-(void) onFavoriteRoomResults:(VCUserSearchResult)searchResult RoomInfo:(NSMutableArray*)roomInfo;
@end
@protocol VCUserIGetPasswordResetUrl
	-(void) onPasswordResetUrl:(NSMutableString*)passwordResetUrl;
@end
@protocol VCUserIGetRecentRooms
	-(void) onRecentRoomResults:(VCUserSearchResult)searchResult RoomInfo:(NSMutableArray*)roomInfo;
@end
@protocol VCUserIGetRecordingServiceProfiles
	/*!
	 * Callback that is triggered upon completion of VidyoUserGetRecordingServiceProfiles request.
	 */
	-(void) onGetRecordingServiceProfiles:(NSMutableArray*)profiles Prefixes:(NSMutableArray*)prefixes Result:(VCUserRecordingServiceResult)result;
@end
@protocol VCUserILogin
	-(void) onLoginComplete:(VCUserLoginResult)result Secure:(BOOL)secure Capabilities:(VCTenantCapabilities*)capabilities;
	-(void) onLoggedOut:(VCUserLogoutReason)reason;
	-(void) onConnectionStatusChanged:(VCUserConnectionStatusChangedReason)reason;
	/*!
	 * A callback that, upon successful portal authentication, returns tokens (Auth,Jwt,RefreshToken).
	 */
	-(void) onTokenReceived:(NSMutableArray*)tokens;
	-(void) onWebProxyCredentialsRequest:(NSMutableString*)webProxyAddress;
@end
@protocol VCUserIRefreshAccessToken
	/*!
	 * A callback that is triggered upon the completion of an attempt to refresh the access token.
	 */
	-(void) onRefreshAccessToken:(VCUserOperationResult)result;
@end
@protocol VCUserIRegisterCallEventListener
	-(void) onCallCreatedByInvite:(VCCall*)call Inviter:(VCContact*)inviter;
@end
@protocol VCUserIRegisterContactEventListener
	-(void) onUpdateSelf:(VCContact*)contact;
	-(void) onUpdateRosterContact:(VCContact*)contact;
	-(void) onRemoveRosterContact:(NSString*)uri;
@end
@protocol VCUserIRegisterLicenseEventListener
	/*!
	 * Informs about new license received by VidyoUser
	 */
	-(void) onLicenseReceived:(NSString*)licenseKey;
	/*!
	 * Requests the license key that was presumably stored when received via VidyoUserLicenseReceivedCallback
	 */
	-(void) onGetLicenseKey:(NSMutableString*)licenseKey;
@end
@protocol VCUserIRegisterRoomEventListener
	-(void) onRoomCreatedByInvite:(VCRoom*)room Inviter:(VCContact*)inviter Message:(const char*)message;
	-(void) onRoomInviteCancelled:(VCRoomInfo*)roomInfo Message:(const char*)message;
@end
@interface VCUser : NSObject
{
	void* objPtr;
	@public
	id<VCUserIAdvancedSearchRooms> userIAdvancedSearchRooms;
	id<VCUserIAdvancedSearchUsers> userIAdvancedSearchUsers;
	id<VCUserICreateCall> userICreateCall;
	/*!
	 * Finds and existing room with the id specified and provides a new VidyoRoom object in the VidyoUserFeedbackRoomCreated callback.
	 */
	id<VCUserICreateRoomFromId> userICreateRoomFromId;
	/*!
	 * Get the supported authentication types for the user.
	 */
	id<VCUserIGetAuthTypes> userIGetAuthTypes;
	id<VCUserIGetContact> userIGetContact;
	/*!
	 * Gets favorite contacts.
	 */
	id<VCUserIGetCurrentRoster> userIGetCurrentRoster;
	id<VCUserIGetFavoriteRooms> userIGetFavoriteRooms;
	/*!
	 * Get an URL where user can reset his password.
	 */
	id<VCUserIGetPasswordResetUrl> userIGetPasswordResetUrl;
	/*!
	 * Get the recent rooms of the user.
	 */
	id<VCUserIGetRecentRooms> userIGetRecentRooms;
	/*!
	 * Asynchronously retrieves two vectors that describe available recording profiles defined by Recording server configuration. Each element of the first vector (profiles) is a LmiString that contains a description of a recording profile. For example, STANDARD-QUALITY, HIGH-QUALITY, VOICE-ONLY. The second vector (prefixes) contains appropriate profile prefixes. For example, 03, 01, 0. Calls a callback upon completion.
	 */
	id<VCUserIGetRecordingServiceProfiles> userIGetRecordingServiceProfiles;
	id<VCUserILogin> userILogin;
	/*!
	 * Asynchronously sends a request to refresh the access token. The application will receive the token through the onTokenReceived callback.
	 */
	id<VCUserIRefreshAccessToken> userIRefreshAccessToken;
	/*!
	 * Registers to get notified about invite to call events.
	 */
	id<VCUserIRegisterCallEventListener> userIRegisterCallEventListener;
	/*!
	 * Registers to get notified about contact events.
	 */
	id<VCUserIRegisterContactEventListener> userIRegisterContactEventListener;
	/*!
	 * Registers to get notified about license events.
	 */
	id<VCUserIRegisterLicenseEventListener> userIRegisterLicenseEventListener;
	/*!
	 * Registers to get notified about invite to room events.
	 */
	id<VCUserIRegisterRoomEventListener> userIRegisterRoomEventListener;
}
	/*!
	 */
	-(id) init:(VCEndpoint*)endpoint;
	-(void) dealloc;
	/*!
	 */
	-(BOOL) addRosterContact:(NSString*)userId;
	/*!
	 * @param onRoomSearchResults Callback that is triggered when the room search results are ready.
	 */
	-(BOOL) advancedSearchRooms:(NSMutableArray*)fieldSet FieldRelations:(NSMutableArray*)fieldRelations FieldValues:(NSMutableArray*)fieldValues SearchToken:(const char*)searchToken Index:(unsigned int)index PageSize:(unsigned int)pageSize UserIAdvancedSearchRooms:(id<VCUserIAdvancedSearchRooms>)userIAdvancedSearchRooms;
	/*!
	 * @param onUserSearchResults Callback that is triggered when the user search results are ready.
	 */
	-(BOOL) advancedSearchUsers:(NSMutableArray*)fieldSet FieldValues:(NSMutableArray*)fieldValues SearchToken:(const char*)searchToken Index:(unsigned int)index PageSize:(unsigned int)pageSize UserIAdvancedSearchUsers:(id<VCUserIAdvancedSearchUsers>)userIAdvancedSearchUsers;
	/*!
	 */
	-(BOOL) allowSubscriber:(NSString*)userId;
	/*!
	 */
	-(BOOL) blockSubscriber:(NSString*)userId;
	/*!
	 * @param onCallCreated Callback that is triggered when the call creation results are ready.
	 */
	-(BOOL) createCall:(NSString*)userId CreateToken:(NSMutableString*)createToken UserICreateCall:(id<VCUserICreateCall>)userICreateCall;
	/*!
	 * Finds and existing room with the id specified and provides a new VidyoRoom object in the VidyoUserFeedbackRoomCreated callback.
	 * @param onRoomCreated Callback that is triggered when the room creation results are ready.
	 */
	-(BOOL) createRoomFromId:(const char*)id CreateToken:(NSMutableString*)createToken UserICreateRoomFromId:(id<VCUserICreateRoomFromId>)userICreateRoomFromId;
	/*!
	 * Finds a room based on the room key and privdes a new VidyoRoom object in the VidyoUserFeedbackRoomCreated callback.
	 * @param onRoomCreated Callback that is triggered when the room creation results are ready.
	 */
	-(BOOL) createRoomFromKey:(const char*)roomKey CreateToken:(NSMutableString*)createToken UserICreateRoomFromId:(id<VCUserICreateRoomFromId>)userICreateRoomFromId;
	/*!
	 * Gets a room with the id specified and provides a new VidyoRoom object in the VidyoUserFeedbackRoomCreated callback.
	 * @param onRoomCreated Callback that is triggered when the room creation results are ready.
	 */
	-(BOOL) createRoomWithId:(const char*)id CreateToken:(const char*)createToken UserICreateRoomFromId:(id<VCUserICreateRoomFromId>)userICreateRoomFromId;
	/*!
	 * Creates a new scheduled room and provides a new VidyoRoom object in the VidyoUserFeedbackRoomCreated callback.
	 * @param onRoomCreated Callback that is triggered when the room creation results are ready.
	 */
	-(BOOL) createScheduledRoom:(VCEventSchedule*)schedule CreateToken:(NSString*)createToken UserICreateRoomFromId:(id<VCUserICreateRoomFromId>)userICreateRoomFromId;
	/*!
	 * Creates a test call room and provides a new VidyoRoom object in the VidyoUserFeedbackRoomCreated callback.
	 * @param onRoomCreated Callback that is triggered when the room creation results are ready.
	 */
	-(BOOL) createTestCallRoom:(NSMutableString*)createToken UserICreateRoomFromId:(id<VCUserICreateRoomFromId>)userICreateRoomFromId;
	/*!
	 * Creates a new topic room and privdes a new VidyoRoom object in the VidyoUserFeedbackRoomCreated callback.
	 * @param onRoomCreated Callback that is triggered when the room creation results are ready.
	 */
	-(BOOL) createTopicRoom:(const char*)name Description:(const char*)description CreateToken:(NSMutableString*)createToken UserICreateRoomFromId:(id<VCUserICreateRoomFromId>)userICreateRoomFromId;
	/*!
	 * Get the supported authentication types for the user.
	 * @param u The user object to authentication types.
	 * @param host Hostname or the IP address of the server.
	 * @param port Optional port of the server. Default is "5222".
	 * @param serviceType Optional type of the service. Default is "xmpp".
	 * @param onAuthTypes callback.
	 * @param onWebProxyCredentialsRequest Callback that is triggered when the user is behind a web proxy which requires credentials to establish a connection.
	 */
	-(BOOL) getAuthTypes:(const char*)host Port:(unsigned int)port ServiceType:(const char*)serviceType UserIGetAuthTypes:(id<VCUserIGetAuthTypes>)userIGetAuthTypes;
	/*!
	 * @param onGetContactResult Callback that is triggered when the contact search results are ready.
	 */
	-(BOOL) getContact:(NSString*)userId UserIGetContact:(id<VCUserIGetContact>)userIGetContact;
	/*!
	 * Finds a Conversation room and privdes a new VidyoRoom object in the VidyoUserFeedbackRoomCreated callback.
	 * @param onRoomCreated Callback that is triggered when the room creation results are ready.
	 */
	-(BOOL) getConversationRoom:(NSMutableArray*)userIds CreateToken:(NSMutableString*)createToken UserICreateRoomFromId:(id<VCUserICreateRoomFromId>)userICreateRoomFromId;
	/*!
	 * Gets favorite contacts.
	 * @param u The VidyoUser object.
	 * @param onComplete The callback that is triggered when getting favorite contacts completes.
	 */
	-(BOOL) getCurrentRoster:(id<VCUserIGetCurrentRoster>)userIGetCurrentRoster;
	/*!
	 */
	-(VCEndpoint*) getEndpoint;
	/*!
	 * @param index The start index from which the recent rooms are required. A value of '0' represents rooms starting from the beginning. A value of 'n' represents rooms starting from 'n'th record. This is used for paging the response.
	 * @param pageSize The maximum number of room records that can be sent in the response. This is used for paging the response.
	 * @param onFavoriteRoomResults Callback that is triggered when the favorite room search results are ready.
	 */
	-(BOOL) getFavoriteRooms:(unsigned int)index PageSize:(unsigned int)pageSize UserIGetFavoriteRooms:(id<VCUserIGetFavoriteRooms>)userIGetFavoriteRooms;
	/*!
	 */
	-(NSString*) getId;
	/*!
	 * Get an URL where user can reset his password.
	 * @param u The user object.
	 * @param onPasswordResetUrl Callback returns password reset URL.
	 */
	-(BOOL) getPasswordResetUrl:(id<VCUserIGetPasswordResetUrl>)userIGetPasswordResetUrl;
	/*!
	 * Get the recent rooms of the user.
	 * @param u Vidyo user object.
	 * @param index The start index from which the recent rooms are required. A value of '0' represents rooms starting from the beginning. A value of 'n' represents rooms starting from 'n'th record. This is used for paging the response.
	 * @param pageSize The maximum number of room records that can be sent in the response. This is used for paging the response.
	 * @param onRecentRoomResults Callback that is triggered when the recent room search results are ready.
	 */
	-(BOOL) getRecentRooms:(unsigned int)index PageSize:(unsigned int)pageSize UserIGetRecentRooms:(id<VCUserIGetRecentRooms>)userIGetRecentRooms;
	/*!
	 * Asynchronously retrieves two vectors that describe available recording profiles defined by Recording server configuration. Each element of the first vector (profiles) is a LmiString that contains a description of a recording profile. For example, STANDARD-QUALITY, HIGH-QUALITY, VOICE-ONLY. The second vector (prefixes) contains appropriate profile prefixes. For example, 03, 01, 0. Calls a callback upon completion.
	 * @param u The VidyoUser object.
	 * @param onGetRecordingServiceProfiles Callback called upon completion. Can be NULL.
	 */
	-(BOOL) getRecordingServiceProfiles:(id<VCUserIGetRecordingServiceProfiles>)userIGetRecordingServiceProfiles;
	/*!
	 */
	-(NSString*) getWebProxyAddress;
	/*!
	 * Set a flag to invalidates token received via VidyoUserOnTokenReceived callback during logout.
	 */
	-(BOOL) invalidateTokenOnLogout:(BOOL)invalidate;
	/*!
	 * @param u Pointer to the VidyoUser object.
	 * @param username Username of the user logging in.
	 * @param password Password of the user logging in.
	 * @param host Hostname or the IP address of the server.
	 * @param port Optional port of the server. Default is "5222" for xmpp, "443" for wss.
	 * @param serviceType Optional type of the service. Default is "wss".
	 * @param onLoginComplete Callback that is triggered when the user login operation is complete. This could be a successful login or a failure to login due to credentials, hostname, etc.
	 * @param onLoggedOut Callback that is triggered when the user is logged out.
	 * @param onConnectionStatusChanged Callback that is triggered when the user's connection status temporarily changes due to network lag and might be re-established without logging out.
	 * @param onTokenReceived Callback that is triggered when the user receives a token that can be used for subsequent logins. This token can be stored in stead of a password.
	 * @param onWebProxyCredentialsRequest Callback that is triggered when the user is behind a web proxy which requires credentials to establish a connection.
	 */
	-(BOOL) login:(const char*)username Password:(const char*)password Host:(const char*)host Port:(unsigned int)port ServiceType:(const char*)serviceType UserILogin:(id<VCUserILogin>)userILogin;
	/*!
	 * @param u Pointer to the VidyoUser object.
	 * @param displayName Display name of the guest user.
	 * @param roomKey key to the room the guest user is attempting to join.
	 * @param host Hostname or the IP address of the server.
	 * @param port Optional port of the server. Default is "5222" for xmpp, "443" for wss.
	 * @param serviceType Optional type of the service. Default is "wss".
	 * @param onLoginComplete Callback that is triggered when the user login operation is complete. This could be a successful login or a failure to login due to credentials, hostname, etc.
	 * @param onLoggedOut Callback that is triggered when the user is logged out.
	 * @param onConnectionStatusChanged Callback that is triggered when the user's connection status temporarily changes due to network lag and might be re-established without logging out.
	 * @param onTokenReceived Callback that is triggered when the user receives a token that can be used for subsequent logins. This token can be stored in stead of a password.
	 * @param onWebProxyCredentialsRequest Callback that is triggered when the user is behind a web proxy which requires credentials to establish a connection.
	 */
	-(BOOL) loginAsGuest:(const char*)displayName RoomKey:(const char*)roomKey Host:(const char*)host Port:(unsigned int)port ServiceType:(const char*)serviceType UserILogin:(id<VCUserILogin>)userILogin;
	/*!
	 * @param u Pointer to the VidyoUser object.
	 * @param accessToken The short-term token used to re-login.
	 * @param host Hostname or the IP address of the server.
	 * @param port Optional port of the server. Default is "5222" for xmpp, "443" for wss.
	 * @param serviceType Optional type of the service. Default is "wss".
	 * @param onLoginComplete Callback that is triggered when the user login operation is complete. This could be a successful login or a failure to login due to credentials, hostname, etc.
	 * @param onLoggedOut Callback that is triggered when the user is logged out.
	 * @param onConnectionStatusChanged Callback that is triggered when the user's connection status temporarily changes due to network lag and might be re-established without logging out.
	 * @param onTokenReceived Callback that is triggered when the user receives a token that can be used for subsequent logins. This token can be stored in stead of a password.
	 * @param onWebProxyCredentialsRequest Callback that is triggered when the user is behind a web proxy which requires credentials to establish a connection.
	 */
	-(BOOL) loginWithAccessToken:(const char*)accessToken Host:(const char*)host Port:(unsigned int)port ServiceType:(const char*)serviceType UserILogin:(id<VCUserILogin>)userILogin;
	/*!
	 * @param u Pointer to the VidyoUser object.
	 * @param certificate The certificate used to login.
	 * @param host Hostname or the IP address of the server.
	 * @param port Optional port of the server. Default is "5222".
	 * @param serviceType Optional type of the service. Default is "xmpp".
	 * @param onLoginComplete Callback that is triggered when the user login operation is complete. This could be a successful login or a failure to login due to credentials, hostname, etc.
	 * @param onLoggedOut Callback that is triggered when the user is logged out.
	 * @param onConnectionStatusChanged Callback that is triggered when the user's connection status temporarily changes due to network lag and might be re-established without logging out.
	 * @param onTokenReceived Callback that is triggered when the user receives a token that can be used for subsequent logins. This token can be stored in stead of a password.
	 * @param onWebProxyCredentialsRequest Callback that is triggered when the user is behind a web proxy which requires credentials to establish a connection.
	 */
	-(BOOL) loginWithCAC:(const char*)certificate Host:(const char*)host Port:(unsigned int)port ServiceType:(const char*)serviceType UserILogin:(id<VCUserILogin>)userILogin;
	/*!
	 * This API is used to login to portal with provision extended data.
	 * @param u Pointer to the VidyoUser object.
	 * @param extData The provision extended data used as authorization token for login.
	 * @param ebMode Specifiy the endpoint behavior mode.
	 * @param host Hostname or the IP address of the server.
	 * @param port Optional port of the server.
	 * @param onLoginComplete Callback that is triggered when the user login operation is complete. This could be a successful login or a failure to login due to credentials, hostname, etc.
	 * @param onLoggedOut Callback that is triggered when the user is logged out.
	 * @param onConnectionStatusChanged Callback that is triggered when the user's connection status temporarily changes due to network lag and might be re-established without logging out.
	 * @param onTokenReceived Callback that is triggered when the user receives a token that can be used for subsequent logins. This token can be stored in stead of a password.
	 * @param onWebProxyCredentialsRequest Callback that is triggered when the user is behind a web proxy which requires credentials to establish a connection.
	 */
	-(BOOL) loginWithExtData:(const char*)extData EbMode:(const char*)ebMode Host:(const char*)host Port:(unsigned int)port UserILogin:(id<VCUserILogin>)userILogin;
	/*!
	 * @param u Pointer to the VidyoUser object.
	 * @param refreshToken The short-term token used to re-login.
	 * @param host Hostname or the IP address of the server.
	 * @param port Optional port of the server. Default is "5222" for xmpp, "443" for wss.
	 * @param serviceType Optional type of the service. Default is "wss".
	 * @param onLoginComplete Callback that is triggered when the user login operation is complete. This could be a successful login or a failure to login due to credentials, hostname, etc.
	 * @param onLoggedOut Callback that is triggered when the user is logged out.
	 * @param onConnectionStatusChanged Callback that is triggered when the user's connection status temporarily changes due to network lag and might be re-established without logging out.
	 * @param onTokenReceived Callback that is triggered when the user receives a token that can be used for subsequent logins. This token can be stored in stead of a password.
	 * @param onWebProxyCredentialsRequest Callback that is triggered when the user is behind a web proxy which requires credentials to establish a connection.
	 */
	-(BOOL) loginWithRefreshToken:(const char*)refreshToken Host:(const char*)host Port:(unsigned int)port ServiceType:(const char*)serviceType UserILogin:(id<VCUserILogin>)userILogin;
	/*!
	 * @param u Pointer to the VidyoUser object.
	 * @param key The SAML key or assertion recieved from the Portal/IDP.
	 * @param host Hostname or the IP address of the server.
	 * @param port Optional port of the server. Default is "5222".
	 * @param serviceType Optional type of the service. Default is "xmpp".
	 * @param onLoginComplete Callback that is triggered when the user login operation is complete. This could be a successful login or a failure to login due to credentials, hostname, etc.
	 * @param onLoggedOut Callback that is triggered when the user is logged out.
	 * @param onConnectionStatusChanged Callback that is triggered when the user's connection status temporarily changes due to network lag and might be re-established without logging out.
	 * @param onTokenReceived Callback that is triggered when the user receives a token that can be used for subsequent logins. This token can be stored in stead of a password.
	 * @param onWebProxyCredentialsRequest Callback that is triggered when the user is behind a web proxy which requires credentials to establish a connection.
	 */
	-(BOOL) loginWithSAML:(const char*)key Host:(const char*)host Port:(unsigned int)port ServiceType:(const char*)serviceType UserILogin:(id<VCUserILogin>)userILogin;
	/*!
	 * @param u Pointer to the VidyoUser object.
	 * @param provisionToken The provision token used to login.
	 * @param host Hostname or the IP address of the server.
	 * @param port Optional port of the server. Default is "5222" for xmpp, "443" for wss.
	 * @param serviceType Optional type of the service. Default is "wss".
	 * @param onLoginComplete Callback that is triggered when the user login operation is complete. This could be a successful login or a failure to login due to credentials, hostname, etc.
	 * @param onLoggedOut Callback that is triggered when the user is logged out.
	 * @param onConnectionStatusChanged Callback that is triggered when the user's connection status temporarily changes due to network lag and might be re-established without logging out.
	 * @param onTokenReceived Callback that is triggered when the user receives a token that can be used for subsequent logins. This token can be stored in stead of a password.
	 * @param onWebProxyCredentialsRequest Callback that is triggered when the user is behind a web proxy which requires credentials to establish a connection.
	 */
	-(BOOL) loginWithTenantToken:(const char*)provisionToken Host:(const char*)host Port:(unsigned int)port ServiceType:(const char*)serviceType UserILogin:(id<VCUserILogin>)userILogin;
	/*!
	 */
	-(BOOL) logout;
	/*!
	 * Pause or resume update notifications.
	 * @param u The user object.
	 * @param pauseUpdateNotification Set to true to resume update notificaiton, set to false to stop udpate notificaiton
	 */
	-(BOOL) pauseUpdateNotification:(BOOL)pauseUpdateNotification;
	/*!
	 * Asynchronously sends a request to refresh the access token. The application will receive the token through the onTokenReceived callback.
	 * @param u The VidyoUser object.
	 * @param onRefreshAccessToken A callback that is triggered upon the completion of the request with actual result.
	 */
	-(BOOL) refreshAccessToken:(id<VCUserIRefreshAccessToken>)userIRefreshAccessToken;
	/*!
	 * Registers to get notified about invite to call events.
	 * @param u The VidyoUser object.
	 * @param onCallCreatedByInvite Callback that is triggered when the user is being invited to a call.
	 */
	-(BOOL) registerCallEventListener:(id<VCUserIRegisterCallEventListener>)userIRegisterCallEventListener;
	/*!
	 * Registers to get notified about contact events.
	 * @param u The VidyoUser object.
	 * @param onUpdateSelf Callback that is triggered when the users' own contact information changes.
	 * @param onUpdateRosterContact Callback that is triggered when a roster contact is updated.
	 * @param onRemoveRosterContact Callback that is triggered when a contact is removed from the roster .
	 */
	-(BOOL) registerContactEventListener:(id<VCUserIRegisterContactEventListener>)userIRegisterContactEventListener;
	/*!
	 * Registers to get notified about license events.
	 * @param u The VidyoUser object.
	 * @param onLicenseReceived Callback that is triggered when the new license is received from the server.
	 * @param onGetLicenseKey Callback that is triggered when the user needs a previousely received license key.
	 */
	-(BOOL) registerLicenseEventListener:(id<VCUserIRegisterLicenseEventListener>)userIRegisterLicenseEventListener;
	/*!
	 * Registers to get notified about invite to room events.
	 * @param u The VidyoUser object.
	 * @param onRoomCreatedByInvite Callback that is triggered when the user is being invited to a room.
	 * @param onRoomInviteCancelled .
	 */
	-(BOOL) registerRoomEventListener:(id<VCUserIRegisterRoomEventListener>)userIRegisterRoomEventListener;
	/*!
	 */
	-(BOOL) removeRosterContact:(NSString*)userId;
	/*!
	 * @param onRoomSearchResults Callback that is triggered when the room search results are ready.
	 */
	-(BOOL) searchConversationRooms:(const char*)searchText Index:(unsigned int)index PageSize:(unsigned int)pageSize UserIAdvancedSearchRooms:(id<VCUserIAdvancedSearchRooms>)userIAdvancedSearchRooms;
	/*!
	 * @param onRoomSearchResults Callback that is triggered when the room search results are ready.
	 */
	-(BOOL) searchRooms:(const char*)searchText Index:(unsigned int)index PageSize:(unsigned int)pageSize UserIAdvancedSearchRooms:(id<VCUserIAdvancedSearchRooms>)userIAdvancedSearchRooms;
	/*!
	 * @param onRoomSearchResults Callback that is triggered when the room search results are ready.
	 */
	-(BOOL) searchRoomsWithName:(const char*)searchText Index:(unsigned int)index PageSize:(unsigned int)pageSize UserIAdvancedSearchRooms:(id<VCUserIAdvancedSearchRooms>)userIAdvancedSearchRooms;
	/*!
	 * @param onRoomSearchResults Callback that is triggered when the room search results are ready.
	 */
	-(BOOL) searchRoomsWithOwner:(const char*)searchText Index:(unsigned int)index PageSize:(unsigned int)pageSize UserIAdvancedSearchRooms:(id<VCUserIAdvancedSearchRooms>)userIAdvancedSearchRooms;
	/*!
	 * @param onRoomSearchResults Callback that is triggered when the room search results are ready.
	 */
	-(BOOL) searchRoomsWithSubject:(const char*)searchText Index:(unsigned int)index PageSize:(unsigned int)pageSize UserIAdvancedSearchRooms:(id<VCUserIAdvancedSearchRooms>)userIAdvancedSearchRooms;
	/*!
	 * @param onRoomSearchResults Callback that is triggered when the room search results are ready.
	 */
	-(BOOL) searchTopicRooms:(const char*)searchText Index:(unsigned int)index PageSize:(unsigned int)pageSize UserIAdvancedSearchRooms:(id<VCUserIAdvancedSearchRooms>)userIAdvancedSearchRooms;
	/*!
	 * @param onUserSearchResults Callback that is triggered when the user search results are ready.
	 */
	-(BOOL) searchUsers:(const char*)searchText Index:(unsigned int)index PageSize:(unsigned int)pageSize UserIAdvancedSearchUsers:(id<VCUserIAdvancedSearchUsers>)userIAdvancedSearchUsers;
	/*!
	 * @param ca The contents of the Certificate Authority file. Note: If the string 'default' is passed here, VidyoUser will use a built-in Certificate Authroity bundle.
	 * @param caFilePath The full path Certificate Authority file.
	 * @param caDir The full path to the directory containing Certificate Authority files.
	 */
	-(void) setCA:(const char*)ca CaFilePath:(const char*)caFilePath CaDir:(const char*)caDir;
	/*!
	 * @param displayName The maximum length of the display name is 256 characters.
	 */
	-(BOOL) setDisplayName:(const char*)displayName;
	/*!
	 * @param enable Enable the tranport.
	 */
	-(void) setTCPTransport:(BOOL)enable;
	/*!
	 * @param enable Enable the tranport.
	 */
	-(void) setUDPTransport:(BOOL)enable;
	/*!
	 */
	-(void) setWebProxyAddressCredentials:(const char*)proxyAddress Username:(const char*)username Password:(const char*)password;
	/*!
	 * @param enable Enable the tranport.
	 */
	-(void) setWebProxyTransport:(BOOL)enable;
	/*!
	 * Enable the use of WebProxy Transport with provided web proxy server address.
	 * @param u The VidyoUser object.
	 * @param name The name of web proxy server, it may also may be prefixed by a scheme ('http://proxy.company.com')
	 * @param port The port that web proxy server is running on
	 */
	-(void) setWebProxyTransportAddress:(NSString*)name Port:(unsigned int)port;
	/*!
	 * Unregisters call event notifications.
	 * @param u The VidyoUser object.
	 */
	-(BOOL) unregisterCallEventListener;
	/*!
	 * Unregisters contact event notifications.
	 * @param u The VidyoUser object.
	 */
	-(BOOL) unregisterContactEventListener;
	/*!
	 * Unregisters license event notifications.
	 * @param u The VidyoUser object.
	 */
	-(BOOL) unregisterLicenseEventListener;
	/*!
	 * Unregisters room event notifications.
	 * @param u The VidyoUser object.
	 */
	-(BOOL) unregisterRoomEventListener;
	/*!
	 */
	-(BOOL) updatePresence:(VCContactPresenceState)state Status:(const char*)status;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
/*!
 * Represents the connection tenant capabilities for the user, which are based on information from the portal.
 */
@interface VCTenantCapabilities : NSObject
{
}
	/*!
	 * Vector of VidyoUserLoginInfo.
	 */
	@property NSMutableArray* LoginAttemptInfo;
	/*!
	 * Address of Web Socket Gateway microservice. This information is valid only when WSGMicroservice is enabled
	 */
	@property NSMutableString* WSGMicroserviceAddress;
	/*!
	 * Indicates whether Breakout Room is enabled on the backend.
	 */
	@property BOOL brEnabled;
	/*!
	 * URL to change the password at the backend.
	 */
	@property NSMutableString* changePasswordUrl;
	/*!
	 * endpoint behavior
	 */
	@property NSMutableArray* endpointBehavior;
	/*!
	 * Indicates whether Closed Captioning is enabled on the backend.
	 */
	@property BOOL isCcEnabled;
	/*!
	 * indicates if the room moderation from client side is supported on the backend.
	 */
	@property BOOL isClientSideRoomModerationEnabled;
	/*!
	 * indicates if creation of public rooms is enabled on the backend.
	 */
	@property BOOL isCreatePublicRoomEnabled;
	/*!
	 * indicates if the guest login is supported on the backend.
	 */
	@property BOOL isGuestEnabled;
	/*!
	 * indicates if the login banner is enabled on the backend.
	 */
	@property BOOL isLoginBannerEnabled;
	/*!
	 * indicates if the Opus Audio codec is enabled on the backend.
	 */
	@property BOOL isOpusAudioEnabled;
	/*!
	 * indicates if personal room is enabled on the backend.
	 */
	@property BOOL isPersonalRoomEnabled;
	/*!
	 * indicates if private chat is enabled on the backend.
	 */
	@property BOOL isPrivateChatEnabled;
	/*!
	 * indicates if public chat is enabled on the backend.
	 */
	@property BOOL isPublicChatEnabled;
	/*!
	 * indicates if the room moderation is supported on the backend.
	 */
	@property BOOL isRoomModerationEnabled;
	/*!
	 * indicates if the creation of a scheduled meeting room is supported on the backend.
	 */
	@property BOOL isScheduledRoomEnabled;
	/*!
	 * indicates if the SDK 220 is enabled on the router.
	 */
	@property BOOL isSdk220Enabled;
	/*!
	 * indicates if test call is enabled on the backend.
	 */
	@property BOOL isTestCallEnabled;
	/*!
	 * indicates if TytoCare is enabled.
	 */
	@property BOOL isTytoCareEnabled;
	/*!
	 * Indicates whether VP9 is enabled on the backend.
	 */
	@property BOOL isVP9Enabled;
	/*!
	 * Indicates if Web Socket Gateway is enabled.
	 */
	@property BOOL isWSGMicroserviceEnabled;
	/*!
	 * indicates if the welcome banner is enabled on the backend.
	 */
	@property BOOL isWelcomeBannerEnabled;
	/*!
	 * Login banner text configured at the backend.
	 */
	@property NSMutableString* loginBannerData;
	/*!
	 * Represents the maximum receive bandwidth.
	 */
	@property unsigned int maxReceiveBandWidth;
	/*!
	 * Represents the maximum send bandwidth.
	 */
	@property unsigned int maxSendBandWidth;
	/*!
	 * represents the maximum room pin length required by the backend.
	 */
	@property int maximumRoomPinLength;
	/*!
	 * represents the minimum room pin length required by the backend.
	 */
	@property int minimumRoomPinLength;
	/*!
	 * Welcome banner text configured at the backend.
	 */
	@property NSMutableString* welcomeBannerData;
@end
/*!
 * Represents the authentication information the server supported.
 */
@interface VCUserAuthenticationInfo : NSObject
{
}
	@property VCUserAuthType authType;
	@property VCProperty* property;
@end
/*!
 * Represents the login attempt information fro the user.
 */
@interface VCUserLoginInfo : NSObject
{
}
	/*!
	 * indicates wether the login attempt was sucessful or a failure.
	 */
	@property NSMutableString* result;
	/*!
	 * The ip address from which the login was initiated
	 */
	@property NSMutableString* sourceIp;
	/*!
	 * The time at which the login was initiated
	 */
	@property NSMutableString* timestamp;
@end
/*!
 * Represents VidyoUser token info.
 */
@interface VCUserTokenInfo : NSObject
{
}
	/*!
	 * Token value.
	 */
	@property NSMutableString* token;
	/*!
	 * Token Type.
	 */
	@property VCUserTokenType tokenType;
@end
