//
//	VidyoMeeting_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoMeetingAttendee_Objc.h"
@class VCMeeting;
/*!
 * @enum This type indicates the result of an attempt to create a meeting.
 * @constant VCMeetingActionResultOk The meeting was created successfully.
 * @constant VCMeetingActionResultNoRecord Could not find an existing record to create the meeting object from.
 * @constant VCMeetingActionResultNoResponse The calendar resource did not respond in a reasonable amount of time for the intended action.
 * @constant VCMeetingActionResultUnauthorized The user is not allowed to create a meeting.
 * @constant VCMeetingActionResultMiscLocalError The server is rejecting the request to perform an action on the meeting due to some miscellaneous problem with the request.
 * @constant VCMeetingActionResultMiscRemoteError The server is rejecting the request to perform an action on the meeting due to some miscellaneous problem of its own.
 */
typedef NS_ENUM(NSInteger, VCMeetingActionResult) {
	VCMeetingActionResultOk,
	VCMeetingActionResultNoRecord,
	VCMeetingActionResultNoResponse,
	VCMeetingActionResultUnauthorized,
	VCMeetingActionResultMiscLocalError,
	VCMeetingActionResultMiscRemoteError
};
/*!
 * @enum This type indicates the result of a search for a meeting(s).
 * @constant VCMeetingAttendeesSearchResultOk The search operation was successful.
 * @constant VCMeetingAttendeesSearchResultIndexOutOfRange Starting index is beyond number of result records.
 * @constant VCMeetingAttendeesSearchResultNoRecords No records found for the search.
 * @constant VCMeetingAttendeesSearchResultNoResponse The search result failed due to request timeout.
 * @constant VCMeetingAttendeesSearchResultMiscLocalError The search result failed due to some miscellaneous local problem.
 * @constant VCMeetingAttendeesSearchResultMiscRemoteError The search result failed due to some miscellaneous remote problem.
 */
typedef NS_ENUM(NSInteger, VCMeetingAttendeesSearchResult) {
	VCMeetingAttendeesSearchResultOk,
	VCMeetingAttendeesSearchResultIndexOutOfRange,
	VCMeetingAttendeesSearchResultNoRecords,
	VCMeetingAttendeesSearchResultNoResponse,
	VCMeetingAttendeesSearchResultMiscLocalError,
	VCMeetingAttendeesSearchResultMiscRemoteError
};
@protocol VCIMeetingFeedback
@optional

	/*!
	 * <p>Provides results from a request to retrieve MeetingAttendees from the VidyoMeetingGetAttendees method call. </p> <p/> <p>Triggered by: VidyoMeetingGetAttendees </p>
	 */
	-(void) getMeetingAttendeeResults:(VCMeeting*)meeting AttendeeList:(NSMutableArray*)attendeeList SearchResult:(VCMeetingAttendeesSearchResult)searchResult CurrentIndex:(unsigned int)currentIndex NumRecords:(unsigned int)numRecords;
@end
@interface VCMeetingFeedback : NSObject<VCIMeetingFeedback>
{
	void* objPtr;
}
	-(id) init;
	-(void) dealloc;
	-(void*)getObjectPtr;
@end
/*!
 * Represents a meeting and all the related attributes.
 */
@interface VCMeeting : NSObject
{
	void* objPtr;
}
	/*!
	 * Body contents for the meeting.
	 */
	@property NSMutableString* body;
	/*!
	 * Date and time that the meeting is scheduled for
	 */
	@property NSMutableString* endDateTime;
	/*!
	 * Unique id that identifies a conference meeting at the service which the meeting is created through. This id must also be unique for each individual meeting within a recurring series
	 */
	@property NSMutableString* id;
	/*!
	 * Indicates whether the meeting contains Vidyo specific meeting information or not.
	 */
	@property BOOL isVidyoMeeting;
	/*!
	 * Subject for the meeting.
	 */
	@property NSMutableString* location;
	/*!
	 * Count of attendees for the meeting.
	 */
	@property int numberOfAttendees;
	/*!
	 * Email for owner the meeting.
	 */
	@property NSMutableString* ownerEmail;
	/*!
	 * Owner name for the meeting.
	 */
	@property NSMutableString* ownerName;
	/*!
	 * Date and time that the meeting is scheduled for
	 */
	@property NSMutableString* startDateTime;
	/*!
	 * Subject for the meeting.
	 */
	@property NSMutableString* subject;
	/*!
	 * Contains key information (URL, Room JID, etc) for the Vidyo room that the meeting is being held in if the meeting type is VIDYO_MEETING_TYPE_VIDYO. Otherwise it contains an empty string.
	 */
	@property NSMutableString* vidyoMeetingRoomLink;
	-(void) dealloc;
	/*!
	 * <p>Retrieve attendees for the meeting using an index and a page size </p> <p/> <p>Results will be returned through the feedback : </p> <p>- VidyoMeetingFeedbackGetMeetingAttendeeResults </p>
	 * @param m Meeting to retrieve attendees from
	 * @param index Zero based index of the starting record in the retrieval results, to use when returning the callback data.
	 * @param pageSize Number of records to return in the callback results, based off of the starting record index argument. NOTE... A value of zero will return all records starting from the index
	 */
	-(BOOL) getAttendees:(unsigned int)index PageSize:(unsigned int)pageSize;
	/*!
	 * Retrieve up to 2K bytes of body data from a Vidyo meeting
	 */
	-(NSString*) getBody;
	/*!
	 */
	-(NSString*) getEndDateTime;
	/*!
	 */
	-(NSString*) getId;
	/*!
	 */
	-(BOOL) getIsVidyoMeeting;
	/*!
	 */
	-(NSString*) getLocation;
	/*!
	 * @param m VidyoMeeting object instance to retrieve value from
	 */
	-(int) getNumberOfAttendees;
	/*!
	 */
	-(NSString*) getOwnerEmail;
	/*!
	 */
	-(NSString*) getOwnerName;
	/*!
	 */
	-(NSString*) getStartDateTime;
	/*!
	 */
	-(NSString*) getSubject;
	/*!
	 */
	-(NSString*) getVidyoMeetingRoomLink;
	/*!
	 * To retrieve entire body from a Vidyo meeting
	 */
	-(NSString*) retrieveBody;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
