//
//	VidyoRemoteWindowShare_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoLocalRenderer_Objc.h"
#import "VidyoParticipant_Objc.h"
#import "VidyoVideoFrame_Objc.h"
@protocol VCRemoteWindowShareIRegisterFrameEventListener
	/*!
	 * Callback that is triggered each time when we get a remote window share frame.
	 */
	-(void) onRemoteWindowShareFrame:(VCParticipant*)participant VideoFrame:(VCVideoFrame*)videoFrame;
@end
/*!
 * This object represents a window share which belongs to the remote participant.
 */
@interface VCRemoteWindowShare : NSObject
{
	void* objPtr;
	@public
	/*!
	 * Registers to get notified about new remote window share frame.
	 */
	id<VCRemoteWindowShareIRegisterFrameEventListener> remoteWindowShareIRegisterFrameEventListener;
}
	/*!
	 * Unique ID.
	 */
	@property NSMutableString* id;
	/*!
	 * Name.
	 */
	@property NSMutableString* name;
	-(void) dealloc;
	/*!
	 * @param w The VidyoRemoteWindowShare object.
	 */
	-(long) addToLocalRenderer:(VCLocalRenderer*)renderer;
	/*!
	 * Gets the unique ID of the window share.
	 * @param w The VidyoRemoteWindowShare object.
	 */
	-(NSString*) getId;
	/*!
	 * Gets the name of the window share.
	 * @param w The VidyoRemoteWindowShare object.
	 */
	-(NSString*) getName;
	/*!
	 * Registers to get notified about new remote window share frame.
	 * @param w The VidyoRemoteWindowShare object.
	 * @param onFrame Callback that is triggered each time when we get a remote window share frame.
	 */
	-(BOOL) registerFrameEventListener:(id<VCRemoteWindowShareIRegisterFrameEventListener>)remoteWindowShareIRegisterFrameEventListener;
	/*!
	 * @param w The VidyoRemoteWindowShare object.
	 */
	-(BOOL) removeFromLocalRenderer:(VCLocalRenderer*)renderer;
	/*!
	 * @param w The VidyoRemoteWindowShare object.
	 */
	-(BOOL) setPositionInLocalRenderer:(VCLocalRenderer*)localRenderer X:(int)x Y:(int)y Width:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval;
	/*!
	 * Unregisters remote window share frame notifications.
	 * @param w The VidyoRemoteWindowShare object.
	 */
	-(BOOL) unregisterFrameEventListener;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
