// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class CameraControlCapabilitiesFactory
	{
		public static CameraControlCapabilities Create()
		{
			return new CameraControlCapabilities(IntPtr.Zero);
		}
		public static void Destroy(CameraControlCapabilities obj)
		{
		}
	}
	/// <summary>
	/// Represents the capability of a camera control.
	/// </summary>
	public class CameraControlCapabilities {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoCameraControlCapabilities reference.
		public IntPtr GetObjectPtr() {

			VidyoCameraControlCapabilitiesSethasPhotoCaptureNative(objPtr, hasPhotoCapture);
			VidyoCameraControlCapabilitiesSethasPresetSupportNative(objPtr, hasPresetSupport);
			VidyoCameraControlCapabilitiesSethasViscaSupportNative(objPtr, hasViscaSupport);
			VidyoCameraControlCapabilitiesSetpanTiltHasContinuousMoveNative(objPtr, panTiltHasContinuousMove);
			VidyoCameraControlCapabilitiesSetpanTiltHasNudgeNative(objPtr, panTiltHasNudge);
			VidyoCameraControlCapabilitiesSetpanTiltHasRubberBandNative(objPtr, panTiltHasRubberBand);
			VidyoCameraControlCapabilitiesSetzoomHasNudgeNative(objPtr, zoomHasNudge);
			VidyoCameraControlCapabilitiesSetzoomHasRubberBandNative(objPtr, zoomHasRubberBand);
			VidyoCameraControlCapabilitiesSetzooomHasContinuousMoveNative(objPtr, zooomHasContinuousMove);

			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoCameraControlCapabilitiesGethasPhotoCaptureNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoCameraControlCapabilitiesSethasPhotoCaptureNative(IntPtr obj, Boolean hasPhotoCapture);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoCameraControlCapabilitiesGethasPresetSupportNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoCameraControlCapabilitiesSethasPresetSupportNative(IntPtr obj, Boolean hasPresetSupport);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoCameraControlCapabilitiesGethasViscaSupportNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoCameraControlCapabilitiesSethasViscaSupportNative(IntPtr obj, Boolean hasViscaSupport);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoCameraControlCapabilitiesGetpanTiltHasContinuousMoveNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoCameraControlCapabilitiesSetpanTiltHasContinuousMoveNative(IntPtr obj, Boolean panTiltHasContinuousMove);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoCameraControlCapabilitiesGetpanTiltHasNudgeNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoCameraControlCapabilitiesSetpanTiltHasNudgeNative(IntPtr obj, Boolean panTiltHasNudge);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoCameraControlCapabilitiesGetpanTiltHasRubberBandNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoCameraControlCapabilitiesSetpanTiltHasRubberBandNative(IntPtr obj, Boolean panTiltHasRubberBand);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoCameraControlCapabilitiesGetzoomHasNudgeNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoCameraControlCapabilitiesSetzoomHasNudgeNative(IntPtr obj, Boolean zoomHasNudge);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoCameraControlCapabilitiesGetzoomHasRubberBandNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoCameraControlCapabilitiesSetzoomHasRubberBandNative(IntPtr obj, Boolean zoomHasRubberBand);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoCameraControlCapabilitiesGetzooomHasContinuousMoveNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoCameraControlCapabilitiesSetzooomHasContinuousMoveNative(IntPtr obj, Boolean zooomHasContinuousMove);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoCameraControlCapabilitiesConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoCameraControlCapabilitiesConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoCameraControlCapabilitiesDestructNative(IntPtr obj);

		/// <summary>
		/// Represents the enumeration of camera control action.
		/// </summary>
		public enum CameraControlAction {
			/// <summary>Start control action for continuous move.</summary>
			CameracontrolactionStart,
			/// <summary>Stop contraol action for stopping the move.</summary>
			CameracontrolactionStop,
			/// <summary>Nudge control action for move the camera to a direction.</summary>
			CameracontrolactionNudge,
			/// <summary>Visca contraol action for sending visca command.</summary>
			CameracontrolactionVisca,
			/// <summary>Preset control action for sending the preset index.</summary>
			CameracontrolactionPreset
		}
		/// <summary>
		/// The camera control direction.
		/// </summary>
		public enum CameraControlDirection {
			/// <summary></summary>
			CameracontroldirectionPanLeft,
			/// <summary></summary>
			CameracontroldirectionPanRight,
			/// <summary></summary>
			CameracontroldirectionTiltUp,
			/// <summary></summary>
			CameracontroldirectionTiltDown,
			/// <summary></summary>
			CameracontroldirectionZoomIn,
			/// <summary></summary>
			CameracontroldirectionZoomOut,
			/// <summary></summary>
			CameracontroldirectionNone
		}
		/// <summary>
		/// 
		/// </summary>
		public Boolean hasPhotoCapture;
		/// <summary>
		/// Camera supports Presets.
		/// </summary>
		public Boolean hasPresetSupport;
		/// <summary>
		/// Camera supports VISCA Protocol.
		/// </summary>
		public Boolean hasViscaSupport;
		/// <summary>
		/// 
		/// </summary>
		public Boolean panTiltHasContinuousMove;
		/// <summary>
		/// 
		/// </summary>
		public Boolean panTiltHasNudge;
		/// <summary>
		/// 
		/// </summary>
		public Boolean panTiltHasRubberBand;
		/// <summary>
		/// 
		/// </summary>
		public Boolean zoomHasNudge;
		/// <summary>
		/// 
		/// </summary>
		public Boolean zoomHasRubberBand;
		/// <summary>
		/// 
		/// </summary>
		public Boolean zooomHasContinuousMove;
		public CameraControlCapabilities(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoCameraControlCapabilitiesConstructDefaultNative();
			}
			else {
				objPtr = VidyoCameraControlCapabilitiesConstructCopyNative(obj);
			}

			hasPhotoCapture = VidyoCameraControlCapabilitiesGethasPhotoCaptureNative(objPtr);
			hasPresetSupport = VidyoCameraControlCapabilitiesGethasPresetSupportNative(objPtr);
			hasViscaSupport = VidyoCameraControlCapabilitiesGethasViscaSupportNative(objPtr);
			panTiltHasContinuousMove = VidyoCameraControlCapabilitiesGetpanTiltHasContinuousMoveNative(objPtr);
			panTiltHasNudge = VidyoCameraControlCapabilitiesGetpanTiltHasNudgeNative(objPtr);
			panTiltHasRubberBand = VidyoCameraControlCapabilitiesGetpanTiltHasRubberBandNative(objPtr);
			zoomHasNudge = VidyoCameraControlCapabilitiesGetzoomHasNudgeNative(objPtr);
			zoomHasRubberBand = VidyoCameraControlCapabilitiesGetzoomHasRubberBandNative(objPtr);
			zooomHasContinuousMove = VidyoCameraControlCapabilitiesGetzooomHasContinuousMoveNative(objPtr);
		}
		~CameraControlCapabilities() {
			VidyoCameraControlCapabilitiesDestructNative(objPtr);
		 }
	};
}
