// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class MeetingInfoFactory
	{
		public static MeetingInfo Create()
		{
			return new MeetingInfo(IntPtr.Zero);
		}
		public static void Destroy(MeetingInfo obj)
		{
		}
	}
	/// <summary>
	/// descriptive details of a meeting.
	/// </summary>
	public class MeetingInfo {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoMeetingInfo reference.
		public IntPtr GetObjectPtr() {
			IntPtr nAttendees = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * attendees.Count);
			int nAttendeesSize = 0;
			IntPtr nBody = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(body ?? string.Empty);
			IntPtr nEndDateTime = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(endDateTime ?? string.Empty);
			IntPtr nId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(id ?? string.Empty);
			IntPtr nLocation = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(location ?? string.Empty);
			IntPtr nOwnerEmail = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(ownerEmail ?? string.Empty);
			IntPtr nOwnerName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(ownerName ?? string.Empty);
			IntPtr nStartDateTime = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(startDateTime ?? string.Empty);
			IntPtr nSubject = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(subject ?? string.Empty);
			IntPtr nVidyoMeetingRoomLink = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(vidyoMeetingRoomLink ?? string.Empty);

			foreach (MeetingAttendee iter in attendees) {
				Marshal.WriteIntPtr(nAttendees + (nAttendeesSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nAttendeesSize++;
			}

			VidyoMeetingInfoSetattendeesNative(objPtr, nAttendees, nAttendeesSize);
			VidyoMeetingInfoSetbodyNative(objPtr, nBody);
			VidyoMeetingInfoSetendDateTimeNative(objPtr, nEndDateTime);
			VidyoMeetingInfoSetidNative(objPtr, nId);
			VidyoMeetingInfoSetisVidyoMeetingNative(objPtr, isVidyoMeeting);
			VidyoMeetingInfoSetlocationNative(objPtr, nLocation);
			VidyoMeetingInfoSetnumOfAttendeesNative(objPtr, numOfAttendees);
			VidyoMeetingInfoSetownerEmailNative(objPtr, nOwnerEmail);
			VidyoMeetingInfoSetownerNameNative(objPtr, nOwnerName);
			VidyoMeetingInfoSetstartDateTimeNative(objPtr, nStartDateTime);
			VidyoMeetingInfoSetsubjectNative(objPtr, nSubject);
			VidyoMeetingInfoSettotalBodyLengthNative(objPtr, totalBodyLength);
			VidyoMeetingInfoSetvidyoMeetingRoomLinkNative(objPtr, nVidyoMeetingRoomLink);

			Marshal.FreeHGlobal(nVidyoMeetingRoomLink);
			Marshal.FreeHGlobal(nSubject);
			Marshal.FreeHGlobal(nStartDateTime);
			Marshal.FreeHGlobal(nOwnerName);
			Marshal.FreeHGlobal(nOwnerEmail);
			Marshal.FreeHGlobal(nLocation);
			Marshal.FreeHGlobal(nId);
			Marshal.FreeHGlobal(nEndDateTime);
			Marshal.FreeHGlobal(nBody);
			Marshal.FreeHGlobal(nAttendees);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingInfoGetattendeesNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMeetingInfoSetattendeesNative(IntPtr obj, IntPtr attendees, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingInfoGetattendeesArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMeetingInfoFreeattendeesArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingInfoGetbodyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMeetingInfoSetbodyNative(IntPtr obj, IntPtr body);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingInfoGetendDateTimeNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMeetingInfoSetendDateTimeNative(IntPtr obj, IntPtr endDateTime);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingInfoGetidNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMeetingInfoSetidNative(IntPtr obj, IntPtr id);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoMeetingInfoGetisVidyoMeetingNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMeetingInfoSetisVidyoMeetingNative(IntPtr obj, Boolean isVidyoMeeting);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingInfoGetlocationNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMeetingInfoSetlocationNative(IntPtr obj, IntPtr location);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoMeetingInfoGetnumOfAttendeesNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMeetingInfoSetnumOfAttendeesNative(IntPtr obj, uint numOfAttendees);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingInfoGetownerEmailNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMeetingInfoSetownerEmailNative(IntPtr obj, IntPtr ownerEmail);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingInfoGetownerNameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMeetingInfoSetownerNameNative(IntPtr obj, IntPtr ownerName);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingInfoGetstartDateTimeNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMeetingInfoSetstartDateTimeNative(IntPtr obj, IntPtr startDateTime);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingInfoGetsubjectNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMeetingInfoSetsubjectNative(IntPtr obj, IntPtr subject);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoMeetingInfoGettotalBodyLengthNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMeetingInfoSettotalBodyLengthNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT totalBodyLength);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingInfoGetvidyoMeetingRoomLinkNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMeetingInfoSetvidyoMeetingRoomLinkNative(IntPtr obj, IntPtr vidyoMeetingRoomLink);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoMeetingInfoConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoMeetingInfoConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoMeetingInfoDestructNative(IntPtr obj);

		/// <summary>
		/// List of up to 20 attendees for the meeting. NOTE... This list will only hold up to 20 attendees If the user would like to retrieve all attendees for the meeting (above 20) they will need to independently construct a VidyoMeeting from this type to retrieve the entire set of attendees.
		/// </summary>
		public List<MeetingAttendee> attendees;
		/// <summary>
		/// Body contents for the meeting (only up to 2K of string data).
		/// </summary>
		public String body;
		/// <summary>
		/// Date and time that the meeting is scheduled for
		/// </summary>
		public String endDateTime;
		/// <summary>
		/// Unique id that identifies a conference meeting at the service which the meeting is created through.
		/// </summary>
		public String id;
		/// <summary>
		/// Indicates whether the meeting contains Vidyo specific meeting information or not.
		/// </summary>
		public Boolean isVidyoMeeting;
		/// <summary>
		/// Subject for the meeting.
		/// </summary>
		public String location;
		/// <summary>
		/// Total number of attendees that exist for this meeting. IMPORTANT - This member reflects the *actual total* number of attendees that exist for the meeting . The attendee vector (below) will be limited to 20 attendees.
		/// </summary>
		public uint numOfAttendees;
		/// <summary>
		/// Email for owner the meeting.
		/// </summary>
		public String ownerEmail;
		/// <summary>
		/// Owner name for the meeting.
		/// </summary>
		public String ownerName;
		/// <summary>
		/// Date and time that the meeting is scheduled for
		/// </summary>
		public String startDateTime;
		/// <summary>
		/// Subject for the meeting.
		/// </summary>
		public String subject;
		/// <summary>
		/// Total number of bytes in the body. Useful if the body is larger than 2K.
		/// </summary>
		public SizeT totalBodyLength;
		/// <summary>
		/// Contains key information (URL, Meeting JID, etc) for the Vidyo Meeting that the meeting is being held in if the meeting type is VIDYO_MEETING_TYPE_VIDYO. Otherwise it contains an empty string.
		/// </summary>
		public String vidyoMeetingRoomLink;
		public MeetingInfo(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoMeetingInfoConstructDefaultNative();
			}
			else {
				objPtr = VidyoMeetingInfoConstructCopyNative(obj);
			}

			List<MeetingAttendee> csAttendees = new List<MeetingAttendee>();
			var nAttendeesSize = 0;
			var nAttendees = VidyoMeetingInfoGetattendeesArrayNative(VidyoMeetingInfoGetattendeesNative(objPtr), ref nAttendeesSize);
			var nAttendeesIndex = 0;
			while (nAttendeesIndex < nAttendeesSize) {
				MeetingAttendee csTattendees = new MeetingAttendee(Marshal.ReadIntPtr(nAttendees + (nAttendeesIndex * Marshal.SizeOf(nAttendees))));
				csAttendees.Add(csTattendees);
				nAttendeesIndex++;
			}

			attendees = csAttendees;
			body = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoMeetingInfoGetbodyNative(objPtr));
			endDateTime = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoMeetingInfoGetendDateTimeNative(objPtr));
			id = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoMeetingInfoGetidNative(objPtr));
			isVidyoMeeting = VidyoMeetingInfoGetisVidyoMeetingNative(objPtr);
			location = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoMeetingInfoGetlocationNative(objPtr));
			numOfAttendees = VidyoMeetingInfoGetnumOfAttendeesNative(objPtr);
			ownerEmail = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoMeetingInfoGetownerEmailNative(objPtr));
			ownerName = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoMeetingInfoGetownerNameNative(objPtr));
			startDateTime = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoMeetingInfoGetstartDateTimeNative(objPtr));
			subject = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoMeetingInfoGetsubjectNative(objPtr));
			totalBodyLength = VidyoMeetingInfoGettotalBodyLengthNative(objPtr);
			vidyoMeetingRoomLink = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoMeetingInfoGetvidyoMeetingRoomLinkNative(objPtr));
			VidyoMeetingInfoFreeattendeesArrayNative(nAttendees, nAttendeesSize);
		}
		~MeetingInfo() {
			VidyoMeetingInfoDestructNative(objPtr);
		 }
	};
}
