// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	/// <summary>
	/// This object represents a microphone which belongs to the remote participant.
	/// </summary>
	public class RemoteMicrophone: IDisposable {
		private bool disposed = false; 
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoRemoteMicrophone reference.
		private GCHandle objHandle; // weak VidyoRemoteMicrophone reference.
		public IntPtr GetObjectPtr() {
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRemoteMicrophoneAddToLocalSpeakerNative(IntPtr m, IntPtr speaker, [MarshalAs(UnmanagedType.I4)]RemoteMicrophoneMode mode);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRemoteMicrophoneConstructCopyNative(IntPtr other);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteMicrophoneDestructNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRemoteMicrophoneGetIdNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRemoteMicrophoneGetNameNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern Device.DeviceAudioSignalType VidyoRemoteMicrophoneGetSignalTypeNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRemoteMicrophoneRemoveFromLocalSpeakerNative(IntPtr m, IntPtr speaker);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoRemoteMicrophoneGetUserDataNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoRemoteMicrophoneSetUserDataNative(IntPtr obj, IntPtr userData);

		/// <summary>
		/// 
		/// </summary>
		public enum RemoteMicrophoneMode {
			/// <summary></summary>
			RemotemicrophonemodeDynamic,
			/// <summary></summary>
			RemotemicrophonemodeStatic
		}
		public RemoteMicrophone(IntPtr other){
			objPtr = VidyoRemoteMicrophoneConstructCopyNative(other);
			objHandle = GCHandle.Alloc(this, GCHandleType.Weak);
			VidyoRemoteMicrophoneSetUserDataNative(objPtr, GCHandle.ToIntPtr(objHandle));
		}
		~RemoteMicrophone(){
			Dispose(false);
		}
		public void Dispose(){
			Dispose(true);
			GC.SuppressFinalize(this);
		}

		public void Dispose(bool disposing){
			if(disposed) return;

			disposed = true;
			if(objPtr != IntPtr.Zero) {
				VidyoRemoteMicrophoneSetUserDataNative(objPtr, IntPtr.Zero);
				VidyoRemoteMicrophoneDestructNative(objPtr);
				objPtr = IntPtr.Zero;
			}

			if(objHandle.IsAllocated) objHandle.Free();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoRemoteMicrophone object.</param>
		/// <param name="speaker"></param>
		/// <param name="mode"></param>
		public Boolean AddToLocalSpeaker(LocalSpeaker speaker, RemoteMicrophoneMode mode) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRemoteMicrophoneAddToLocalSpeakerNative(objPtr, (speaker != null) ? speaker.GetObjectPtr():IntPtr.Zero, mode);

			return ret;
		}
		/// <summary>
		/// Gets the unique ID of the microphone.
		/// </summary>
		/// <param name="m">The VidyoRemoteMicrophone object.</param>
		public String GetId() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoRemoteMicrophoneGetIdNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// Gets the name of the microphone.
		/// </summary>
		/// <param name="m">The VidyoRemoteMicrophone object.</param>
		public String GetName() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoRemoteMicrophoneGetNameNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// Gets signal type of the microphone, which affects how the audio is processed.
		/// </summary>
		/// <param name="m">The VidyoRemoteMicrophone object.</param>
		public Device.DeviceAudioSignalType GetSignalType() {
			if (objPtr == IntPtr.Zero) { return default; }

			Device.DeviceAudioSignalType ret = VidyoRemoteMicrophoneGetSignalTypeNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoRemoteMicrophone object.</param>
		/// <param name="speaker"></param>
		public Boolean RemoveFromLocalSpeaker(LocalSpeaker speaker) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRemoteMicrophoneRemoveFromLocalSpeakerNative(objPtr, (speaker != null) ? speaker.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
	};
}
