// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class RemoteRendererStreamStatsFactory
	{
		public static RemoteRendererStreamStats Create()
		{
			return new RemoteRendererStreamStats(IntPtr.Zero);
		}
		public static void Destroy(RemoteRendererStreamStats obj)
		{
		}
	}
	/// <summary>
	/// Statistics for a remote renderer.
	/// </summary>
	public class RemoteRendererStreamStats {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoRemoteRendererStreamStats reference.
		public IntPtr GetObjectPtr() {
			IntPtr nCodecName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(codecName ?? string.Empty);
			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);

			VidyoRemoteRendererStreamStatsSetcodecFirNative(objPtr, codecFir);
			VidyoRemoteRendererStreamStatsSetcodecIFramesNative(objPtr, codecIFrames);
			VidyoRemoteRendererStreamStatsSetcodecLayersNative(objPtr, codecLayers);
			VidyoRemoteRendererStreamStatsSetcodecNacksNative(objPtr, codecNacks);
			VidyoRemoteRendererStreamStatsSetcodecNameNative(objPtr, nCodecName);
			VidyoRemoteRendererStreamStatsSetfpsNative(objPtr, fps);
			VidyoRemoteRendererStreamStatsSetfpsInputNative(objPtr, fpsInput);
			VidyoRemoteRendererStreamStatsSetfpsSentNative(objPtr, fpsSent);
			VidyoRemoteRendererStreamStatsSetframesDroppedNative(objPtr, framesDropped);
			VidyoRemoteRendererStreamStatsSetheightNative(objPtr, height);
			VidyoRemoteRendererStreamStatsSetlastHeightNative(objPtr, lastHeight);
			VidyoRemoteRendererStreamStatsSetlastWidthNative(objPtr, lastWidth);
			VidyoRemoteRendererStreamStatsSetnameNative(objPtr, nName);
			VidyoRemoteRendererStreamStatsSetsendNetworkBitRateNative(objPtr, sendNetworkBitRate);
			VidyoRemoteRendererStreamStatsSetsendNetworkRttNative(objPtr, sendNetworkRtt);
			VidyoRemoteRendererStreamStatsSetwidthNative(objPtr, width);

			Marshal.FreeHGlobal(nName);
			Marshal.FreeHGlobal(nCodecName);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRemoteRendererStreamStatsGetcodecFirNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteRendererStreamStatsSetcodecFirNative(IntPtr obj, uint codecFir);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRemoteRendererStreamStatsGetcodecIFramesNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteRendererStreamStatsSetcodecIFramesNative(IntPtr obj, uint codecIFrames);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRemoteRendererStreamStatsGetcodecLayersNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteRendererStreamStatsSetcodecLayersNative(IntPtr obj, uint codecLayers);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRemoteRendererStreamStatsGetcodecNacksNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteRendererStreamStatsSetcodecNacksNative(IntPtr obj, uint codecNacks);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRemoteRendererStreamStatsGetcodecNameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteRendererStreamStatsSetcodecNameNative(IntPtr obj, IntPtr codecName);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRemoteRendererStreamStatsGetfpsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteRendererStreamStatsSetfpsNative(IntPtr obj, uint fps);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRemoteRendererStreamStatsGetfpsInputNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteRendererStreamStatsSetfpsInputNative(IntPtr obj, uint fpsInput);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRemoteRendererStreamStatsGetfpsSentNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteRendererStreamStatsSetfpsSentNative(IntPtr obj, uint fpsSent);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteRendererStreamStatsGetframesDroppedNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteRendererStreamStatsSetframesDroppedNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT framesDropped);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteRendererStreamStatsGetheightNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteRendererStreamStatsSetheightNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT height);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteRendererStreamStatsGetlastHeightNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteRendererStreamStatsSetlastHeightNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT lastHeight);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteRendererStreamStatsGetlastWidthNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteRendererStreamStatsSetlastWidthNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT lastWidth);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRemoteRendererStreamStatsGetnameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteRendererStreamStatsSetnameNative(IntPtr obj, IntPtr name);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRemoteRendererStreamStatsGetsendNetworkBitRateNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteRendererStreamStatsSetsendNetworkBitRateNative(IntPtr obj, uint sendNetworkBitRate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoRemoteRendererStreamStatsGetsendNetworkRttNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteRendererStreamStatsSetsendNetworkRttNative(IntPtr obj, ulong sendNetworkRtt);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoRemoteRendererStreamStatsGetwidthNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteRendererStreamStatsSetwidthNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT width);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoRemoteRendererStreamStatsConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoRemoteRendererStreamStatsConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoRemoteRendererStreamStatsDestructNative(IntPtr obj);

		/// <summary>
		/// Codec FIR.
		/// </summary>
		public uint codecFir;
		/// <summary>
		/// Codec I frames.
		/// </summary>
		public uint codecIFrames;
		/// <summary>
		/// Codec layers.
		/// </summary>
		public uint codecLayers;
		/// <summary>
		/// Codec nacks.
		/// </summary>
		public uint codecNacks;
		/// <summary>
		/// Codec name.
		/// </summary>
		public String codecName;
		/// <summary>
		/// Frame rate determined by the operating point.
		/// </summary>
		public uint fps;
		/// <summary>
		/// Frame rate at encoder input.
		/// </summary>
		public uint fpsInput;
		/// <summary>
		/// Frame rate at the encoder output.
		/// </summary>
		public uint fpsSent;
		/// <summary>
		/// Number of frames dropped due to overconstraint or resizing errors.
		/// </summary>
		public SizeT framesDropped;
		/// <summary>
		/// Height determined by the operating point.
		/// </summary>
		public SizeT height;
		/// <summary>
		/// Height of the last frame received from the capturing device.
		/// </summary>
		public SizeT lastHeight;
		/// <summary>
		/// Width of the last frame received from the capturing device.
		/// </summary>
		public SizeT lastWidth;
		/// <summary>
		/// Name.
		/// </summary>
		public String name;
		/// <summary>
		/// Send bitrate.
		/// </summary>
		public uint sendNetworkBitRate;
		/// <summary>
		/// Round trip time of send network.
		/// </summary>
		public ulong sendNetworkRtt;
		/// <summary>
		/// Width determined by the operating point.
		/// </summary>
		public SizeT width;
		public RemoteRendererStreamStats(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoRemoteRendererStreamStatsConstructDefaultNative();
			}
			else {
				objPtr = VidyoRemoteRendererStreamStatsConstructCopyNative(obj);
			}

			codecFir = VidyoRemoteRendererStreamStatsGetcodecFirNative(objPtr);
			codecIFrames = VidyoRemoteRendererStreamStatsGetcodecIFramesNative(objPtr);
			codecLayers = VidyoRemoteRendererStreamStatsGetcodecLayersNative(objPtr);
			codecNacks = VidyoRemoteRendererStreamStatsGetcodecNacksNative(objPtr);
			codecName = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRemoteRendererStreamStatsGetcodecNameNative(objPtr));
			fps = VidyoRemoteRendererStreamStatsGetfpsNative(objPtr);
			fpsInput = VidyoRemoteRendererStreamStatsGetfpsInputNative(objPtr);
			fpsSent = VidyoRemoteRendererStreamStatsGetfpsSentNative(objPtr);
			framesDropped = VidyoRemoteRendererStreamStatsGetframesDroppedNative(objPtr);
			height = VidyoRemoteRendererStreamStatsGetheightNative(objPtr);
			lastHeight = VidyoRemoteRendererStreamStatsGetlastHeightNative(objPtr);
			lastWidth = VidyoRemoteRendererStreamStatsGetlastWidthNative(objPtr);
			name = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRemoteRendererStreamStatsGetnameNative(objPtr));
			sendNetworkBitRate = VidyoRemoteRendererStreamStatsGetsendNetworkBitRateNative(objPtr);
			sendNetworkRtt = VidyoRemoteRendererStreamStatsGetsendNetworkRttNative(objPtr);
			width = VidyoRemoteRendererStreamStatsGetwidthNative(objPtr);
		}
		~RemoteRendererStreamStats() {
			VidyoRemoteRendererStreamStatsDestructNative(objPtr);
		 }
	};
}
