// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class RoomStatsFactory
	{
		public static RoomStats Create()
		{
			return new RoomStats(IntPtr.Zero);
		}
		public static void Destroy(RoomStats obj)
		{
		}
	}
	/// <summary>
	/// Staticstics for a room.
	/// </summary>
	public class RoomStats {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoRoomStats reference.
		public IntPtr GetObjectPtr() {
			IntPtr nCallId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(callId ?? string.Empty);
			IntPtr nConferenceId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(conferenceId ?? string.Empty);
			IntPtr nId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(id ?? string.Empty);
			IntPtr nParticipantGenerationStats = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * participantGenerationStats.Count);
			int nParticipantGenerationStatsSize = 0;
			IntPtr nParticipantStats = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * participantStats.Count);
			int nParticipantStatsSize = 0;
			IntPtr nReflectorId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(reflectorId ?? string.Empty);
			IntPtr nSelectedParticipantsStats = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * selectedParticipantsStats.Count);
			int nSelectedParticipantsStatsSize = 0;
			IntPtr nTransportInformation = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * transportInformation.Count);
			int nTransportInformationSize = 0;

			foreach (ParticipantGenerationStats iter in participantGenerationStats) {
				Marshal.WriteIntPtr(nParticipantGenerationStats + (nParticipantGenerationStatsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nParticipantGenerationStatsSize++;
			}
			foreach (ParticipantStats iter in participantStats) {
				Marshal.WriteIntPtr(nParticipantStats + (nParticipantStatsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nParticipantStatsSize++;
			}
			foreach (ParticipantGenerationStats iter in selectedParticipantsStats) {
				Marshal.WriteIntPtr(nSelectedParticipantsStats + (nSelectedParticipantsStatsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nSelectedParticipantsStatsSize++;
			}
			foreach (MediaConnectionTransportInfo iter in transportInformation) {
				Marshal.WriteIntPtr(nTransportInformation + (nTransportInformationSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nTransportInformationSize++;
			}

			VidyoRoomStatsSetavailableDecodeBwPercentNative(objPtr, availableDecodeBwPercent);
			VidyoRoomStatsSetavailableDecodeCpuPercentNative(objPtr, availableDecodeCpuPercent);
			VidyoRoomStatsSetavailableEncodeBwPercentNative(objPtr, availableEncodeBwPercent);
			VidyoRoomStatsSetavailableEncodeCpuPercentNative(objPtr, availableEncodeCpuPercent);
			VidyoRoomStatsSetbandwidthAppNative(objPtr, bandwidthApp.GetObjectPtr());
			VidyoRoomStatsSetbandwidthAudioNative(objPtr, bandwidthAudio.GetObjectPtr());
			VidyoRoomStatsSetbandwidthVideoNative(objPtr, bandwidthVideo.GetObjectPtr());
			VidyoRoomStatsSetcallIdNative(objPtr, nCallId);
			VidyoRoomStatsSetconferenceIdNative(objPtr, nConferenceId);
			VidyoRoomStatsSetcpuUsageNative(objPtr, cpuUsage);
			VidyoRoomStatsSetcurrentBandwidthDecodePixelRateNative(objPtr, currentBandwidthDecodePixelRate);
			VidyoRoomStatsSetcurrentBandwidthEncodePixelRateNative(objPtr, currentBandwidthEncodePixelRate);
			VidyoRoomStatsSetcurrentCpuDecodePixelRateNative(objPtr, currentCpuDecodePixelRate);
			VidyoRoomStatsSetcurrentCpuEncodePixelRateNative(objPtr, currentCpuEncodePixelRate);
			VidyoRoomStatsSetidNative(objPtr, nId);
			VidyoRoomStatsSetmaxDecodePixelRateNative(objPtr, maxDecodePixelRate);
			VidyoRoomStatsSetmaxEncodePixelRateNative(objPtr, maxEncodePixelRate);
			VidyoRoomStatsSetmaxVideoSourcesNative(objPtr, maxVideoSources);
			VidyoRoomStatsSetparticipantGenerationStatsNative(objPtr, nParticipantGenerationStats, nParticipantGenerationStatsSize);
			VidyoRoomStatsSetparticipantStatsNative(objPtr, nParticipantStats, nParticipantStatsSize);
			VidyoRoomStatsSetrateShaperAppNative(objPtr, rateShaperApp.GetObjectPtr());
			VidyoRoomStatsSetrateShaperAudioNative(objPtr, rateShaperAudio.GetObjectPtr());
			VidyoRoomStatsSetrateShaperVideoNative(objPtr, rateShaperVideo.GetObjectPtr());
			VidyoRoomStatsSetreceiveBitRateAvailableNative(objPtr, receiveBitRateAvailable);
			VidyoRoomStatsSetreceiveBitRateTotalNative(objPtr, receiveBitRateTotal);
			VidyoRoomStatsSetreflectorIdNative(objPtr, nReflectorId);
			VidyoRoomStatsSetselectedParticipantsStatsNative(objPtr, nSelectedParticipantsStats, nSelectedParticipantsStatsSize);
			VidyoRoomStatsSetsendBitRateAvailableNative(objPtr, sendBitRateAvailable);
			VidyoRoomStatsSetsendBitRateTotalNative(objPtr, sendBitRateTotal);
			VidyoRoomStatsSetstaticSourcesNative(objPtr, staticSources);
			VidyoRoomStatsSettransportInformationNative(objPtr, nTransportInformation, nTransportInformationSize);

			Marshal.FreeHGlobal(nTransportInformation);
			Marshal.FreeHGlobal(nSelectedParticipantsStats);
			Marshal.FreeHGlobal(nReflectorId);
			Marshal.FreeHGlobal(nParticipantStats);
			Marshal.FreeHGlobal(nParticipantGenerationStats);
			Marshal.FreeHGlobal(nId);
			Marshal.FreeHGlobal(nConferenceId);
			Marshal.FreeHGlobal(nCallId);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRoomStatsGetavailableDecodeBwPercentNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetavailableDecodeBwPercentNative(IntPtr obj, uint availableDecodeBwPercent);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRoomStatsGetavailableDecodeCpuPercentNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetavailableDecodeCpuPercentNative(IntPtr obj, uint availableDecodeCpuPercent);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRoomStatsGetavailableEncodeBwPercentNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetavailableEncodeBwPercentNative(IntPtr obj, uint availableEncodeBwPercent);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRoomStatsGetavailableEncodeCpuPercentNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetavailableEncodeCpuPercentNative(IntPtr obj, uint availableEncodeCpuPercent);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomStatsGetbandwidthAppNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetbandwidthAppNative(IntPtr obj, IntPtr bandwidthApp);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomStatsGetbandwidthAudioNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetbandwidthAudioNative(IntPtr obj, IntPtr bandwidthAudio);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomStatsGetbandwidthVideoNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetbandwidthVideoNative(IntPtr obj, IntPtr bandwidthVideo);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomStatsGetcallIdNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetcallIdNative(IntPtr obj, IntPtr callId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomStatsGetconferenceIdNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetconferenceIdNative(IntPtr obj, IntPtr conferenceId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRoomStatsGetcpuUsageNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetcpuUsageNative(IntPtr obj, uint cpuUsage);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoRoomStatsGetcurrentBandwidthDecodePixelRateNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetcurrentBandwidthDecodePixelRateNative(IntPtr obj, ulong currentBandwidthDecodePixelRate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoRoomStatsGetcurrentBandwidthEncodePixelRateNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetcurrentBandwidthEncodePixelRateNative(IntPtr obj, ulong currentBandwidthEncodePixelRate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoRoomStatsGetcurrentCpuDecodePixelRateNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetcurrentCpuDecodePixelRateNative(IntPtr obj, ulong currentCpuDecodePixelRate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoRoomStatsGetcurrentCpuEncodePixelRateNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetcurrentCpuEncodePixelRateNative(IntPtr obj, ulong currentCpuEncodePixelRate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomStatsGetidNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetidNative(IntPtr obj, IntPtr id);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoRoomStatsGetmaxDecodePixelRateNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetmaxDecodePixelRateNative(IntPtr obj, ulong maxDecodePixelRate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoRoomStatsGetmaxEncodePixelRateNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetmaxEncodePixelRateNative(IntPtr obj, ulong maxEncodePixelRate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRoomStatsGetmaxVideoSourcesNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetmaxVideoSourcesNative(IntPtr obj, uint maxVideoSources);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomStatsGetparticipantGenerationStatsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetparticipantGenerationStatsNative(IntPtr obj, IntPtr participantGenerationStats, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomStatsGetparticipantGenerationStatsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsFreeparticipantGenerationStatsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomStatsGetparticipantStatsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetparticipantStatsNative(IntPtr obj, IntPtr participantStats, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomStatsGetparticipantStatsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsFreeparticipantStatsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomStatsGetrateShaperAppNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetrateShaperAppNative(IntPtr obj, IntPtr rateShaperApp);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomStatsGetrateShaperAudioNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetrateShaperAudioNative(IntPtr obj, IntPtr rateShaperAudio);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomStatsGetrateShaperVideoNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetrateShaperVideoNative(IntPtr obj, IntPtr rateShaperVideo);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoRoomStatsGetreceiveBitRateAvailableNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetreceiveBitRateAvailableNative(IntPtr obj, ulong receiveBitRateAvailable);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoRoomStatsGetreceiveBitRateTotalNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetreceiveBitRateTotalNative(IntPtr obj, ulong receiveBitRateTotal);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomStatsGetreflectorIdNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetreflectorIdNative(IntPtr obj, IntPtr reflectorId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomStatsGetselectedParticipantsStatsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetselectedParticipantsStatsNative(IntPtr obj, IntPtr selectedParticipantsStats, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomStatsGetselectedParticipantsStatsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsFreeselectedParticipantsStatsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoRoomStatsGetsendBitRateAvailableNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetsendBitRateAvailableNative(IntPtr obj, ulong sendBitRateAvailable);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoRoomStatsGetsendBitRateTotalNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetsendBitRateTotalNative(IntPtr obj, ulong sendBitRateTotal);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRoomStatsGetstaticSourcesNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSetstaticSourcesNative(IntPtr obj, uint staticSources);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomStatsGettransportInformationNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsSettransportInformationNative(IntPtr obj, IntPtr transportInformation, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomStatsGettransportInformationArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomStatsFreetransportInformationArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoRoomStatsConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoRoomStatsConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoRoomStatsDestructNative(IntPtr obj);

		/// <summary>
		/// Available Percent of the Bandwidth for the decoder.
		/// </summary>
		public uint availableDecodeBwPercent;
		/// <summary>
		/// Available Percent of the CPU for the decoder.
		/// </summary>
		public uint availableDecodeCpuPercent;
		/// <summary>
		/// Available Percent of the Bandwidth for the encoder.
		/// </summary>
		public uint availableEncodeBwPercent;
		/// <summary>
		/// Available Percent of the CPU for the encoder.
		/// </summary>
		public uint availableEncodeCpuPercent;
		/// <summary>
		/// Bandwidth summary statistics of application content.
		/// </summary>
		public BandwidthSummaryStats bandwidthApp;
		/// <summary>
		/// Bandwidth summary statistics of audio content.
		/// </summary>
		public BandwidthSummaryStats bandwidthAudio;
		/// <summary>
		/// Bandwidth summary statistics of video content.
		/// </summary>
		public BandwidthSummaryStats bandwidthVideo;
		/// <summary>
		/// Unique ID every time media is started and stopped.
		/// </summary>
		public String callId;
		/// <summary>
		/// ID conference on the reflector associated with this VidyoRoom.
		/// </summary>
		public String conferenceId;
		/// <summary>
		/// Current CPU usage.
		/// </summary>
		public uint cpuUsage;
		/// <summary>
		/// Current Bandwidth decode pixel rate.
		/// </summary>
		public ulong currentBandwidthDecodePixelRate;
		/// <summary>
		/// Current Bandwidth encode pixel rate.
		/// </summary>
		public ulong currentBandwidthEncodePixelRate;
		/// <summary>
		/// Current CPU decode pixel rate.
		/// </summary>
		public ulong currentCpuDecodePixelRate;
		/// <summary>
		/// Current CPU encode pixel rate.
		/// </summary>
		public ulong currentCpuEncodePixelRate;
		/// <summary>
		/// Room ID.
		/// </summary>
		public String id;
		/// <summary>
		/// Max decode pixel rate.
		/// </summary>
		public ulong maxDecodePixelRate;
		/// <summary>
		/// Max encode pixel rate.
		/// </summary>
		public ulong maxEncodePixelRate;
		/// <summary>
		/// Maximum video sources allowed based on the minimum of configured and constrained by resource manager.
		/// </summary>
		public uint maxVideoSources;
		/// <summary>
		/// Ordered list of generations (selected participants).
		/// </summary>
		public List<ParticipantGenerationStats> participantGenerationStats;
		/// <summary>
		/// Vector of stats of participants.
		/// </summary>
		public List<ParticipantStats> participantStats;
		/// <summary>
		/// Rate shaper statistics of application content.
		/// </summary>
		public RateShaperStats rateShaperApp;
		/// <summary>
		/// Rate shaper statistics of audio content.
		/// </summary>
		public RateShaperStats rateShaperAudio;
		/// <summary>
		/// Rate shaper statistics of video content.
		/// </summary>
		public RateShaperStats rateShaperVideo;
		/// <summary>
		/// Estimated available receive bandwidth in bps as detected by the automatic bandwidth detection algorithm.
		/// </summary>
		public ulong receiveBitRateAvailable;
		/// <summary>
		/// Estimate of the current receive bit rate on the entire media session.
		/// </summary>
		public ulong receiveBitRateTotal;
		/// <summary>
		/// ID of the refector to which the media conneciton is established.
		/// </summary>
		public String reflectorId;
		/// <summary>
		/// Unordered list of stats for all selected participants.
		/// </summary>
		public List<ParticipantGenerationStats> selectedParticipantsStats;
		/// <summary>
		/// Estimated available send bandwidth in bps as detected by the automatic bandwidth detection algorithm.
		/// </summary>
		public ulong sendBitRateAvailable;
		/// <summary>
		/// Estimate of the current send bit rate for the entire media session.
		/// </summary>
		public ulong sendBitRateTotal;
		/// <summary>
		/// Current ammount of static sources shown.
		/// </summary>
		public uint staticSources;
		/// <summary>
		/// Vector of media transport information.
		/// </summary>
		public List<MediaConnectionTransportInfo> transportInformation;
		public RoomStats(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoRoomStatsConstructDefaultNative();
			}
			else {
				objPtr = VidyoRoomStatsConstructCopyNative(obj);
			}

			BandwidthSummaryStats csBandwidthApp = new BandwidthSummaryStats(VidyoRoomStatsGetbandwidthAppNative(objPtr));
			BandwidthSummaryStats csBandwidthAudio = new BandwidthSummaryStats(VidyoRoomStatsGetbandwidthAudioNative(objPtr));
			BandwidthSummaryStats csBandwidthVideo = new BandwidthSummaryStats(VidyoRoomStatsGetbandwidthVideoNative(objPtr));
			List<ParticipantGenerationStats> csParticipantGenerationStats = new List<ParticipantGenerationStats>();
			var nParticipantGenerationStatsSize = 0;
			var nParticipantGenerationStats = VidyoRoomStatsGetparticipantGenerationStatsArrayNative(VidyoRoomStatsGetparticipantGenerationStatsNative(objPtr), ref nParticipantGenerationStatsSize);
			var nParticipantGenerationStatsIndex = 0;
			while (nParticipantGenerationStatsIndex < nParticipantGenerationStatsSize) {
				ParticipantGenerationStats csTparticipantGenerationStats = new ParticipantGenerationStats(Marshal.ReadIntPtr(nParticipantGenerationStats + (nParticipantGenerationStatsIndex * Marshal.SizeOf(nParticipantGenerationStats))));
				csParticipantGenerationStats.Add(csTparticipantGenerationStats);
				nParticipantGenerationStatsIndex++;
			}

			List<ParticipantStats> csParticipantStats = new List<ParticipantStats>();
			var nParticipantStatsSize = 0;
			var nParticipantStats = VidyoRoomStatsGetparticipantStatsArrayNative(VidyoRoomStatsGetparticipantStatsNative(objPtr), ref nParticipantStatsSize);
			var nParticipantStatsIndex = 0;
			while (nParticipantStatsIndex < nParticipantStatsSize) {
				ParticipantStats csTparticipantStats = new ParticipantStats(Marshal.ReadIntPtr(nParticipantStats + (nParticipantStatsIndex * Marshal.SizeOf(nParticipantStats))));
				csParticipantStats.Add(csTparticipantStats);
				nParticipantStatsIndex++;
			}

			RateShaperStats csRateShaperApp = new RateShaperStats(VidyoRoomStatsGetrateShaperAppNative(objPtr));
			RateShaperStats csRateShaperAudio = new RateShaperStats(VidyoRoomStatsGetrateShaperAudioNative(objPtr));
			RateShaperStats csRateShaperVideo = new RateShaperStats(VidyoRoomStatsGetrateShaperVideoNative(objPtr));
			List<ParticipantGenerationStats> csSelectedParticipantsStats = new List<ParticipantGenerationStats>();
			var nSelectedParticipantsStatsSize = 0;
			var nSelectedParticipantsStats = VidyoRoomStatsGetselectedParticipantsStatsArrayNative(VidyoRoomStatsGetselectedParticipantsStatsNative(objPtr), ref nSelectedParticipantsStatsSize);
			var nSelectedParticipantsStatsIndex = 0;
			while (nSelectedParticipantsStatsIndex < nSelectedParticipantsStatsSize) {
				ParticipantGenerationStats csTselectedParticipantsStats = new ParticipantGenerationStats(Marshal.ReadIntPtr(nSelectedParticipantsStats + (nSelectedParticipantsStatsIndex * Marshal.SizeOf(nSelectedParticipantsStats))));
				csSelectedParticipantsStats.Add(csTselectedParticipantsStats);
				nSelectedParticipantsStatsIndex++;
			}

			List<MediaConnectionTransportInfo> csTransportInformation = new List<MediaConnectionTransportInfo>();
			var nTransportInformationSize = 0;
			var nTransportInformation = VidyoRoomStatsGettransportInformationArrayNative(VidyoRoomStatsGettransportInformationNative(objPtr), ref nTransportInformationSize);
			var nTransportInformationIndex = 0;
			while (nTransportInformationIndex < nTransportInformationSize) {
				MediaConnectionTransportInfo csTtransportInformation = new MediaConnectionTransportInfo(Marshal.ReadIntPtr(nTransportInformation + (nTransportInformationIndex * Marshal.SizeOf(nTransportInformation))));
				csTransportInformation.Add(csTtransportInformation);
				nTransportInformationIndex++;
			}

			availableDecodeBwPercent = VidyoRoomStatsGetavailableDecodeBwPercentNative(objPtr);
			availableDecodeCpuPercent = VidyoRoomStatsGetavailableDecodeCpuPercentNative(objPtr);
			availableEncodeBwPercent = VidyoRoomStatsGetavailableEncodeBwPercentNative(objPtr);
			availableEncodeCpuPercent = VidyoRoomStatsGetavailableEncodeCpuPercentNative(objPtr);
			bandwidthApp = csBandwidthApp;
			bandwidthAudio = csBandwidthAudio;
			bandwidthVideo = csBandwidthVideo;
			callId = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomStatsGetcallIdNative(objPtr));
			conferenceId = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomStatsGetconferenceIdNative(objPtr));
			cpuUsage = VidyoRoomStatsGetcpuUsageNative(objPtr);
			currentBandwidthDecodePixelRate = VidyoRoomStatsGetcurrentBandwidthDecodePixelRateNative(objPtr);
			currentBandwidthEncodePixelRate = VidyoRoomStatsGetcurrentBandwidthEncodePixelRateNative(objPtr);
			currentCpuDecodePixelRate = VidyoRoomStatsGetcurrentCpuDecodePixelRateNative(objPtr);
			currentCpuEncodePixelRate = VidyoRoomStatsGetcurrentCpuEncodePixelRateNative(objPtr);
			id = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomStatsGetidNative(objPtr));
			maxDecodePixelRate = VidyoRoomStatsGetmaxDecodePixelRateNative(objPtr);
			maxEncodePixelRate = VidyoRoomStatsGetmaxEncodePixelRateNative(objPtr);
			maxVideoSources = VidyoRoomStatsGetmaxVideoSourcesNative(objPtr);
			participantGenerationStats = csParticipantGenerationStats;
			participantStats = csParticipantStats;
			rateShaperApp = csRateShaperApp;
			rateShaperAudio = csRateShaperAudio;
			rateShaperVideo = csRateShaperVideo;
			receiveBitRateAvailable = VidyoRoomStatsGetreceiveBitRateAvailableNative(objPtr);
			receiveBitRateTotal = VidyoRoomStatsGetreceiveBitRateTotalNative(objPtr);
			reflectorId = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomStatsGetreflectorIdNative(objPtr));
			selectedParticipantsStats = csSelectedParticipantsStats;
			sendBitRateAvailable = VidyoRoomStatsGetsendBitRateAvailableNative(objPtr);
			sendBitRateTotal = VidyoRoomStatsGetsendBitRateTotalNative(objPtr);
			staticSources = VidyoRoomStatsGetstaticSourcesNative(objPtr);
			transportInformation = csTransportInformation;
			VidyoRoomStatsFreetransportInformationArrayNative(nTransportInformation, nTransportInformationSize);
			VidyoRoomStatsFreeselectedParticipantsStatsArrayNative(nSelectedParticipantsStats, nSelectedParticipantsStatsSize);
			VidyoRoomStatsFreeparticipantStatsArrayNative(nParticipantStats, nParticipantStatsSize);
			VidyoRoomStatsFreeparticipantGenerationStatsArrayNative(nParticipantGenerationStats, nParticipantGenerationStatsSize);
		}
		~RoomStats() {
			VidyoRoomStatsDestructNative(objPtr);
		 }
	};
}
