#include <bnb/glsl.frag>

BNB_IN(0)
vec2 var_uv;

BNB_DECLARE_SAMPLER_2D(0, 1, tex_foreground);
BNB_DECLARE_SAMPLER_2D(2, 3, vid_foreground);

void main()
{
    vec4 texture_color = BNB_TEXTURE_2D(BNB_SAMPLER_2D(tex_foreground), var_uv);
    vec4 video_color = BNB_TEXTURE_2D(BNB_SAMPLER_2D(vid_foreground), var_uv);
    vec4 out_color = texture_color * foreground_input_mask.x + video_color * foreground_input_mask.y;

    bnb_FragColor = out_color;
}
