#include <bnb/glsl.vert>
#include <bnb/transform_uv.glsl>

BNB_LAYOUT_LOCATION(0)
BNB_IN vec2 attrib_pos;

BNB_OUT(0)
vec2 var_uv;

#ifdef BNB_VK_1
const float degrees_to_radians = 0.017453292f;
#else
const float degrees_to_radians = -0.017453292f;
#endif

void main()
{
    var_uv = attrib_pos * 0.5 + 0.5;

#ifdef BNB_VK_1
    var_uv.y = 1. - var_uv.y;
#endif

    gl_Position = vec4(attrib_pos, 0., 1.);

    var_uv = bnb_rotate_uv(var_uv, degrees_to_radians * foreground_rotation.x);

#ifndef BNB_VK_1
    var_uv.y = 1. - var_uv.y;
#endif
}
