#include <bnb/glsl.vert>

BNB_LAYOUT_LOCATION(0)
BNB_IN vec3 attrib_pos;
BNB_LAYOUT_LOCATION(3)
BNB_IN vec2 attrib_uv;

#ifndef BNB_GL_ES_1
BNB_LAYOUT_LOCATION(4)
BNB_IN uvec4 attrib_bones;
#else
BNB_LAYOUT_LOCATION(4)
BNB_IN vec4 attrib_bones;
#endif

BNB_DECLARE_SAMPLER_2D(4, 5, bnb_BONES);

BNB_OUT(0)
vec2 var_uv;
BNB_OUT(1)
vec2 var_uv_alpha;

#define BNB_1_BONE
#include <bnb/anim_transform.glsl>

void main()
{
    mat4 m = bnb_get_transform();
    vec3 vpos = vec3(vec4(attrib_pos, 1.) * m);

    gl_Position = bnb_MVP * vec4(vpos, 1.);
#ifndef BNB_VK_1
    gl_Position.z = -1.;
#else
    gl_Position.z = 0.;
#endif

    var_uv = attrib_uv;
    if (use_alpha.x == 1.0f) {
        var_uv.x *= 0.5;
    }
    var_uv_alpha = var_uv;
    if (use_alpha.x == 1.0f) {
        var_uv_alpha.x += 0.5;
    }
}