'use strict';

const prefabs = require("bnb_js/prefabs");

class Msaa extends prefabs.Base {
    constructor() {
        super();
        
        const assets = bnb.scene.getAssetManager();
        this.baseRt = assets.findRenderTarget("gltf_base_rt");
    }

    samplesCount(count) {
        this.baseRt.setSamplesCount(count);
    }
    
    clear() {
        this.baseRt.setSamplesCount(1);
    }
}

exports = {
    Msaa
}
