#include <bnb/glsl.frag>
#include <bnb/mediump.glsl>
#include <bnb/transform_uv.glsl>

BNB_IN(0)
vec2 var_uv;

BNB_DECLARE_SAMPLER_2D(0, 1, tex_y);
BNB_DECLARE_SAMPLER_2D(2, 3, tex_u);
BNB_DECLARE_SAMPLER_2D(4, 5, tex_v);
BNB_DECLARE_SAMPLER_2D(6, 7, tex_uv);
BNB_DECLARE_SAMPLER_2D(8, 9, tex_rgb);

#include <bnb/sample_camera.glsl>

void main()
{
    vec2 uv = var_uv;
    bnb_FragColor = bnb_sample_camera(uv);
    // discard pixels where uv values are out of range [0, 1]
    float s = bnb_get_uv_frame_alpha(uv);
    bnb_FragColor.rgb = mix(vec3(0., 0., 0.), bnb_FragColor.rgb, s);
    bnb_FragColor.a = 1.;
}