#ifndef BNB_TRANSFORM_CAMERA_UV
#define BNB_TRANSFORM_CAMERA_UV

/**
 * Transforms camera image uv depending on bnb_camera_orientation,
 * bnb_camera_scale_i420 and bnb_camera_origin_scale gloabal constants.
 * in_uv - uv in [-1; 1] space coordinates
 */
vec2 bnb_transform_camera_uv(vec2 in_uv)
{
    /* apply scaling before flip/rotate transformations */
    vec2 var_uv = in_uv / bnb_camera_origin_scale.zw;

    /* flip and rotate */
    mat2 ori = mat2(bnb_camera_orientation.xy, bnb_camera_orientation.zw);
    var_uv = (ori * vec2(var_uv.x * bnb_camera_scale_i420.x, var_uv.y)) * 0.5 + 0.5;

    /* apply offset to original camera image */
    var_uv += -ori * (bnb_camera_origin_scale.xy / bnb_camera_origin_scale.zw);

    return var_uv;
}

#endif // BNB_TRANSFORM_CAMERA_UV