//
//	VidyoConnector_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoAudioFrame_Objc.h"
#import "VidyoChatMessage_Objc.h"
#import "VidyoContactInfo_Objc.h"
#import "VidyoDevice_Objc.h"
#import "VidyoEndpoint_Objc.h"
#import "VidyoLocalCamera_Objc.h"
#import "VidyoLocalMicrophone_Objc.h"
#import "VidyoLocalMonitor_Objc.h"
#import "VidyoLocalSpeaker_Objc.h"
#import "VidyoLocalWindowShare_Objc.h"
#import "VidyoLogRecord_Objc.h"
#import "VidyoNetworkInterface_Objc.h"
#import "VidyoParticipant_Objc.h"
#import "VidyoRemoteCamera_Objc.h"
#import "VidyoRemoteMicrophone_Objc.h"
#import "VidyoRemoteRenderer_Objc.h"
#import "VidyoRemoteSpeaker_Objc.h"
#import "VidyoRemoteWindowShare_Objc.h"
#import "VidyoVideoFrame_Objc.h"
#import "VidyoVirtualAudioSource_Objc.h"
#import "VidyoVirtualRenderer_Objc.h"
#import "VidyoVirtualVideoSource_Objc.h"
@class VCConnectorBotInfo;
@class VCConnectorCameraEffectInfo;
@class VCConnectorConnectionProperties;
@class VCConnectorGoogleAnalyticsEventTable;
@class VCConnectorGoogleAnalyticsOptions;
@class VCConnectorInCallEvent;
@class VCConnectorProductInformation;
@class VCConnectorShareOptions;
@class VCConnectorTokenInfo;
/*!
 * @enum Indicates the audio mode.
 * @constant VCConnectorAudioModeSharedModeBoth Both audio devices (Speaker and Microphone) used in shared mode.
 * @constant VCConnectorAudioModeExclusiveModeBoth Both audio devices (Speaker and Microphone) used in exclusive mode.
 * @constant VCConnectorAudioModeExclusiveModeMicrophone Microphone is used in exclusive mode and speaker in shared mode.
 * @constant VCConnectorAudioModeUnknown Unknown audio mode.
 */
typedef NS_ENUM(NSInteger, VCConnectorAudioMode) {
	VCConnectorAudioModeSharedModeBoth,
	VCConnectorAudioModeExclusiveModeBoth,
	VCConnectorAudioModeExclusiveModeMicrophone,
	VCConnectorAudioModeUnknown
};
/*!
 * @enum Base transport type.
 * @constant VCConnectorBaseTransportTypeTLS Use TLS as base transport.
 * @constant VCConnectorBaseTransportTypeTCP Use TCP as base transport.
 * @constant VCConnectorBaseTransportTypeUDP Use UDP as base transport.
 */
typedef NS_ENUM(NSInteger, VCConnectorBaseTransportType) {
	VCConnectorBaseTransportTypeTLS,
	VCConnectorBaseTransportTypeTCP,
	VCConnectorBaseTransportTypeUDP
};
/*!
 * @enum Provides the error codes for camera background effect.
 * @constant VCConnectorCameraEffectErrorNone No errors.
 * @constant VCConnectorCameraEffectErrorInvalidToken The token is empty or expired.
 * @constant VCConnectorCameraEffectErrorInvalidResources The path to resources is empty or does not contain some files.
 * @constant VCConnectorCameraEffectErrorInvalidEffect The path to effect is empty or does not contain some files.
 * @constant VCConnectorCameraEffectErrorInvalidBlurIntensity The blur intensity is out of allowed range.
 * @constant VCConnectorCameraEffectErrorInvalidBackgroundPicture The path to background picture is empty or file doesn't exist or has unsupported format.
 * @constant VCConnectorCameraEffectErrorLoadEffectFailed Failed to load effect.
 * @constant VCConnectorCameraEffectErrorUnsupportedOpenGLVersion Effect was not started due to unsupported OpenGL version.
 * @constant VCConnectorCameraEffectErrorUnsupportedLibraryVersion Effect was not started due to unsupported Banuba library version.
 * @constant VCConnectorCameraEffectErrorNotAllowedForCurrectEffect Opperation is not allowed with the current effect.
 * @constant VCConnectorCameraEffectErrorMiscError Miscellaneous error.
 */
typedef NS_ENUM(NSInteger, VCConnectorCameraEffectError) {
	VCConnectorCameraEffectErrorNone,
	VCConnectorCameraEffectErrorInvalidToken,
	VCConnectorCameraEffectErrorInvalidResources,
	VCConnectorCameraEffectErrorInvalidEffect,
	VCConnectorCameraEffectErrorInvalidBlurIntensity,
	VCConnectorCameraEffectErrorInvalidBackgroundPicture,
	VCConnectorCameraEffectErrorLoadEffectFailed,
	VCConnectorCameraEffectErrorUnsupportedOpenGLVersion,
	VCConnectorCameraEffectErrorUnsupportedLibraryVersion,
	VCConnectorCameraEffectErrorNotAllowedForCurrectEffect,
	VCConnectorCameraEffectErrorMiscError
};
/*!
 * @enum Provides the supported camera background effects and used to enable or disable effect.
 * @constant VCConnectorCameraEffectTypeNone Disables active effects.
 * @constant VCConnectorCameraEffectTypeBlur Enables background blur effect.
 * @constant VCConnectorCameraEffectTypeVirtualBackground Enables virtual background effect.
 */
typedef NS_ENUM(NSInteger, VCConnectorCameraEffectType) {
	VCConnectorCameraEffectTypeNone,
	VCConnectorCameraEffectTypeBlur,
	VCConnectorCameraEffectTypeVirtualBackground
};
/*!
 * @enum Tell us the joining status of the host or owner of the room hosting the conference.
 * @constant VCConnectorConferenceHostStateJOINED Tells us if the host has joined
 * @constant VCConnectorConferenceHostStateLEFT Tells us if the host has left the conference
 */
typedef NS_ENUM(NSInteger, VCConnectorConferenceHostState) {
	VCConnectorConferenceHostStateJOINED,
	VCConnectorConferenceHostStateLEFT
};
/*!
 * @enum Sets the type of conference mode.
 * @constant VCConnectorConferenceModeLOBBY Indicate the user has joined the room which has Lobby Room property. The user is waiting in lobby because the host or presenter has not joined yet
 * @constant VCConnectorConferenceModeLECTURE Indicate the user has joined the room which has Lecture Mode property. The lecture mode features will be enforced on this room.
 * @constant VCConnectorConferenceModeGROUP Indicate the user is in room with property Group mode, which is a regular conference room with no special property
 */
typedef NS_ENUM(NSInteger, VCConnectorConferenceMode) {
	VCConnectorConferenceModeLOBBY,
	VCConnectorConferenceModeLECTURE,
	VCConnectorConferenceModeGROUP
};
/*!
 * @enum Reasons why an established connection was disconnected.
 * @constant VCConnectorDisconnectReasonDisconnected The user disconnected gracefully.
 * @constant VCConnectorDisconnectReasonConnectionLost The transport connection was lost.
 * @constant VCConnectorDisconnectReasonConnectionTimeout The signaling connection timed-out.
 * @constant VCConnectorDisconnectReasonNoResponse The service did not respond in a reasonable amount of time to a request by the user.
 * @constant VCConnectorDisconnectReasonTerminated The service closed the connection or otherwise terminated the login session.
 * @constant VCConnectorDisconnectReasonBooted The user was kicked out of the room. This could be the result of an administrator's action.
 * @constant VCConnectorDisconnectReasonMiscLocalError A miscellaneous problem occurred with this client library.
 * @constant VCConnectorDisconnectReasonMiscRemoteError A miscellaneous problem occurred with the conferencing service.
 * @constant VCConnectorDisconnectReasonMiscError The connection was closed for some other miscellaneous reason.
 */
typedef NS_ENUM(NSInteger, VCConnectorDisconnectReason) {
	VCConnectorDisconnectReasonDisconnected,
	VCConnectorDisconnectReasonConnectionLost,
	VCConnectorDisconnectReasonConnectionTimeout,
	VCConnectorDisconnectReasonNoResponse,
	VCConnectorDisconnectReasonTerminated,
	VCConnectorDisconnectReasonBooted,
	VCConnectorDisconnectReasonMiscLocalError,
	VCConnectorDisconnectReasonMiscRemoteError,
	VCConnectorDisconnectReasonMiscError
};
/*!
 * @enum Provide the advanced error code to the application.
 * @constant VCConnectorErrorCodeNotAllowed Not allowed.
 * @constant VCConnectorErrorCodeWrongState Called in wrong state.
 * @constant VCConnectorErrorCodeInvalidInput Invalid input.
 * @constant VCConnectorErrorCodeMisc Miscellaneous remote error.
 */
typedef NS_ENUM(NSInteger, VCConnectorErrorCode) {
	VCConnectorErrorCodeNotAllowed,
	VCConnectorErrorCodeWrongState,
	VCConnectorErrorCodeInvalidInput,
	VCConnectorErrorCodeMisc
};
/*!
 * @enum Reasons why a connection attempt failed.
 * @constant VCConnectorFailReasonConnectionFailed The destination could not be reached.
 * @constant VCConnectorFailReasonConnectionLost The transport connection was lost prior to completing the login procedure.
 * @constant VCConnectorFailReasonConnectionTimeout The signaling connection timed-out prior to completing the login procedure.
 * @constant VCConnectorFailReasonNoResponse The service was successfully contacted, but the service ignored the user's request to log in or it did not answer in a reasonable amount of time.
 * @constant VCConnectorFailReasonTerminated The service was successfully contacted, but the service closed the connection or it refused to continue processing the login request.
 * @constant VCConnectorFailReasonInvalidToken The token that was provided is unknown to the service or unauthorized to log in.
 * @constant VCConnectorFailReasonInvalidRoomPin The room pin that was provided is invalid or unauthorized.
 * @constant VCConnectorFailReasonUnableToCreateResource The server was unable to create the resource.
 * @constant VCConnectorFailReasonNoResponseFromResource The server did not respond in a reasonable amount of time to the request to connect to the resource.
 * @constant VCConnectorFailReasonInvalidResourceId The resource ID was invalid.
 * @constant VCConnectorFailReasonResourceFull The resource is at full capacity, and it cannot accept additional members.
 * @constant VCConnectorFailReasonNotMember The resource allows only certain users to enter, and the current user is not one of them.
 * @constant VCConnectorFailReasonBanned The user has been banned from entering the resource.
 * @constant VCConnectorFailReasonMediaNotEnabled The client could not enable media.
 * @constant VCConnectorFailReasonMediaFailed An established media connection failed.
 * @constant VCConnectorFailReasonMiscLocalError The server rejected the user's request to enter the resource, due to a miscellaneous problem with the request.
 * @constant VCConnectorFailReasonMiscRemoteError The server rejected the user's request to enter the resource, due to a miscellaneous problem of its own.
 * @constant VCConnectorFailReasonMiscError The login failed for some other miscellaneous reason.
 * @constant VCConnectorFailReasonInvalidDisplayNameLength Length of the display name is longer than 256 characters.
 * @constant VCConnectorFailReasonRoomLocked An established media connection failed because the room is locked and it cannot accept additional members.
 * @constant VCConnectorFailReasonRoomDisabled An established media connection failed because the room is disabled.
 * @constant VCConnectorFailReasonAllLinesInUse An established media connection failed because all lines are in use.
 * @constant VCConnectorFailReasonSeatLicenseExpired An established media connection failed because the seat license has expired.
 * @constant VCConnectorFailReasonNotLicensed An established media connection failed because the endpoint is not licensed.
 * @constant VCConnectorFailReasonRejected Attempt to enable media was rejected by the server.
 * @constant VCConnectorFailReasonBrowserVersionNotSupported VidyoClient library does not support this browser versoin.
 */
typedef NS_ENUM(NSInteger, VCConnectorFailReason) {
	VCConnectorFailReasonConnectionFailed,
	VCConnectorFailReasonConnectionLost,
	VCConnectorFailReasonConnectionTimeout,
	VCConnectorFailReasonNoResponse,
	VCConnectorFailReasonTerminated,
	VCConnectorFailReasonInvalidToken,
	VCConnectorFailReasonInvalidRoomPin,
	VCConnectorFailReasonUnableToCreateResource,
	VCConnectorFailReasonNoResponseFromResource,
	VCConnectorFailReasonInvalidResourceId,
	VCConnectorFailReasonResourceFull,
	VCConnectorFailReasonNotMember,
	VCConnectorFailReasonBanned,
	VCConnectorFailReasonMediaNotEnabled,
	VCConnectorFailReasonMediaFailed,
	VCConnectorFailReasonMiscLocalError,
	VCConnectorFailReasonMiscRemoteError,
	VCConnectorFailReasonMiscError,
	VCConnectorFailReasonInvalidDisplayNameLength,
	VCConnectorFailReasonRoomLocked,
	VCConnectorFailReasonRoomDisabled,
	VCConnectorFailReasonAllLinesInUse,
	VCConnectorFailReasonSeatLicenseExpired,
	VCConnectorFailReasonNotLicensed,
	VCConnectorFailReasonRejected,
	VCConnectorFailReasonBrowserVersionNotSupported
};
/*!
 * @enum Represents the event action of google analytics service.
 * @constant VCConnectorGoogleAnalyticsEventActionLoginSuccess The event indicates that login was successful.
 * @constant VCConnectorGoogleAnalyticsEventActionLoginAttempt This event indicates a login attempt.
 * @constant VCConnectorGoogleAnalyticsEventActionLoginFailedAuthentication This event indicates that login failed due to authentication.
 * @constant VCConnectorGoogleAnalyticsEventActionLoginFailedConnect This event indicates that login failed due to connect.
 * @constant VCConnectorGoogleAnalyticsEventActionLoginFailedResponseTimeout This event indicates that login failed due to response timeout.
 * @constant VCConnectorGoogleAnalyticsEventActionLoginFailedMiscError This event indicates that login failed due to miscellaneous error.
 * @constant VCConnectorGoogleAnalyticsEventActionLoginFailedWebProxyAuthRequired This event indicates that login failed due to webproxy authentication.
 * @constant VCConnectorGoogleAnalyticsEventActionLoginFailedUnsupportedTenantVersion This event indicates that login failed due to unsupported tenant version.
 * @constant VCConnectorGoogleAnalyticsEventActionUserTypeGuest This event indicates that user type is guest.
 * @constant VCConnectorGoogleAnalyticsEventActionUserTypeRegularToken This event indicates that user type is regular with token.
 * @constant VCConnectorGoogleAnalyticsEventActionUserTypeRegularPassword This event indicates that user type is regular with password.
 * @constant VCConnectorGoogleAnalyticsEventActionUserTypeRegularSaml This event indicates that user type is regular with saml.
 * @constant VCConnectorGoogleAnalyticsEventActionUserTypeRegularExtdata This event indicates that user type is regular with extended data.
 * @constant VCConnectorGoogleAnalyticsEventActionJoinConferenceSuccess This event indicates that join conference is successful.
 * @constant VCConnectorGoogleAnalyticsEventActionJoinConferenceAttempt This event indicates that join conference attempt is made.
 * @constant VCConnectorGoogleAnalyticsEventActionJoinConferenceReconnectRequests This event indicates that join conference with reconnect requested.
 * @constant VCConnectorGoogleAnalyticsEventActionJoinConferenceFailedConnectionError This Event indicates that join conference is failed due to connection error.
 * @constant VCConnectorGoogleAnalyticsEventActionJoinConferenceFailedWrongPin This event indicates that join conference is failed due to wrong pin.
 * @constant VCConnectorGoogleAnalyticsEventActionJoinConferenceFailedRoomFull This event indicates that join conference is failed because room is full.
 * @constant VCConnectorGoogleAnalyticsEventActionJoinConferenceFailedRoomDisabled This event indicates that join conference is failed because room is disabled.
 * @constant VCConnectorGoogleAnalyticsEventActionJoinConferenceFailedConferenceLocked This event indicates that join conference is failed because conference room is locked.
 * @constant VCConnectorGoogleAnalyticsEventActionJoinConferenceFailedUnknownError This event indicates that join conference is failed due to unknown error.
 * @constant VCConnectorGoogleAnalyticsEventActionConferenceEndLeft This event indicates that conference is ended because user is left.
 * @constant VCConnectorGoogleAnalyticsEventActionConferenceEndBooted This event indicates that conference is ended because user is booted.
 * @constant VCConnectorGoogleAnalyticsEventActionConferenceEndSignalingConnectionLost This event indicates that conference is ended because signaling connection is lost.
 * @constant VCConnectorGoogleAnalyticsEventActionConferenceEndMediaConnectionLost This event indicates that conference is ended because media connection is lost.
 * @constant VCConnectorGoogleAnalyticsEventActionConferenceEndUnknownError This event indicates that conference is ended with unknown error.
 * @constant VCConnectorGoogleAnalyticsEventActionInCallCodecVideoH264 This event indicates that H264 video codec is used in a conference call.
 * @constant VCConnectorGoogleAnalyticsEventActionInCallCodecVideoH264SVC This event indicates that H264-SVC video codec is used in a conference call.
 * @constant VCConnectorGoogleAnalyticsEventActionInCallCodecAudioSPEEXRED This event indicates that SPEEX RED audio codec is used in a conference call.
 * @constant VCConnectorGoogleAnalyticsEventActionAll This event includes all the above mentioned events.
 * @constant VCConnectorGoogleAnalyticsEventActionUnknown Unknown event action.
 */
typedef NS_ENUM(NSInteger, VCConnectorGoogleAnalyticsEventAction) {
	VCConnectorGoogleAnalyticsEventActionLoginSuccess,
	VCConnectorGoogleAnalyticsEventActionLoginAttempt,
	VCConnectorGoogleAnalyticsEventActionLoginFailedAuthentication,
	VCConnectorGoogleAnalyticsEventActionLoginFailedConnect,
	VCConnectorGoogleAnalyticsEventActionLoginFailedResponseTimeout,
	VCConnectorGoogleAnalyticsEventActionLoginFailedMiscError,
	VCConnectorGoogleAnalyticsEventActionLoginFailedWebProxyAuthRequired,
	VCConnectorGoogleAnalyticsEventActionLoginFailedUnsupportedTenantVersion,
	VCConnectorGoogleAnalyticsEventActionUserTypeGuest,
	VCConnectorGoogleAnalyticsEventActionUserTypeRegularToken,
	VCConnectorGoogleAnalyticsEventActionUserTypeRegularPassword,
	VCConnectorGoogleAnalyticsEventActionUserTypeRegularSaml,
	VCConnectorGoogleAnalyticsEventActionUserTypeRegularExtdata,
	VCConnectorGoogleAnalyticsEventActionJoinConferenceSuccess,
	VCConnectorGoogleAnalyticsEventActionJoinConferenceAttempt,
	VCConnectorGoogleAnalyticsEventActionJoinConferenceReconnectRequests,
	VCConnectorGoogleAnalyticsEventActionJoinConferenceFailedConnectionError,
	VCConnectorGoogleAnalyticsEventActionJoinConferenceFailedWrongPin,
	VCConnectorGoogleAnalyticsEventActionJoinConferenceFailedRoomFull,
	VCConnectorGoogleAnalyticsEventActionJoinConferenceFailedRoomDisabled,
	VCConnectorGoogleAnalyticsEventActionJoinConferenceFailedConferenceLocked,
	VCConnectorGoogleAnalyticsEventActionJoinConferenceFailedUnknownError,
	VCConnectorGoogleAnalyticsEventActionConferenceEndLeft,
	VCConnectorGoogleAnalyticsEventActionConferenceEndBooted,
	VCConnectorGoogleAnalyticsEventActionConferenceEndSignalingConnectionLost,
	VCConnectorGoogleAnalyticsEventActionConferenceEndMediaConnectionLost,
	VCConnectorGoogleAnalyticsEventActionConferenceEndUnknownError,
	VCConnectorGoogleAnalyticsEventActionInCallCodecVideoH264,
	VCConnectorGoogleAnalyticsEventActionInCallCodecVideoH264SVC,
	VCConnectorGoogleAnalyticsEventActionInCallCodecAudioSPEEXRED,
	VCConnectorGoogleAnalyticsEventActionAll,
	VCConnectorGoogleAnalyticsEventActionUnknown
};
/*!
 * @enum Represents the event category of google analytics service.
 * @constant VCConnectorGoogleAnalyticsEventCategoryLogin The login event category.
 * @constant VCConnectorGoogleAnalyticsEventCategoryUserType The user type event category.
 * @constant VCConnectorGoogleAnalyticsEventCategoryJoinConference The join conference event category.
 * @constant VCConnectorGoogleAnalyticsEventCategoryConferenceEnd The conference end event category.
 * @constant VCConnectorGoogleAnalyticsEventCategoryInCallCodec The in-call codec event category.
 * @constant VCConnectorGoogleAnalyticsEventCategoryNone Unknown event category.
 */
typedef NS_ENUM(NSInteger, VCConnectorGoogleAnalyticsEventCategory) {
	VCConnectorGoogleAnalyticsEventCategoryLogin,
	VCConnectorGoogleAnalyticsEventCategoryUserType,
	VCConnectorGoogleAnalyticsEventCategoryJoinConference,
	VCConnectorGoogleAnalyticsEventCategoryConferenceEnd,
	VCConnectorGoogleAnalyticsEventCategoryInCallCodec,
	VCConnectorGoogleAnalyticsEventCategoryNone
};
/*!
 * @enum It identifies the class of in call event.
 * @constant VCConnectorInCallEventClassMediaTransport It indicate event belongs to media transportation.
 * @constant VCConnectorInCallEventClassInCallCodec It indicate event belongs to InCallCodec.
 * @constant VCConnectorInCallEventClassDtls It indicate event belongs to Dtls Encryption.
 * @constant VCConnectorInCallEventClassUnKnown It indicate Unknown event.
 */
typedef NS_ENUM(NSInteger, VCConnectorInCallEventClass) {
	VCConnectorInCallEventClassMediaTransport,
	VCConnectorInCallEventClassInCallCodec,
	VCConnectorInCallEventClassDtls,
	VCConnectorInCallEventClassUnKnown
};
/*!
 * @enum It represents error code as call event.
 * @constant VCConnectorInCallEventCodeRTCPSendError RTCP send fail.
 * @constant VCConnectorInCallEventCodeRTCPReceiveError RTCP receive fail.
 * @constant VCConnectorInCallEventCodeRTPSendError RTP media packet send fail.
 * @constant VCConnectorInCallEventCodeRTPReceiveError RTP media packet receive fail.
 * @constant VCConnectorInCallEventCodeEncoderPausedOnLowBW Event when encoder paused on low bandwidth condition.
 * @constant VCConnectorInCallEventCodeEncoderResumed Event when encoder resumed after pause.
 * @constant VCConnectorInCallEventCodeInCallCodecVideoH264 Event when H264 video codec is used in a conference call.
 * @constant VCConnectorInCallEventCodeInCallCodecVideoH264SVC Event when H264-SVC video codec is used in a conference call.
 * @constant VCConnectorInCallEventCodeInCallCodecAudioSPEEXRED Event when SPEEX RED audio codec is used in a conference call.
 * @constant VCConnectorInCallEventCodeDtlsError Event when there is an error encrypting srtp packet because DTLSSRTP session is not yet established.
 * @constant VCConnectorInCallEventCodeUnKnown Unknown event code.
 */
typedef NS_ENUM(NSInteger, VCConnectorInCallEventCode) {
	VCConnectorInCallEventCodeRTCPSendError,
	VCConnectorInCallEventCodeRTCPReceiveError,
	VCConnectorInCallEventCodeRTPSendError,
	VCConnectorInCallEventCodeRTPReceiveError,
	VCConnectorInCallEventCodeEncoderPausedOnLowBW,
	VCConnectorInCallEventCodeEncoderResumed,
	VCConnectorInCallEventCodeInCallCodecVideoH264,
	VCConnectorInCallEventCodeInCallCodecVideoH264SVC,
	VCConnectorInCallEventCodeInCallCodecAudioSPEEXRED,
	VCConnectorInCallEventCodeDtlsError,
	VCConnectorInCallEventCodeUnKnown
};
/*!
 * @enum Log levels of VidyoClient library.
 * @constant VCConnectorLogLevelPRODUCTION The production log mode.
 * @constant VCConnectorLogLevelDEBUG The debug log mode.
 * @constant VCConnectorLogLevelINVALID The Invalid log level. This value should not be used when using VidyoConnectorSetLogLevel. It is used to indicate errors when VidyoConnectorGetLogLevel is used.
 */
typedef NS_ENUM(NSInteger, VCConnectorLogLevel) {
	VCConnectorLogLevelPRODUCTION,
	VCConnectorLogLevelDEBUG,
	VCConnectorLogLevelINVALID
};
/*!
 * @enum Logger type of VidyoClient library.
 * @constant VCConnectorLoggerTypeCONSOLE The console logger.
 * @constant VCConnectorLoggerTypeFILE The file logger.
 * @constant VCConnectorLoggerTypeFEEDBACK The feedback logger.
 * @constant VCConnectorLoggerTypeHTTP The http logger.
 */
typedef NS_ENUM(NSInteger, VCConnectorLoggerType) {
	VCConnectorLoggerTypeCONSOLE,
	VCConnectorLoggerTypeFILE,
	VCConnectorLoggerTypeFEEDBACK,
	VCConnectorLoggerTypeHTTP
};
/*!
 * @enum Operating modes of a VidyoConnector object.
 * @constant VCConnectorModeDefault The default operating mode.
 * @constant VCConnectorModeForeground Runs in the foreground.
 * @constant VCConnectorModeBackground Runs in the background.
 */
typedef NS_ENUM(NSInteger, VCConnectorMode) {
	VCConnectorModeDefault,
	VCConnectorModeForeground,
	VCConnectorModeBackground
};
/*!
 * @enum This type indicates the action of moderation request.
 * @constant VCConnectorModerationActionTypeMute Mute video or audio action.
 * @constant VCConnectorModerationActionTypeUnmute Unmute video or audio action.
 * @constant VCConnectorModerationActionTypeStartLectureMode Start lecture mode action.
 * @constant VCConnectorModerationActionTypeStopLectureMode Stop lecture mode action.
 * @constant VCConnectorModerationActionTypeSetPresenter Set presenter action.
 * @constant VCConnectorModerationActionTypeRemovePresenter Remove presenter action.
 * @constant VCConnectorModerationActionTypeRaiseHand Raise hand action.
 * @constant VCConnectorModerationActionTypeUnraiseHand Unraise hand action.
 * @constant VCConnectorModerationActionTypeDismissRaisedHand Dismiss raised hand action.
 * @constant VCConnectorModerationActionTypeDismissAllRaisedHands Dismiss all raised hands action.
 * @constant VCConnectorModerationActionTypeSetModeratorPin Set moderator pin.
 * @constant VCConnectorModerationActionTypeRemoveModeratorPin REmove moderator pin.
 * @constant VCConnectorModerationActionTypeDisconnectAll Disconnect all participants.
 * @constant VCConnectorModerationActionTypeDisconnectOne Disconnect one participant.
 * @constant VCConnectorModerationActionTypeInvalid Wrong action.
 */
typedef NS_ENUM(NSInteger, VCConnectorModerationActionType) {
	VCConnectorModerationActionTypeMute,
	VCConnectorModerationActionTypeUnmute,
	VCConnectorModerationActionTypeStartLectureMode,
	VCConnectorModerationActionTypeStopLectureMode,
	VCConnectorModerationActionTypeSetPresenter,
	VCConnectorModerationActionTypeRemovePresenter,
	VCConnectorModerationActionTypeRaiseHand,
	VCConnectorModerationActionTypeUnraiseHand,
	VCConnectorModerationActionTypeDismissRaisedHand,
	VCConnectorModerationActionTypeDismissAllRaisedHands,
	VCConnectorModerationActionTypeSetModeratorPin,
	VCConnectorModerationActionTypeRemoveModeratorPin,
	VCConnectorModerationActionTypeDisconnectAll,
	VCConnectorModerationActionTypeDisconnectOne,
	VCConnectorModerationActionTypeInvalid
};
/*!
 * @enum This type indicates the result of moderation request.
 * @constant VCConnectorModerationResultOK Request was successful.
 * @constant VCConnectorModerationResultNoResponse The server did not respond in a reasonable amount of time for request.
 * @constant VCConnectorModerationResultUnauthorized The user did not have permission for request.
 * @constant VCConnectorModerationResultNotOwnerOfRoom The user is not owner of the room.
 * @constant VCConnectorModerationResultNotAcceptable Request is not acceptable.
 * @constant VCConnectorModerationResultNotAllowed Request is not allowed.
 * @constant VCConnectorModerationResultConflict Request has a conflict.
 * @constant VCConnectorModerationResultInvalidInput Request parameter is invalid.
 * @constant VCConnectorModerationResultOutOfResources The request cannot completed at the current time because it is out of some resource.
 * @constant VCConnectorModerationResultUserIsOffline Requested user is offline.
 * @constant VCConnectorModerationResultRoomFull Room is currently full.
 * @constant VCConnectorModerationResultMiscLocalError Request failed due to some miscellaneous problem with the request.
 * @constant VCConnectorModerationResultMiscRemoteError The server is rejecting the request due to some miscellaneous problem of its own.
 */
typedef NS_ENUM(NSInteger, VCConnectorModerationResult) {
	VCConnectorModerationResultOK,
	VCConnectorModerationResultNoResponse,
	VCConnectorModerationResultUnauthorized,
	VCConnectorModerationResultNotOwnerOfRoom,
	VCConnectorModerationResultNotAcceptable,
	VCConnectorModerationResultNotAllowed,
	VCConnectorModerationResultConflict,
	VCConnectorModerationResultInvalidInput,
	VCConnectorModerationResultOutOfResources,
	VCConnectorModerationResultUserIsOffline,
	VCConnectorModerationResultRoomFull,
	VCConnectorModerationResultMiscLocalError,
	VCConnectorModerationResultMiscRemoteError
};
/*!
 * @enum Lists available actions for next generation renderer library.
 * @constant VCConnectorNGRActionTypeSetLayout Sets the layout.
 * @constant VCConnectorNGRActionTypeSetViewSize Sets the view size.
 * @constant VCConnectorNGRActionTypeSetDebugInfoVisible Sets the visibility of debug information.
 * @constant VCConnectorNGRActionTypeSetLabelVisible Sets the visibility of labels on renderer.
 * @constant VCConnectorNGRActionTypeSetAudioMeterVisible Sets the visibility of audio meter on tiles.
 * @constant VCConnectorNGRActionTypeSetBackgroundColor Sets the background color.
 * @constant VCConnectorNGRActionTypeSetDensity Sets the density.
 * @constant VCConnectorNGRActionTypeSetMaxRemoteParticipants Sets the max remote participants.
 * @constant VCConnectorNGRActionTypePinParticipant Pin the participants.
 * @constant VCConnectorNGRActionTypeShowAudioTiles Sets whether to show audio only tiles.
 * @constant VCConnectorNGRActionTypeInvalid Invalid action.
 */
typedef NS_ENUM(NSInteger, VCConnectorNGRActionType) {
	VCConnectorNGRActionTypeSetLayout,
	VCConnectorNGRActionTypeSetViewSize,
	VCConnectorNGRActionTypeSetDebugInfoVisible,
	VCConnectorNGRActionTypeSetLabelVisible,
	VCConnectorNGRActionTypeSetAudioMeterVisible,
	VCConnectorNGRActionTypeSetBackgroundColor,
	VCConnectorNGRActionTypeSetDensity,
	VCConnectorNGRActionTypeSetMaxRemoteParticipants,
	VCConnectorNGRActionTypePinParticipant,
	VCConnectorNGRActionTypeShowAudioTiles,
	VCConnectorNGRActionTypeInvalid
};
/*!
 * @enum Preferred audio codec to be set.
 * @constant VCConnectorPreferredAudioCodecOpusRed Preferred audio codec is OPUS RED.
 * @constant VCConnectorPreferredAudioCodecOpus Preferred audio codec is OPUS.
 * @constant VCConnectorPreferredAudioCodecSpeexRed Preferred audio codec is SPEEX RED.
 * @constant VCConnectorPreferredAudioCodecUnknown Unknown preferred audio codec .
 */
typedef NS_ENUM(NSInteger, VCConnectorPreferredAudioCodec) {
	VCConnectorPreferredAudioCodecOpusRed,
	VCConnectorPreferredAudioCodecOpus,
	VCConnectorPreferredAudioCodecSpeexRed,
	VCConnectorPreferredAudioCodecUnknown
};
/*!
 * @enum VidyoConnector properties that can be set.
 * @constant VCConnectorPropertyApplicationName Application name property.
 * @constant VCConnectorPropertyApplicationVersion Application version property.
 */
typedef NS_ENUM(NSInteger, VCConnectorProperty) {
	VCConnectorPropertyApplicationName,
	VCConnectorPropertyApplicationVersion
};
/*!
 * @enum Results of recording service requests.
 * @constant VCConnectorRecordingServiceResultSuccess The request has succeeded.
 * @constant VCConnectorRecordingServiceResultInvalidArgument One or more input arguments are invalid.
 * @constant VCConnectorRecordingServiceResultGeneralFailure Media support was disabled or there is an unknown fault on the portal.
 * @constant VCConnectorRecordingServiceResultSeatLicenseExpired The seat license has expired.
 * @constant VCConnectorRecordingServiceResultNotLicensed The endpoint is not licensed.
 * @constant VCConnectorRecordingServiceResultResourceNotAvailable There are no available resources of the portal or recording servers.
 * @constant VCConnectorRecordingServiceResultControlMeetingFailure Miscellaneous portal error occurred.
 */
typedef NS_ENUM(NSInteger, VCConnectorRecordingServiceResult) {
	VCConnectorRecordingServiceResultSuccess,
	VCConnectorRecordingServiceResultInvalidArgument,
	VCConnectorRecordingServiceResultGeneralFailure,
	VCConnectorRecordingServiceResultSeatLicenseExpired,
	VCConnectorRecordingServiceResultNotLicensed,
	VCConnectorRecordingServiceResultResourceNotAvailable,
	VCConnectorRecordingServiceResultControlMeetingFailure
};
/*!
 * @enum Provide the status of recording.
 * @constant VCConnectorRecordingStateNotRecording Recording is in stop state.
 * @constant VCConnectorRecordingStateRecordingPaused Recording is in pause state.
 * @constant VCConnectorRecordingStateRecording Recording is in start/resume state.
 */
typedef NS_ENUM(NSInteger, VCConnectorRecordingState) {
	VCConnectorRecordingStateNotRecording,
	VCConnectorRecordingStateRecordingPaused,
	VCConnectorRecordingStateRecording
};
/*!
 * @enum Provide the result of user search request.
 * @constant VCConnectorSearchResultOk The user search concluded properly.
 * @constant VCConnectorSearchResultNoRecords No record found for user search request.
 * @constant VCConnectorSearchResultNoResponse No response from server for user search request.
 * @constant VCConnectorSearchResultMiscLocalError Not able to search for some other miscellaneous local error.
 * @constant VCConnectorSearchResultMiscRemoteError Not able to search for some other miscellaneous remote error.
 */
typedef NS_ENUM(NSInteger, VCConnectorSearchResult) {
	VCConnectorSearchResultOk,
	VCConnectorSearchResultNoRecords,
	VCConnectorSearchResultNoResponse,
	VCConnectorSearchResultMiscLocalError,
	VCConnectorSearchResultMiscRemoteError
};
/*!
 * @enum States of a connection, mostly representing the progress of a connection attempt.
 * @constant VCConnectorStateIdle Not ready to connect, no devices.
 * @constant VCConnectorStateReady Ready to connect.
 * @constant VCConnectorStateEstablishingConnection Establishing a connection to the server.
 * @constant VCConnectorStateFindingResource Finding a resource.
 * @constant VCConnectorStateConnectingToResource Connecting to a resource.
 * @constant VCConnectorStateEnablingMedia Enabling media.
 * @constant VCConnectorStateConnected Successfully connected.
 * @constant VCConnectorStateDisconnecting Disconnecting.
 * @constant VCConnectorStateDisabling Disabling.
 * @constant VCConnectorStateDead VidyoConnector can't be used any more and must be destructed.
 */
typedef NS_ENUM(NSInteger, VCConnectorState) {
	VCConnectorStateIdle,
	VCConnectorStateReady,
	VCConnectorStateEstablishingConnection,
	VCConnectorStateFindingResource,
	VCConnectorStateConnectingToResource,
	VCConnectorStateEnablingMedia,
	VCConnectorStateConnected,
	VCConnectorStateDisconnecting,
	VCConnectorStateDisabling,
	VCConnectorStateDead
};
/*!
 * @enum An enumeration that represents the type of token.
 * @constant VCConnectorTokenTypeRefreshToken Represents the associated token is a refresh token.
 * @constant VCConnectorTokenTypeJwtToken Represents the associated token is a jwt token.
 * @constant VCConnectorTokenTypeUndefined Represents the associated token is undefined.
 */
typedef NS_ENUM(NSInteger, VCConnectorTokenType) {
	VCConnectorTokenTypeRefreshToken,
	VCConnectorTokenTypeJwtToken,
	VCConnectorTokenTypeUndefined
};
/*!
 * @enum CPU tradeoff profile.
 * @constant VCConnectorTradeOffProfileHigh High CPU usage.
 * @constant VCConnectorTradeOffProfileMedium Balanced CPU usage.
 * @constant VCConnectorTradeOffProfileLow Low CPU usage.
 */
typedef NS_ENUM(NSInteger, VCConnectorTradeOffProfile) {
	VCConnectorTradeOffProfileHigh,
	VCConnectorTradeOffProfileMedium,
	VCConnectorTradeOffProfileLow
};
/*!
 * @enum Styles of the composite renderer, which apply to its layout and behaviour.
 * @constant VCConnectorViewStyleDefault The default style.
 * @constant VCConnectorViewStyleTiles Participants are shown in sizes that best reflect their order of importance.
 * @constant VCConnectorViewStyleNGRGrid Next generation renderer with grid layout.
 * @constant VCConnectorViewStyleNGRSpeaker Next generation renderer with speaker layout.
 */
typedef NS_ENUM(NSInteger, VCConnectorViewStyle) {
	VCConnectorViewStyleDefault,
	VCConnectorViewStyleTiles,
	VCConnectorViewStyleNGRGrid,
	VCConnectorViewStyleNGRSpeaker
};
/*!
 * @enum Provide the status of webcasting/broadcasting.
 * @constant VCConnectorWebcastingStateNotWebcasting Room is not broadcast or webcasting is not going on.
 * @constant VCConnectorWebcastingStateWebcasting Room is being broadcast or webcasting is going on.
 */
typedef NS_ENUM(NSInteger, VCConnectorWebcastingState) {
	VCConnectorWebcastingStateNotWebcasting,
	VCConnectorWebcastingStateWebcasting
};
/*!
 * Package that encapsulates all the APIs required to build a simple videoconferencing application.
 */
@interface VCConnectorPkg : NSObject
{}
	/*!
	 * Initialize the VidyoConnector API.
	 */
	+(BOOL) vcInitialize;
	/*!
	 * Sets up experimental options on the VidyoConnector API.
	 */
	+(BOOL) setExperimentalOptions:(const char*)options;
	/*!
	 * Uninitialize the VidyoConnector API.
	 */
	+(void) uninitialize;
@end
@protocol VCConnectorIConnect
	/*!
	 * Callback that is triggered when the connection is successfully established.
	 */
	-(void) onSuccess;
	/*!
	 * Callback that is triggered when the connection attempt has failed.
	 */
	-(void) onFailure:(VCConnectorFailReason)reason;
	/*!
	 * Callback that is triggered when an established connection is disconnected.
	 */
	-(void) onDisconnected:(VCConnectorDisconnectReason)reason;
@end
@protocol VCConnectorIGetActiveNetworkInterface
	/*!
	 * Callback that is triggered each time when result of VidyoConnectorGetActiveNetworkInterface is received.
	 */
	-(void) onGetActiveNetworkInterface:(VCNetworkInterface*)signalingInterface MediaInterface:(VCNetworkInterface*)mediaInterface;
@end
@protocol VCConnectorIGetAutoReconnectSetting
	/*!
	 * Callback that is triggered each time when result of VidyoConnectorGetAutoReconnectSetting is received.
	 */
	-(void) onGetAutoReconnectSetting:(BOOL)enableAutoReconnect ReconnectBackoff:(unsigned int)reconnectBackoff MaxReconnectAttempts:(unsigned int)maxReconnectAttempts;
@end
@protocol VCConnectorIGetCameraBackgroundEffect
	/*!
	 * Callback that reports the current configuration of camera background effect to the application.
	 */
	-(void) onGetCameraBackgroundEffectInfo:(VCConnectorCameraEffectInfo*)effectInfo;
@end
@protocol VCConnectorIGetGoogleAnalyticsEventTable
	/*!
	 * Callback that is triggered each time when result of VidyoConnectorGetGoogleAnalyticsEventTable is received.
	 */
	-(void) onGetGoogleAnalyticsEventTable:(NSMutableArray*)eventTable;
@end
@protocol VCConnectorIGetGoogleAnalyticsOptions
	/*!
	 * Callback that is triggered each time when result of VidyoConnectorGetGoogleAnalyticsOptions is received.
	 */
	-(void) onGetGoogleAnalyticsOptions:(VCConnectorGoogleAnalyticsOptions*)options;
@end
@protocol VCConnectorIGetRecordingServiceProfiles
	/*!
	 * Callback that is triggered each time when result of recording service profiles is received.
	 */
	-(void) onGetRecordingServiceProfiles:(NSMutableArray*)profiles Prefixes:(NSMutableArray*)prefixes Result:(VCConnectorRecordingServiceResult)result;
@end
@protocol VCConnectorIGetWhitelistedAudioDevices
	/*!
	 * Callback that reports the names of the audio devices that are whitelisted.
	 */
	-(void) onGetWhitelistedAudioDevices:(NSMutableArray*)audioDevices;
@end
@protocol VCConnectorIInviteParticipant
	/*!
	 * Callback that is triggered each time when the result of invitation is received.
	 */
	-(void) onInviteResult:(NSString*)inviteeId Result:(VCConnectorModerationResult)result;
@end
@protocol VCConnectorILockRoom
	/*!
	 * Callback that is triggered each time when the result of lock room request is received.
	 */
	-(void) onLockRoomResult:(VCConnectorModerationResult)result;
@end
@protocol VCConnectorIPauseRecording
	/*!
	 * Callback that is triggered each time when result of recording service pause is received.
	 */
	-(void) onRecordingServicePauseResult:(VCConnectorModerationResult)result;
@end
@protocol VCConnectorIRaiseHand
	/*!
	 * Callback that notifies if raise hand request was approved or dismissed.
	 */
	-(void) onRaiseHandResponse:(VCParticipantHandState)handState;
@end
@protocol VCConnectorIRegisterBotEventListener
	/*!
	 * Callback that is triggered when bot participant joins a conference.
	 */
	-(void) onBotJoined:(VCConnectorBotInfo*)info;
	/*!
	 * Callback that is triggered when an existing bot participant leaves a conference.
	 */
	-(void) onBotLeft:(VCConnectorBotInfo*)info;
@end
@protocol VCConnectorIRegisterCameraEffectErrorListener
	/*!
	 * Callback that reports camera effect errors.
	 */
	-(void) onCameraEffectError:(VCConnectorCameraEffectError)error;
@end
@protocol VCConnectorIRegisterConferenceModeEventListener
	/*!
	 * Change to Callback that will be triggered when conference mode changes.
	 */
	-(void) onConferenceModeChanged:(VCConnectorConferenceMode)mode;
@end
@protocol VCConnectorIRegisterConnectionPropertiesEventListener
	/*!
	 * Callback that is triggered each time when connection properties is changed.
	 */
	-(void) onConnectionPropertiesChanged:(VCConnectorConnectionProperties*)connectionProperties;
@end
@protocol VCConnectorIRegisterErrorEventListener
	/*!
	 * Callback that is triggered to provide advanced error codes to the application.
	 */
	-(void) onError:(VCConnectorErrorCode)error ApiName:(NSString*)apiName;
@end
@protocol VCConnectorIRegisterHostEventListener
	/*!
	 * Callback that will be triggered when conference host joins or leaves.
	 */
	-(void) onConferenceHostStatusChanged:(VCParticipant*)host HostState:(VCConnectorConferenceHostState)hostState;
@end
@protocol VCConnectorIRegisterInCallEventListener
	/*!
	 * A callback to be invoked when any in call event to be sent to application.
	 */
	-(void) onInCallEvents:(VCConnectorInCallEvent*)ev;
@end
@protocol VCConnectorIRegisterLectureModeEventListener
	/*!
	 * Callback that is triggered each time when presenter changed.
	 */
	-(void) onPresenterChanged:(VCParticipant*)participant;
	/*!
	 * Callback that is triggered for the moderator every time someone raises their hand .
	 */
	-(void) onHandRaised:(NSMutableArray*)participant;
@end
@protocol VCConnectorIRegisterLocalCameraEventListener
	/*!
	 * Callback that is triggered each time a local camera becomes available to a VidyoConnector.
	 */
	-(void) onLocalCameraAdded:(VCLocalCamera*)localCamera;
	/*!
	 * Callback that is triggered each time a local camera is no longer available to a VidyoConnector.
	 */
	-(void) onLocalCameraRemoved:(VCLocalCamera*)localCamera;
	/*!
	 * Callback that is triggered each time there is a change in which local camera is selected for use.
	 */
	-(void) onLocalCameraSelected:(VCLocalCamera*)localCamera;
	/*!
	 * Callback that is triggered each time there is a change in the state of the camera such as being suspended or disabled.
	 */
	-(void) onLocalCameraStateUpdated:(VCLocalCamera*)localCamera State:(VCDeviceState)state;
@end
@protocol VCConnectorIRegisterLocalCameraFrameListener
	/*!
	 * Callback that is triggered each time a local camera produces a video frame.
	 */
	-(void) onLocalCameraFrame:(VCLocalCamera*)localCamera VideoFrame:(VCVideoFrame*)videoFrame;
@end
@protocol VCConnectorIRegisterLocalMicrophoneEnergyListener
	/*!
	 * Callback that is triggered each time a local microphone produces an audio frame with energy present.
	 */
	-(void) onLocalMicrophoneEnergy:(VCLocalMicrophone*)localMicrophone AudioEnergy:(int)audioEnergy;
@end
@protocol VCConnectorIRegisterLocalMicrophoneEventListener
	/*!
	 * Callback that is triggered each time a local microphone becomes available to a VidyoConnector.
	 */
	-(void) onLocalMicrophoneAdded:(VCLocalMicrophone*)localMicrophone;
	/*!
	 * Callback that is triggered each time a local microphone is no longer available to a VidyoConnector.
	 */
	-(void) onLocalMicrophoneRemoved:(VCLocalMicrophone*)localMicrophone;
	/*!
	 * Callback that is triggered each time there is a change in which local microphone is selected for use.
	 */
	-(void) onLocalMicrophoneSelected:(VCLocalMicrophone*)localMicrophone;
	/*!
	 * Callback that is triggered each time there is a change in the state of the microphone such as being suspended or disabled.
	 */
	-(void) onLocalMicrophoneStateUpdated:(VCLocalMicrophone*)localMicrophone State:(VCDeviceState)state;
@end
@protocol VCConnectorIRegisterLocalMicrophoneFrameListener
	/*!
	 * Callback that is triggered each time a local microphone produces an audio frame.
	 */
	-(void) onLocalMicrophoneFrame:(VCLocalMicrophone*)localMicrophone AudioFrame:(VCAudioFrame*)audioFrame;
@end
@protocol VCConnectorIRegisterLocalMonitorEventListener
	/*!
	 * Callback that is triggered each time a local monitor becomes available to a VidyoConnector.
	 */
	-(void) onLocalMonitorAdded:(VCLocalMonitor*)localMonitor;
	/*!
	 * Callback that is triggered each time a local monitor is no longer available to a VidyoConnector.
	 */
	-(void) onLocalMonitorRemoved:(VCLocalMonitor*)localMonitor;
	/*!
	 * Callback that is triggered each time there is a change in which local monitor is selected for sharing.
	 */
	-(void) onLocalMonitorSelected:(VCLocalMonitor*)localMonitor;
	/*!
	 * Callback that is triggered each time there is a change in the state of the monitor such as being suspended or disabled.
	 */
	-(void) onLocalMonitorStateUpdated:(VCLocalMonitor*)localMonitor State:(VCDeviceState)state;
@end
@protocol VCConnectorIRegisterLocalMonitorFrameListener
	/*!
	 * Callback that is triggered each time a local camera produces a video frame.
	 */
	-(void) onLocalMonitorFrame:(VCLocalMonitor*)localMonitor VideoFrame:(VCVideoFrame*)videoFrame;
@end
@protocol VCConnectorIRegisterLocalSpeakerEventListener
	/*!
	 * Callback that is triggered each time a local speaker becomes available to a VidyoConnector.
	 */
	-(void) onLocalSpeakerAdded:(VCLocalSpeaker*)localSpeaker;
	/*!
	 * Callback that is triggered each time a local speaker is no longer available to a VidyoConnector.
	 */
	-(void) onLocalSpeakerRemoved:(VCLocalSpeaker*)localSpeaker;
	/*!
	 * Callback that is triggered each time there is a change in which local speaker is selected for use.
	 */
	-(void) onLocalSpeakerSelected:(VCLocalSpeaker*)localSpeaker;
	/*!
	 * Callback that is triggered each time there is a change in the state of the speaker such as being suspended or disabled.
	 */
	-(void) onLocalSpeakerStateUpdated:(VCLocalSpeaker*)localSpeaker State:(VCDeviceState)state;
@end
@protocol VCConnectorIRegisterLocalWindowShareEventListener
	/*!
	 * Callback that is triggered each time a local window becomes available for a VidyoConnector to share in a conference.
	 */
	-(void) onLocalWindowShareAdded:(VCLocalWindowShare*)localWindowShare;
	/*!
	 * Callback that is triggered each time a local window is no longer available for a VidyoConnector to share in a conference.
	 */
	-(void) onLocalWindowShareRemoved:(VCLocalWindowShare*)localWindowShare;
	/*!
	 * Callback that is triggered each time there is a change in which local window is selected for sharing.
	 */
	-(void) onLocalWindowShareSelected:(VCLocalWindowShare*)localWindowShare;
	/*!
	 * Callback that is triggered each time there is a change in the state of the window such as being suspended or disabled.
	 */
	-(void) onLocalWindowShareStateUpdated:(VCLocalWindowShare*)localWindowShare State:(VCDeviceState)state;
@end
@protocol VCConnectorIRegisterLocalWindowShareFrameListener
	/*!
	 * Callback that is triggered each time a local camera produces a video frame.
	 */
	-(void) onLocalWindowShareFrame:(VCLocalWindowShare*)localWindowShare VideoFrame:(VCVideoFrame*)videoFrame;
@end
@protocol VCConnectorIRegisterLogEventListener
	/*!
	 * Callback that is triggered for every log record.
	 */
	-(void) onLog:(VCLogRecord*)logRecord;
@end
@protocol VCConnectorIRegisterMessageEventListener
	/*!
	 * Callback that is triggered each time a chat message is received from one of the other participants.
	 */
	-(void) onChatMessageReceived:(VCParticipant*)participant ChatMessage:(VCChatMessage*)chatMessage;
@end
@protocol VCConnectorIRegisterModerationCommandEventListener
	/*!
	 * Callback that will be tringgered when the moderation command will be recieved from the server.
	 */
	-(void) onModerationCommandReceived:(VCDeviceType)deviceType ModerationType:(VCRoomModerationType)moderationType State:(BOOL)state;
@end
@protocol VCConnectorIRegisterModerationResultEventListener
	/*!
	 * Callback that triggered when the moderation API is complete.
	 */
	-(void) onModerationResult:(VCParticipant*)participant Result:(VCConnectorModerationResult)result Action:(VCConnectorModerationActionType)action RequestId:(NSString*)requestId;
@end
@protocol VCConnectorIRegisterNGRResultEventListener
	/*!
	 * Callback providing final response for actions requested to next generation renderer.
	 */
	-(void) onNGRResult:(VCConnectorNGRActionType)type Success:(BOOL)success Error:(NSString*)error;
@end
@protocol VCConnectorIRegisterNetworkInterfaceEventListener
	/*!
	 * Callback that is triggered each time a network interface is available to a VidyoConnector.
	 */
	-(void) onNetworkInterfaceAdded:(VCNetworkInterface*)networkInterface;
	/*!
	 * Callback that is triggered each time a network interface is no longer available to a VidyoConnector.
	 */
	-(void) onNetworkInterfaceRemoved:(VCNetworkInterface*)networkInterface;
	/*!
	 * Callback that is triggered each time there is a change in which network interface is selected for use.
	 */
	-(void) onNetworkInterfaceSelected:(VCNetworkInterface*)networkInterface TransportType:(VCNetworkInterfaceTransportType)transportType;
	/*!
	 * Callback that is triggered each time there is a change in the state of the network interface such as being up or down.
	 */
	-(void) onNetworkInterfaceStateUpdated:(VCNetworkInterface*)networkInterface State:(VCNetworkInterfaceState)state;
@end
@protocol VCConnectorIRegisterParticipantEventListener
	/*!
	 * Callback that is triggered each time another participant joins a conference.
	 */
	-(void) onParticipantJoined:(VCParticipant*)participant;
	/*!
	 * Callback that is triggered each time an existing participant leaves a conference.
	 */
	-(void) onParticipantLeft:(VCParticipant*)participant;
	/*!
	 * Callback that is triggered each time the order of dyanmic participants has changed, based on active speech detection.
	 */
	-(void) onDynamicParticipantChanged:(NSMutableArray*)participants;
	/*!
	 * Callback that is triggered each time one of the other participants becomes the loudest, based on active speech detection.
	 */
	-(void) onLoudestParticipantChanged:(VCParticipant*)participant AudioOnly:(BOOL)audioOnly;
@end
@protocol VCConnectorIRegisterReconnectEventListener
	/*!
	 * Callback that is triggered when the reconnecting attempt has failed and new attempt will be started.
	 */
	-(void) onReconnecting:(unsigned int)attempt AttemptTimeout:(unsigned int)attemptTimeout Reason:(VCConnectorFailReason)reason;
	/*!
	 * This callback will be triggered when the connection was established and the user rejoined to the call/conference.
	 */
	-(void) onReconnected;
	/*!
	 * Callback that is triggered when reconnecting failed and there no more attempt to reconnect.
	 */
	-(void) onConferenceLost:(VCConnectorFailReason)reason;
@end
@protocol VCConnectorIRegisterRecorderInCallEventListener
	/*!
	 * Callback that is triggered each time a recorder joins or leaves the call.
	 */
	-(void) recorderInCall:(BOOL)hasRecorder IsPaused:(BOOL)isPaused;
@end
@protocol VCConnectorIRegisterRemoteCameraEventListener
	/*!
	 * Callback that is triggered each time one of the other participants adds a remote camera into a conference.
	 */
	-(void) onRemoteCameraAdded:(VCRemoteCamera*)remoteCamera Participant:(VCParticipant*)participant;
	/*!
	 * Callback that is triggered each time one of the other participants removes a remote camera from a conference.
	 */
	-(void) onRemoteCameraRemoved:(VCRemoteCamera*)remoteCamera Participant:(VCParticipant*)participant;
	/*!
	 * Callback that is triggered each time one of the other participants remote camera changes state in a conference.
	 */
	-(void) onRemoteCameraStateUpdated:(VCRemoteCamera*)remoteCamera Participant:(VCParticipant*)participant State:(VCDeviceState)state;
@end
@protocol VCConnectorIRegisterRemoteCameraFrameListener
	/*!
	 * Callback that is triggered each time a remote camera produces a video frame.
	 */
	-(void) onRemoteCameraFrame:(VCRemoteCamera*)remoteCamera Participant:(VCParticipant*)participant VideoFrame:(VCVideoFrame*)videoFrame;
@end
@protocol VCConnectorIRegisterRemoteMicrophoneEnergyListener
	/*!
	 * Callback that is triggered each time a remote microphone produces an frame with energy.
	 */
	-(void) onRemoteMicrophoneEnergy:(VCRemoteMicrophone*)remoteMicrophone Participant:(VCParticipant*)participant AudioEnergy:(int)audioEnergy;
@end
@protocol VCConnectorIRegisterRemoteMicrophoneEventListener
	/*!
	 * Callback that is triggered each time one of the other participants adds a remote microphone into a conference.
	 */
	-(void) onRemoteMicrophoneAdded:(VCRemoteMicrophone*)remoteMicrophone Participant:(VCParticipant*)participant;
	/*!
	 * Callback that is triggered each time one of the other participants removes a remote microphone from a conference.
	 */
	-(void) onRemoteMicrophoneRemoved:(VCRemoteMicrophone*)remoteMicrophone Participant:(VCParticipant*)participant;
	/*!
	 * Callback that is triggered each time one of the other participants remote microphone changes state in a conference.
	 */
	-(void) onRemoteMicrophoneStateUpdated:(VCRemoteMicrophone*)remoteMicrophone Participant:(VCParticipant*)participant State:(VCDeviceState)state;
@end
@protocol VCConnectorIRegisterRemoteMicrophoneFrameListener
	/*!
	 * Callback that is triggered each time a remote microphone produces an audio frame.
	 */
	-(void) onRemoteMicrophoneFrame:(VCRemoteMicrophone*)remoteMicrophone Participant:(VCParticipant*)participant AudioFrame:(VCAudioFrame*)audioFrame;
@end
@protocol VCConnectorIRegisterRemoteRendererEventListener
	/*!
	 * Callback that is triggered when server is ready to accept video stream from local camera.
	 */
	-(void) onRemoteRendererAdded:(VCRemoteRenderer*)remoteRenderer;
	/*!
	 * Callback that is triggered when server stops receiving video stream from local camera.
	 */
	-(void) onRemoteRendererRemoved:(VCRemoteRenderer*)remoteRenderer;
	/*!
	 * Callback that is triggered when server makes a state change on accepting audio stream.
	 */
	-(void) onRemoteRendererStateUpdated:(VCRemoteRenderer*)remoteRenderer State:(VCDeviceState)state;
@end
@protocol VCConnectorIRegisterRemoteSpeakerEventListener
	/*!
	 * Callback that is triggered when server is ready to accept audio stream from local microphone.
	 */
	-(void) onRemoteSpeakerAdded:(VCRemoteSpeaker*)remoteSpeaker;
	/*!
	 * Callback that is triggered when server stops receiving audio stream from local microphone.
	 */
	-(void) onRemoteSpeakerRemoved:(VCRemoteSpeaker*)remoteSpeaker;
	/*!
	 * Callback that is triggered when server makes a state change on accepting audio stream.
	 */
	-(void) onRemoteSpeakerStateUpdated:(VCRemoteSpeaker*)remoteSpeaker State:(VCDeviceState)state;
@end
@protocol VCConnectorIRegisterRemoteWindowShareEventListener
	/*!
	 * Callback that is triggered each time one of the other participants adds, or shares, a remote window into a conference.
	 */
	-(void) onRemoteWindowShareAdded:(VCRemoteWindowShare*)remoteWindowShare Participant:(VCParticipant*)participant;
	/*!
	 * Callback that is triggered each time one of the other participants removes a remote window from a conference, or stops sharing it.
	 */
	-(void) onRemoteWindowShareRemoved:(VCRemoteWindowShare*)remoteWindowShare Participant:(VCParticipant*)participant;
	/*!
	 * Callback that is triggered each time one of the other participants remote window changes state in a conference.
	 */
	-(void) onRemoteWindowShareStateUpdated:(VCRemoteWindowShare*)remoteWindowShare Participant:(VCParticipant*)participant State:(VCDeviceState)state;
@end
@protocol VCConnectorIRegisterRemoteWindowShareFrameListener
	/*!
	 * Callback that is triggered each time a remote camera produces a video frame.
	 */
	-(void) onRemoteWindowShareFrame:(VCRemoteWindowShare*)remoteWindowShare Participant:(VCParticipant*)participant VideoFrame:(VCVideoFrame*)videoFrame;
@end
@protocol VCConnectorIRegisterResourceManagerEventListener
	/*!
	 * Callback that is triggered each time the available local resources change. If there is no enough bandwidth for sources bandwidthSend and bandwidthReceive will be 0. If has enough bandwidth for sources bandwidthSend and bandwidthReceive will be 1-70%. If has more bandwidth than required for sources bandwidthSend and bandwidthReceive will be 70-100%.
	 */
	-(void) onAvailableResourcesChanged:(unsigned int)cpuEncode CpuDecode:(unsigned int)cpuDecode BandwidthSend:(unsigned int)bandwidthSend BandwidthReceive:(unsigned int)bandwidthReceive;
	/*!
	 * Callback that is triggered each time the local client's maximum decoding capability changes.
	 */
	-(void) onMaxRemoteSourcesChanged:(unsigned int)maxRemoteSources;
@end
@protocol VCConnectorIRegisterTokenReceivedEventListener
	/*!
	 * This is private callback that is triggered upon successful received tokens from the vidyo portal, for usage please contact vidyo api support team.
	 */
	-(void) onTokenReceived:(NSMutableArray*)tokenInfo;
@end
@protocol VCConnectorIRegisterVirtualAudioSourceEventListener
	/*!
	 * Callback that is triggered each time a virtual audio source becomes available for a VidyoConnector to add into a conference.
	 */
	-(void) onVirtualAudioSourceAdded:(VCVirtualAudioSource*)virtualAudioSource;
	/*!
	 * Callback that is triggered each time a virtual audio source is no longer available for a VidyoConnector to add into a conference.
	 */
	-(void) onVirtualAudioSourceRemoved:(VCVirtualAudioSource*)virtualAudioSource;
	/*!
	 * Callback that is triggered each time there is a change in the state of the window such as being suspended or disabled.
	 */
	-(void) onVirtualAudioSourceStateUpdated:(VCVirtualAudioSource*)virtualAudioSource State:(VCDeviceState)state;
	/*!
	 * Callback that is triggered when specific virtual audio source selected.
	 */
	-(void) onVirtualAudioSourceSelected:(VCVirtualAudioSource*)virtualAudioSource;
	/*!
	 * Callback that is triggered to notify application that VidyoClient is done with the buffer that holds raw audio frame. This buffer is the same one that was passed to VidyoClient via function VidyoVirtualAudioSourceSendFrameWithExternalData.
	 */
	-(void) onVirtualAudioSourceExternalMediaBufferReleased:(VCVirtualAudioSource*)virtualAudioSource Buffer:(unsigned char*)buffer Size:(size_t)size;
@end
@protocol VCConnectorIRegisterVirtualVideoSourceEventListener
	/*!
	 * Callback that is triggered each time a virtual video source becomes available for a VidyoConnector to add into a conference.
	 */
	-(void) onVirtualVideoSourceAdded:(VCVirtualVideoSource*)virtualVideoSource;
	/*!
	 * Callback that is triggered each time a virtual video source is no longer available for a VidyoConnector to add into a conference.
	 */
	-(void) onVirtualVideoSourceRemoved:(VCVirtualVideoSource*)virtualVideoSource;
	/*!
	 * Callback that is triggered each time there is a change in the state of the window such as being suspended or disabled.
	 */
	-(void) onVirtualVideoSourceStateUpdated:(VCVirtualVideoSource*)virtualVideoSource State:(VCDeviceState)state;
	/*!
	 * Callback that is triggered to notify application that VidyoClient is done with the buffer that holds raw video frame. This buffer is the same one that was passed to VidyoClient via function VidyoVirtualVideoSourceSendFrameWithExternalData.
	 */
	-(void) onVirtualVideoSourceExternalMediaBufferReleased:(VCVirtualVideoSource*)virtualVideoSource Buffer:(unsigned char*)buffer Size:(size_t)size;
@end
@protocol VCConnectorIRegisterWebProxyEventListener
	/*!
	 * Callback that is triggered when Web Proxy Server requires password.
	 */
	-(void) onWebProxyCredentialsRequest:(NSMutableString*)webProxyAddress;
@end
@protocol VCConnectorIRemoveModeratorRole
	/*!
	 * Callback that is triggered each time when the result of removing moderator role is received.
	 */
	-(void) onRemoveModeratorRoleResult:(VCConnectorModerationResult)result;
@end
@protocol VCConnectorIRemoveRoomPIN
	/*!
	 * Callback that is triggered each time when result of remove room pin is received.
	 */
	-(void) onRemoveRoomPINResult:(VCConnectorModerationResult)result;
@end
@protocol VCConnectorIRequestModeratorRole
	/*!
	 * Callback that is triggered each time when the result of requesting moderator role is received.
	 */
	-(void) onRequestModeratorRoleResult:(VCConnectorModerationResult)result;
@end
@protocol VCConnectorIRequestVideoForRemoteCamera
	/*!
	 * Callback that is triggered each time the first frame for remote camera received.
	 */
	-(void) onRemoteCameraFirstFrameReceived:(VCRemoteCamera*)remoteCamera;
@end
@protocol VCConnectorIRequestVideoForRemoteWindowShare
	/*!
	 * Callback that is triggered each time the first frame for remote window share received.
	 */
	-(void) onRemoteWindowShareFirstFrameReceived:(VCRemoteWindowShare*)remoteWindowShare;
@end
@protocol VCConnectorIResumeRecording
	/*!
	 * Callback that is triggered each time when result of recording service resume is received.
	 */
	-(void) onRecordingServiceResumeResult:(VCConnectorModerationResult)result;
@end
@protocol VCConnectorISearchUsers
	/*!
	 * Callback that is triggered for each user search operation.
	 */
	-(void) onUserSearchResults:(NSString*)searchText StartIndex:(unsigned int)startIndex SearchResult:(VCConnectorSearchResult)searchResult Contacts:(NSMutableArray*)contacts NumRecords:(size_t)numRecords;
@end
@protocol VCConnectorISetRoomPIN
	/*!
	 * Callback that is triggered each time when result of set room pin is received.
	 */
	-(void) onSetRoomPINResult:(VCConnectorModerationResult)result;
@end
@protocol VCConnectorIStartRecording
	/*!
	 * Callback that is triggered each time when result of recording service start is received.
	 */
	-(void) onRecordingServiceStartResult:(VCConnectorModerationResult)result;
@end
@protocol VCConnectorIStopRecording
	/*!
	 * Callback that is triggered each time when result of recording service stop is received.
	 */
	-(void) onRecordingServiceStopResult:(VCConnectorModerationResult)result;
@end
@protocol VCConnectorIUnlockRoom
	/*!
	 * Callback that is triggered each time when result of unlock room request is received.
	 */
	-(void) onUnlockRoomResult:(VCConnectorModerationResult)result;
@end
/*!
 * The videoconferencing API that handles all aspects of the media (audio/video) connection.
 */
@interface VCConnector : NSObject
{
	void* objPtr;
	NSMutableDictionary<NSString*, VCParticipant*> *participantsMap;
	NSMutableDictionary<NSString*, VCRemoteCamera*> *remoteCamerasMap;
	NSMutableDictionary<NSString*, VCRemoteMicrophone*> *remoteMicrophonesMap;
	NSMutableDictionary<NSString*, VCRemoteWindowShare*> *remoteWindowSharesMap;
	NSMutableDictionary<NSString*, id<VCConnectorIRequestVideoForRemoteCamera>> *onRemoteCameraFirstFrameReceivedCallbacksMap;
	NSMutableDictionary<NSString*, id<VCConnectorIRequestVideoForRemoteWindowShare>> *onRemoteWindowShareFirstFrameReceivedCallbacksMap;
	@public
	/*!
	 * This is an asynchronous interface. Connects to a live conference with the specified resourceId. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIConnect> connectorIConnect;
	/*!
	 * This is an asynchronous interface. Get the NetworkInterface for media and signaling. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIGetActiveNetworkInterface> connectorIGetActiveNetworkInterface;
	/*!
	 * This is an asynchronous interface. Gets the auto-reconnect settings. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIGetAutoReconnectSetting> connectorIGetAutoReconnectSetting;
	/*!
	 * This is a asynchronous interface. Gets the current configuration of camera background effect. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE. This functionality is supported only for macOS 10.14 and above, iOS 10.0 and above and Windows VC++ 15 and above.
	 */
	id<VCConnectorIGetCameraBackgroundEffect> connectorIGetCameraBackgroundEffect;
	/*!
	 * This is an asynchronous interface. Get the analytics event table. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIGetGoogleAnalyticsEventTable> connectorIGetGoogleAnalyticsEventTable;
	/*!
	 * This is a asynchronous interface. It returns google analytics configured options. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIGetGoogleAnalyticsOptions> connectorIGetGoogleAnalyticsOptions;
	/*!
	 * Asynchronously retrieves a vector of available recording profiles. Each element of this vector is a LmiString that contains a description of a recording profile as provided by the active recording server. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE. For example, STANDARD-QUALITY, HIGH-QUALITY, VOICE-ONLY. Calls a callback upon completion.
	 */
	id<VCConnectorIGetRecordingServiceProfiles> connectorIGetRecordingServiceProfiles;
	/*!
	 * This is an asynchronous interface. Gets the names of the audio devices that are whitelisted. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIGetWhitelistedAudioDevices> connectorIGetWhitelistedAudioDevices;
	/*!
	 * This is an asynchronous interface. This API provides the ability to the room owner, admin or moderators to invite other users to join this room for conference. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIInviteParticipant> connectorIInviteParticipant;
	/*!
	 * This is an asynchronous interface. This api provides the ability lock the current room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorILockRoom> connectorILockRoom;
	/*!
	 * Asynchronously pauses recording a conference. Must be called on behalf of a moderator. Fails in case recording is not in progress or already paused. Calls a callback upon completion. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIPauseRecording> connectorIPauseRecording;
	/*!
	 * This is an asynchronous interface. Each participant can send a moderation request to raise their hand to request to be unmuted. The Moderator and Presenter will be notified.
	 */
	id<VCConnectorIRaiseHand> connectorIRaiseHand;
	/*!
	 * This is a synchronous interface. Application can register a callback to get notified about bot participants. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterBotEventListener> connectorIRegisterBotEventListener;
	/*!
	 * This is a synchronous interface. Registers callback to notify the user in case of any errors occur during enabling camera effect.
	 */
	id<VCConnectorIRegisterCameraEffectErrorListener> connectorIRegisterCameraEffectErrorListener;
	/*!
	 * This is a synchronous interface. Registers the conference mode event listeners. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterConferenceModeEventListener> connectorIRegisterConferenceModeEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified when a connection properties is changed. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterConnectionPropertiesEventListener> connectorIRegisterConnectionPropertiesEventListener;
	/*!
	 * This is a synchronous interface. Registers the advanced error event listeners.
	 */
	id<VCConnectorIRegisterErrorEventListener> connectorIRegisterErrorEventListener;
	/*!
	 * This is a synchronous interface. Registers the host event listeners. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterHostEventListener> connectorIRegisterHostEventListener;
	/*!
	 * This is a synchronous interface. Sets the callback which will be triggered during a conference, these events may not stop the conferece but may degrade quality of call. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterInCallEventListener> connectorIRegisterInCallEventListener;
	/*!
	 * This is a synchronous interface. Registers the Lecture mode feature callbacks. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterLectureModeEventListener> connectorIRegisterLectureModeEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about local camera events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterLocalCameraEventListener> connectorIRegisterLocalCameraEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about camera frames. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterLocalCameraFrameListener> connectorIRegisterLocalCameraFrameListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about microphone energies. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterLocalMicrophoneEnergyListener> connectorIRegisterLocalMicrophoneEnergyListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about local microphone events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterLocalMicrophoneEventListener> connectorIRegisterLocalMicrophoneEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about microphone frames. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterLocalMicrophoneFrameListener> connectorIRegisterLocalMicrophoneFrameListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about local monitor events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterLocalMonitorEventListener> connectorIRegisterLocalMonitorEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about monitor frames. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterLocalMonitorFrameListener> connectorIRegisterLocalMonitorFrameListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about local speaker events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterLocalSpeakerEventListener> connectorIRegisterLocalSpeakerEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about local shareable-window events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterLocalWindowShareEventListener> connectorIRegisterLocalWindowShareEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about window frames. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterLocalWindowShareFrameListener> connectorIRegisterLocalWindowShareFrameListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about log events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterLogEventListener> connectorIRegisterLogEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about message events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterMessageEventListener> connectorIRegisterMessageEventListener;
	/*!
	 * This is a synchronous interface. Register a callback to receive moderation commands sent from the server. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterModerationCommandEventListener> connectorIRegisterModerationCommandEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about result of moderation APIs. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterModerationResultEventListener> connectorIRegisterModerationResultEventListener;
	/*!
	 * This is a synchronous interface. Register a callback to receive the final response for the Next Generation Renderer action. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterNGRResultEventListener> connectorIRegisterNGRResultEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about network interface events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterNetworkInterfaceEventListener> connectorIRegisterNetworkInterfaceEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about participant events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterParticipantEventListener> connectorIRegisterParticipantEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about reconnecting events. Note: You should not perform long action in the callbacks. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterReconnectEventListener> connectorIRegisterReconnectEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified when a recorder joins or leaves the call. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterRecorderInCallEventListener> connectorIRegisterRecorderInCallEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about remote camera events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterRemoteCameraEventListener> connectorIRegisterRemoteCameraEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about camera frames from other participants. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterRemoteCameraFrameListener> connectorIRegisterRemoteCameraFrameListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about microphone energies from other participants. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterRemoteMicrophoneEnergyListener> connectorIRegisterRemoteMicrophoneEnergyListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about remote microphone events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterRemoteMicrophoneEventListener> connectorIRegisterRemoteMicrophoneEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about microphone frames from other participants. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterRemoteMicrophoneFrameListener> connectorIRegisterRemoteMicrophoneFrameListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about remote renderer events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterRemoteRendererEventListener> connectorIRegisterRemoteRendererEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about remote speaker events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterRemoteSpeakerEventListener> connectorIRegisterRemoteSpeakerEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about remote shreable-window events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterRemoteWindowShareEventListener> connectorIRegisterRemoteWindowShareEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about window-share frames from other participants. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterRemoteWindowShareFrameListener> connectorIRegisterRemoteWindowShareFrameListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about resource-management events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterResourceManagerEventListener> connectorIRegisterResourceManagerEventListener;
	/*!
	 * This is a synchronous and private interface, for usage please contact vidyo api support team. Application can register a private callback to receive tokens from the vidyo portal. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterTokenReceivedEventListener> connectorIRegisterTokenReceivedEventListener;
	/*!
	 * Registers to get notified about virtual audio source events. This is a synchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterVirtualAudioSourceEventListener> connectorIRegisterVirtualAudioSourceEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about virtual video source events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterVirtualVideoSourceEventListener> connectorIRegisterVirtualVideoSourceEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about web proxy events. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRegisterWebProxyEventListener> connectorIRegisterWebProxyEventListener;
	/*!
	 * This is an asynchronous interface. This API provides the ability to remove moderator privilege. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRemoveModeratorRole> connectorIRemoveModeratorRole;
	/*!
	 * This is an asynchronous interface. This api provides the ability to remove the room pin. Once room pin is remove, all other users are not required to enter room pin to join conference room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRemoveRoomPIN> connectorIRemoveRoomPIN;
	/*!
	 * This is an asynchronous interface. This API provides the ability to request moderator privilege for the regular user. If the room is owned by this user or user is Admin/operator moderator pin can be empty string. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIRequestModeratorRole> connectorIRequestModeratorRole;
	/*!
	 * Asynchronously resumes recording a conference. Must be called on behalf of a moderator. Fails in case recording is not in progress or not paused. Calls a callback upon completion. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIResumeRecording> connectorIResumeRecording;
	/*!
	 * This is an asynchronous interface. Search for users in conference mode.
	 */
	id<VCConnectorISearchUsers> connectorISearchUsers;
	/*!
	 * This is an asynchronous interface. This api provides the ability to set the room pin. Once room pin is set, all other users are required to enter this room pin to join this conference room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorISetRoomPIN> connectorISetRoomPIN;
	/*!
	 * Asynchronously starts recording a conference using the specified recording profile. Must be called on behalf of a moderator. Fails in case another recording is in progress. Calls a callback upon completion. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIStartRecording> connectorIStartRecording;
	/*!
	 * Asynchronously stops recording a conference. Must be called on behalf of a moderator. Fails in case there is no recording in progress. Calls a callback upon completion. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIStopRecording> connectorIStopRecording;
	/*!
	 * This is an asynchronous interface. This api provides the ability unlock the current room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 */
	id<VCConnectorIUnlockRoom> connectorIUnlockRoom;
}
	/*!
	 * The videoconferencing API that handles all aspects of the media (audio/video) connection.
	 * @param c The VidyoConnector object.
	 * @param viewId A platform-specific view ID where the VidyoConnector's rendering window will be added as a child window. It will be used to render the preview and composite remote participants. When running custom layout on macOS, the core animation layer should be disabled on this view.
	 * @param viewStyle Type of the composite renderer which represents the visual style and behaviour.
	 * @param remoteParticipants Number of remote participants to composite into the window. Setting the value to 0 (zero) will render the preview only.
	 * @param logFileFilter <p>A space-separated (or comma-separated) sequence of names of log levels, each optionally followed by a category. Categories are separated from levels by the character '@'.</p> <p>Either a level or category may be specified as 'all' or '*' (interchangeably), meaning all levels or categories. A level specified without a category is equivalent to a level@*.</p> <p>The levels are: 'fatal', 'error', 'warning', 'info', 'debug', 'sent', 'received', 'enter', and 'leave'.</p> <p>The level may be prefixed by '-' or '!' (interchangeably), meaning to remove the given level (or levels, see below) from the given category. The string 'none' is equivalent to '-all'.</p> <p>The first level in the list may be prefixed by '+'. If the first level begins with a '+' or '-'/'!', the string is used to modify the listener's existing levels and categories. Otherwise, unless the <code>add</code> parameter is true, the levels and categories specified in the string replace all existing levels and categories for the listener. The leading character '+' may be present before other levels, but is ignored.</p> <p>Unless they are preceded by '=', level names imply other levels as well. In particular, each of the levels 'fatal', 'error', 'warning', 'info', and 'debug' implies the levels higher than it, when specified positively; 'sent' and 'received' always imply each other; and 'enter' and 'leave' always imply each other.</p> <p>See VidyoConnectorGetLogCategories for determining the names and descriptions of registered categories.</p> <p>Level names are case-insensitive; category names are case-sensitive.</p> <p>Example: "all" - all levels, all categories.</p> <p>Example: "all -enter" - all categories, all levels but enter and leave.</p> <p>Example: "*@VidyoClient" - all levels for the VidyoClient category.</p> <p>Example: "-*@VidyoClient" - remove all levels from the VidyoClient category.</p> <p>Example: "debug" - all categories, fatal, error, warning, info, and debug levels.</p> <p>Example: "=debug" - all categories, debug level only.</p> <p>Example: "all -=enter" - all categories, all levels but enter (leave is still included).</p> <p>Example: "error@VidyoClient" - fatal and error only for the VidyoClient category.</p> <p>Example: "warning debug@VidyoClient" - fatal, error, and warning for all categories; additionally, info and debug for the VidyoClient category.</p>
	 * @param logFileName Full path to the file where the log should be stored; otherwise, NULL or empty string, in order to use the default OS-dependent writable path.
	 * @param userData Arbitrary user data that can be retrieved later.
	 */
	-(id) init:(void*)viewId ViewStyle:(VCConnectorViewStyle)viewStyle RemoteParticipants:(unsigned int)remoteParticipants LogFileFilter:(const char*)logFileFilter LogFileName:(const char*)logFileName UserData:(long)userData;
	-(void) dealloc;
	/*!
	 * This is a synchronous interface. Adds audio device to whitelist. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param deviceName The name of audio device that will be whitelisted.
	 */
	-(BOOL) addAudioDeviceToWhitelist:(NSString*)deviceName;
	/*!
	 * This is a synchronous interface. Add message class that application should receive. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param messageClass Name of message class. MSGCLASS_HUNTER is added by default so application will receive only these message class.
	 */
	-(BOOL) addMessageClass:(const char*)messageClass;
	/*!
	 * This is an asynchronous interface. The Moderator can send a moderation request to approve a raised hand, in which case the participant whose hand was raised will be notified. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param participant Selected participant whose raised hand request is approved.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) approveRaisedHand:(VCParticipant*)participant RequestId:(NSString*)requestId;
	/*!
	 * This is a synchronous interface. Composites the preview and remote participants in a view. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disconnecting. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param viewId A platform specific view ID where the participant will be rendered.
	 * @param viewStyle Type of the composite renderer which represents the visual style and behaviour.
	 * @param remoteParticipants Number of remote participants to composite into the window. Setting the value to 0 will render preview only.
	 */
	-(BOOL) assignViewToCompositeRenderer:(void*)viewId ViewStyle:(VCConnectorViewStyle)viewStyle RemoteParticipants:(unsigned int)remoteParticipants;
	/*!
	 * This is a synchronous interface. Assigns the view in which to show the preview from a local camera. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param viewId A platform specific view ID where the participant will be rendered.
	 * @param localCamera The VidyoLocalCamera that will be shown.
	 * @param displayCropped Render the image as cropped. Otherwise letterbox.
	 * @param allowZoom Allow zooming of the image with mouse or touch.
	 */
	-(BOOL) assignViewToLocalCamera:(void*)viewId LocalCamera:(VCLocalCamera*)localCamera DisplayCropped:(BOOL)displayCropped AllowZoom:(BOOL)allowZoom;
	/*!
	 * This is a synchronous interface. Shows a VidyoLocalMonitor in a view. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param viewId A platform specific view ID where the VidyoLocalMonitor will be rendered.
	 * @param localMonitor The VidyoLocalMonitor that will be shown.
	 * @param displayCropped Render the image as cropped. Otherwise letterbox.
	 * @param allowZoom Allow zooming of the image with mouse or touch.
	 */
	-(BOOL) assignViewToLocalMonitor:(void*)viewId LocalMonitor:(VCLocalMonitor*)localMonitor DisplayCropped:(BOOL)displayCropped AllowZoom:(BOOL)allowZoom;
	/*!
	 * This is a synchronous interface. Shows a VidyoLocalWindowShare in a view. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param viewId A platform specific view ID where the VidyoLocalWindowShare will be rendered.
	 * @param localWindowShare The VidyoLocalWindowShare that will be shown.
	 * @param displayCropped Render the image as cropped. Otherwise letterbox.
	 * @param allowZoom Allow zooming of the image with mouse or touch.
	 */
	-(BOOL) assignViewToLocalWindowShare:(void*)viewId LocalWindowShare:(VCLocalWindowShare*)localWindowShare DisplayCropped:(BOOL)displayCropped AllowZoom:(BOOL)allowZoom;
	/*!
	 * This is a synchronous interface. Assigns the view in which to show the remote camera of one of the other participants. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param viewId A platform specific view ID where the participant will be rendered.
	 * @param remoteCamera The VidyoRemoteCamera that will be shown.
	 * @param displayCropped Render the image as cropped. Otherwise letterbox.
	 * @param allowZoom Allow zooming of the image with mouse or touch.
	 */
	-(BOOL) assignViewToRemoteCamera:(void*)viewId RemoteCamera:(VCRemoteCamera*)remoteCamera DisplayCropped:(BOOL)displayCropped AllowZoom:(BOOL)allowZoom;
	/*!
	 * This is a synchronous interface. Shows a VidyoRemoteWindowShare in a view. On, iOS, this API must be called from main(UI) thread. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param viewId A platform specific view ID where the VidyoRemoteWindowShare will be rendered.
	 * @param remoteWindowShare The VidyoRemoteWindowShare that will be shown.
	 * @param displayCropped Render the image as cropped. Otherwise letterbox.
	 * @param allowZoom Allow zooming of the image with mouse or touch.
	 */
	-(BOOL) assignViewToRemoteWindowShare:(void*)viewId RemoteWindowShare:(VCRemoteWindowShare*)remoteWindowShare DisplayCropped:(BOOL)displayCropped AllowZoom:(BOOL)allowZoom;
	/*!
	 * This is a synchronous interface. Shows a VidyoVirtualVideoSource in a view. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param viewId A platform specific view ID where the VidyoVirtualVideoSource will be rendered.
	 * @param virtualVideoSource The VidyoVirtualVideoSource that will be shown.
	 * @param displayCropped Render the image as cropped. Otherwise letterbox.
	 * @param allowZoom Allow zooming of the image with mouse or touch.
	 */
	-(BOOL) assignViewToVirtualVideoSource:(void*)viewId VirtualVideoSource:(VCVirtualVideoSource*)virtualVideoSource DisplayCropped:(BOOL)displayCropped AllowZoom:(BOOL)allowZoom;
	/*!
	 * This is an synchronous interface. This API provides the ability to cancels invitation of a participant. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param contact VidyoContactInfo object.
	 */
	-(BOOL) cancelInviteParticipant:(VCContactInfo*)contact;
	/*!
	 * This is an asynchronous interface. Connects to a live conference with the specified resourceId. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param host Host to which the connection will be made.
	 * @param token Token generated by the backend that contains the user ID and other metadata that will be used for authentication.
	 * @param displayName A display name that will be used in the UI.
	 * @param resourceId An alphanumeric string. This resourceId does not need to be pre-provisioned but in order to create a connection between multiple participants, the same resourceId has to be specified.
	 * @param onSuccess Callback that is triggered when the connection is successfully established.
	 * @param onFailure Callback that is triggered when the connection establishemnt failed.
	 * @param onDisconnected Callback that is triggered when an established connection is disconnected.
	 */
	-(BOOL) connect:(const char*)host Token:(const char*)token DisplayName:(const char*)displayName ResourceId:(const char*)resourceId ConnectorIConnect:(id<VCConnectorIConnect>)connectorIConnect;
	/*!
	 * This is an asynchronous interface. Connects to a live conference as guest with the specified room key on VidyoCloud. This API is not supported on Vidyo.io. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param host Host to which the connection will be made.
	 * @param displayName A display name that will be used in the UI.
	 * @param roomKey Room key.
	 * @param roomPin Room Pin / Password to enter the room.
	 * @param onSuccess Callback that is triggered when the connection is successfully established.
	 * @param onFailure Callback that is triggered when the connection establishemnt failed.
	 * @param onDisconnected Callback that is triggered when an established connection is disconnected.
	 */
	-(BOOL) connectToRoomAsGuest:(const char*)host DisplayName:(const char*)displayName RoomKey:(const char*)roomKey RoomPin:(const char*)roomPin ConnectorIConnect:(id<VCConnectorIConnect>)connectorIConnect;
	/*!
	 * This is an asynchronous interface. Connects to a live conference with the specified room ID on VidyoCloud. This API is not supported on Vidyo.io. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param host Host to which the connection will be made.
	 * @param userName User name.
	 * @param password Password.
	 * @param roomId Room ID.
	 * @param roomPin Room Pin/Password to enter the room.
	 * @param onSuccess Callback that is triggered when the connection is successfully established.
	 * @param onFailure Callback that is triggered when the connection establishemnt failed.
	 * @param onDisconnected Callback that is triggered when an established connection is disconnected.
	 */
	-(BOOL) connectToRoomWithId:(const char*)host UserName:(const char*)userName Password:(const char*)password RoomId:(const char*)roomId RoomPin:(const char*)roomPin ConnectorIConnect:(id<VCConnectorIConnect>)connectorIConnect;
	/*!
	 * This is an asynchronous interface. Connects to a live conference with the specified room key on VidyoCloud. This API is not supported on Vidyo.io. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param host Host to which the connection will be made.
	 * @param userName User name.
	 * @param password Password.
	 * @param roomKey Room key.
	 * @param roomPin Room Pin/Password to enter the room.
	 * @param onSuccess Callback that is triggered when the connection is successfully established.
	 * @param onFailure Callback that is triggered when the connection establishemnt failed.
	 * @param onDisconnected Callback that is triggered when an established connection is disconnected.
	 */
	-(BOOL) connectToRoomWithKey:(const char*)host UserName:(const char*)userName Password:(const char*)password RoomKey:(const char*)roomKey RoomPin:(const char*)roomPin ConnectorIConnect:(id<VCConnectorIConnect>)connectorIConnect;
	/*!
	 * This is an asynchronous interface. Connects to a live conference with the specified room ID on VidyoCloud. This API is not supported on Vidyo.io. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param host Host to which the connection will be made.
	 * @param userName User name.
	 * @param token Access Token.
	 * @param roomId Room ID.
	 * @param roomPin Room Pin/Password to enter the room.
	 * @param onSuccess Callback that is triggered when the connection is successfully established.
	 * @param onFailure Callback that is triggered when the connection establishemnt failed.
	 * @param onDisconnected Callback that is triggered when an established connection is disconnected.
	 */
	-(BOOL) connectToRoomWithTokenAndId:(const char*)host UserName:(const char*)userName Token:(const char*)token RoomId:(const char*)roomId RoomPin:(const char*)roomPin ConnectorIConnect:(id<VCConnectorIConnect>)connectorIConnect;
	/*!
	 * This is an asynchronous interface. Connects to a live conference with the specified room key. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param host Host to which the connection will be made.
	 * @param userName User name.
	 * @param token Access Token.
	 * @param roomKey Room Key.
	 * @param roomPin Room Pin/Password used to enter the room.
	 * @param onSuccess Callback that is triggered when the connection is successfully established.
	 * @param onFailure Callback that is triggered when the connection establishemnt failed.
	 * @param onDisconnected Callback that is triggered when an established connection is disconnected.
	 */
	-(BOOL) connectToRoomWithTokenAndKey:(const char*)host UserName:(const char*)userName Token:(const char*)token RoomKey:(const char*)roomKey RoomPin:(const char*)roomPin ConnectorIConnect:(id<VCConnectorIConnect>)connectorIConnect;
	/*!
	 * Create virtual audio source. This is an asynchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE. The VidyoConnectorOnVirtualAudioSourceAdded will trigger.
	 * @param c The VidyoConnector object.
	 * @param name The name for the virtual audio source.
	 * @param id The id for the virtual audio source.
	 * @param configuration The string in JSON format that contain audio configuration that will be used for virtual audio source. <p>format - Specifies the media format. Possible values are: fl32 or in16. The default is fl32.</p> <p>Example: {'format' : 'in16'}.</p> <p>sampleRate - Specifies the audio sample rate. Possible values are: 48000, 32000 and 16000. The default is 32000.</p> <p>Example: {'sampleRate' : 48000}.</p> <p>numberOfChannels - Specifies the number of channels. Possible values are: 1 or 2. The default is 1.</p> <p>Example: {'numberOfChannels' : 2}.</p> <p>frameInterval - Specifies the frame interval in ms. Possible values are: 20 or 40. The default is 20.</p> <p>Example: {'frameInterval' : 40}.</p>
	 */
	-(BOOL) createVirtualAudioSource:(NSString*)name Id:(NSString*)id Configuration:(NSString*)configuration;
	/*!
	 * This is an asynchronous interface. Create virtual video source. The user can create a maximum of 10 virtual video sources. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param type Type of the virtual video source.
	 * @param id Unique ID.
	 * @param name Name of the virtual video source.
	 */
	-(BOOL) createVirtualVideoSource:(VCVirtualVideoSourceType)type Id:(const char*)id Name:(const char*)name;
	/*!
	 * This is an asynchronous interface. Cycles camera selection to the next available camera. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) cycleCamera;
	/*!
	 * This is an asynchronous interface. Cycles microphone selection to the next available microphone. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) cycleMicrophone;
	/*!
	 * This is an asynchronous interface. Cycles speaker selection to the next available speaker. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) cycleSpeaker;
	/*!
	 * Destroy virtual audio source. This is an asynchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE. The VidyoConnectorOnVirtualAudioSourceRemoved will trigger.
	 * @param c The VidyoConnector object.
	 * @param virtualAudioSource The virtual audio source that will be destroyed.
	 */
	-(BOOL) destroyVirtualAudioSource:(VCVirtualAudioSource*)virtualAudioSource;
	/*!
	 * This is an asynchronous interface. Destroy virtual video source. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param virtualVideoSource The virtual video source that will be destroyed.
	 */
	-(BOOL) destroyVirtualVideoSource:(VCVirtualVideoSource*)virtualVideoSource;
	/*!
	 * This is a synchronous interface. Disables connector object, releases all devices as precursor to destruct. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disconnecting. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) disable;
	/*!
	 * This is an asynchronous interface. Set disable audio state for all participants in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c VidyoConnector object.
	 * @param disable Set to LMI_TRUE to stop all participants' audio. Audio cannot be resumed until another call with revoke set to LMI_FALSE.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) disableAudioForAll:(BOOL)disable RequestId:(NSString*)requestId;
	/*!
	 * This is an asynchronous interface. Set disable audio state for a selected participant in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c VidyoConnector object.
	 * @param participant VidyoParticipant Object whose audio is revoked/resumed.
	 * @param disable Set to LMI_TRUE to stop the participant's audio. Audio cannot be resumed until another call with revoke set to LMI_FALSE.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) disableAudioForParticipant:(VCParticipant*)participant Disable:(BOOL)disable RequestId:(NSString*)requestId;
	/*!
	 * This is an asynchronous interface. Set disable audio silence state for all participants in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c VidyoConnector object.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) disableAudioSilenceForAll:(NSString*)requestId;
	/*!
	 * This is an asynchronous interface. Set disable audio silence state for a selected participant in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c VidyoConnector object.
	 * @param participant VidyoParticipant object whose audio is revoked/resumed.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) disableAudioSilenceForParticipant:(VCParticipant*)participant RequestId:(NSString*)requestId;
	/*!
	 * This is a synchronous interface. Disable debug mode. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) disableDebug;
	/*!
	 * This is an asynchronous interface. Set video disable state for all participants in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c VidyoConnector object.
	 * @param disable Set to LMI_TRUE to stop all participants' video. Video cannot be resumed until another call with revoke set to LMI_FALSE.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) disableVideoForAll:(BOOL)disable RequestId:(NSString*)requestId;
	/*!
	 * This is an asynchronous interface. Set video disable state for a selected participant in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c VidyoConnector object.
	 * @param participant VidyoParticipant object whose audio is revoked/resumed.
	 * @param disable Set to LMI_TRUE to stop the participant's video. Video cannot be resumed until another call with revoke set to LMI_FALSE.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) disableVideoForParticipant:(VCParticipant*)participant Disable:(BOOL)disable RequestId:(NSString*)requestId;
	/*!
	 * This is an asynchronous interface. Set disable video silence state for all participants in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c VidyoConnector object.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) disableVideoSilenceForAll:(NSString*)requestId;
	/*!
	 * This is an asynchronous interface. Set disable video silence state for a selected participant in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c VidyoConnector object.
	 * @param participant VidyoParticipant Object whose video is revoked/resumed.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) disableVideoSilenceForParticipant:(VCParticipant*)participant RequestId:(NSString*)requestId;
	/*!
	 * This is an asynchronous interface. Disconnects a live conference. The onDisconnected callback will be called on successful execution. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) disconnect;
	/*!
	 * This is an asynchronous interface. The Moderator or the Presenter can send a moderation request to reject all hands raised, in which case all participants whose hand was raised will be notified. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) dismissAllRaisedHands:(NSString*)requestId;
	/*!
	 * This is an asynchronous interface. The Moderator or the Presenter can send a moderation request to decline a raised hands, in which case the participant whose hand was raised will be notified. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param participants List of selected participants whose raised hand request is going to dismiss.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) dismissRaisedHand:(NSMutableArray*)participants RequestId:(NSString*)requestId;
	/*!
	 * This is an asynchronous interface. Drop all participant out of a room, including the moderator used this API. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c VidyoConnector object.
	 * @param reason A message explaining the reason for the dropping. This can be NULL if no message is desired.
	 */
	-(BOOL) dropAllParticipants:(NSString*)reason;
	/*!
	 * This is an asynchronous interface. Drop one participant out of a room. Application needs to register VidyoConnectorRegisterModerationResultEventListener to get the result. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c VidyoConnector object.
	 * @param participant VidyoParticipant Object.
	 * @param reason A message explaining the reason for the booting. This can be NULL if no message is desired.
	 */
	-(BOOL) dropParticipant:(VCParticipant*)participant Reason:(NSString*)reason;
	/*!
	 * This is a synchronous interface. Enabled debug mode which will start debug logging and enable statistics. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param port Local listening port for debugging.
	 * @param logFilter Log filter to use on the debug port. Default log filter will be use if null or empty string is passed. <p>Example: warning debug@VidyoClient debug@VidyoConnector all@LmiPortalSession all@LmiPortalMembership debug@LmiResourceManager all@LmiIce all@LmiSignaling.</p>
	 */
	-(BOOL) enableDebug:(unsigned int)port LogFilter:(const char*)logFilter;
	/*!
	 * This is an asynchronous interface. Get the NetworkInterface for media and signaling. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onGetActiveNetworkInterfaceCallback Callback called upon completion.
	 */
	-(BOOL) getActiveNetworkInterface:(id<VCConnectorIGetActiveNetworkInterface>)connectorIGetActiveNetworkInterface;
	/*!
	 * This is a synchronous interface. Gets audio bitrate multiplier which is used when calculating the audio bitrate. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return -1.
	 * @param c The VidyoConnector object.
	 */
	-(int) getAudioBitrateMultiplier;
	/*!
	 * This is a synchronous interface. Gets the audio mode for both the audio devices (speaker and microphone). This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return VIDYO_CONNECTORAUDIOMODE_Unknown.
	 * @param c The VidyoConnector object.
	 */
	-(VCConnectorAudioMode) getAudioMode;
	/*!
	 * This is a synchronous interface. Gets time interval between two packet of audio in miliseconds. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return -1.
	 * @param c The VidyoConnector object.
	 */
	-(int) getAudioPacketInterval;
	/*!
	 * This is a synchronous interface. Gets audio loss percantage - value that is used to configure encoder. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return -1.
	 * @param c The VidyoConnector object.
	 */
	-(int) getAudioPacketLossPercentage;
	/*!
	 * This is a synchronous interface. Gets state of auto-reconnect. It's either enabled or disabled. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) getAutoReconnect;
	/*!
	 * This is a synchronous interface. Gets back off for next reconnect attempt. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(unsigned int) getAutoReconnectAttemptBackOff;
	/*!
	 * This is a synchronous interface. Gets maximum attempts to be done for reconnecting. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(unsigned int) getAutoReconnectMaxAttempts;
	/*!
	 * This is an asynchronous interface. Gets the auto-reconnect settings. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onGetAutoReconnectSettingCallback Callback called upon completion.
	 */
	-(BOOL) getAutoReconnectSetting:(id<VCConnectorIGetAutoReconnectSetting>)connectorIGetAutoReconnectSetting;
	/*!
	 * This is a asynchronous interface. Gets the current configuration of camera background effect. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE. This functionality is supported only for macOS 10.14 and above, iOS 10.0 and above and Windows VC++ 15 and above.
	 * @param c The VidyoConnector object.
	 * @param onGetEffectInfo Callback that reports the current configuration of camera background effect to the application. In case some error occurs NULL will be reported.
	 */
	-(BOOL) getCameraBackgroundEffect:(id<VCConnectorIGetCameraBackgroundEffect>)connectorIGetCameraBackgroundEffect;
	/*!
	 * This is a synchronous interface. Gets conference number - a special identifier that is showed up in the Portal CDR record for the conference. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and empty string returned.
	 * @param c The VidyoConnector object.
	 */
	-(NSString*) getConferenceNumber;
	/*!
	 * This is a synchronous interface. Get current CPU tradeoff profile setting. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(VCConnectorTradeOffProfile) getCpuTradeOffProfile;
	/*!
	 * This is a synchronous interface. Gets state of video on low bandwidth. It's either enabled or disabled. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) getDisableVideoOnLowBandwidth;
	/*!
	 * This is a synchronous interface. Gets number of audio streams requested while video is shut off. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(unsigned int) getDisableVideoOnLowBandwidthAudioStreams;
	/*!
	 * This is a synchronous interface. Gets time it takes to recover when video is shut off. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(unsigned int) getDisableVideoOnLowBandwidthRecoveryTime;
	/*!
	 * This is a synchronous interface. Gets time it takes to shut off video due to low bandwidth. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(unsigned int) getDisableVideoOnLowBandwidthResponseTime;
	/*!
	 * This is a synchronous interface. Gets how often checking for low bandwidth happens. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(unsigned int) getDisableVideoOnLowBandwidthSampleTime;
	/*!
	 * This is a synchronous interface. Gets low bandwidth threshold. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(unsigned int) getDisableVideoOnLowBandwidthThreshold;
	/*!
	 * This is an asynchronous interface. Get the analytics event table. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onGetGoogleAnalyticsEventTable Callback called upon completion.
	 */
	-(BOOL) getGoogleAnalyticsEventTable:(id<VCConnectorIGetGoogleAnalyticsEventTable>)connectorIGetGoogleAnalyticsEventTable;
	/*!
	 * This is a asynchronous interface. It returns google analytics configured options. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onGetGoogleAnalyticsOptions Callback called upon completion.
	 */
	-(BOOL) getGoogleAnalyticsOptions:(id<VCConnectorIGetGoogleAnalyticsOptions>)connectorIGetGoogleAnalyticsOptions;
	/*!
	 * This is a synchronous interface. It returns Insights Url if service is running. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(NSString*) getInsightsServiceUrl;
	/*!
	 * This is a synchronous interface. Allow application to get log level i.e production or debug. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return VIDYO_CONNECTORLOGLEVEL_INVALID.
	 * @param c The VidyoConnector object.
	 * @param loggerType logger type ( console, file, feedback, http).
	 */
	-(VCConnectorLogLevel) getLogLevel:(VCConnectorLoggerType)loggerType;
	/*!
	 * This is a synchronous interface. Return the max receive bit rate configured by application. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(unsigned int) getMaxReceiveBitRate;
	/*!
	 * This is a synchronous interface. Return the max send bit rate configured by application. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(unsigned int) getMaxSendBitRate;
	/*!
	 * This is a synchronous interface. Gets maximum microphone boost level that is applied only in the conference for the selected microphone in case the system is set to the higher value. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return -1.
	 * @param c The VidyoConnector object.
	 */
	-(double) getMicrophoneMaxBoostLevel;
	/*!
	 * This is a synchronous interface. Gets minimum microphone value that is applied only in the conference for the selected microphone in case the system is set to the lower value. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return -1.
	 * @param c The VidyoConnector object.
	 */
	-(short) getMinMicrophoneVolume;
	/*!
	 * This is a synchronous interface. Retrieves VidyoConnector options in JSON format. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(NSString*) getOptions;
	/*!
	 * This is a synchronous interface. Gets preferred audio codec name. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return VIDYO_CONNECTORPREFERREDAUDIOCODEC_Unknown.
	 * @param c The VidyoConnector object.
	 */
	-(VCConnectorPreferredAudioCodec) getPreferredAudioCodec;
	/*!
	 * Asynchronously retrieves a vector of available recording profiles. Each element of this vector is a LmiString that contains a description of a recording profile as provided by the active recording server. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE. For example, STANDARD-QUALITY, HIGH-QUALITY, VOICE-ONLY. Calls a callback upon completion.
	 * @param c Pointer to the VidyoConnector object.
	 * @param onGetRecordingProfilesCallback Callback called upon completion.
	 */
	-(BOOL) getRecordingServiceProfiles:(id<VCConnectorIGetRecordingServiceProfiles>)connectorIGetRecordingServiceProfiles;
	/*!
	 * This is a synchronous interface. Get the local renderer and conference tiles displaying options. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param viewId A platform-specific view ID.
	 */
	-(NSMutableString*) getRendererOptionsForViewId:(void*)viewId;
	/*!
	 * This is a synchronous interface. Retrieves the state of the VidyoConnector.
	 * @param c The VidyoConnector object.
	 */
	-(VCConnectorState) getState;
	/*!
	 * This is a synchronous interface. Gets whether SVC is enabled. The default is false. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) getStaticShareSvcState;
	/*!
	 * This is a synchronous interface. Gets conference room statistics gather interval in seconds. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return -1.
	 * @param c The VidyoConnector object.
	 */
	-(int) getStatisticRate;
	/*!
	 * This is a synchronous interface. Retrieves VidyoConnector statistics in JSON format. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(NSString*) getStatsJson;
	/*!
	 * This is a synchronous interface. Retrieves version of the VidyoConnector library.
	 * @param c The VidyoConnector object.
	 */
	-(NSString*) getVersion;
	/*!
	 * This is a synchronous interface. Retrieves version of the VidyoConnector library wihtout the build number.
	 * @param c The VidyoConnector object.
	 */
	-(NSString*) getVersionWithoutBuildNumber;
	/*!
	 * This is an asynchronous interface. Gets the names of the audio devices that are whitelisted. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onGetCallback Callback that will report an array with the names of audio devices that are whitelisted.
	 */
	-(BOOL) getWhitelistedAudioDevices:(id<VCConnectorIGetWhitelistedAudioDevices>)connectorIGetWhitelistedAudioDevices;
	/*!
	 * This is a synchronous interface. Control type of event action and categories of google analytics. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param eventCategory Type of event category. refer VidyoConnectorGoogleAnalyticsEventCategory.
	 * @param eventAction Type of event action. refer VidyoConnectorGoogleAnalyticsEventAction.
	 * @param enable Event action state flag.
	 */
	-(BOOL) googleAnalyticsControlEventAction:(VCConnectorGoogleAnalyticsEventCategory)eventCategory EventAction:(VCConnectorGoogleAnalyticsEventAction)eventAction Enable:(BOOL)enable;
	/*!
	 * This is a synchronous interface. Hides a view which is used for custom layout of sources. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param viewId The view ID of the view to hide.
	 */
	-(BOOL) hideView:(void*)viewId;
	/*!
	 * This is a synchronous interface. Notify the events as a part of analytics service. The event data will be sent to Loki analytics server if analytics service is started with VIDYO_CONNECTORANALYTICSSERVICETYPE_VidyoInsights. Event is automatically timestamped. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param eventName Event name.
	 * @param parameters Pointer to string vector event parameters. Can be NULL if no parameters are needed.
	 */
	-(BOOL) insightsNotifyEvent:(const char*)eventName Parameters:(NSMutableArray*)parameters;
	/*!
	 * This is an asynchronous interface. This API provides the ability to the room owner, admin or moderators to invite other users to join this room for conference. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c VidyoConnector object.
	 * @param contact VidyoContactInfo Object.
	 * @param message Invitation Message.
	 * @param onInviteResult Callback to be triggered for invitation result.
	 */
	-(BOOL) inviteParticipant:(VCContactInfo*)contact Message:(NSString*)message ConnectorIInviteParticipant:(id<VCConnectorIInviteParticipant>)connectorIInviteParticipant;
	/*!
	 * This is a synchronous interface. Checks whether Google Analytics service is running. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) isGoogleAnalyticsServiceEnabled;
	/*!
	 * This is a synchronous interface. Checks whether Insights service is running. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) isInsightsServiceEnabled;
	/*!
	 * This is an asynchronous interface. This api provides the ability lock the current room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c VidyoConnector object.
	 * @param onLockRoomResult Callback to be triggered for lock room result.
	 */
	-(BOOL) lockRoom:(id<VCConnectorILockRoom>)connectorILockRoom;
	/*!
	 * Asynchronously pauses recording a conference. Must be called on behalf of a moderator. Fails in case recording is not in progress or already paused. Calls a callback upon completion. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c Pointer to the VidyoConnector object.
	 * @param onRecordingServicePauseResultCallback Callback called upon completion.
	 */
	-(BOOL) pauseRecording:(id<VCConnectorIPauseRecording>)connectorIPauseRecording;
	/*!
	 * This is a synchronous interface. Pin a participant's video. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param participant A participant that will pinned/unpinned.
	 * @param pin LMI_TRUE to pin participant, LMI_FALSE to unpin.
	 */
	-(BOOL) pinParticipant:(VCParticipant*)participant Pin:(BOOL)pin;
	/*!
	 * This is an asynchronous interface. Each participant can send a moderation request to raise their hand to request to be unmuted. The Moderator and Presenter will be notified.
	 * @param c The VidyoConnector object.
	 * @param raiseHandResponse Callback that is triggered each time when response of hand raise request.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) raiseHand:(id<VCConnectorIRaiseHand>)connectorIRaiseHand RequestId:(NSString*)requestId;
	/*!
	 * This is a synchronous interface. Application can register a callback to get notified about bot participants. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onJoined Callback that is triggered when bot participant joins a conference.
	 * @param onLeft Callback that is triggered when an existing bot participant leaves a conference.
	 */
	-(BOOL) registerBotEventListener:(id<VCConnectorIRegisterBotEventListener>)connectorIRegisterBotEventListener;
	/*!
	 * This is a synchronous interface. Registers callback to notify the user in case of any errors occur during enabling camera effect.
	 * @param c The VidyoConnector object.
	 * @param onError The callback that will reports camera effect errors.
	 */
	-(BOOL) registerCameraEffectErrorListener:(id<VCConnectorIRegisterCameraEffectErrorListener>)connectorIRegisterCameraEffectErrorListener;
	/*!
	 * This is a synchronous interface. Registers the conference mode event listeners. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param conferenceModeChanged The VidyoConnectorOnConferenceModeChanged status as lecture,lobby or group.
	 */
	-(BOOL) registerConferenceModeEventListener:(id<VCConnectorIRegisterConferenceModeEventListener>)connectorIRegisterConferenceModeEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified when a connection properties is changed. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onConnectionPropertiesChanged Callback that is triggered when a connection properties is changed.
	 */
	-(BOOL) registerConnectionPropertiesEventListener:(id<VCConnectorIRegisterConnectionPropertiesEventListener>)connectorIRegisterConnectionPropertiesEventListener;
	/*!
	 * This is a synchronous interface. Registers the advanced error event listeners.
	 * @param c The VidyoConnector object.
	 * @param onErrorCallback Callback that is triggered when an error occurs.
	 */
	-(BOOL) registerErrorEventListener:(id<VCConnectorIRegisterErrorEventListener>)connectorIRegisterErrorEventListener;
	/*!
	 * This is a synchronous interface. Registers the host event listeners. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param hostStatus The VidyoConnectorOnConferenceHostStatusChanged status i..e host joined or left
	 */
	-(BOOL) registerHostEventListener:(id<VCConnectorIRegisterHostEventListener>)connectorIRegisterHostEventListener;
	/*!
	 * This is a synchronous interface. Sets the callback which will be triggered during a conference, these events may not stop the conferece but may degrade quality of call. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param cb The callback which will be triggered when error occur in conference.
	 */
	-(BOOL) registerInCallEventListener:(id<VCConnectorIRegisterInCallEventListener>)connectorIRegisterInCallEventListener;
	/*!
	 * This is a synchronous interface. Registers the Lecture mode feature callbacks. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param presenterChanged Callback that is triggered when presenter changed.
	 * @param handRaised Callback that is triggered for Moderator when some hand raised.
	 */
	-(BOOL) registerLectureModeEventListener:(id<VCConnectorIRegisterLectureModeEventListener>)connectorIRegisterLectureModeEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about local camera events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onAdded Callback that is triggered for every new or existing camera added.
	 * @param onRemoved Callback that is triggered when the camera is removed.
	 * @param onSelected Callback that is triggered when a camera is selected for use.
	 * @param onStateUpdated Callback that is triggered when a camera state is updated.
	 */
	-(BOOL) registerLocalCameraEventListener:(id<VCConnectorIRegisterLocalCameraEventListener>)connectorIRegisterLocalCameraEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about camera frames. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onFrame Callback that is triggered for every frame from a remote camera.
	 * @param localCamera The VidyoLocalCamera for which to receive the frames.
	 * @param width Approximate width of the requested frame.
	 * @param height Approximate height of the requested frame.
	 * @param frameInterval Approximate frame interval of the requested frame.
	 */
	-(BOOL) registerLocalCameraFrameListener:(id<VCConnectorIRegisterLocalCameraFrameListener>)connectorIRegisterLocalCameraFrameListener LocalCamera:(VCLocalCamera*)localCamera Width:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval;
	/*!
	 * This is a synchronous interface. Registers to get notified about microphone energies. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onEnergy Callback that is triggered for every frame from a microphone that has energy.
	 */
	-(BOOL) registerLocalMicrophoneEnergyListener:(id<VCConnectorIRegisterLocalMicrophoneEnergyListener>)connectorIRegisterLocalMicrophoneEnergyListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about local microphone events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onAdded Callback that is triggered for every new or existing microphone added.
	 * @param onRemoved Callback that is triggered when the microphone is removed.
	 * @param onSelected Callback that is triggered when a microphone is selected for use.
	 * @param onStateUpdated Callback that is triggered when a microphone state is updated.
	 */
	-(BOOL) registerLocalMicrophoneEventListener:(id<VCConnectorIRegisterLocalMicrophoneEventListener>)connectorIRegisterLocalMicrophoneEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about microphone frames. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onFrame Callback that is triggered for every frame from a microphone.
	 * @param localMicrophone The VidyoLocalMicrophone for which to receive the frames.
	 */
	-(BOOL) registerLocalMicrophoneFrameListener:(id<VCConnectorIRegisterLocalMicrophoneFrameListener>)connectorIRegisterLocalMicrophoneFrameListener LocalMicrophone:(VCLocalMicrophone*)localMicrophone;
	/*!
	 * This is a synchronous interface. Registers to get notified about local monitor events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onAdded Callback that is triggered for every new or existing monitor added.
	 * @param onRemoved Callback that is triggered when the monitor is removed.
	 * @param onSelected Callback that is triggered when a monitor is selected for use.
	 * @param onStateUpdated Callback that is triggered when a monitor state is updated.
	 */
	-(BOOL) registerLocalMonitorEventListener:(id<VCConnectorIRegisterLocalMonitorEventListener>)connectorIRegisterLocalMonitorEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about monitor frames. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onFrame Callback that is triggered for every frame from a monitor.
	 * @param localMonitor The VidyoLocalMonitor for which to receive the frames.
	 * @param width Approximate width of the requested frame.
	 * @param height Approximate height of the requested frame.
	 * @param frameInterval Approximate frame interval of the requested frame.
	 */
	-(BOOL) registerLocalMonitorFrameListener:(id<VCConnectorIRegisterLocalMonitorFrameListener>)connectorIRegisterLocalMonitorFrameListener LocalMonitor:(VCLocalMonitor*)localMonitor Width:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval;
	/*!
	 * This is a synchronous interface. Registers to get notified about local speaker events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onAdded Callback that is triggered for every new or existing speaker added.
	 * @param onRemoved Callback that is triggered when the speaker is removed.
	 * @param onSelected Callback that is triggered when a speaker is selected for use.
	 * @param onStateUpdated Callback that is triggered when a speaker state is updated.
	 */
	-(BOOL) registerLocalSpeakerEventListener:(id<VCConnectorIRegisterLocalSpeakerEventListener>)connectorIRegisterLocalSpeakerEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about local shareable-window events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onAdded Callback that is triggered for every new or existing window added.
	 * @param onRemoved Callback that is triggered when the window is removed.
	 * @param onSelected Callback that is triggered when a window is selected for use.
	 * @param onStateUpdated Callback that is triggered when a window state is updated.
	 */
	-(BOOL) registerLocalWindowShareEventListener:(id<VCConnectorIRegisterLocalWindowShareEventListener>)connectorIRegisterLocalWindowShareEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about window frames. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onFrame Callback that is triggered for every frame from a window.
	 * @param localWindowShare The VidyoLocalWindowShare for which to receive the frames.
	 * @param width Approximate width of the requested frame.
	 * @param height Approximate height of the requested frame.
	 * @param frameInterval Approximate frame interval of the requested frame.
	 */
	-(BOOL) registerLocalWindowShareFrameListener:(id<VCConnectorIRegisterLocalWindowShareFrameListener>)connectorIRegisterLocalWindowShareFrameListener LocalWindowShare:(VCLocalWindowShare*)localWindowShare Width:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval;
	/*!
	 * This is a synchronous interface. Registers to get notified about log events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onLog Callback that is triggered for every new log record.
	 * @param filter <p>A space-separated (or comma-separated) sequence of names of log levels, each optionally followed by a category. Categories are separated from levels by the character '@'.</p> <p>Either a level or category may be specified as 'all' or '*' (interchangeably), meaning all levels or categories. A level specified without a category is equivalent to a level@*.</p> <p>The levels are: 'fatal', 'error', 'warning', 'info', 'debug', 'sent', 'received', 'enter', and 'leave'.</p> <p>The level may be prefixed by '-' or '!' (interchangeably), meaning to remove the given level (or levels, see below) from the given category. The string 'none' is equivalent to '-all'.</p> <p>The first level in the list may be prefixed by '+'. If the first level begins with a '+' or '-'/'!', the string is used to modify the listener's existing levels and 45categories. Otherwise, unless the <code>add</code> parameter is true, the levels and categories specified in the string replace all existing levels and categories for the listener. The leading character '+' may be present before other levels, but is ignored.</p> <p>Unless they are preceded by '=', level names imply other levels as well. In particular, each of the levels 'fatal', 'error', 'warning', 'info', and 'debug' implies the levels higher than it, when specified positively; 'sent' and 'received' always imply each other; and 'enter' and 'leave' always imply each other.</p> <p>See VidyoConnectorGetLogCategories for determining the names and descriptions of registered categories.</p> <p>Level names are case-insensitive; category names are case-sensitive.</p> <p>Example: "all" - all levels, all categories.</p> <p>Example: "all -enter" - all categories, all levels but enter and leave.</p> <p>Example: "*@VidyoClient" - all levels for the VidyoClient category.</p> <p>Example: "-*@VidyoClient" - remove all levels from the VidyoClient category.</p> <p>Example: "debug" - all categories, fatal, error, warning, info, and debug levels.</p> <p>Example: "=debug" - all categories, debug level only.</p> <p>Example: "all -=enter" - all categories, all levels but enter (leave is still included).</p> <p>Example: "error@VidyoClient" - fatal and error only for the VidyoClient category.</p> <p>Example: "warning debug@VidyoClient" - fatal, error, and warning for all categories; additionally, info and debug for the VidyoClient category.</p>
	 */
	-(BOOL) registerLogEventListener:(id<VCConnectorIRegisterLogEventListener>)connectorIRegisterLogEventListener Filter:(const char*)filter;
	/*!
	 * This is a synchronous interface. Registers to get notified about message events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onChatMessageReceived Callback that is triggered when a chat message is received from a participant.
	 */
	-(BOOL) registerMessageEventListener:(id<VCConnectorIRegisterMessageEventListener>)connectorIRegisterMessageEventListener;
	/*!
	 * This is a synchronous interface. Register a callback to receive moderation commands sent from the server. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c VidyoConnector object.
	 * @param onModerationCommand Callback to be triggered upon receive moderation command from the server.
	 */
	-(BOOL) registerModerationCommandEventListener:(id<VCConnectorIRegisterModerationCommandEventListener>)connectorIRegisterModerationCommandEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about result of moderation APIs. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onModerationResult Callback that is triggered when the moderation API is complete.
	 */
	-(BOOL) registerModerationResultEventListener:(id<VCConnectorIRegisterModerationResultEventListener>)connectorIRegisterModerationResultEventListener;
	/*!
	 * This is a synchronous interface. Register a callback to receive the final response for the Next Generation Renderer action. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c VidyoConnector object.
	 * @param onNGRResult Callback to be triggered upon receive the final response from next generation renderer library.
	 */
	-(BOOL) registerNGRResultEventListener:(id<VCConnectorIRegisterNGRResultEventListener>)connectorIRegisterNGRResultEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about network interface events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onAdded Callback that is triggered for every new or existing network interface added.
	 * @param onRemoved Callback that is triggered when the network interface is removed.
	 * @param onSelected Callback that is triggered when a network interface is selected for use.
	 * @param onStateUpdated Callback that is triggered when a network interface state changes.
	 */
	-(BOOL) registerNetworkInterfaceEventListener:(id<VCConnectorIRegisterNetworkInterfaceEventListener>)connectorIRegisterNetworkInterfaceEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about participant events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onJoined Callback that is triggered when another participant joins a conference.
	 * @param onLeft Callback that is triggered when an existing participant leaves a conference.
	 * @param onDynamicChanged Callback that is triggered when the order of participants has changed, based on their importance according to active speech detection.
	 * @param onLoudestChanged Callback that is triggered when a new participant becomes the loudest, based on active speech detection.
	 */
	-(BOOL) registerParticipantEventListener:(id<VCConnectorIRegisterParticipantEventListener>)connectorIRegisterParticipantEventListener;
	/*!
	 * This is a synchronous interface. Registers plugin. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return NULL.
	 * @param c The VidyoConnector object.
	 * @param plugin Plugin to register.
	 */
	-(long) registerPlugin:(long)plugin;
	/*!
	 * This is a synchronous interface. Registers to get notified about reconnecting events. Note: You should not perform long action in the callbacks. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onReconnecting Callback that is triggered each time the new attempt to reconnect will be started.
	 * @param onReconnected Callback that is triggered when reconnecting was successful.
	 * @param onConferenceLost Callback that is triggered when reconnecting failed.
	 */
	-(BOOL) registerReconnectEventListener:(id<VCConnectorIRegisterReconnectEventListener>)connectorIRegisterReconnectEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified when a recorder joins or leaves the call. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onRecorderInCallChanged Callback that is triggered when a recorder joins or leaves the call.
	 */
	-(BOOL) registerRecorderInCallEventListener:(id<VCConnectorIRegisterRecorderInCallEventListener>)connectorIRegisterRecorderInCallEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about remote camera events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onAdded Callback that is triggered each time one of the other participants adds a remote camera into a conference.
	 * @param onRemoved Callback that is triggered each time one of the other participants removes a remote camera from a conference.
	 * @param onStateUpdated Callback that is triggered each time one of the other participants remote camera chagnes state in a conference.
	 */
	-(BOOL) registerRemoteCameraEventListener:(id<VCConnectorIRegisterRemoteCameraEventListener>)connectorIRegisterRemoteCameraEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about camera frames from other participants. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onFrame Callback that is triggered for every frame from a remote camera.
	 * @param remoteCamera The VidyoRemoteCamera for which to receive the frames.
	 * @param width Approximate width of the requested frame.
	 * @param height Approximate height of the requested frame.
	 * @param frameInterval Approximate frame interval of the requested frame.
	 */
	-(BOOL) registerRemoteCameraFrameListener:(id<VCConnectorIRegisterRemoteCameraFrameListener>)connectorIRegisterRemoteCameraFrameListener RemoteCamera:(VCRemoteCamera*)remoteCamera Width:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval;
	/*!
	 * This is a synchronous interface. Registers to get notified about microphone energies from other participants. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onEnergy Callback that is triggered for every frame with energy from a remote microphone.
	 */
	-(BOOL) registerRemoteMicrophoneEnergyListener:(id<VCConnectorIRegisterRemoteMicrophoneEnergyListener>)connectorIRegisterRemoteMicrophoneEnergyListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about remote microphone events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onAdded Callback that is triggered when another participant adds a microphone into a conference.
	 * @param onRemoved Callback that is triggered when another participant removes a microphone from a conference.
	 * @param onStateUpdated Callback that is triggered when another participant microphone changes state in a conference.
	 */
	-(BOOL) registerRemoteMicrophoneEventListener:(id<VCConnectorIRegisterRemoteMicrophoneEventListener>)connectorIRegisterRemoteMicrophoneEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about microphone frames from other participants. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onFrame Callback that is triggered for every frame from a remote microphone.
	 * @param remoteMicrophone The VidyoRemoteMicrophone for which to receive the frames.
	 */
	-(BOOL) registerRemoteMicrophoneFrameListener:(id<VCConnectorIRegisterRemoteMicrophoneFrameListener>)connectorIRegisterRemoteMicrophoneFrameListener RemoteMicrophone:(VCRemoteMicrophone*)remoteMicrophone;
	/*!
	 * This is a synchronous interface. Registers to get notified about remote renderer events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onAdded Callback that is triggered when server is ready to accept video stream from local camera.
	 * @param onRemoved Callback that is triggered when server stops receiving video stream from local camera.
	 * @param onStateUpdated Callback that is triggered when server makes a state change on accepting video stream.
	 */
	-(BOOL) registerRemoteRendererEventListener:(id<VCConnectorIRegisterRemoteRendererEventListener>)connectorIRegisterRemoteRendererEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about remote speaker events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onAdded Callback that is triggered when server is ready to accept audio stream from local microphone.
	 * @param onRemoved Callback that is triggered when server stops receiving audio stream from local microphone.
	 * @param onStateUpdated Callback that is triggered when server makes a state change on accepting audio stream.
	 */
	-(BOOL) registerRemoteSpeakerEventListener:(id<VCConnectorIRegisterRemoteSpeakerEventListener>)connectorIRegisterRemoteSpeakerEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about remote shreable-window events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onAdded Callback that is triggered when another participant adds a window-share into a conference.
	 * @param onRemoved Callback that is triggered when another participant removes a window-share from a conference.
	 * @param onStateUpdated Callback that is triggered when another participant window-share changes state in a conference.
	 */
	-(BOOL) registerRemoteWindowShareEventListener:(id<VCConnectorIRegisterRemoteWindowShareEventListener>)connectorIRegisterRemoteWindowShareEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about window-share frames from other participants. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onFrame Callback that is triggered for every frame from a remote window share.
	 * @param remoteWindowShare The VidyoRemoteWindowShare for which to receive the frames.
	 * @param width Approximate width of the requested frame.
	 * @param height Approximate height of the requested frame.
	 * @param frameInterval Approximate frame interval of the requested frame.
	 */
	-(BOOL) registerRemoteWindowShareFrameListener:(id<VCConnectorIRegisterRemoteWindowShareFrameListener>)connectorIRegisterRemoteWindowShareFrameListener RemoteWindowShare:(VCRemoteWindowShare*)remoteWindowShare Width:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval;
	/*!
	 * This is a synchronous interface. Registers to get notified about resource-management events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onAvailableResourcesChanged Callback that is triggered when local resource availability changes.
	 * @param onMaxRemoteSourcesChanged Callback that is triggered when the maximum number of decoded sources changes.
	 */
	-(BOOL) registerResourceManagerEventListener:(id<VCConnectorIRegisterResourceManagerEventListener>)connectorIRegisterResourceManagerEventListener;
	/*!
	 * This is a synchronous and private interface, for usage please contact vidyo api support team. Application can register a private callback to receive tokens from the vidyo portal. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onTokenReceived Callback that is triggered when the tokens are received from the vidyo portal.
	 */
	-(BOOL) registerTokenReceivedEventListener:(id<VCConnectorIRegisterTokenReceivedEventListener>)connectorIRegisterTokenReceivedEventListener;
	/*!
	 * Registers to get notified about virtual audio source events. This is a synchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onAdded Callback that is triggered each time when virtual audio source is created.
	 * @param onRemoved Callback that is triggered each time when virtual audio source is removed.
	 * @param onStateUpdated Callback that is triggered each time when virtual audio source chagnes state.
	 * @param onSelected Callback that is triggered each time when virtual audio source is selected.
	 * @param onExternalMediaBufferReleased Callback that is triggered each time when VidyoClient is done with an application allocated buffer that holds raw audio frame data.
	 */
	-(BOOL) registerVirtualAudioSourceEventListener:(id<VCConnectorIRegisterVirtualAudioSourceEventListener>)connectorIRegisterVirtualAudioSourceEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about virtual video source events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onAdded Callback that is triggered each time when virtual video source is added into a conference.
	 * @param onRemoved Callback that is triggered each time when virtual video source is added from a conference.
	 * @param onStateUpdated Callback that is triggered each time when virtual video source chagnes state in a conference.
	 * @param onExternalMediaBufferReleased Callback that is triggered each time when VidyoClient is done with an application allocated buffer that holds raw video frame.
	 */
	-(BOOL) registerVirtualVideoSourceEventListener:(id<VCConnectorIRegisterVirtualVideoSourceEventListener>)connectorIRegisterVirtualVideoSourceEventListener;
	/*!
	 * This is a synchronous interface. Registers to get notified about web proxy events. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param onWebProxyCredentialsRequest Callback that is triggered when web proxy credentials are requested.
	 */
	-(BOOL) registerWebProxyEventListener:(id<VCConnectorIRegisterWebProxyEventListener>)connectorIRegisterWebProxyEventListener;
	/*!
	 * This is a synchronous interface. Removes audio device from whitelist. This interface is allowed to be called in all VidyoConnector states except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param deviceName The name of audio device that will be removed from whitelist.
	 */
	-(BOOL) removeAudioDeviceFromWhitelist:(NSString*)deviceName;
	/*!
	 * This is an asynchronous interface. This API provides the ability for the room owner to remove authentication scheme for moderator functionality. Once moderator pin is removed, other users will not be able to moderate call on that room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c VidyoConnector object.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) removeModeratorPIN:(NSString*)requestId;
	/*!
	 * This is an asynchronous interface. This API provides the ability to remove moderator privilege. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c VidyoConnector object.
	 * @param onRemoveModeratorRoleResult Callback to be triggered when remove of moderator role is completed
	 */
	-(BOOL) removeModeratorRole:(id<VCConnectorIRemoveModeratorRole>)connectorIRemoveModeratorRole;
	/*!
	 * This is an asynchronous interface. Remove presenter rights from a specific participant. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) removePresenter:(NSString*)requestId;
	/*!
	 * This is an asynchronous interface. This api provides the ability to remove the room pin. Once room pin is remove, all other users are not required to enter room pin to join conference room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c VidyoConnector object.
	 * @param onRemoveRoomPinResult Callback to be triggered for remove room pin result.
	 */
	-(BOOL) removeRoomPIN:(id<VCConnectorIRemoveRoomPIN>)connectorIRemoveRoomPIN;
	/*!
	 * This is a synchronous interface. By default, local participant joining/leaving are not reported to applicaiotn. Use this function to report those events. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param reportLocalParticipant Set to LMI_TRUE if application is interested in local participant to be included in participant event callbacks. Otherwise set to LMI_FALSE. Default is LMI_FALSE
	 */
	-(BOOL) reportLocalParticipantOnJoined:(BOOL)reportLocalParticipant;
	/*!
	 * This is an asynchronous interface. This API provides the ability to request moderator privilege for the regular user. If the room is owned by this user or user is Admin/operator moderator pin can be empty string. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c VidyoConnector object.
	 * @param moderatorPIN set authentication scheme (moderator pIN) to get the moderatore role functionality. Empty string for admin/host.
	 * @param onRequestModeratorRoleResult Callback to be triggered when request of moderator role is completed
	 */
	-(BOOL) requestModeratorRole:(NSString*)moderatorPIN ConnectorIRequestModeratorRole:(id<VCConnectorIRequestModeratorRole>)connectorIRequestModeratorRole;
	/*!
	 * This is an asynchronous interface. Request to resume sending video after sever paused video stream from selected local camera. Will resume both local and remote streams and show preview in case it is on. Allowed only in case of soft mute. On, iOS, this API must be called from main(UI) thread. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) requestToResumeVideo;
	/*!
	 * This is an asynchronous interface. Request to speak after sever paused audio stream from selected local microphone. On, iOS, this API must be called from main(UI) thread. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) requestToSpeak;
	/*!
	 * This is an asynchronous interface. Requests video for remote camera before assign. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param remoteCamera The VidyoRemoteCamera for which to receive the video.
	 * @param width Approximate width of the requested video.
	 * @param height Approximate height of the requested video.
	 * @param frameInterval Approximate frame interval of the requested video.
	 * @param onFirstFrameReceived Callback that is triggered when first frame from a remote camera received.
	 */
	-(BOOL) requestVideoForRemoteCamera:(VCRemoteCamera*)remoteCamera Width:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval ConnectorIRequestVideoForRemoteCamera:(id<VCConnectorIRequestVideoForRemoteCamera>)connectorIRequestVideoForRemoteCamera;
	/*!
	 * This is an asynchronous interface. Requests video for remote window share before assign. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param remoteWindowShare The VidyoRemoteWindowShare for which to receive the video.
	 * @param width Approximate width of the requested video.
	 * @param height Approximate height of the requested video.
	 * @param frameInterval Approximate frame interval of the requested video.
	 * @param onFirstFrameReceived Callback that is triggered when first frame from a remote window share received.
	 */
	-(BOOL) requestVideoForRemoteWindowShare:(VCRemoteWindowShare*)remoteWindowShare Width:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval ConnectorIRequestVideoForRemoteWindowShare:(id<VCConnectorIRequestVideoForRemoteWindowShare>)connectorIRequestVideoForRemoteWindowShare;
	/*!
	 * Asynchronously resumes recording a conference. Must be called on behalf of a moderator. Fails in case recording is not in progress or not paused. Calls a callback upon completion. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c Pointer to the VidyoConnector object.
	 * @param onRecordingServiceResumeResultCallback Callback called upon completion.
	 */
	-(BOOL) resumeRecording:(id<VCConnectorIResumeRecording>)connectorIResumeRecording;
	/*!
	 * This is an asynchronous interface. Search for users in conference mode.
	 * @param c The VidyoConnector object pointer.
	 * @param searchText The search text to search users.
	 * @param startIndex The starting index from where the result should be retrieved.
	 * @param maxRecords The max number of records in the result.
	 * @param onUserSearchResults The callback which will receive the results.
	 */
	-(BOOL) searchUsers:(NSString*)searchText StartIndex:(unsigned int)startIndex MaxRecords:(unsigned int)maxRecords ConnectorISearchUsers:(id<VCConnectorISearchUsers>)connectorISearchUsers;
	/*!
	 * This is an asynchronous interface. Selects the local microphone to use for audio content share. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param localMicrophone Local microphone to select for audio content share. NULL if none of them should be selected.
	 */
	-(BOOL) selectAudioContentShare:(VCLocalMicrophone*)localMicrophone;
	/*!
	 * This is an asynchronous interface. Resets the camera selection to pick the Default camera. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) selectDefaultCamera;
	/*!
	 * This is an asynchronous interface. Resets the microphone selection to pick the Default microphone. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) selectDefaultMicrophone;
	/*!
	 * This is a synchronous interface. Selects the default ANY network interface to be used for Media. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) selectDefaultNetworkInterfaceForMedia;
	/*!
	 * This is a synchronous interface. Selects the default ANY network interface to be used for Signaling. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) selectDefaultNetworkInterfaceForSignaling;
	/*!
	 * This is a synchronous interface. Resets the speaker selection to pick the Default speaker. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) selectDefaultSpeaker;
	/*!
	 * This is an asynchronous interface. Selects the local camera to use. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param localCamera Local camera to select. NULL if none of them should be selected.
	 */
	-(BOOL) selectLocalCamera:(VCLocalCamera*)localCamera;
	/*!
	 * This is an asynchronous interface. Selects the local microphone to use. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param localMicrophone Local microphone to select. NULL if none of them should be selected.
	 */
	-(BOOL) selectLocalMicrophone:(VCLocalMicrophone*)localMicrophone;
	/*!
	 * This is an asynchronous interface. Selects the local monitor to share in a conference. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param localMonitor Local monitor to share in a conference. NULL if none of them should be shared.
	 */
	-(BOOL) selectLocalMonitor:(VCLocalMonitor*)localMonitor;
	/*!
	 * This is an asynchronous interface. Selects the local monitor to share in a conference. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param localMonitor Local monitor to share in a conference. NULL if none of them should be shared.
	 * @param options A structure that represent the sharing options.
	 */
	-(BOOL) selectLocalMonitorAdvanced:(VCLocalMonitor*)localMonitor Options:(VCConnectorShareOptions*)options;
	/*!
	 * This is an asynchronous interface. Selects the local speaker to use. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param localSpeaker Local speaker to select. NULL if none of them should be selected.
	 */
	-(BOOL) selectLocalSpeaker:(VCLocalSpeaker*)localSpeaker;
	/*!
	 * This is an asynchronous interface. Selects the local window to share in a conference. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param localWindowShare Local window to share in a conference. NULL if none of them should be shared.
	 */
	-(BOOL) selectLocalWindowShare:(VCLocalWindowShare*)localWindowShare;
	/*!
	 * This is an asynchronous interface. Selects the local window to share in a conference. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param localWindowShare Local window to share in a conference. NULL if none of them should be shared.
	 * @param options A structure that represent the sharing options.
	 */
	-(BOOL) selectLocalWindowShareAdvanced:(VCLocalWindowShare*)localWindowShare Options:(VCConnectorShareOptions*)options;
	/*!
	 * This is a synchronous interface. Selects the network interface to be used for Media. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param networkInterface Network interface to be selected.
	 */
	-(BOOL) selectNetworkInterfaceForMedia:(VCNetworkInterface*)networkInterface;
	/*!
	 * This is a synchronous interface. Selects the network interface to be used for Signaling. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param networkInterface Network interface to be selected.
	 */
	-(BOOL) selectNetworkInterfaceForSignaling:(VCNetworkInterface*)networkInterface;
	/*!
	 * This is an asynchronous interface. Selects the local camera to use for video content share. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param localCamera Local camera to select. NULL if none of them should be selected.
	 */
	-(BOOL) selectVideoContentShare:(VCLocalCamera*)localCamera;
	/*!
	 * Selects the virtual audio source which will be used for content share. The selected microphone which currently using for content share will be unselected. This is a synchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE. The VidyoConnectorOnVirtualAudioSourceStateUpdated will trigger.
	 * @param c The VidyoConnector object.
	 * @param virtualAudioSource The virtual audio source that will be used for content share.
	 */
	-(BOOL) selectVirtualAudioContentShare:(VCVirtualAudioSource*)virtualAudioSource;
	/*!
	 * This is a synchronous interface. Selects the virtual video source which is camera that will be shown to remote participants. The real camera will be unselected if it's selected. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param virtualCamera The virtual video source that will be shown to remote participants.
	 */
	-(BOOL) selectVirtualCamera:(VCVirtualVideoSource*)virtualCamera;
	/*!
	 * Selects the virtual audio source which will be used as microphone. The real miicrophone will be unselected if it's selected. This is a synchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE. The VidyoConnectorOnVirtualAudioSourceStateUpdated will trigger.
	 * @param c The VidyoConnector object.
	 * @param virtualAudioSource The virtual audio source that will be used as microphone.
	 */
	-(BOOL) selectVirtualMicrophone:(VCVirtualAudioSource*)virtualAudioSource;
	/*!
	 * This is a synchronous interface. Selects the virtual renderer to receive all events required for rendering. On, iOS, this API must be called from main(UI) thread. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param renderer The virtual renderer object to select, NULL to unselect.
	 */
	-(BOOL) selectVirtualRenderer:(VCVirtualRenderer*)renderer;
	/*!
	 * This is a synchronous interface. Selects the virtual video source which is window share that will be shown to remote participants. The local window share will be unselected if it's selected. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param virtualWindowShare The virtual video source that will be shown to remote participants.
	 */
	-(BOOL) selectVirtualSourceWindowShare:(VCVirtualVideoSource*)virtualWindowShare;
	/*!
	 * This is a synchronous interface. Sends a message to all the other participants. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param message A message to send to all the other participants.
	 */
	-(BOOL) sendChatMessage:(const char*)message;
	/*!
	 * This is a synchronous interface. Sends a message to the specific participant. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param participant A participant that will receive message.
	 * @param message A message to send to the specific participants.
	 */
	-(BOOL) sendPrivateChatMessage:(VCParticipant*)participant Message:(const char*)message;
	/*!
	 * Sends already constructed audio frame to selected virtual audio source and then send it to local and/or remote streams. This is a synchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param virtualAudioSource The virtual audio source.
	 * @param audioFrame The audio frame to be sent.
	 */
	-(BOOL) sendVirtualAudioSourceFrame:(VCVirtualAudioSource*)virtualAudioSource AudioFrame:(VCAudioFrame*)audioFrame;
	/*!
	 * Pass raw buffer to selected virtual audio source, based on which the audio frame will be constructed and then send it to local and/or remote streams. This is an asynchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE. The VidyoConnectorOnVirtualAudioSourceExternalMediaBufferReleased will trigger when buffer is not needed anymore.
	 * @param c The VidyoConnector object.
	 * @param virtualAudioSource The virtual audio source.
	 * @param buffer The buffer with audio data to be sent.
	 * @param nbSamples The number of sample frames that will be represented in the audio data.
	 * @param elapsedTime The elapsed time.
	 */
	-(BOOL) sendVirtualAudioSourceFrameWithExternalData:(VCVirtualAudioSource*)virtualAudioSource Buffer:(unsigned char*)buffer NbSamples:(size_t)nbSamples ElapsedTime:(long)elapsedTime;
	/*!
	 * This is a synchronous interface. Allow application to set advanced log options in addition to standard ones. The given log levels and categories string will be added to current log level the application is running with. The string should be valid for this API to work correctly. e.g debug@VidyoConnector debug@VidyoClient.
	 * @param c The VidyoConnector object.
	 * @param loggerType The loggerType console, file, feedback, http.
	 * @param advancedLogFilter advanced log options in addition to standard ones. <p>A space-separated (or comma-separated) sequence of names of log levels, each optionally followed by a category. Categories are separated from levels by the character '@'.</p> <p>Either a level or category may be specified as 'all' or '*' (interchangeably), meaning all levels or categories. A level specified without a category is equivalent to a level@*.</p> <p>The levels are: 'fatal', 'error', 'warning', 'info', 'debug', 'sent', 'received', 'enter', and 'leave'.</p> <p>The level may be prefixed by '-' or '!' (interchangeably), meaning to remove the given level (or levels, see below) from the given category. The string 'none' is equivalent to '-all'.</p> <p>The first level in the list may be prefixed by '+'. If the first level begins with a '+' or '-'/'!', the string is used to modify the listener's existing levels and categories. Otherwise, unless the <code>add</code> parameter is true, the levels and categories specified in the string replace all existing levels and categories for the listener. The leading character '+' may be present before other levels, but is ignored.</p> <p>Unless they are preceded by '=', level names imply other levels as well. In particular, each of the levels 'fatal', 'error', 'warning', 'info', and 'debug' implies the levels higher than it, when specified positively; 'sent' and 'received' always imply each other; and 'enter' and 'leave' always imply each other.</p> <p>See VidyoConnectorGetLogCategories for determining the names and descriptions of registered categories.</p> <p>Level names are case-insensitive; category names are case-sensitive.</p> <p>Example: "all" - all levels, all categories.</p> <p>Example: "all -enter" - all categories, all levels but enter and leave.</p> <p>Example: "*@VidyoClient" - all levels for the VidyoClient category.</p> <p>Example: "-*@VidyoClient" - remove all levels from the VidyoClient category.</p> <p>Example: "debug" - all categories, fatal, error, warning, info, and debug levels.</p> <p>Example: "=debug" - all categories, debug level only.</p> <p>Example: "all -=enter" - all categories, all levels but enter (leave is still included).</p> <p>Example: "error@VidyoClient" - fatal and error only for the VidyoClient category.</p> <p>Example: "warning debug@VidyoClient" - fatal, error, and warning for all categories; additionally, info and debug for the VidyoClient category.</p>
	 */
	-(BOOL) setAdvancedLogOptions:(VCConnectorLoggerType)loggerType AdvancedLogFilter:(NSString*)advancedLogFilter;
	/*!
	 * This is a synchronous interface. Sets up advanced options on the VidyoConnector API. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param options The experimental optons in JSON format.
	 */
	-(BOOL) setAdvancedOptions:(const char*)options;
	/*!
	 * This is a synchronous interface. Sets multiplier value to be used when calculating the audio bitrate. Default is 2. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param bitrateMultiplier Bitrate multiplier for which possible values are 0, 1 and 2.
	 */
	-(BOOL) setAudioBitrateMultiplier:(unsigned int)bitrateMultiplier;
	/*!
	 * This is a synchronous interface. Enables or disables usage of audio devices (speaker and microphone) in different audio modes. By default SharedModeBoth is enabled. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param audioMode Indicates which audio mode is enabled/disabled for both audio devices. For possible values of the audio mode, refer VidyoConnectorAudioMode.
	 */
	-(BOOL) setAudioMode:(VCConnectorAudioMode)audioMode;
	/*!
	 * This is a synchronous interface. Sets time interval between two packet of audio in miliseconds. Default is 40 ms. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param packetInterval Packet interval for which possible values are 20, and 40 ms.
	 */
	-(BOOL) setAudioPacketInterval:(unsigned int)packetInterval;
	/*!
	 * This is a synchronous interface. Sets value that is used to configure encoder. If given higher value then encoder is configured to resistant to loss on the expense of quality. Default is 10%. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param lossPercentage Loss percantage for which possible values are [0, 10, 20, 30] in percentage.
	 */
	-(BOOL) setAudioPacketLossPercentage:(unsigned int)lossPercentage;
	/*!
	 * This is a synchronous interface. Enables or disables auto-reconnect. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param enable Indicates whether auto-reconnect is enabled or not.
	 */
	-(BOOL) setAutoReconnect:(BOOL)enable;
	/*!
	 * This is a synchronous interface. Sets back off for next reconnect attempt. By default, it is set to 5 seconds. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param backOff Time in seconds before next reconnect attempt. Min value is 2 and the max is 20 seconds.
	 */
	-(BOOL) setAutoReconnectAttemptBackOff:(unsigned int)backOff;
	/*!
	 * This is a synchronous interface. Sets maximum attempts to be done for reconnecting. By default, it is set to 3. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param maxAttempts Number of maximum attempts to be done for reconnecting. Min value is 1 and the max is 4.
	 */
	-(BOOL) setAutoReconnectMaxAttempts:(unsigned int)maxAttempts;
	/*!
	 * This is a synchronous interface. Sets the intensity of the background blur effect. It is allowed to change blur intensity while the effect is enabled. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE. This functionality is supported only for macOS 10.14 and above, iOS 10.0 and above and Windows VC++ 15 and above.
	 * @param c The VidyoConnector object.
	 * @param intensity The intensity of the background blur effect. Valid valies is [3-8]. Default value is 5.
	 */
	-(BOOL) setBlurIntensity:(unsigned int)intensity;
	/*!
	 * This is a synchronous interface. Enables the specified by VidyoConnectorCameraEffectType camera background effect or disables active effect if VIDYO_CONNECTORCAMERAEFFECTTYPE_None passed. The application must provide token to enable this feature as part of VidyoConnectorCameraEffectInfo structure. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE. This functionality is supported only for macOS 10.14 and above, iOS 10.0 and above and Windows VC++ 15 and above.
	 * @param c The VidyoConnector object.
	 * @param effectInfo Represents the configuration of camera background effect.
	 */
	-(BOOL) setCameraBackgroundEffect:(VCConnectorCameraEffectInfo*)effectInfo;
	/*!
	 * This is a synchronous interface. Sets camera PTZ nudge configuration. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param cameraNudgeConfig Camera PTZ nudge configuration in JSON format.
	 */
	-(BOOL) setCameraNudgeConfiguration:(const char*)cameraNudgeConfig;
	/*!
	 * This is an asynchronous interface. Sets the flag to show/hide the local camera for remote participants for composite/custom layout and local camera preview for composite layout only. Will also unmute a soft mute(Hunter only). On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param privacy Flag to show/hide the local camera.
	 */
	-(BOOL) setCameraPrivacy:(BOOL)privacy;
	/*!
	 * This is a synchronous interface. Sets the file that contains certificate authority's certificates used to authenticate a TLS connection. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param certificateAuthorityFile The string representing Certificate Authority file. Note: The string must containt full path and name of file.
	 */
	-(BOOL) setCertificateAuthorityFile:(const char*)certificateAuthorityFile;
	/*!
	 * This is a synchronous interface. Sets the list of certificate authority's certificates used to authenticate a TLS connection. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param certificateAuthorityList The string representing Certificate Authority lists. Note: If the string 'default' is passed here, VidyoConnector will use a built-in Certificate Authority list.
	 */
	-(BOOL) setCertificateAuthorityList:(const char*)certificateAuthorityList;
	/*!
	 * This is a synchronous interface. Sets conference number - a special identifier that will show up in the Portal CDR record for the conference. Should be set before joining the conference. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param conferenceNumber Conference number to be set.
	 */
	-(BOOL) setConferenceNumber:(NSString*)conferenceNumber;
	/*!
	 * This is a synchronous interface. Set CPU tradeoff profile. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param profile The tradeoff profile.
	 */
	-(BOOL) setCpuTradeOffProfile:(VCConnectorTradeOffProfile)profile;
	/*!
	 * This is a synchronous interface. When enabled, all video feeds (video and content share) will be shut off to the client when the user experiences prolonged low network bandwidth. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param enable Indicates whether disable video on low bandwidth is enabled or not.
	 */
	-(BOOL) setDisableVideoOnLowBandwidth:(BOOL)enable;
	/*!
	 * This is a synchronous interface. Sets number of audio streams requested while video is shut off. By default, it is set to 3. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param audioStreams Number of audio streams requested while video is shut off. Min value is 1 and max is 3.
	 */
	-(BOOL) setDisableVideoOnLowBandwidthAudioStreams:(unsigned int)audioStreams;
	/*!
	 * This is a synchronous interface. Sets time it takes to recover when video is shut off. By default, it is set to 0 seconds which means never. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param recoveryTime Time it takes to recover when video is shut off. Recovery can only happen when there are no available video sources.
	 */
	-(BOOL) setDisableVideoOnLowBandwidthRecoveryTime:(unsigned int)recoveryTime;
	/*!
	 * This is a synchronous interface. Sets time it takes to shut off video due to low bandwidth. By default, it is set to 30 seconds. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param responseTime Time it takes to shut off video due to low bandwidth.
	 */
	-(BOOL) setDisableVideoOnLowBandwidthResponseTime:(unsigned int)responseTime;
	/*!
	 * This is a synchronous interface. Sets how often to check for low bandwidth. By default, it is set to 5 seconds. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param sampleTime How often to check for low bandwidth. Must divide evenly into responseTime.
	 */
	-(BOOL) setDisableVideoOnLowBandwidthSampleTime:(unsigned int)sampleTime;
	/*!
	 * This is a synchronous interface. Sets low bandwidth threshold. By default, it is set to 100kpbs. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param kbps Threshold for low bandwidth in kilobits/sec.
	 */
	-(BOOL) setDisableVideoOnLowBandwidthThreshold:(unsigned int)kbps;
	/*!
	 * This is a synchronous interface. Sets log file size limit, how often to initiate the wrap, and number of log files. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param maxSize The number of bytes of logged messages to save.
	 * @param wrapPeriod How often to initiate the wrap in nanoseconds. If this value is LMI_TIME_INFINITE, the log file will not be wrapped based on time.
	 * @param wrapCount The maximum number of files to keep.
	 */
	-(BOOL) setFileLoggerRotationParameters:(size_t)maxSize WrapPeriod:(long)wrapPeriod WrapCount:(size_t)wrapCount;
	/*!
	 * This is a synchronous interface. Set font file name. On, iOS, this API must be called from main(UI) thread. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param fontFileName Pointer to char array that contains font file name. Note: on Windows this must be the name of a system TrueType font. For example "Microsoft YaHei"
	 */
	-(BOOL) setFontFileName:(const char*)fontFileName;
	/*!
	 * This is a synchronous interface. Sets the geographic location of the endpoint using the VidyoConnector. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param latitude Latitude of the geographic coordinate.
	 * @param longitude Longitude of the geographic coordinate.
	 */
	-(BOOL) setLocation:(double)latitude Longitude:(double)longitude;
	/*!
	 * This is a synchronous interface. Sets new path to log file. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param filename The name of the file to log to. Note: Can be passed just filename or with full path so that location will be changed.
	 */
	-(BOOL) setLogFilePath:(const char*)filename;
	/*!
	 * This is a synchronous interface. Allow application to replace log level of logger(console, file, feedback, http) as production or debug. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param loggerType loggerType console, file, feedback, http.
	 * @param logLevel log level production or debug.
	 */
	-(BOOL) setLogLevel:(VCConnectorLoggerType)loggerType LogLevel:(VCConnectorLogLevel)logLevel;
	/*!
	 * This is a synchronous interface. Sets the max send bit rate for all sources. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param bitRate The max send bit rate for all sources.
	 */
	-(BOOL) setMaxBitRate:(unsigned int)bitRate;
	/*!
	 * This is a synchronous interface. Request server to limit bit rate sent to this client. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CNNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param bitRate The maximum receiving bit rate request sent to server, in bps.
	 */
	-(BOOL) setMaxReceiveBitRate:(unsigned int)bitRate;
	/*!
	 * This is a synchronous interface. Sets the max send bit rate for all sources. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param bitRate The max send bit rate for all sources, in bps.
	 */
	-(BOOL) setMaxSendBitRate:(unsigned int)bitRate;
	/*!
	 * This is a synchronous interface. Sets max boost level that will be applied only in the conference for the selected microphone in case the system is set to the higher value. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param boostLevel Boost level for which possible values are devices specific, e.g. 0 - 20 dB. Default is 12 dB.
	 */
	-(BOOL) setMicrophoneMaxBoostLevel:(double)boostLevel;
	/*!
	 * This is an asynchronous interface. Sets the flag to mute/unmute the microphone. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param privacy Flag to mute/unmute the microphone.
	 */
	-(BOOL) setMicrophonePrivacy:(BOOL)privacy;
	/*!
	 * This is a synchronous interface. Sets min volume that will be applied only in the conference for the selected microphone in case the system is set to the lower value. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param volumePercent Volume percent for which possible values are 0 - 100 percentage. Default is 50 percent.
	 */
	-(BOOL) setMinMicrophoneVolume:(unsigned int)volumePercent;
	/*!
	 * This is a synchronous interface. Sets the operating mode of the VidyoConnector. This API have to be called before renderer is destructed: i.e. VidyoConnectorHideView will be called in case VIDYO_CONNECTORMODE_Background and after renderer is constructed: i.e. VidyoConnectorAssignViewToCompositeRenderer, VidyoConnectorAssignViewToLocalCamera, VidyoConnectorAssignViewToRemoteCamera will be called in case VIDYO_CONNECTORMODE_Foreground. This API is required only when user in the conference. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector. It won't do anything in VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead states of VidyoConnector but it will still return LMI_TRUE.
	 * @param c The VidyoConnector object.
	 * @param mode Desired operating mode.
	 */
	-(BOOL) setMode:(VCConnectorMode)mode;
	/*!
	 * This is an asynchronous interface. This API provides the ability to allow a room owner to set an authentication scheme (moderator pin) for moderator functionality. The same authentication scheme must be used by other users by calling VidyoConnectorRequestModeratorRole to get moderator privilege. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c VidyoConnector object.
	 * @param moderatorPIN authentication scheme (moderator pin) for moderator functionality.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) setModeratorPIN:(NSString*)moderatorPIN RequestId:(NSString*)requestId;
	/*!
	 * This is a synchronous interface. Sets up options on the VidyoConnector API. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param options The options in JSON format. <p>conferenceReferenceNumber - a special identifier that will show up in the Portal CDR record for the conference. Should be set before joining the conference.</p> <p>Example: {'conferenceReferenceNumber' : 'reference number'}.</p> <p>microphoneMaxBoostLevel - sets max boost level that will be applied only in the conference for the selected microphone in case the system is set to the higher value. Possible values are devices specific, e.g. 0 - 20 dB. Default is 12 dB.</p> <p>Example: {'microphoneMaxBoostLevel' : 10}.</p> <p>minMicrophoneVolume - sets min volume that will be applied only in the conference for the selected microphone in case the system is set to the lower value. Possible values are 0 - 100 percentage. Default is 50 per cent.</p> <p>Example: {'minMicrophoneVolume' : 70}.</p> <p>Possible values for audio device modes are : audioSharedModeBoth - use both audio devices (Speaker and Microphone) in shared mode. audioExclusiveModeBoth - use both audio devices (Speaker and Microphone) in exclusive mode. audioExclusiveModeMic - use microphone in exclusive mode and speaker in shared mode. By default VidyoClient is working with audioSharedModeBoth. A new mode will be applied only for the next conference or in case another device is selected.</p> <p>Example: {'audioSharedModeBoth' : true}.</p> <p>Example: {'audioExclusiveModeBoth' : true}.</p> <p>Example: {'audioExclusiveModeMic' : true}.</p> <p>preferredAudioCodec - sets VidyoClient to use preferred audio codec. Possible value are OPUS RED, OPUS and SPEEX RED. Default is OPUS RED.</p> <p>Example: {'preferredAudioCodec' : 'SPEEX RED'}.</p> <p>AudioBitrateMultiplier - A multiplier to be used when calculating the audio bitrate. Possible values are 0, 1 and 2. Default is 2.</p> <p>Example: {'AudioBitrateMultiplier':1}.</p> <p>AudioPacketInterval - It decies audio frame duration to encoder. It sets time interval between two packet of audio in miliseconds Possible values are 20, and 40 ms. Default is 40 ms.</p> <p>Example: {'AudioPacketInterval':40}.</p> <p>AudioPacketLossPercentage - it values is used to configure encoder. If given higher value then encoder is configured to resistant to loss on the expense of quality. Possible values are [0, 10, 20, 30] in percentage. Default is 10%.</p> <p>Example: {'AudioPacketLossPercentage':20}.</p> <p>statRate - sets VidyoRoom statistics gather interval in seconds. Possible values are 2, 5, 10, 20 and 30. Default is 10.</p> <p>Example: {'statRate':10}.</p> <p>enableStaticShareSvc - Specifies whether SVC will be enabled or disabled for static sharing. Possible values are true or false. The default is false. Note: SVC is enabled by default for interactive video and high frame rate sharing.</p> <p>Example: {'enableStaticShareSvc' : true}.</p>
	 */
	-(BOOL) setOptions:(const char*)options;
	/*!
	 * This is a synchronous interface. Sets a specific media pool to use for audio and video. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param name Name of the pool.
	 */
	-(BOOL) setPool:(const char*)name;
	/*!
	 * This is a synchronous interface. Sets VidyoClient to use preferred audio codec. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param preferredAudioCodec Preferred audio codec to be set. For possible values of the audio codec, refer VidyoConnectorPreferredAudioCodec.
	 */
	-(BOOL) setPreferredAudioCodec:(VCConnectorPreferredAudioCodec)preferredAudioCodec;
	/*!
	 * This is an asynchronous interface. Set a specific participant as a presenter. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param participant The VidyoParticipant object who will be a new presenter.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) setPresenter:(VCParticipant*)participant RequestId:(NSString*)requestId;
	/*!
	 * This is a synchronous interface. Sets the product information. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param productInfo Sets the product information. Supported Properties- ApplicationName, ApplicationVersion
	 */
	-(BOOL) setProductInfo:(NSMutableArray*)productInfo;
	/*!
	 * This is a synchronous interface. Sets up the local renderer and conference tiles displaying options. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param viewId A platform-specific view ID.
	 * @param options A char array that contains options in the JSON format. <p>EnableVerticalVideoCentering - Enable or disable the vertical centering of the video screen. Default is true.</p> <p>Example: {'EnableVerticalVideoCentering':true}.</p> <p>EnableFECCIconCustomLayout - Enable or disable the displaying of custom FECC icon in the right bottom corner. Default is false.</p> <p>Example: {'EnableFECCIconCustomLayout':false}.</p> <p>ViewingDistance - Sets viewing distance in feet. Default is 2.5. Minimum and Maximum values are 1f & 15f respectively.</p> <p>Example: {'ViewingDistance':2.5}.</p> <p>ShowAudioTiles - Enable or disable the showing of audio tiles. Default is true.</p> <p>Example: {'ShowAudioTiles':false}.</p> <p>SetPipPosition - Sets the position of the preview when it is displayed using picture-in-picture mode. Possible values for x: "PipPositionLeft", "PipPositionCenter", "PipPositionRight". Possible values for y: "PipPositionBottom", "PipPositionCenter", "PipPositionTop". lockPip is a boolean indicating whether to lock the preview in this position (by default is false). When false, the user may drag the preview to another location using the mouse or a touch. setPipSize - Sets the size of the preview in picture-in-picture mode. The value is a positive integer representing the percentage of the screen size (1 to 50). Default value is 1. setPipToTileAfterNTiles - Sets the number of tiles after which the preview will be displayed as a tile instead of picture-in-picture. (default value is 2) A value of 0 means the preview will always be visible in picture-in-picture mode whereas N means that the preview will be visible as tile if the number of tiles is greater than N (where N is a positive integer).</p> <p>Example: {'SetPipPosition':{'x':'PipPositionRight', 'y': 'PipPositionTop', 'lockPip':true, 'setPipSize':1, 'setPipToTileAfterNTiles':2}}.</p> <p>SetPixelDensity - Sets the rendering environment's pixel density.</p> <p>Example: {'SetPixelDensity':326.0f. However for latest rendering environment, being released for iOS only, this option is used to choose surface density with possible values as 0.5 (everything will be smaller) / 1.0 (default) / 2.0 (everything will be larger).}</p> <p>SetTouchAsInputDevice - Enable or disable touch as a input device. Default is false.</p> <p>Example: {'SetTouchAsInputDevice':false}.</p> <p>EnableExpandedCameraControl - Enable or disable expanded camera control. Default is true for mobile devices and false for non-mobile devices.</p> <p>Example: {'EnableExpandedCameraControl':false}.</p> <p>BorderStyle - Sets the border style of the preview. None: Do not put a border on any tiles. Same: Put the same colored border on each tile. Highlight: Put a border on each tile, but tiles associated with the highest ranked participant will have a different colored border than the others. Flash: Tiles associated with the highest ranked participant have a different colored border than the others, When the highest ranked participant changes, the border of the new highest ranked participant flashes momentarily. Possible values for BorderStyle: "None", "Same", "Highlight", "Flash"</p> <p>Example: {'BorderStyle':'Same'</p>} <p>enablePreviewMirroring - Specifies whether mirroring will be enabled or disabled for local cameras. Possible values are true or false. The default is true.</p> <p>Example: {'EnablePreviewMirroring' : true}.</p>
	 */
	-(BOOL) setRendererOptionsForViewId:(void*)viewId Options:(const char*)options;
	/*!
	 * This is an asynchronous interface. This api provides the ability to set the room pin. Once room pin is set, all other users are required to enter this room pin to join this conference room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c VidyoConnector object.
	 * @param roomPIN Pin to be set as room PIN or set NULL to remove existing room PIN
	 * @param onSetRoomPinResult Callback to be triggered for set room pin result.
	 */
	-(BOOL) setRoomPIN:(NSString*)roomPIN ConnectorISetRoomPIN:(id<VCConnectorISetRoomPIN>)connectorISetRoomPIN;
	/*!
	 * This is an asynchronous interface. Sets the flag to mute/unmute the speaker. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param privacy Flag to mute/unmute the speaker.
	 */
	-(BOOL) setSpeakerPrivacy:(BOOL)privacy;
	/*!
	 * This is a synchronous interface. Enables or disables SVC. By default SVC is disabled. Note: For interactive video and high frame rate sharing SVC is enabled by default. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param enable Indicates whether enable SVC or not.
	 */
	-(BOOL) setStaticShareSvcState:(BOOL)enable;
	/*!
	 * This is a synchronous interface. Sets conference room statistics gather interval in seconds. Default is 10. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param statRate Statistics gather interval for which possible values are 2, 5, 10, 20 and 30.
	 */
	-(BOOL) setStatisticRate:(unsigned int)statRate;
	/*!
	 * This is a synchronous interface. Enable the use of TCP Transport when connecting. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param enable Enable the tranport.
	 */
	-(BOOL) setTCPTransport:(BOOL)enable;
	/*!
	 * This is a synchronous interface. Set TURN server and credentials information. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param turnAddress TURN server FQDN or IP address.
	 * @param port TURN server port.
	 * @param username TURN server user name.
	 * @param password TURN server password.
	 * @param baseTransport Base transport type.
	 */
	-(BOOL) setTURNAddressCredentials:(const char*)turnAddress Port:(unsigned int)port Username:(const char*)username Password:(const char*)password BaseTransport:(VCConnectorBaseTransportType)baseTransport;
	/*!
	 * This is a synchronous interface. Set TURN server certificate requirement. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param required LMI_TRUE if TURN server certificate is required.
	 */
	-(BOOL) setTURNServerCertificateRequired:(BOOL)required;
	/*!
	 * This is a synchronous interface. Enable the use of UDP Transport when connecting. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param enable Enable the tranport.
	 */
	-(BOOL) setUDPTransport:(BOOL)enable;
	/*!
	 * This is a synchronous interface. Sets the speed of transition animation for windows moving around inside the view. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param viewId A platform specific view ID to be positioned.
	 * @param speedPercentage Percentage of animation speed with default of 50, 100 for slowest and 0 for instant.
	 */
	-(BOOL) setViewAnimationSpeed:(void*)viewId SpeedPercentage:(unsigned int)speedPercentage;
	/*!
	 * This is a synchronous interface. Set the background color of the view. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param viewId A platform specific view ID to be positioned.
	 * @param red Red component of the color 0-255.
	 * @param green Green component of the color 0-255.
	 * @param blue Blue component of the color 0-255.
	 */
	-(BOOL) setViewBackgroundColor:(void*)viewId Red:(unsigned char)red Green:(unsigned char)green Blue:(unsigned char)blue;
	/*!
	 * This is a synchronous interface. Sets path and file name to the picture that will be used for the virtual background effect. It is allowed to change picture while the effect is enabled. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE. This functionality is supported only for macOS 10.14 and above, iOS 10.0 and above and Windows VC++ 15 and above.
	 * @param c The VidyoConnector object.
	 * @param pathToPicture Path and file name to the picture. Currently, only PNG and JPG is supported.
	 */
	-(BOOL) setVirtualBackgroundPicture:(NSString*)pathToPicture;
	/*!
	 * This is a synchronous interface. Sets web proxy server address and credentials. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param proxyAddress The web proxy server address.
	 * @param username The web proxy server user name.
	 * @param password The web proxy server password.
	 */
	-(BOOL) setWebProxyAddressCredentials:(const char*)proxyAddress Username:(const char*)username Password:(const char*)password;
	/*!
	 * This is a synchronous interface. Enable the use of WebProxy Transport when connecting. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param enable Enable the tranport.
	 */
	-(BOOL) setWebProxyTransport:(BOOL)enable;
	/*!
	 * This is a synchronous interface. Enable the use of WebProxy Transport with provided web proxy server address. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param name The name of web proxy server, it may also may be prefixed by a scheme ('http://proxy.company.com')
	 * @param port The port that web proxy server is running on
	 */
	-(BOOL) setWebProxyTransportAddress:(NSString*)name Port:(unsigned int)port;
	/*!
	 * This is a synchronous interface. Shows or hides the audio meters in the view. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param viewId A platform specific view ID to be positioned.
	 * @param showMeters Boolean to show or hide the audio meters.
	 */
	-(BOOL) showAudioMeters:(void*)viewId ShowMeters:(BOOL)showMeters;
	/*!
	 * This is a synchronous interface. Sets the flag to show/hide the local camera preview for composite layout only. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param preview Flag to show/hide the local camera preview.
	 */
	-(BOOL) showPreview:(BOOL)preview;
	/*!
	 * This is a synchronous interface to display statistics dialog box for a conference on desktop devices. It is not applicable for handheld devices. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param showStatisticsDialog Boolean value that indicate to show or hide the statistics dialog.
	 */
	-(BOOL) showStatisticsDialog:(BOOL)showStatisticsDialog;
	/*!
	 * This is a synchronous interface. Sets the position of the view every time it's changed on the screen. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param viewId A platform specific view ID to be positioned.
	 * @param x X coordinate.
	 * @param y Y coordinate.
	 * @param width Width of the view.
	 * @param height Height of the view.
	 */
	-(BOOL) showViewAt:(void*)viewId X:(int)x Y:(int)y Width:(unsigned int)width Height:(unsigned int)height;
	/*!
	 * This is a synchronous interface. Sets the position of the view every time it's changed on the screen. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param viewId A platform specific view ID to be positioned.
	 * @param x X coordinate (in points).
	 * @param y Y coordinate (in points).
	 * @param width Width of the view (in points).
	 * @param height Height of the view (in points).
	 */
	-(BOOL) showViewAtPoints:(void*)viewId X:(int)x Y:(int)y Width:(unsigned int)width Height:(unsigned int)height;
	/*!
	 * This is a synchronous interface. Shows or hides the label on the view which displays the participant name or preview. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param viewId A platform specific view ID to be positioned.
	 * @param showLabel Boolean to show or hide the label.
	 */
	-(BOOL) showViewLabel:(void*)viewId ShowLabel:(BOOL)showLabel;
	/*!
	 * This is a synchronous interface. Sets the flag to show/hide the window share preview. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param preview Flag to show/hide the window share preview.
	 */
	-(BOOL) showWindowSharePreview:(BOOL)preview;
	/*!
	 * This is a synchronous interface. Start google analytics service. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param options A structure that represent the google analytics options, plz refer VidyoConnectorGoogleAnalyticsOptions. If the user set to NULL, Vidyo Client will use default option to use google analytics.
	 */
	-(BOOL) startGoogleAnalyticsService:(VCConnectorGoogleAnalyticsOptions*)options;
	/*!
	 * This is a synchronous interface. Start insights service. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param serverUrl Url of Insights server.
	 */
	-(BOOL) startInsightsService:(NSString*)serverUrl;
	/*!
	 * This is an asynchronous interface. Switch room mode to the Lecture mode. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) startLectureMode:(NSString*)requestId;
	/*!
	 * This is a synchronous interface. Stops logging into current file and start logging to the next one. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) startNextLogFile;
	/*!
	 * Asynchronously starts recording a conference using the specified recording profile. Must be called on behalf of a moderator. Fails in case another recording is in progress. Calls a callback upon completion. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c Pointer to the VidyoConnector object.
	 * @param recordingProfilePrefix Recording profile prefix to start the recording with. Can be one of those provided by VidyoConnectorGetRecordingServiceProfiles or NULL - a default profile will be used.
	 * @param onRecordingServiceStartCallback Callback called upon completion.
	 */
	-(BOOL) startRecording:(NSString*)recordingProfilePrefix ConnectorIStartRecording:(id<VCConnectorIStartRecording>)connectorIStartRecording;
	/*!
	 * This is a synchronous interface. Stop google analytics service. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) stopGoogleAnalyticsService;
	/*!
	 * This is a synchronous interface. Stop insights service. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) stopInsightsService;
	/*!
	 * This is an asynchronous interface. Switch room mode to the Group mode. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) stopLectureMode:(NSString*)requestId;
	/*!
	 * Asynchronously stops recording a conference. Must be called on behalf of a moderator. Fails in case there is no recording in progress. Calls a callback upon completion. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c Pointer to the VidyoConnector object.
	 * @param onRecordingServiceStopResultCallback Callback called upon completion.
	 */
	-(BOOL) stopRecording:(id<VCConnectorIStopRecording>)connectorIStopRecording;
	/*!
	 * This is a synchronous interface. Swap streams of the remote video sources between views. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param first A platform specific view ID where the first remote video sources is displayed.
	 * @param second A platform specific view ID where the second remote video sources is displayed.
	 */
	-(BOOL) swapStreamsBetweenViews:(void*)first Second:(void*)second;
	/*!
	 * This is an asynchronous interface. This api provides the ability unlock the current room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
	 * @param c VidyoConnector object.
	 * @param onUnlockRoomResult Callback to be triggered for UnlockRoom Result.
	 */
	-(BOOL) unlockRoom:(id<VCConnectorIUnlockRoom>)connectorIUnlockRoom;
	/*!
	 * This is an asynchronous interface. Each participant can send a moderation request to remove his raised hand to cancel the request to be unmuted. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param requestId Application provide identifier to track this request.
	 */
	-(BOOL) unraiseHand:(NSString*)requestId;
	/*!
	 * This is a synchronous interface. Application can unregister callback to stop bot participant event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterBotEventListener;
	/*!
	 * This is a synchronous interface. Unregisters callback to notify the user in case of any errors occur during enabling camera effect.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterCameraEffectErrorListener;
	/*!
	 * This is a synchronous interface. Un-Registers the conference mode event listeners. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterConferenceModeEventListener;
	/*!
	 * This is a synchronous interface. Unregisters event listener, application will not receive an event about connection properties changes. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterConnectionPropertiesEventListener;
	/*!
	 * This is a synchronous interface. Unregisters advanced error event notifications.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterErrorEventListener;
	/*!
	 * This is a synchronous interface. Un-Registers the host event listeners. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterHostEventListener;
	/*!
	 * This is a synchronous interface. Resets the callback for in call event. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterInCallEventListener;
	/*!
	 * This is a synchronous interface. Unregisters the Lecture mode part callbacks. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterLectureModeEventListener;
	/*!
	 * This is a synchronous interface. Unregisters local camera event notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterLocalCameraEventListener;
	/*!
	 * This is a synchronous interface. Unregisters local camera frame notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param localCamera The VidyoLocalCamera for which to stop notifications.
	 */
	-(BOOL) unregisterLocalCameraFrameListener:(VCLocalCamera*)localCamera;
	/*!
	 * This is a synchronous interface. Unregisters local microphone energy notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterLocalMicrophoneEnergyListener;
	/*!
	 * This is a synchronous interface. Unregisters local microphone event notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterLocalMicrophoneEventListener;
	/*!
	 * This is a synchronous interface. Unregisters local microphone frame notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param localMicrophone The VidyoLocalMicrophone for which to stop notifications.
	 */
	-(BOOL) unregisterLocalMicrophoneFrameListener:(VCLocalMicrophone*)localMicrophone;
	/*!
	 * This is a synchronous interface. Unregisters local monitor event notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterLocalMonitorEventListener;
	/*!
	 * This is a synchronous interface. Unregisters local monitor frame notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param localMonitor The VidyoLocalMonitor for which to stop notifications.
	 */
	-(BOOL) unregisterLocalMonitorFrameListener:(VCLocalMonitor*)localMonitor;
	/*!
	 * This is a synchronous interface. Unregisters local speaker event notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterLocalSpeakerEventListener;
	/*!
	 * This is a synchronous interface. Unregisters local window share event notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterLocalWindowShareEventListener;
	/*!
	 * This is a synchronous interface. Unregisters local window share frame notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param localWindowShare The VidyoLocalWindowShare for which to stop notifications.
	 */
	-(BOOL) unregisterLocalWindowShareFrameListener:(VCLocalWindowShare*)localWindowShare;
	/*!
	 * This is a synchronous interface. Unregisters log event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterLogEventListener;
	/*!
	 * This is a synchronous interface. Unregisters message event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterMessageEventListener;
	/*!
	 * This is a synchronous interface. Unregister a callback to do not receive moderation commands sent from the server. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c VidyoConnector object.
	 */
	-(BOOL) unregisterModerationCommandEventListener;
	/*!
	 * This is a synchronous interface. Unregistering notifications about moderation result events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterModerationResultEventListener;
	/*!
	 * This is a synchronous interface. Unregister the callback to stop receiving the final response for the next generation renderer action. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c VidyoConnector object.
	 */
	-(BOOL) unregisterNGRResultEventListener;
	/*!
	 * This is a synchronous interface. Unregisters network interface event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterNetworkInterfaceEventListener;
	/*!
	 * This is a synchronous interface. Unregisters participant event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterParticipantEventListener;
	/*!
	 * This is a synchronous interface. Unregisters plugin. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param plugin Plugin to unregister.
	 */
	-(BOOL) unregisterPlugin:(long)plugin;
	/*!
	 * This is a synchronous interface. Unregisters reconnecting event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterReconnectEventListener;
	/*!
	 * This is a synchronous interface. Unregisters recorder in call event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterRecorderInCallEventListener;
	/*!
	 * This is a synchronous interface. Unregisters remote camera event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterRemoteCameraEventListener;
	/*!
	 * This is a synchronous interface. Unregisters remote camera frame notifications. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param remoteCamera The VidyoRemoteCamera for which to stop notifications.
	 */
	-(BOOL) unregisterRemoteCameraFrameListener:(VCRemoteCamera*)remoteCamera;
	/*!
	 * This is a synchronous interface. Unregisters remote microphone frame notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterRemoteMicrophoneEnergyListener;
	/*!
	 * This is a synchronous interface. Unregisters remote microphone event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterRemoteMicrophoneEventListener;
	/*!
	 * This is a synchronous interface. Unregisters remote microphone frame notifications. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param remoteMicrophone The VidyoRemoteMicrophone for which to stop notifications.
	 */
	-(BOOL) unregisterRemoteMicrophoneFrameListener:(VCRemoteMicrophone*)remoteMicrophone;
	/*!
	 * This is a synchronous interface. Unregisters remote renderer event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterRemoteRendererEventListener;
	/*!
	 * This is a synchronous interface. Unregisters remote speaker event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterRemoteSpeakerEventListener;
	/*!
	 * This is a synchronous interface. Unregisters remote window share event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterRemoteWindowShareEventListener;
	/*!
	 * This is a synchronous interface. Unregisters remote window share frame notifications. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 * @param remoteWindowShare The VidyoRemoteWindowShare for which to stop notifications.
	 */
	-(BOOL) unregisterRemoteWindowShareFrameListener:(VCRemoteWindowShare*)remoteWindowShare;
	/*!
	 * This is a synchronous interface. Unregisters resource manager event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterResourceManagerEventListener;
	/*!
	 * This is a synchronous and private interface, for usage please contact vidyo api support team. Application can unregister private callback to stop receiving tokens from the vidyo portal. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterTokenReceivedEventListener;
	/*!
	 * Unregisters virtual audio source event notifications. This is a synchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterVirtualAudioSourceEventListener;
	/*!
	 * This is a synchronous interface. Unregisters virtual video source event notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterVirtualVideoSourceEventListener;
	/*!
	 * This is a synchronous interface. Unregisters web proxy event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
	 * @param c The VidyoConnector object.
	 */
	-(BOOL) unregisterWebProxyEventListener;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
	-(NSMutableDictionary<NSString*, VCParticipant*> *)getParticipantsMap;
	-(NSMutableDictionary<NSString*, VCRemoteCamera*> *)getRemoteCamerasMap;
	-(NSMutableDictionary<NSString*, VCRemoteMicrophone*> *)getRemoteMicrophonesMap;
	-(NSMutableDictionary<NSString*, VCRemoteWindowShare*> *)getRemoteWindowSharesMap;
	-(NSMutableDictionary<NSString*, id<VCConnectorIRequestVideoForRemoteCamera>> *)getOnRemoteCameraFirstFrameReceivedCallbacksMap;
	-(NSMutableDictionary<NSString*, id<VCConnectorIRequestVideoForRemoteWindowShare>> *)getOnRemoteWindowShareFirstFrameReceivedCallbacksMap;
@end
/*!
 * Represents the bot info structure.
 */
@interface VCConnectorBotInfo : NSObject
{
}
	/*!
	 * Represents the meta data associated with bot in json format string.
	 */
	@property NSMutableString* data;
	/*!
	 * Represents the id associated with bot.
	 */
	@property NSMutableString* id;
	/*!
	 * Represents the name associated with bot.
	 */
	@property NSMutableString* name;
@end
/*!
 * Represent the configuration of camera background effect.
 */
@interface VCConnectorCameraEffectInfo : NSObject
{
}
	/*!
	 * Blur intensity. Valid valies is [3-8]. Default value is 5. Used only if effectType VIDYO_CONNECTORCAMERAEFFECTTYPE_Blur
	 */
	@property unsigned int blurIntensity;
	/*!
	 * Type of the camera background effect. In case VIDYO_CONNECTORCAMERAEFFECTTYPE_None is set no need to set other fields.
	 */
	@property VCConnectorCameraEffectType effectType;
	/*!
	 * The path to effect. A directory with supported effect is packaged with VidyoClient library.
	 */
	@property NSMutableString* pathToEffect;
	/*!
	 * The path to resources like a model and its configuration. A directory with supported resources is packaged with VidyoClient library.
	 */
	@property NSMutableString* pathToResources;
	/*!
	 * The token for enabling the camera background effect. The blank string is NOT allowed. In case the token is not valid or expired enabling of camera background effect will fail.
	 */
	@property NSMutableString* token;
	/*!
	 * The path to the picture that will be used for the virtual background. Used only if effectType VIDYO_CONNECTORCAMERAEFFECTTYPE_VirtualBackground.
	 */
	@property NSMutableString* virtualBackgroundPicture;
@end
/*!
 * Represents the connection properties structure, which are based on information from the portal.
 */
@interface VCConnectorConnectionProperties : NSObject
{
}
	/*!
	 * Return LMI_TRUE if moderation pin is set otherwise LMI_FALSE.
	 */
	@property BOOL hasModeratorPin;
	/*!
	 * Return LMI_TRUE if room pin is set otherwise LMI_FALSE.
	 */
	@property BOOL hasRoomPin;
	/*!
	 * Return LMI_TRUE if room is lock otherwise LMI_FALSE.
	 */
	@property BOOL isRoomLocked;
	/*!
	 * Return LMI_TRUE if VP9 is enabled otherwise LMI_FALSE.
	 */
	@property BOOL isVp9Enabled;
	/*!
	 * Represents the maximum receive bandwidth.
	 */
	@property unsigned int maxReceiveBandWidth;
	/*!
	 * Represents the maximum send bandwidth.
	 */
	@property unsigned int maxSendBandWidth;
	/*!
	 * Return the maximum room pin length if maximumRoomPinLength is set by default.
	 */
	@property int maximumRoomPinLength;
	/*!
	 * Return the minimum room pin length if minimumRoomPinLength is set by default.
	 */
	@property int minimumRoomPinLength;
	/*!
	 * State of Recording. See enum VidyoConnectorRecordingState.
	 */
	@property VCConnectorRecordingState recordingState;
	/*!
	 * Name of the room.
	 */
	@property NSMutableString* roomName;
	/*!
	 * State of Webcasting. See enum VidyoConnectorWebcastingState.
	 */
	@property VCConnectorWebcastingState webcastingState;
@end
/*!
 * Represents the google analytics event table.
 */
@interface VCConnectorGoogleAnalyticsEventTable : NSObject
{
}
	/*!
	 * Represents the event action enable flag.
	 */
	@property BOOL enable;
	/*!
	 * Represents the event action of google analytics.
	 */
	@property VCConnectorGoogleAnalyticsEventAction eventAction;
	/*!
	 * Represents the event category of google analytics.
	 */
	@property VCConnectorGoogleAnalyticsEventCategory eventCategory;
@end
/*!
 * Represent the options for google analytics.
 */
@interface VCConnectorGoogleAnalyticsOptions : NSObject
{
}
	/*!
	 * Represents the measurement is for google analytics service.
	 */
	@property NSMutableString* id;
	/*!
	 * Represents the configured API secret key for google analytics service.
	 */
	@property NSMutableString* key;
@end
/*!
 * It is the event which will be sent to application which register for incall events.
 */
@interface VCConnectorInCallEvent : NSObject
{
}
	/*!
	 * It is error code for the event.
	 */
	@property VCConnectorInCallEventCode code;
	/*!
	 * It extra information for the event. It is optional and it may depend on type of event.
	 */
	@property NSMutableString* details;
	/*!
	 * This indicate the module to which event belongs to.
	 */
	@property VCConnectorInCallEventClass type;
@end
/*!
 * Describes the information about the product.
 */
@interface VCConnectorProductInformation : NSObject
{
}
	/*!
	 * Describes the property name. Refer VidyoConnectorProperty.
	 */
	@property VCConnectorProperty propertyName;
	/*!
	 * This represents the value of the property.
	 */
	@property NSMutableString* value;
@end
/*!
 * Represent the options for sharing.
 */
@interface VCConnectorShareOptions : NSObject
{
}
	/*!
	 * A variable that indicates whether the sharing will be with or without audio.
	 */
	@property BOOL enableAudio;
	/*!
	 * A variable that indicates whether the sharing will be with or without high framerate share.
	 */
	@property BOOL enableHighFramerate;
@end
/*!
 * Represents the structure associate with token info.
 */
@interface VCConnectorTokenInfo : NSObject
{
}
	/*!
	 * Represents the value or data related to token.
	 */
	@property NSMutableString* token;
	/*!
	 * Represents the type of token, please refer VidyoConnectorTokenType.
	 */
	@property VCConnectorTokenType tokenType;
@end
