//
//	VidyoMeetingAttendee_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

/*!
 * @enum <p>This indicates the role of the local user in a meeting. </p> <p>Maps directly to participation roles defined in IETF RFC 5545. </p>
 * @constant VCAttendeeParticipationRoleChair 
 * @constant VCAttendeeParticipationRoleRequired 
 * @constant VCAttendeeParticipationRoleOptional 
 * @constant VCAttendeeParticipationRoleInformational Maps to NON-PARTICIPANT role in RFC type
 */
typedef NS_ENUM(NSInteger, VCAttendeeParticipationRole) {
	VCAttendeeParticipationRoleChair,
	VCAttendeeParticipationRoleRequired,
	VCAttendeeParticipationRoleOptional,
	VCAttendeeParticipationRoleInformational
};
/*!
 * @enum <p>This indicates the role of the local user in a meeting. </p> <p>Maps directly to participation statuses defined in IETF RFC 5545. </p>
 * @constant VCAttendeeParticipationStatusNeedsAction 
 * @constant VCAttendeeParticipationStatusOrganized 
 * @constant VCAttendeeParticipationStatusAccepted 
 * @constant VCAttendeeParticipationStatusDeclined 
 * @constant VCAttendeeParticipationStatusTentative 
 * @constant VCAttendeeParticipationStatusDelegated 
 * @constant VCAttendeeParticipationStatusNone Response not required
 * @constant VCAttendeeParticipationStatusCompleted 
 * @constant VCAttendeeParticipationStatusInProcess 
 */
typedef NS_ENUM(NSInteger, VCAttendeeParticipationStatus) {
	VCAttendeeParticipationStatusNeedsAction,
	VCAttendeeParticipationStatusOrganized,
	VCAttendeeParticipationStatusAccepted,
	VCAttendeeParticipationStatusDeclined,
	VCAttendeeParticipationStatusTentative,
	VCAttendeeParticipationStatusDelegated,
	VCAttendeeParticipationStatusNone,
	VCAttendeeParticipationStatusCompleted,
	VCAttendeeParticipationStatusInProcess
};
/*!
 * Stores information for a meeting attendee.
 */
@interface VCMeetingAttendee : NSObject
{
}
	/*!
	 * Email for attendee.
	 */
	@property NSMutableString* email;
	/*!
	 * Attendee name as held by the underlying calendar service
	 */
	@property NSMutableString* name;
	/*!
	 * Role for the attendee as defined by the roleparam specified in RFC 5545
	 */
	@property VCAttendeeParticipationRole role;
	/*!
	 * Participation status of the attendee for the meeting as specified by the STATUS property name specified in RFC 5545
	 */
	@property VCAttendeeParticipationStatus status;
@end
