//
//	VidyoNetworkService_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

@class VCNetworkServiceCAInfo;
@class VCNetworkServiceRequestHeader;
@class VCNetworkServiceResponseHeader;
/*!
 * @enum NetworkService error codes.
 * @constant NETWORKSERVICE_ERRORCODE_Ok Successful request.
 * @constant NETWORKSERVICE_ERRORCODE_Error Unsuccessful request.
 * @constant NETWORKSERVICE_ERRORCODE_MandatoryParamsMissing Mandatory parameters are missing from request.
 * @constant NETWORKSERVICE_ERRORCODE_BadRequest Invalid parameters.
 * @constant NETWORKSERVICE_ERRORCODE_MaxSimultaneousRequestsReached Maximum number of simultaneous requests reached. By default 10 simultaneous requests.
 * @constant NETWORKSERVICE_ERRORCODE_HttpRequestTimeOut Http request time out received.
 */
typedef NS_ENUM(NSInteger, VCNetworkServiceErrorCode) {
	NETWORKSERVICE_ERRORCODE_Ok,
	NETWORKSERVICE_ERRORCODE_Error,
	NETWORKSERVICE_ERRORCODE_MandatoryParamsMissing,
	NETWORKSERVICE_ERRORCODE_BadRequest,
	NETWORKSERVICE_ERRORCODE_MaxSimultaneousRequestsReached,
	NETWORKSERVICE_ERRORCODE_HttpRequestTimeOut
};
@protocol VCNetworkServiceIHttpRequestASync
	/*!
	 * This is Http Response CallBack, Application should define this callback in order to get response data. VidyoClient library will not process http response including status code. Application has to process the response and take necessary action.
	 */
	-(void) responseCB:(VCNetworkServiceResponseHeader*)httpResponseHeader UserData:(long)userData;
@end
/*!
 * An optional module that handles all request related to REST and SOAP protocol.
 */
@interface VCNetworkService : NSObject
{
	void* objPtr;
	@public
	/*!
	 * Http request function, this will be call by the application in order to placed any http request. This will be asynchronous call, Application call will not be blocked.
	 */
	id<VCNetworkServiceIHttpRequestASync> networkServiceIHttpRequestASync;
}
	/*!
	 * An optional module that handles all request related to REST and SOAP protocol.
	 * @param networkService The VidyoNetworkService Object to construct.
	 * @param caInfo The VidyoNetworkServiceCAInfo object.
	 */
	-(id) init:(VCNetworkServiceCAInfo*)caInfo;
	-(void) dealloc;
	/*!
	 * Http request function, this will be call by the application in order to placed any http request. This will be asynchronous call, Application call will not be blocked.
	 * @param networkService The VidyoNetworkService object.
	 * @param requestHeader Http request data, user has to provide data for http request.
	 * @param responseCB Callback function through which application will get http response.
	 * @param userData Application specific data, same thing will be provided back to application through http response CallBack.
	 */
	-(VCNetworkServiceErrorCode) httpRequestASync:(VCNetworkServiceRequestHeader*)requestHeader NetworkServiceIHttpRequestASync:(id<VCNetworkServiceIHttpRequestASync>)networkServiceIHttpRequestASync UserData:(long)userData;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
/*!
 * Represents the header structure of the http request.
 */
@interface VCNetworkServiceRequestHeader : NSObject
{
}
	/*!
	 * Represents the content/encoding type of the request. Default value: empty. Requirement: Optional.
	 */
	@property NSMutableString* requestContentType;
	/*!
	 * Represents the type of the request. Default value: post. Requirement: Optional.
	 */
	@property NSMutableString* requestMethod;
	/*!
	 * Represents the request number of the request. Default value: empty. Requirement: Optional.
	 */
	@property NSMutableString* requestNumber;
	/*!
	 * Represents the payload of the request. Default value: empty. Requirement: Optional.
	 */
	@property NSMutableString* requestPayload;
	/*!
	 * Represents the url of the request. Requirement: Mandatory.
	 */
	@property NSMutableString* requestUrl;
	/*!
	 * Represents the authorization token of the request. Default value: empty. Requirement: Optional.
	 */
	@property NSMutableString* userAuthToken;
	/*!
	 * Represents the authorization user name of the request. Default value: empty. Requirement: Optional.
	 */
	@property NSMutableString* userAuthUserName;
	/*!
	 * Represents the authorization user password of the request. Default value: empty. Requirement: Optional.
	 */
	@property NSMutableString* userAuthUserPassword;
	/*!
	 * Represents the user name of the webproxy. Default value: empty. Requirement: Optional.
	 */
	@property NSMutableString* webProxyUserName;
	/*!
	 * Represents the user password of the webproxy. Default value: empty. Requirement: Optional.
	 */
	@property NSMutableString* webProxyUserPassword;
@end
/*!
 * Represents a http response header structure.
 */
@interface VCNetworkServiceResponseHeader : NSObject
{
}
	/*!
	 * Represents the error code, see VidyoNetworkServiceErrorCode.
	 */
	@property VCNetworkServiceErrorCode errorCode;
	/*!
	 * Represents the content of the response.
	 */
	@property NSMutableString* httpResponseContent;
	/*!
	 * Represents the content size of the respons.
	 */
	@property unsigned int httpResponseContentSize;
	/*!
	 * Represents the content type of response.
	 */
	@property NSMutableString* httpResponseContentType;
	/*!
	 * Represents the http status code of the response.
	 */
	@property unsigned int httpStatusCode;
	/*!
	 * Represents the unique request number for each Http request, provided/used in VidyoNetworkServiceHttpRequestASync.
	 */
	@property NSMutableString* requestNumber;
	/*!
	 * Represents the discovered webproxy IP address.
	 */
	@property NSMutableString* webProxyIPAddress;
	/*!
	 * Represents the discovered webproxy IP address port.
	 */
	@property unsigned int webProxyIPPort;
@end
/*!
 * Represents a certificate authority structure. if not specify, by default OS certificates will be used.
 */
@interface VCNetworkServiceCAInfo : NSObject
{
}
	/*!
	 * The content of the CA file that will be use by the library when connecting to the specified server. Default value: empty. Requirement: Optional. Each certificate authority content should be ended with 'n' or 'rn'. Note: If the string 'default' is passed here, VidyoNetworkService will use a built-in Certificate Authority bundle.
	 */
	@property NSMutableString* caFileContent;
	/*!
	 * The path to the CA certificate file that the library will use when connecting to the specified server. Default value: empty. Requirement: Optional.
	 */
	@property NSMutableString* caFilePath;
@end
