//
//	VidyoRemoteMicrophone_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoDevice_Objc.h"
#import "VidyoLocalSpeaker_Objc.h"
/*!
 * @enum 
 * @constant VCRemoteMicrophoneModeDynamic 
 * @constant VCRemoteMicrophoneModeStatic 
 */
typedef NS_ENUM(NSInteger, VCRemoteMicrophoneMode) {
	VCRemoteMicrophoneModeDynamic,
	VCRemoteMicrophoneModeStatic
};
/*!
 * This object represents a microphone which belongs to the remote participant.
 */
@interface VCRemoteMicrophone : NSObject
{
	void* objPtr;
}
	/*!
	 * Unique ID.
	 */
	@property NSMutableString* id;
	/*!
	 * Name.
	 */
	@property NSMutableString* name;
	/*!
	 * Signal Type.
	 */
	@property VCDeviceAudioSignalType signalType;
	-(void) dealloc;
	/*!
	 * @param m The VidyoRemoteMicrophone object.
	 */
	-(BOOL) addToLocalSpeaker:(VCLocalSpeaker*)speaker Mode:(VCRemoteMicrophoneMode)mode;
	/*!
	 * Gets the unique ID of the microphone.
	 * @param m The VidyoRemoteMicrophone object.
	 */
	-(NSString*) getId;
	/*!
	 * Gets the name of the microphone.
	 * @param m The VidyoRemoteMicrophone object.
	 */
	-(NSString*) getName;
	/*!
	 * Gets signal type of the microphone, which affects how the audio is processed.
	 * @param m The VidyoRemoteMicrophone object.
	 */
	-(VCDeviceAudioSignalType) getSignalType;
	/*!
	 * @param m The VidyoRemoteMicrophone object.
	 */
	-(BOOL) removeFromLocalSpeaker:(VCLocalSpeaker*)speaker;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
